/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.server.VitamServerLifeCycle;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.processing.distributor.api.IWorkerManager;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.distributor.core.AsyncResourceCleaner;
import fr.gouv.vitam.processing.distributor.core.AsyncResourcesMonitor;
import fr.gouv.vitam.processing.distributor.core.ProcessDistributorImpl;
import fr.gouv.vitam.processing.distributor.core.WorkerManager;
import fr.gouv.vitam.processing.distributor.rest.ProcessDistributorResource;
import fr.gouv.vitam.processing.management.api.ProcessManagement;
import fr.gouv.vitam.processing.management.rest.ProcessManagementResource;
import fr.gouv.vitam.worker.client.WorkerClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class VitamApplicationInitializr {
    private static final VitamApplicationInitializr INSTANCE = new VitamApplicationInitializr();
    private Set<Object> singletons = new HashSet<Object>();
    private VitamServerLifeCycle vitamServerLifeCycle;
    private CommonBusinessApplication commonBusinessApplication;

    public static VitamApplicationInitializr get() {
        return INSTANCE;
    }

    public void initialize(String configurationFile) {
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            ServerConfiguration configuration = (ServerConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, ServerConfiguration.class);
            this.commonBusinessApplication = new CommonBusinessApplication();
            WorkspaceClientFactory.changeMode((String)configuration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
            WorkerManager workerManager = new WorkerManager();
            workerManager.initialize();
            AsyncResourcesMonitor asyncResourcesMonitor = new AsyncResourcesMonitor(configuration);
            AsyncResourceCleaner asyncResourceCleaner = new AsyncResourceCleaner(configuration);
            ProcessDistributorImpl processDistributor = new ProcessDistributorImpl((IWorkerManager)workerManager, asyncResourcesMonitor, asyncResourceCleaner, configuration);
            ProcessManagementResource processManagementResource = new ProcessManagementResource(configuration, (ProcessDistributor)processDistributor);
            ProcessDistributorResource processDistributorResource = new ProcessDistributorResource((IWorkerManager)workerManager);
            this.vitamServerLifeCycle = new VitamServerLifeCycle(processManagementResource.getProcessLifeCycle());
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)processManagementResource);
            this.singletons.add(processDistributorResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public void initialize(ServerConfiguration serverConfiguration, WorkerClientFactory workerClientFactory, ProcessManagement processManagement) throws IOException {
        this.commonBusinessApplication = new CommonBusinessApplication();
        WorkerManager workerManager = new WorkerManager(workerClientFactory);
        workerManager.initialize();
        ProcessManagementResource processManagementResource = new ProcessManagementResource(processManagement, serverConfiguration);
        ProcessDistributorResource processDistributorResource = new ProcessDistributorResource((IWorkerManager)workerManager);
        this.vitamServerLifeCycle = new VitamServerLifeCycle(processManagementResource.getProcessLifeCycle());
        this.singletons = new HashSet<Object>();
        this.singletons.addAll(this.commonBusinessApplication.getResources());
        this.singletons.add((Object)processManagementResource);
        this.singletons.add(processDistributorResource);
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public VitamServerLifeCycle getVitamServerLifeCycle() {
        return this.vitamServerLifeCycle;
    }

    public CommonBusinessApplication getCommonBusinessApplication() {
        return this.commonBusinessApplication;
    }
}

