/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.StateNotAllowedException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.lifecycle.ProcessLifeCycle;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.ProcessingStorageWorkspaceException;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.engine.core.monitoring.ProcessMonitoring;
import fr.gouv.vitam.processing.engine.core.monitoring.ProcessMonitoringImpl;
import fr.gouv.vitam.processing.management.api.ProcessManagement;
import fr.gouv.vitam.processing.management.core.ProcessManagementImpl;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/processing/v1")
@ApplicationPath(value="webresources")
@Tag(name="Processing")
public class ProcessManagementResource
extends ApplicationStatusResource {
    private static final String WORKFLOW = "workflow";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessManagementResource.class);
    private static final String ERR_OPERATION_ID_IS_MANDATORY = "The operation identifier is mandatory";
    private static final String ERR_PROCESS_INPUT_ISMANDATORY = "The process input object is mandatory";
    private final ServerConfiguration config;
    private final ProcessManagement processManagement;
    private final ProcessMonitoring processMonitoring;
    private final AtomicLong runningWorkflows = new AtomicLong(0L);

    public ProcessLifeCycle getProcessLifeCycle() {
        return this.processManagement;
    }

    public ProcessManagementResource(ServerConfiguration configuration, ProcessDistributor processDistributor) {
        this.config = configuration;
        try {
            this.processManagement = new ProcessManagementImpl(this.config, processDistributor);
        }
        catch (ProcessingStorageWorkspaceException e) {
            throw new RuntimeException(e);
        }
        this.processMonitoring = ProcessMonitoringImpl.getInstance();
        LOGGER.info("init Process Management Resource server");
    }

    ProcessManagementResource(ProcessManagement pManagement, ServerConfiguration configuration) {
        this.processManagement = pManagement;
        this.config = configuration;
        this.processMonitoring = ProcessMonitoringImpl.getInstance();
    }

    private VitamError getErrorEntity(Response.Status status, String msg, String description) {
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(WORKFLOW).setState("code_vitam").setMessage(msg).setDescription(description);
    }

    private Response buildResponse(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).entity(entity).build();
    }

    private Response buildResponse(ItemStatus itemStatus) {
        RequestResponseOK responseOK = new RequestResponseOK();
        responseOK.addResult((Object)itemStatus);
        responseOK.setHttpCode(itemStatus.getGlobalState().getEquivalentHttpStatus().getStatusCode());
        return Response.status((Response.Status)itemStatus.getGlobalState().getEquivalentHttpStatus()).header("X-Global-Execution-State", (Object)itemStatus.getGlobalState()).header("X-Global-Execution-Status", (Object)itemStatus.getGlobalStatus()).header("X-Context-Id", (Object)itemStatus.getLogbookTypeProcess()).entity((Object)responseOK).build();
    }

    @Path(value="workflows")
    @GET
    @Produces(value={"application/json"})
    public Response getWorkflowDefinitions() {
        try {
            ArrayList<WorkFlow> workflowDefinitions = new ArrayList<WorkFlow>(this.processManagement.getWorkflowDefinitions().values());
            RequestResponseOK response = new RequestResponseOK();
            response.addAllResults(workflowDefinitions).setHits((long)workflowDefinitions.size(), 0, workflowDefinitions.size(), workflowDefinitions.size()).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving workflow definitions : ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.WORKFLOW_DEFINITION_ERROR, (String)e.getLocalizedMessage())).build();
        }
    }

    @Path(value="workflows/{workfowId}")
    @GET
    @Produces(value={"application/json"})
    public Response getWorkflowDetails(@PathParam(value="workfowId") String workfowId) {
        try {
            Optional<WorkFlow> optionalWorkflow = this.processManagement.getWorkflowDefinitions().values().stream().filter(workFlow -> StringUtils.equals((CharSequence)workFlow.getId(), (CharSequence)workfowId)).findFirst();
            if (optionalWorkflow.isPresent()) {
                return Response.status((Response.Status)Response.Status.OK).header("X_TYPE_PROCESS", (Object)optionalWorkflow.get().getTypeProc()).entity((Object)optionalWorkflow.get()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving workflow definitions : ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Internal Server Error while getting workflow (" + workfowId + ") :" + e.getMessage())).build();
        }
    }

    @Path(value="operations/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeWorkFlow(@Context HttpHeaders headers, @PathParam(value="id") String id, ProcessingEntry process) {
        ParametersChecker.checkParameter((String)ERR_OPERATION_ID_IS_MANDATORY, (String[])new String[]{id});
        ParametersChecker.checkParameter((String)ERR_PROCESS_INPUT_ISMANDATORY, (Object[])new Object[]{process});
        String reqId = VitamThreadUtils.getVitamSession().getRequestId();
        WorkerParameters workParams = WorkerParametersFactory.newWorkerParameters().setContainerName(process.getContainer()).setRequestId(reqId).setProcessId(process.getContainer()).setUrlMetadata(this.config.getUrlMetadata()).setUrlWorkspace(this.config.getUrlWorkspace());
        if (process.getExtraParams().size() > 0) {
            workParams.setMap(process.getExtraParams());
        }
        ParametersChecker.checkParameter((String)"actionId is a mandatory parameter", (Object[])new Object[]{headers.getRequestHeader("X-ACTION")});
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String xAction = (String)headers.getRequestHeader("X-ACTION").get(0);
        try {
            this.runningWorkflows.incrementAndGet();
            ProcessAction action = ProcessAction.getProcessAction((String)xAction);
            ItemStatus itemStatus = null;
            switch (action) {
                case INIT: {
                    ProcessWorkflow pw = this.processManagement.init(workParams, process.getWorkflow());
                    return this.buildResponse(Response.Status.CREATED, pw);
                }
                case NEXT: {
                    itemStatus = this.processManagement.next(workParams, tenantId);
                    break;
                }
                case RESUME: {
                    itemStatus = this.processManagement.resume(workParams, tenantId, true);
                    break;
                }
                default: {
                    return this.buildResponse(Response.Status.CONFLICT, this.getErrorEntity(Response.Status.CONFLICT, "NOT_ALLOWED_ACTION " + xAction, "The action " + xAction + " is not allowed! Only INIT, NEXT and RESUME are allowed for this endpoint"));
                }
            }
            return this.buildResponse(itemStatus);
        }
        catch (StateNotAllowedException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.CONFLICT, this.getErrorEntity(Response.Status.CONFLICT, "NOT_ALLOWED_ACTION " + xAction, "The action " + xAction + " is not allowed! The engine exception is :" + e.getMessage()));
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.PRECONDITION_FAILED, this.getErrorEntity(Response.Status.PRECONDITION_FAILED, "Error processing the action :" + xAction, "The action " + xAction + " cause an error :" + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, "Internal error while processing the action :" + xAction, "The action " + xAction + " cause an internal error :" + e.getMessage()));
        }
    }

    @Path(value="operations/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response getOperationProcessExecutionDetails(@PathParam(value="id") String id) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            ProcessWorkflow processWorkflow = this.processMonitoring.findOneProcessWorkflow(id, tenantId);
            ItemStatus itemStatus = new ItemStatus(id).setGlobalState(processWorkflow.getState()).increment(processWorkflow.getStatus());
            RequestResponseOK responseOK = new RequestResponseOK();
            responseOK.addResult((Object)itemStatus);
            responseOK.setHttpCode(itemStatus.getGlobalState().getEquivalentHttpStatus().getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).header("X-Global-Execution-State", (Object)processWorkflow.getState()).header("X-Global-Execution-Status", (Object)processWorkflow.getStatus()).header("X-Context-Id", (Object)processWorkflow.getLogbookTypeProcess()).entity((Object)responseOK).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED, "Error while find ProcessWorkflow", "The parameter id expected not null, id :" + id + " >> Error : " + e.getMessage())).build();
        }
        catch (WorkflowNotFoundException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, "Error while find ProcessWorkflow", "ProcessWorkflow not found with tenant :" + tenantId + " and with id:" + id + " >> Error : " + e.getMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, "Error while find ProcessWorkflow", "ProcessWorkflow with tenant :" + tenantId + " and with id:" + id + " >> Error : " + e.getMessage())).build();
        }
    }

    @Path(value="operations/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWorkFlowStatus(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)"actionId is a mandatory parameter", (Object[])new Object[]{headers.getRequestHeader("X-ACTION")});
        ParametersChecker.checkParameter((String)ERR_OPERATION_ID_IS_MANDATORY, (String[])new String[]{id});
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String reqId = VitamThreadUtils.getVitamSession().getRequestId();
        WorkerParameters workParams = WorkerParametersFactory.newWorkerParameters().setContainerName(id).setRequestId(reqId).setProcessId(id).setUrlMetadata(this.config.getUrlMetadata()).setUrlWorkspace(this.config.getUrlWorkspace());
        String xAction = (String)headers.getRequestHeader("X-ACTION").get(0);
        try {
            ItemStatus itemStatus;
            ProcessAction action = ProcessAction.getProcessAction((String)xAction);
            switch (action) {
                case NEXT: {
                    itemStatus = this.processManagement.next(workParams, tenantId);
                    break;
                }
                case RESUME: {
                    itemStatus = this.processManagement.resume(workParams, tenantId, false);
                    break;
                }
                case REPLAY: {
                    itemStatus = this.processManagement.replay(workParams, tenantId);
                    break;
                }
                case PAUSE: {
                    itemStatus = this.processManagement.pause(workParams.getContainerName(), tenantId);
                    break;
                }
                default: {
                    return this.buildResponse(Response.Status.CONFLICT, this.getErrorEntity(Response.Status.CONFLICT, "NOT_ALLOWED_ACTION " + xAction, "The action " + xAction + " is not allowed! Only INIT, NEXT, REPLAY and RESUME are allowed for this endpoint"));
                }
            }
            return this.buildResponse(itemStatus);
        }
        catch (StateNotAllowedException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.CONFLICT, this.getErrorEntity(Response.Status.CONFLICT, "NOT_ALLOWED_ACTION " + xAction, "The action " + xAction + " is not allowed! The engine exception is :" + e.getMessage()));
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.PRECONDITION_FAILED, this.getErrorEntity(Response.Status.PRECONDITION_FAILED, "Error processing the action :" + xAction, "The action " + xAction + " cause an error :" + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, "Internal error while processing the action :" + xAction, "The action " + xAction + " cause an internal error :" + e.getMessage()));
        }
    }

    @Path(value="operations/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cancelOperationProcessExecution(@PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)ERR_OPERATION_ID_IS_MANDATORY, (String[])new String[]{id});
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            ItemStatus itemStatus = this.processManagement.cancel(id, tenantId);
            return this.buildResponse(itemStatus);
        }
        catch (StateNotAllowedException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.CONFLICT, this.getErrorEntity(Response.Status.CONFLICT, "NOT_ALLOWED_ACTION  CANCEL", "The action cancel is not allowed! The engine exception is :" + e.getMessage()));
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.NOT_FOUND, this.getErrorEntity(Response.Status.NOT_FOUND, "Error processing the action : CANCEL", "The action cancel cause an error :" + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, "Internal error while processing the action : CANCEL", "The action cancel cause an internal error :" + e.getMessage()));
        }
    }

    @Path(value="operations/{id}")
    @HEAD
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getWorkFlowState(@PathParam(value="id") String id) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            ProcessWorkflow processWorkflow = this.processMonitoring.findOneProcessWorkflow(id, tenantId);
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.ACCEPTED);
            if (ProcessState.COMPLETED.equals((Object)processWorkflow.getState())) {
                builder.status(Response.Status.OK);
            } else {
                builder.status(Response.Status.ACCEPTED);
            }
            return builder.header("X-Global-Execution-State", (Object)processWorkflow.getState()).header("X-Global-Execution-Status", (Object)processWorkflow.getStatus()).header("X-Context-Id", (Object)processWorkflow.getLogbookTypeProcess()).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        catch (WorkflowNotFoundException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findProcessWorkflow(ProcessQuery query) {
        try {
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            List<ProcessDetail> processDetails = this.processManagement.getFilteredProcess(query, tenantId);
            RequestResponseOK response = new RequestResponseOK(JsonHandler.toJsonNode((Object)query));
            response.addAllResults(processDetails).setHits((long)processDetails.size(), 0, processDetails.size(), processDetails.size()).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while finding existing workflow process: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.WORKFLOW_PROCESSES_ERROR, (String)e.getMessage())).build();
        }
    }

    @Path(value="/forcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response forcePause(ProcessPause info) {
        try {
            this.processManagement.forcePause(info);
            RequestResponseOK response = new RequestResponseOK();
            response.addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.BAD_REQUEST, this.getErrorEntity(Response.Status.BAD_REQUEST, "Error while set force pause", e.getMessage()));
        }
    }

    @Path(value="/removeforcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeForcePause(ProcessPause info) {
        try {
            this.processManagement.removeForcePause(info);
            RequestResponseOK response = new RequestResponseOK();
            response.addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return this.buildResponse(Response.Status.BAD_REQUEST, this.getErrorEntity(Response.Status.BAD_REQUEST, "Error while remove force pause", e.getMessage()));
        }
    }
}

