/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.processing.management.rest.BusinessApplication;
import fr.gouv.vitam.processing.management.rest.VitamApplicationInitializr;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.util.EventListener;
import javax.ws.rs.core.Application;

public class ProcessManagementMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessManagementMain.class);
    private static final String CONF_FILE_NAME = "processing.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.processing.port";
    private final VitamStarter vitamStarter;

    public ProcessManagementMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(ServerConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class);
        VitamApplicationInitializr.get().initialize(configurationFile);
        this.vitamStarter.getVitamServer().getServer().addEventListener((EventListener)VitamApplicationInitializr.get().getVitamServerLifeCycle());
    }

    @VisibleForTesting
    public ProcessManagementMain(String configurationFile, Class<? extends Application> businessApplication, Class<? extends Application> adminApplication) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        if (null == businessApplication) {
            businessApplication = BusinessApplication.class;
        }
        if (null == adminApplication) {
            adminApplication = AdminApplication.class;
        }
        this.vitamStarter = new VitamStarter(ServerConfiguration.class, configurationFile, businessApplication, adminApplication);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            ProcessManagementMain main = new ProcessManagementMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.register((VitamClientFactoryInterface)LogbookOperationsClientFactory.getInstance()).register((VitamClientFactoryInterface)WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM)).registerOptional((VitamClientFactoryInterface)MetaDataClientFactory.getInstance());
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

