/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.management.api.ProcessManagement;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class WorkflowsLoader
implements Runnable {
    private final ProcessManagement processManagement;

    public WorkflowsLoader(ProcessManagement processManagement) {
        this.processManagement = processManagement;
        Integer period = processManagement.getConfiguration().getWorkflowRefreshPeriod();
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleWithFixedDelay(this, period.intValue(), period.intValue(), TimeUnit.HOURS);
    }

    @Override
    public void run() {
        this.reloadWorkflows();
    }

    private void reloadWorkflows() {
        VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
        this.processManagement.reloadWorkflowDefinitions();
    }
}

