/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.processing.engine.api.ProcessEngine;
import fr.gouv.vitam.processing.management.core.StateMachine;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;

public class StateMachineFactory {
    private static final StateMachineFactory INSTANCE = new StateMachineFactory();

    private StateMachineFactory() {
    }

    public static StateMachineFactory get() {
        return INSTANCE;
    }

    public StateMachine create(ProcessWorkflow processWorkflow, ProcessEngine processEngine) {
        ParametersChecker.checkParameter((String)"ProcessWorkflow cannot be null", (Object[])new Object[]{processWorkflow});
        ParametersChecker.checkParameter((String)"ProcessEngine cannot be null", (Object[])new Object[]{processEngine});
        return new StateMachine(processWorkflow, processEngine);
    }

    @VisibleForTesting
    public StateMachine create(ProcessWorkflow processWorkflow, ProcessEngine processEngine, ProcessDataManagement dataManagement, WorkspaceClientFactory workspaceClientFactory) {
        ParametersChecker.checkParameter((String)"ProcessWorkflow cannot be null", (Object[])new Object[]{processWorkflow});
        ParametersChecker.checkParameter((String)"ProcessEngine cannot be null", (Object[])new Object[]{processEngine});
        ParametersChecker.checkParameter((String)"dataManagement cannot be null", (Object[])new Object[]{dataManagement});
        ParametersChecker.checkParameter((String)"workspaceClientFactory cannot be null", (Object[])new Object[]{workspaceClientFactory});
        return new StateMachine(processWorkflow, processEngine, dataManagement, workspaceClientFactory);
    }
}

