/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.StateNotAllowedException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.PauseOrCancelAction;
import fr.gouv.vitam.common.model.processing.ProcessBehavior;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.automation.IEventsProcessEngine;
import fr.gouv.vitam.processing.common.automation.IEventsState;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.model.PauseRecover;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.processing.data.core.management.WorkspaceProcessDataManagement;
import fr.gouv.vitam.processing.engine.api.ProcessEngine;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;

public class StateMachine
implements IEventsState,
IEventsProcessEngine {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StateMachine.class);
    private static final AlertService alertService = new AlertServiceImpl();
    private int stepIndex = 0;
    private ProcessStep currentStep = null;
    private CompletableFuture<Boolean> waitMonitor;
    private final ProcessWorkflow processWorkflow;
    private final ProcessEngine processEngine;
    private final ProcessDataManagement dataManagement;
    private final WorkspaceClientFactory workspaceClientFactory;
    @VisibleForTesting
    private static final long TIMEOUT = 30L;

    public StateMachine(ProcessWorkflow processWorkflow, ProcessEngine processEngine) {
        this(processWorkflow, processEngine, WorkspaceProcessDataManagement.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    public StateMachine(ProcessWorkflow processWorkflow, ProcessEngine processEngine, ProcessDataManagement dataManagement, WorkspaceClientFactory workspaceClientFactory) {
        ParametersChecker.checkParameter((String)"Parameters (processWorkflow, processEngine) are required", (Object[])new Object[]{processWorkflow, processEngine});
        this.workspaceClientFactory = workspaceClientFactory;
        this.processWorkflow = processWorkflow;
        this.processEngine = processEngine;
        this.dataManagement = dataManagement;
        if (CollectionUtils.isEmpty((Collection)this.processWorkflow.getSteps())) {
            throw new IllegalArgumentException("At least one step is needed");
        }
        this.initStepIndex();
    }

    private void initStepIndex() {
        int stepSize = this.processWorkflow.getSteps().size();
        for (ProcessStep step : this.processWorkflow.getSteps()) {
            PauseOrCancelAction pauseOrCancelAction = step.getPauseOrCancelAction();
            StatusCode stepStatus = step.getStepStatusCode();
            if (PauseOrCancelAction.ACTION_CANCEL.equals((Object)pauseOrCancelAction)) {
                this.stepIndex = stepSize - 1;
                break;
            }
            if (StatusCode.STARTED.equals((Object)stepStatus) || StatusCode.FATAL.equals((Object)stepStatus)) {
                step.setPauseOrCancelAction(PauseOrCancelAction.ACTION_RECOVER);
                break;
            }
            if (step.isBlockingKO()) {
                this.stepIndex = stepSize - 1;
                break;
            }
            if (PauseOrCancelAction.ACTION_COMPLETE.equals((Object)pauseOrCancelAction) && this.stepIndex + 1 < stepSize) {
                ++this.stepIndex;
                continue;
            }
            if (!PauseOrCancelAction.ACTION_PAUSE.equals((Object)pauseOrCancelAction) && !step.getStepStatusCode().isGreaterOrEqualToStarted()) break;
            step.setPauseOrCancelAction(PauseOrCancelAction.ACTION_RECOVER);
            break;
        }
        this.currentStep = (ProcessStep)this.processWorkflow.getSteps().get(this.stepIndex);
    }

    public synchronized void resume(WorkerParameters workerParameters) throws StateNotAllowedException, ProcessingException {
        this.processWorkflow.getState().eval(ProcessState.RUNNING);
        this.doRunning(workerParameters, ProcessState.RUNNING);
    }

    public synchronized void next(WorkerParameters workerParameters) throws StateNotAllowedException, ProcessingException {
        this.processWorkflow.getState().eval(ProcessState.RUNNING);
        this.doRunning(workerParameters, ProcessState.PAUSE);
    }

    public synchronized void replay(WorkerParameters workerParameters) throws StateNotAllowedException, ProcessingException {
        this.processWorkflow.getState().eval(ProcessState.RUNNING);
        this.doReplay(workerParameters);
    }

    public synchronized void pause() throws StateNotAllowedException {
        this.processWorkflow.getState().eval(ProcessState.PAUSE);
        this.doPause(PauseRecover.RECOVER_FROM_API_PAUSE);
    }

    public void shutdown() {
        this.doPause(PauseRecover.RECOVER_FROM_SERVER_PAUSE);
    }

    public synchronized void cancel() throws StateNotAllowedException {
        this.processWorkflow.getState().eval(ProcessState.COMPLETED);
        this.doCancel();
    }

    public boolean isDone() {
        return ProcessState.COMPLETED.equals((Object)this.processWorkflow.getState()) || ProcessState.PAUSE.equals((Object)this.processWorkflow.getState());
    }

    public int getTenant() {
        return this.processWorkflow.getTenantId();
    }

    public String getWorkflowId() {
        return this.processWorkflow.getWorkflowId();
    }

    public String getContextId() {
        return this.processWorkflow.getContextId();
    }

    public Map<String, String> getWorkflowParameters() {
        return this.processWorkflow.getParameters();
    }

    public boolean isStepByStep() {
        return this.processWorkflow.isStepByStep();
    }

    public LogbookTypeProcess getLogbookTypeProcess() {
        return this.processWorkflow.getLogbookTypeProcess();
    }

    protected void doPause(PauseRecover pauseRecover) {
        if (this.isPause() || this.isCompleted()) {
            return;
        }
        if (PauseRecover.RECOVER_FROM_SERVER_PAUSE.equals((Object)pauseRecover)) {
            this.waitMonitor = new CompletableFuture();
        }
        if (!this.isLastStep()) {
            if (this.processWorkflow.getTargetState() != ProcessState.COMPLETED) {
                this.processWorkflow.setTargetState(ProcessState.PAUSE);
            }
            switch (this.currentStep.getPauseOrCancelAction()) {
                case ACTION_COMPLETE: 
                case ACTION_CANCEL: {
                    break;
                }
                default: {
                    this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_PAUSE);
                }
            }
            this.processWorkflow.setPauseRecover(pauseRecover);
        }
        this.tryPersistProcessWorkflow();
        if (PauseRecover.RECOVER_FROM_SERVER_PAUSE.equals((Object)pauseRecover)) {
            try {
                this.waitMonitor.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                String msg = "[StateMachine] The operation " + this.processWorkflow.getOperationId() + " is not completed properly. To be safe, all workers must be restarted before starting processing > ";
                LOGGER.error(msg, (Throwable)e);
                alertService.createAlert(VitamLogLevel.ERROR, msg);
            }
        }
    }

    protected void doCancel() {
        StatusCode currentStatus = this.processWorkflow.getStatus();
        this.processWorkflow.setTargetState(ProcessState.COMPLETED);
        this.processWorkflow.setTargetStatus(StatusCode.KO);
        this.processWorkflow.setStatus(StatusCode.KO);
        this.tryPersistProcessWorkflow();
        if (this.isRunning()) {
            if (!this.isLastStep()) {
                this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_CANCEL);
            }
        } else if (this.isPause()) {
            if (StatusCode.UNKNOWN.equals((Object)currentStatus)) {
                this.processWorkflow.setState(ProcessState.COMPLETED);
                this.finalizeOperation();
            } else {
                this.processWorkflow.setState(ProcessState.RUNNING);
                WorkerParameters workerParameters = WorkerParametersFactory.newWorkerParameters().setMap(this.processWorkflow.getParameters());
                this.executeFinalStep(workerParameters);
            }
        }
    }

    protected void doRunning(WorkerParameters workerParameters, ProcessState targetState) throws ProcessingException {
        if (null == targetState) {
            throw new ProcessingException("The targetState is required");
        }
        if (this.isRunning()) {
            throw new ProcessingException("doRunning not allowed on already running state");
        }
        this.processWorkflow.setState(ProcessState.RUNNING);
        this.processWorkflow.setTargetState(targetState);
        this.processWorkflow.setStepByStep(ProcessState.PAUSE.equals((Object)targetState));
        this.findAndExecuteNextStep(workerParameters, false);
    }

    protected void doReplay(WorkerParameters workerParameters) throws ProcessingException {
        if (this.isRunning()) {
            throw new ProcessingException("doRunning not allowed on already running state");
        }
        this.processWorkflow.setState(ProcessState.RUNNING);
        this.processWorkflow.setTargetState(ProcessState.PAUSE);
        this.processWorkflow.setStepByStep(true);
        this.findAndExecuteNextStep(workerParameters, true);
    }

    protected void findAndExecuteNextStep(WorkerParameters workerParameters, boolean replayCurrentStep) {
        boolean mustExecuteTheFinalStep;
        if (replayCurrentStep && this.stepIndex > 0) {
            --this.stepIndex;
        }
        boolean cancelRequired = PauseOrCancelAction.ACTION_CANCEL.equals((Object)this.currentStep.getPauseOrCancelAction());
        boolean bl = mustExecuteTheFinalStep = !replayCurrentStep && this.currentStep.isBlockingKO() && !this.isLastStep() || cancelRequired;
        if (mustExecuteTheFinalStep) {
            this.executeFinalStep(workerParameters);
            return;
        }
        this.currentStep = (ProcessStep)this.processWorkflow.getSteps().get(this.stepIndex);
        boolean paused = this.currentStep.getPauseOrCancelAction().equals((Object)PauseOrCancelAction.ACTION_PAUSE);
        if (paused) {
            this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_RECOVER);
            this.processWorkflow.setPauseRecover(PauseRecover.RECOVER_FROM_API_PAUSE);
        } else {
            this.processWorkflow.setPauseRecover(PauseRecover.NO_RECOVER);
        }
        if (replayCurrentStep) {
            this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_REPLAY);
            this.processWorkflow.setPauseRecover(PauseRecover.NO_RECOVER);
        }
        this.tryPersistProcessWorkflow();
        try {
            if (this.isLastStep()) {
                this.currentStep.setLastStep(true);
            }
            workerParameters.setPreviousStep(replayCurrentStep ? this.currentStep.getStepName() : null);
            this.processEngine.start(this.currentStep, workerParameters);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    protected void executeFinalStep(WorkerParameters workerParameters) {
        this.tryPersistProcessWorkflow();
        this.stepIndex = this.processWorkflow.getSteps().size() - 1;
        this.currentStep = (ProcessStep)this.processWorkflow.getSteps().get(this.stepIndex);
        this.currentStep.setLastStep(true);
        try {
            this.processEngine.start(this.currentStep, workerParameters);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public synchronized void onUpdate(StatusCode statusCode) {
        StatusCode stepStatusCode = this.currentStep.getStepStatusCode();
        boolean replayAfterFatal = StatusCode.FATAL.equals((Object)this.processWorkflow.getStatus());
        stepStatusCode = stepStatusCode.compareTo((Enum)statusCode) < 0 || replayAfterFatal ? statusCode : stepStatusCode;
        this.currentStep.setStepStatusCode(stepStatusCode);
        if (replayAfterFatal) {
            this.recomputeProcessWorkflowStatus(statusCode);
        } else if (this.processWorkflow.getStatus().compareTo((Enum)statusCode) < 0) {
            this.processWorkflow.setStatus(statusCode);
        }
        if (!this.tryPersistProcessWorkflow() && StatusCode.STARTED.equals((Object)statusCode)) {
            throw new VitamRuntimeException("Operation:" + this.processWorkflow.getOperationId() + ", stepIndex : " + this.stepIndex + ", stepIndexName: " + this.currentStep.getStepName() + ", Cannot continue with unreachable workspace ...");
        }
    }

    public StatusCode getCurrentProcessWorkflowStatus() {
        return this.processWorkflow.getStatus();
    }

    private void recomputeProcessWorkflowStatus(StatusCode statusCode) {
        StatusCode computedStatus = statusCode;
        for (int i = 0; i <= this.stepIndex; ++i) {
            StatusCode previousStatusCode = ((ProcessStep)this.processWorkflow.getSteps().get(i)).getStepStatusCode();
            if (previousStatusCode.compareTo((Enum)computedStatus) <= 0) continue;
            computedStatus = previousStatusCode;
        }
        this.processWorkflow.setStatus(computedStatus);
    }

    public synchronized void onUpdate(String messageIdentifier, String originatingAgency) {
        if (null != messageIdentifier) {
            this.processWorkflow.setMessageIdentifier(messageIdentifier);
        }
        if (null != originatingAgency) {
            this.processWorkflow.setProdService(originatingAgency);
        }
    }

    public synchronized void onError(Throwable throwable) {
        LOGGER.error("Error in Engine", throwable);
        this.processWorkflow.setPauseRecover(PauseRecover.RECOVER_FROM_API_PAUSE);
        this.processWorkflow.setTargetState(ProcessState.PAUSE);
        this.processWorkflow.setStatus(StatusCode.FATAL);
        this.processWorkflow.setState(ProcessState.PAUSE);
        this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_PAUSE);
        alertService.createAlert(VitamLogLevel.WARN, String.format("[StateMachine] Process %s (%s) failed. Operation State: %s, Status: %s", this.processWorkflow.getOperationId(), this.processWorkflow.getLogbookTypeProcess(), this.processWorkflow.getState(), this.processWorkflow.getStatus()), throwable);
        try {
            this.tryPersistProcessWorkflow();
        }
        catch (VitamRuntimeException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public synchronized void onProcessEngineCancel(WorkerParameters workerParameters) {
        this.executeFinalStep(workerParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onProcessEngineCompleteStep(ItemStatus itemStatus, WorkerParameters workerParameters) {
        StatusCode statusCode = itemStatus.getGlobalStatus();
        this.onUpdate(statusCode);
        if (!this.isLastStep()) {
            if (itemStatus.shallStop(this.currentStep.getBehavior().equals((Object)ProcessBehavior.BLOCKING))) {
                if (statusCode.isGreaterOrEqualToFatal()) {
                    this.processWorkflow.setPauseRecover(PauseRecover.RECOVER_FROM_API_PAUSE);
                    this.processWorkflow.setTargetState(ProcessState.PAUSE);
                    this.processWorkflow.setState(ProcessState.PAUSE);
                    this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_PAUSE);
                    this.tryPersistProcessWorkflow();
                } else {
                    this.executeFinalStep(workerParameters);
                }
            } else {
                ProcessState targetState = this.processWorkflow.getTargetState();
                if (ProcessState.COMPLETED.equals((Object)targetState)) {
                    this.processWorkflow.setTargetStatus(StatusCode.KO);
                    this.executeFinalStep(workerParameters);
                } else if (ProcessState.PAUSE.equals((Object)targetState)) {
                    if (this.currentStep.getPauseOrCancelAction() == PauseOrCancelAction.ACTION_COMPLETE && this.currentStep.getElementProcessed().get() == this.currentStep.getElementToProcess().get()) {
                        ++this.stepIndex;
                    }
                    this.processWorkflow.setState(ProcessState.PAUSE);
                    try {
                        this.tryPersistProcessWorkflow();
                    }
                    finally {
                        if (null != this.waitMonitor) {
                            this.waitMonitor.complete(Boolean.TRUE);
                        }
                    }
                } else {
                    ++this.stepIndex;
                    this.findAndExecuteNextStep(workerParameters, false);
                }
            }
        } else {
            try {
                if (itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) {
                    this.processWorkflow.setPauseRecover(PauseRecover.RECOVER_FROM_API_PAUSE);
                    this.processWorkflow.setTargetState(ProcessState.PAUSE);
                    this.processWorkflow.setState(ProcessState.PAUSE);
                    this.currentStep.setPauseOrCancelAction(PauseOrCancelAction.ACTION_PAUSE);
                    this.tryPersistProcessWorkflow();
                } else {
                    this.finalizeOperation();
                }
            }
            finally {
                if (this.waitMonitor != null) {
                    this.waitMonitor.complete(Boolean.TRUE);
                }
            }
        }
    }

    protected boolean isRunning() {
        return ProcessState.RUNNING.equals((Object)this.processWorkflow.getState());
    }

    protected boolean isPause() {
        return ProcessState.PAUSE.equals((Object)this.processWorkflow.getState());
    }

    public boolean isCompleted() {
        return ProcessState.COMPLETED.equals((Object)this.processWorkflow.getState());
    }

    public boolean isRecover() {
        return !ProcessState.COMPLETED.equals((Object)this.processWorkflow.getState()) && PauseRecover.RECOVER_FROM_SERVER_PAUSE.equals((Object)this.processWorkflow.getPauseRecover());
    }

    protected boolean isLastStep() {
        return this.stepIndex == this.processWorkflow.getSteps().size() - 1;
    }

    protected boolean tryPersistProcessWorkflow() {
        if (ProcessState.COMPLETED.equals((Object)this.processWorkflow.getState()) && null == this.processWorkflow.getProcessCompletedDate()) {
            this.processWorkflow.setProcessCompletedDate(LocalDateUtil.now());
        }
        try {
            this.dataManagement.persistProcessWorkflow(VitamConfiguration.getWorkspaceWorkflowsFolder(), this.processWorkflow);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Cannot persist process workflow > ", (Throwable)e);
            return false;
        }
    }

    protected void finalizeOperation() {
        if (null != this.processWorkflow.getTargetStatus()) {
            this.processWorkflow.setStatus(this.processWorkflow.getTargetStatus());
        }
        this.processWorkflow.setState(ProcessState.COMPLETED);
        this.processWorkflow.setTargetState(ProcessState.COMPLETED);
        if (!this.tryPersistProcessWorkflow()) {
            alertService.createAlert(VitamLogLevel.WARN, "[StateMachine] The latest of ProcessWorkflow (" + this.processWorkflow.getOperationId() + ") not saved in workspace. Expected > State: COMPLETED, Status: " + this.processWorkflow.getStatus());
        }
        this.dataManagement.removeOperationContainer(this.processWorkflow, this.workspaceClientFactory);
        this.silentlyCleanBackupOperation();
    }

    private void silentlyCleanBackupOperation() {
        try {
            switch (this.processWorkflow.getLogbookTypeProcess()) {
                case INGEST: 
                case MASTERDATA: 
                case TRACEABILITY: 
                case INGEST_TEST: 
                case AUDIT: 
                case DATA_MIGRATION: 
                case COMPUTE_INHERITED_RULES: {
                    LOGGER.debug("Cleanup operation context. No operation context for the process type " + this.processWorkflow.getLogbookTypeProcess());
                    break;
                }
                default: {
                    OperationContextMonitor operationContextMonitor = new OperationContextMonitor();
                    operationContextMonitor.deleteBackup(VitamConfiguration.getDefaultStrategy(), this.processWorkflow.getOperationId(), this.processWorkflow.getLogbookTypeProcess());
                    break;
                }
            }
        }
        catch (Exception e) {
            String msg = "Cleaning the offer temporary backup of the operation (" + this.processWorkflow.getOperationId() + ") failed. Operation State: COMPLETED, Status: " + this.processWorkflow.getStatus();
            LOGGER.error(msg, (Throwable)e);
            alertService.createAlert(VitamLogLevel.WARN, "[StateMachine] " + msg);
        }
    }

    public ProcessStep getCurrentStep() {
        return this.currentStep;
    }

    public int getStepIndex() {
        return this.stepIndex;
    }
}

