/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingStorageWorkspaceException;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.processing.data.core.management.WorkspaceProcessDataManagement;
import fr.gouv.vitam.processing.management.api.ProcessManagement;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ProcessWorkFlowsCleaner
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessWorkFlowsCleaner.class);
    private final Integer period = VitamConfiguration.getVitamCleanPeriod();
    private LocalDateTime timeLimit;
    private final ProcessManagement processManagement;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final ProcessDataManagement processDataManagement;

    public ProcessWorkFlowsCleaner(ProcessManagement processManagement, TimeUnit timeunit) {
        this(processManagement, WorkspaceProcessDataManagement.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), timeunit);
    }

    @VisibleForTesting
    public ProcessWorkFlowsCleaner(ProcessManagement processManagement, ProcessDataManagement processDataManagement, WorkspaceClientFactory workspaceClientFactory, TimeUnit timeunit) {
        this.processManagement = processManagement;
        this.processDataManagement = processDataManagement;
        this.workspaceClientFactory = workspaceClientFactory;
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleAtFixedRate(this, this.period.intValue(), this.period.intValue(), timeunit);
    }

    @Override
    public void run() {
        this.timeLimit = LocalDateUtil.now().minusHours(this.period.intValue());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        this.cleanProcessingByTenants();
    }

    private void cleanProcessingByTenants() {
        for (Map.Entry<Integer, Map<String, ProcessWorkflow>> entry : this.processManagement.getWorkFlowList().entrySet()) {
            Map<String, ProcessWorkflow> map = entry.getValue();
            if (null == map || map.size() <= 0) continue;
            VitamThreadUtils.getVitamSession().setTenantId(entry.getKey());
            this.cleanCompletedProcess(entry.getValue());
        }
    }

    private void cleanCompletedProcess(Map<String, ProcessWorkflow> map) {
        for (Map.Entry<String, ProcessWorkflow> element : map.entrySet()) {
            if (!this.isCleanable(element.getValue())) continue;
            try {
                this.processDataManagement.removeOperationContainer(element.getValue(), this.workspaceClientFactory);
                this.processDataManagement.removeProcessWorkflow(VitamConfiguration.getWorkspaceWorkflowsFolder(), element.getKey());
                map.remove(element.getKey());
                this.processManagement.getProcessMonitorList().remove(element.getKey());
            }
            catch (ProcessingStorageWorkspaceException e) {
                LOGGER.error("cannot delete workflow file for serverID {} and asyncID {}", new Object[]{VitamConfiguration.getWorkspaceWorkflowsFolder(), element.getKey(), e});
            }
        }
    }

    private boolean isCleanable(ProcessWorkflow workflow) {
        return workflow.getState().equals((Object)ProcessState.COMPLETED) && workflow.getProcessCompletedDate() != null && workflow.getProcessCompletedDate().isBefore(this.timeLimit);
    }
}

