/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcessPopulator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessPopulator.class);
    private static final String WORKFLOWS_FOLDER = "workflows/";

    private ProcessPopulator() {
    }

    public static void loadWorkflow(Map<String, WorkFlow> poolWorkflows) {
        ProcessPopulator.loadInternalWorkflow(poolWorkflows);
        ProcessPopulator.loadExternalWorkflow(poolWorkflows, Instant.EPOCH.toEpochMilli());
    }

    public static void reloadWorkflow(Map<String, WorkFlow> poolWorkflows, Long fromDate) {
        ProcessPopulator.loadExternalWorkflow(poolWorkflows, fromDate);
    }

    private static void loadInternalWorkflow(Map<String, WorkFlow> poolWorkflows) {
        List workflowFiles;
        LOGGER.debug("Loading internal workflow resources...");
        try {
            workflowFiles = PropertiesUtils.getResourceListing(ProcessPopulator.class, (String)WORKFLOWS_FOLDER).filter(f -> f.endsWith(".json")).map(f -> WORKFLOWS_FOLDER + f).distinct().collect(Collectors.toList());
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Error while load internal workflow", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOGGER.debug("Found " + workflowFiles.size() + " workflow resource files: " + workflowFiles);
        for (String workflowFile : workflowFiles) {
            try {
                LOGGER.debug("populate internal : " + workflowFile);
                ProcessPopulator.populate(poolWorkflows, PropertiesUtils.getResourceAsStream((String)workflowFile), false);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Cannot load workflow file (" + workflowFile + ") ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void loadExternalWorkflow(Map<String, WorkFlow> poolWorkflows, Long fromDate) {
        LOGGER.debug("Loading external workflow resources...");
        List<Path> workflowFiles = ProcessPopulator.loadExternalWorkflowFiles(fromDate);
        LOGGER.debug("Found " + workflowFiles.size() + " workflow resource files");
        for (Path workflowFile : workflowFiles) {
            try {
                LOGGER.debug("populate external : " + workflowFile.toString());
                ProcessPopulator.populate(poolWorkflows, Files.newInputStream(workflowFile, new OpenOption[0]), true);
            }
            catch (IOException e) {
                LOGGER.warn(workflowFile.toString(), (Throwable)e);
            }
        }
    }

    private static List<Path> loadExternalWorkflowFiles(Long fromDate) {
        List<Path> list;
        block9: {
            LOGGER.debug("load external file : {}{}", (Object)VitamConfiguration.getVitamConfigFolder(), (Object)WORKFLOWS_FOLDER);
            File workflowFolder = PropertiesUtils.fileFromConfigFolder((String)WORKFLOWS_FOLDER);
            if (!workflowFolder.isDirectory()) {
                LOGGER.debug("DirectoryNotFoundException thrown by populator: {}", (Object)workflowFolder);
                return new ArrayList<Path>();
            }
            LOGGER.debug("load external :" + workflowFolder.toPath().toString());
            Stream<Path> stream = Files.list(workflowFolder.toPath());
            try {
                list = stream.filter(f -> f.toFile().isFile()).filter(f -> f.toFile().getName().endsWith(".json")).filter(f -> f.toFile().lastModified() > fromDate).distinct().collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error while list external workflow folder", (Throwable)e);
                    return new ArrayList<Path>();
                }
            }
            stream.close();
        }
        return list;
    }

    private static void populate(Map<String, WorkFlow> poolWorkflows, InputStream workflowFile, boolean update) {
        LOGGER.debug("Populating workflow using file " + workflowFile);
        Optional<WorkFlow> workflow = ProcessPopulator.populate(workflowFile);
        if (workflow.isPresent()) {
            String wfId = workflow.get().getId();
            LOGGER.debug("Parsed workflow with id " + wfId);
            if (update) {
                poolWorkflows.put(wfId, workflow.get());
            } else {
                poolWorkflows.putIfAbsent(wfId, workflow.get());
            }
        }
    }

    public static Optional<WorkFlow> populate(InputStream workflowFileStream) {
        ParametersChecker.checkParameter((String)"WorkflowFile is a mandatory parameter", (Object[])new Object[]{workflowFileStream});
        try {
            return Optional.of((WorkFlow)JsonHandler.getFromInputStream((InputStream)workflowFileStream, WorkFlow.class));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error while load workflow :", (Throwable)e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    public static Optional<WorkFlow> populate(String workflowFile) {
        try {
            return ProcessPopulator.populate(PropertiesUtils.getResourceAsStream((String)workflowFile));
        }
        catch (FileNotFoundException e) {
            LOGGER.error(workflowFile, (Throwable)e);
            return Optional.empty();
        }
    }
}

