/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.StateNotAllowedException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.automation.IEventsProcessEngine;
import fr.gouv.vitam.processing.common.automation.IEventsState;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.ProcessingStorageWorkspaceException;
import fr.gouv.vitam.processing.common.metrics.ProcessWorkflowMetricsCollector;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import fr.gouv.vitam.processing.data.core.ProcessDataAccess;
import fr.gouv.vitam.processing.data.core.ProcessDataAccessImpl;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.engine.api.ProcessEngine;
import fr.gouv.vitam.processing.engine.core.ProcessEngineFactory;
import fr.gouv.vitam.processing.engine.core.ProcessEngineImpl;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.processing.management.api.ProcessManagement;
import fr.gouv.vitam.processing.management.core.ProcessPopulator;
import fr.gouv.vitam.processing.management.core.ProcessWorkFlowsCleaner;
import fr.gouv.vitam.processing.management.core.StateMachine;
import fr.gouv.vitam.processing.management.core.StateMachineFactory;
import fr.gouv.vitam.processing.management.core.WorkflowsLoader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ProcessManagementImpl
implements ProcessManagement {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessManagementImpl.class);
    private static final Map<String, IEventsState> PROCESS_MONITORS = new ConcurrentHashMap<String, IEventsState>();
    private final OperationContextMonitor operationContextMonitor;
    private ServerConfiguration config;
    private final ProcessDataAccess processDataAccess;
    private final Map<String, WorkFlow> poolWorkflow;
    private ProcessDistributor processDistributor;
    private ProcessDataManagement workspaceProcessDataManagement;
    private final Map<Integer, List<LogbookTypeProcess>> pausedProcessesByTenant;
    private final List<Integer> pausedTenants;
    private final List<LogbookTypeProcess> pausedTypeProcesses;
    private Boolean pauseAll;

    public ProcessManagementImpl(ServerConfiguration config, ProcessDistributor processDistributor) throws ProcessingStorageWorkspaceException {
        this(config, processDistributor, (ProcessDataAccess)ProcessDataAccessImpl.getInstance(), processDistributor.getProcessDataManagement(), new OperationContextMonitor());
    }

    @VisibleForTesting
    public ProcessManagementImpl(ServerConfiguration config, ProcessDistributor processDistributor, ProcessDataAccess processDataAccess, ProcessDataManagement processDataManagement, OperationContextMonitor operationContextMonitor) throws ProcessingStorageWorkspaceException {
        this.operationContextMonitor = operationContextMonitor;
        ParametersChecker.checkParameter((String)"Server config cannot be null", (Object[])new Object[]{config});
        this.config = config;
        this.processDataAccess = processDataAccess;
        this.poolWorkflow = new ConcurrentHashMap<String, WorkFlow>();
        this.pausedProcessesByTenant = new ConcurrentHashMap<Integer, List<LogbookTypeProcess>>();
        this.pausedTenants = new ArrayList<Integer>();
        this.pausedTypeProcesses = new ArrayList<LogbookTypeProcess>();
        this.pauseAll = Boolean.FALSE;
        this.processDistributor = processDistributor;
        this.workspaceProcessDataManagement = processDataManagement;
        ProcessWorkflowMetricsCollector.getInstance().initialize(this.processDataAccess.getWorkFlowList());
        new ProcessWorkFlowsCleaner(this, TimeUnit.HOURS);
        new WorkflowsLoader(this);
        ProcessPopulator.loadWorkflow(this.poolWorkflow);
        this.loadProcessFromWorkSpace(config.getUrlMetadata(), config.getUrlWorkspace());
    }

    public void startProcess() {
        if (VitamConfiguration.isIntegrationTest()) {
            return;
        }
        for (String operationId : PROCESS_MONITORS.keySet()) {
            IEventsState stateMachine = PROCESS_MONITORS.get(operationId);
            if (!stateMachine.isRecover()) continue;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(stateMachine.getTenant()));
                VitamThreadUtils.getVitamSession().setRequestId(operationId);
                VitamThreadUtils.getVitamSession().setContextId(stateMachine.getContextId());
                WorkerParameters workerParameters = WorkerParametersFactory.newWorkerParameters().setMap(stateMachine.getWorkflowParameters()).setUrlMetadata(this.config.getUrlMetadata()).setUrlWorkspace(this.config.getUrlWorkspace()).setLogbookTypeProcess(stateMachine.getLogbookTypeProcess()).setContainerName(operationId).setRequestId(operationId).setWorkflowIdentifier(stateMachine.getWorkflowId());
                if (stateMachine.isStepByStep()) {
                    stateMachine.next(workerParameters);
                    continue;
                }
                stateMachine.resume(workerParameters);
            }
            catch (StateNotAllowedException | ProcessingException e) {
                LOGGER.error("Error while pause the processWorkflow : " + operationId, e);
            }
        }
    }

    public void stopProcess() {
        CountDownLatch countDownLatch = new CountDownLatch(PROCESS_MONITORS.size());
        for (String operationId : PROCESS_MONITORS.keySet()) {
            IEventsState stateMachine = PROCESS_MONITORS.get(operationId);
            if (stateMachine.isDone()) {
                countDownLatch.countDown();
                continue;
            }
            VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
                try {
                    stateMachine.shutdown();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Throwable)e);
        }
        PROCESS_MONITORS.clear();
    }

    @Override
    public ProcessWorkflow init(WorkerParameters workerParameters, String workflowId) throws ProcessingException {
        this.workspaceProcessDataManagement.createProcessContainer();
        this.workspaceProcessDataManagement.createFolder(VitamConfiguration.getWorkspaceWorkflowsFolder());
        Optional<WorkFlow> workFlow = this.poolWorkflow.values().stream().filter(w -> StringUtils.equals((CharSequence)w.getId(), (CharSequence)workflowId)).findFirst();
        if (!workFlow.isPresent()) {
            throw new ProcessingException("Workflow (" + workflowId + ") not found");
        }
        String workflowIdentifier = workFlow.get().getIdentifier();
        ProcessWorkflow processWorkflow = this.processDataAccess.initProcessWorkflow(workFlow.get(), workerParameters.getContainerName());
        processWorkflow.setWorkflowId(workflowIdentifier);
        for (WorkerParameterName workerParameterName : workerParameters.getMapParameters().keySet()) {
            processWorkflow.getParameters().put(workerParameterName.name(), workerParameters.getParameterValue(workerParameterName));
        }
        try {
            this.workspaceProcessDataManagement.persistProcessWorkflow(VitamConfiguration.getWorkspaceWorkflowsFolder(), processWorkflow);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException((Throwable)e);
        }
        workerParameters.setLogbookTypeProcess(processWorkflow.getLogbookTypeProcess());
        workerParameters.setWorkflowIdentifier(workflowIdentifier);
        ProcessEngineImpl processEngine = ProcessEngineFactory.get().create(workerParameters, this.processDistributor);
        StateMachine stateMachine = StateMachineFactory.get().create(processWorkflow, (ProcessEngine)processEngine);
        processEngine.setStateMachineCallback((IEventsProcessEngine)stateMachine);
        PROCESS_MONITORS.put(workerParameters.getContainerName(), stateMachine);
        try {
            switch (processWorkflow.getLogbookTypeProcess()) {
                case INGEST: 
                case MASTERDATA: 
                case TRACEABILITY: 
                case INGEST_TEST: 
                case AUDIT: 
                case DATA_MIGRATION: {
                    LOGGER.debug("Backup operation context. No operation context for the process type " + processWorkflow.getLogbookTypeProcess());
                    break;
                }
                default: {
                    this.operationContextMonitor.backup(VitamConfiguration.getDefaultStrategy(), workerParameters.getContainerName(), processWorkflow.getLogbookTypeProcess());
                    break;
                }
            }
        }
        catch (OperationContextException e) {
            LOGGER.error("Unable to backup operation context from the workspace", (Throwable)e);
        }
        return processWorkflow;
    }

    @Override
    public ItemStatus next(WorkerParameters workerParameters, Integer tenantId) throws ProcessingException, StateNotAllowedException {
        return this.execute(workerParameters.getContainerName(), tenantId, workerParameters, null, ProcessAction.NEXT);
    }

    @Override
    public ItemStatus resume(WorkerParameters workerParameters, Integer tenantId, boolean useForcedPause) throws ProcessingException, StateNotAllowedException {
        return this.execute(workerParameters.getContainerName(), tenantId, workerParameters, useForcedPause, ProcessAction.RESUME);
    }

    @Override
    public ItemStatus replay(WorkerParameters workerParameters, Integer tenantId) throws ProcessingException, StateNotAllowedException {
        return this.execute(workerParameters.getContainerName(), tenantId, workerParameters, null, ProcessAction.REPLAY);
    }

    @Override
    public ItemStatus pause(String operationId, Integer tenantId) throws ProcessingException, StateNotAllowedException {
        return this.execute(operationId, tenantId, null, null, ProcessAction.PAUSE);
    }

    @Override
    public ItemStatus cancel(String operationId, Integer tenantId) throws WorkflowNotFoundException, ProcessingException, StateNotAllowedException {
        return this.execute(operationId, tenantId, null, null, null);
    }

    public ItemStatus execute(String operationId, Integer tenantId, WorkerParameters workerParameters, Boolean useForcedPause, ProcessAction action) throws ProcessingException, StateNotAllowedException {
        IEventsState stateMachine = PROCESS_MONITORS.get(operationId);
        if (null == stateMachine) {
            throw new StateNotAllowedException("Operation " + operationId + "does not exists or already completed");
        }
        ProcessWorkflow processWorkflow = this.findOneProcessWorkflow(operationId, tenantId);
        if (null == action) {
            stateMachine.cancel();
            return new ItemStatus(operationId).increment(processWorkflow.getStatus()).setGlobalState(processWorkflow.getState()).setLogbookTypeProcess(processWorkflow.getLogbookTypeProcess().toString());
        }
        switch (action) {
            case NEXT: {
                stateMachine.next(workerParameters);
                break;
            }
            case RESUME: {
                if (Boolean.TRUE.equals(useForcedPause) && this.isPauseForced(processWorkflow, tenantId)) {
                    return this.next(workerParameters, tenantId);
                }
                stateMachine.resume(workerParameters);
                break;
            }
            case REPLAY: {
                stateMachine.replay(workerParameters);
                break;
            }
            case PAUSE: {
                stateMachine.pause();
                break;
            }
            default: {
                throw new IllegalArgumentException("Action not managed :" + action);
            }
        }
        return new ItemStatus(operationId).increment(processWorkflow.getStatus()).setGlobalState(processWorkflow.getState()).setLogbookTypeProcess(processWorkflow.getLogbookTypeProcess().toString());
    }

    private boolean isPauseForced(ProcessWorkflow processWorkflow, Integer tenantId) {
        if (Boolean.TRUE.equals(this.pauseAll)) {
            return true;
        }
        if (this.pausedTenants.contains(tenantId)) {
            return true;
        }
        LogbookTypeProcess logbookTypeProcess = processWorkflow.getLogbookTypeProcess();
        if (this.pausedTypeProcesses.contains(logbookTypeProcess)) {
            return true;
        }
        List<LogbookTypeProcess> pausedWorklowsByTenant = this.pausedProcessesByTenant.get(tenantId);
        return pausedWorklowsByTenant != null && pausedWorklowsByTenant.contains(logbookTypeProcess);
    }

    @Override
    public void forcePause(ProcessPause pause) throws ProcessingException {
        String type = pause.getType();
        Integer tenantId = pause.getTenant();
        Boolean pauseAll = pause.getPauseAll();
        if (type == null && tenantId == null && pauseAll == null) {
            throw new ProcessingException("Type, tenant and pauseAll param cannot all be null");
        }
        this.pauseAll = pause.getPauseAll();
        LogbookTypeProcess processType = null;
        if (type != null && !type.isEmpty()) {
            try {
                processType = LogbookTypeProcess.getLogbookTypeProcess((String)type);
            }
            catch (IllegalArgumentException e) {
                throw new ProcessingException("Type " + type + " is not a valid process type");
            }
        }
        if (processType != null && tenantId != null) {
            List<LogbookTypeProcess> pausedWorklowsByTenant = this.pausedProcessesByTenant.get(tenantId);
            if (pausedWorklowsByTenant == null) {
                pausedWorklowsByTenant = new ArrayList<LogbookTypeProcess>();
            }
            if (!pausedWorklowsByTenant.contains(processType)) {
                pausedWorklowsByTenant.add(tenantId, processType);
            }
            this.pausedProcessesByTenant.put(tenantId, pausedWorklowsByTenant);
        } else if (processType == null && tenantId != null) {
            if (!this.pausedTenants.contains(tenantId)) {
                this.pausedTenants.add(tenantId);
            }
        } else if (processType != null && tenantId == null && !this.pausedTypeProcesses.contains(processType)) {
            this.pausedTypeProcesses.add(processType);
        }
    }

    @Override
    public void removeForcePause(ProcessPause pause) throws ProcessingException {
        String type = pause.getType();
        Integer tenantId = pause.getTenant();
        Boolean pauseAll = pause.getPauseAll();
        if (type == null && tenantId == null && pauseAll == null) {
            throw new ProcessingException("Type, tenant and pauseAll param cannot all be null");
        }
        if (Boolean.FALSE.equals(pauseAll)) {
            this.pauseAll = pauseAll;
        }
        LogbookTypeProcess processType = null;
        if (type != null && !type.isEmpty()) {
            try {
                processType = LogbookTypeProcess.getLogbookTypeProcess((String)type);
            }
            catch (IllegalArgumentException e) {
                throw new ProcessingException("Type " + type + "is not a valid process type");
            }
        }
        if (processType != null && tenantId != null) {
            List<LogbookTypeProcess> pausedWorklowsByTenant = this.pausedProcessesByTenant.get(tenantId);
            if (pausedWorklowsByTenant != null && !pausedWorklowsByTenant.isEmpty()) {
                pausedWorklowsByTenant.remove(processType);
            }
        } else if (processType == null && tenantId != null) {
            if (this.pausedTenants.contains(tenantId)) {
                this.pausedTenants.remove(tenantId);
            }
            if (this.pausedProcessesByTenant.containsKey(tenantId)) {
                this.pausedProcessesByTenant.remove(tenantId);
            }
        } else if (processType != null && tenantId == null) {
            if (this.pausedTypeProcesses.contains(processType)) {
                this.pausedTypeProcesses.remove(processType);
            }
            LogbookTypeProcess pr = processType;
            this.pausedProcessesByTenant.forEach((id, v) -> {
                if (v != null && !v.isEmpty()) {
                    v.remove(pr);
                }
            });
        }
    }

    public void close() {
    }

    @Override
    public List<ProcessWorkflow> findAllProcessWorkflow(Integer tenantId) {
        return this.processDataAccess.findAllProcessWorkflow(tenantId);
    }

    @Override
    public ProcessWorkflow findOneProcessWorkflow(String operationId, Integer tenantId) {
        return this.processDataAccess.findOneProcessWorkflow(operationId, tenantId);
    }

    @Override
    public Map<String, WorkFlow> getWorkflowDefinitions() {
        return this.poolWorkflow;
    }

    @Override
    public void reloadWorkflowDefinitions() {
        Integer period = this.getConfiguration().getWorkflowRefreshPeriod();
        long fromDate = Instant.now().minus(period.intValue(), ChronoUnit.HOURS).toEpochMilli();
        ProcessPopulator.reloadWorkflow(this.poolWorkflow, fromDate);
    }

    @Override
    public Map<Integer, Map<String, ProcessWorkflow>> getWorkFlowList() {
        return this.processDataAccess.getWorkFlowList();
    }

    @Override
    public Map<String, IEventsState> getProcessMonitorList() {
        return PROCESS_MONITORS;
    }

    private Map<String, IEventsState> loadProcessFromWorkSpace(String urlMetadata, String urlWorkspace) throws ProcessingStorageWorkspaceException {
        if (!PROCESS_MONITORS.isEmpty()) {
            return PROCESS_MONITORS;
        }
        Map map = this.workspaceProcessDataManagement.getProcessWorkflowFor(null, VitamConfiguration.getWorkspaceWorkflowsFolder());
        if (map == null) {
            return PROCESS_MONITORS;
        }
        for (String operationId : map.keySet()) {
            ProcessWorkflow processWorkflow = (ProcessWorkflow)map.get(operationId);
            if (processWorkflow.getState().equals((Object)ProcessState.PAUSE)) {
                WorkerParameters workerParameters = WorkerParametersFactory.newWorkerParameters().setMap(processWorkflow.getParameters()).setUrlMetadata(urlMetadata).setUrlWorkspace(urlWorkspace).setLogbookTypeProcess(processWorkflow.getLogbookTypeProcess()).setContainerName(operationId).setWorkflowIdentifier(processWorkflow.getWorkflowId());
                ProcessEngineImpl processEngine = ProcessEngineFactory.get().create(workerParameters, this.processDistributor);
                StateMachine stateMachine = StateMachineFactory.get().create(processWorkflow, (ProcessEngine)processEngine);
                processEngine.setStateMachineCallback((IEventsProcessEngine)stateMachine);
                PROCESS_MONITORS.put(workerParameters.getContainerName(), stateMachine);
            }
            this.processDataAccess.addToWorkflowList(processWorkflow);
        }
        return PROCESS_MONITORS;
    }

    @Override
    public List<ProcessDetail> getFilteredProcess(ProcessQuery query, Integer tenantId) {
        List<ProcessWorkflow> listWorkflow = this.findAllProcessWorkflow(tenantId);
        listWorkflow.sort((a, b) -> b.getProcessDate().compareTo(a.getProcessDate()));
        ArrayList<ProcessDetail> results = new ArrayList<ProcessDetail>();
        for (ProcessWorkflow processWorkflow : listWorkflow) {
            ProcessDetail workflow = new ProcessDetail();
            this.getNextAndPreviousSteps(processWorkflow, workflow);
            if (query.getId() != null && !query.getId().equals(processWorkflow.getOperationId()) || query.getStates() != null && !query.getStates().isEmpty() && !query.getStates().contains(processWorkflow.getState().name()) || query.getStatuses() != null && !query.getStatuses().isEmpty() && !query.getStatuses().contains(processWorkflow.getStatus().name()) || query.getWorkflows() != null && !query.getWorkflows().isEmpty() && !query.getWorkflows().contains(processWorkflow.getWorkflowId()) || query.getListSteps() != null && !query.getListSteps().isEmpty() && !this.isContainsStep(query.getListSteps(), workflow) || query.getListProcessTypes() != null && !query.getListProcessTypes().isEmpty() && !query.getListProcessTypes().contains(processWorkflow.getLogbookTypeProcess().toString()) || query.getStartDateMin() != null && query.getStartDateMax() != null && !this.isStartDateIn(query.getStartDateMin(), query.getStartDateMax(), processWorkflow)) continue;
            workflow.setOperationId(processWorkflow.getOperationId());
            workflow.setProcessType(processWorkflow.getLogbookTypeProcess().toString());
            workflow.setStepByStep(processWorkflow.isStepByStep());
            workflow.setGlobalState(processWorkflow.getState().name());
            workflow.setStepStatus(processWorkflow.getStatus().name());
            workflow.setProcessDate(processWorkflow.getProcessDate());
            results.add(workflow);
        }
        return results;
    }

    private boolean isContainsStep(List<String> stepsName, ProcessDetail workflow) {
        String previous = workflow.getPreviousStep();
        return previous != null && !previous.isEmpty() && stepsName.contains(previous);
    }

    private boolean isStartDateIn(String startDateMin, String startDateMax, ProcessWorkflow processWorkflow) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        String date = processWorkflow.getProcessDate();
        LocalDate ldt = LocalDateUtil.parseMongoFormattedDate((String)date).toLocalDate();
        LocalDate startDateTimeMin = LocalDate.parse(startDateMin, formatter);
        LocalDate startDateTimeMax = LocalDate.parse(startDateMax, formatter);
        return !(!ldt.isBefore(startDateTimeMax) && !ldt.isEqual(startDateTimeMax) || !ldt.isAfter(startDateTimeMin) && !ldt.isEqual(startDateTimeMin));
    }

    private void getNextAndPreviousSteps(ProcessWorkflow processWorkflow, ProcessDetail workflow) {
        String previousStep = "";
        String nextStep = "";
        String temporaryPreviousTask = "";
        boolean currentStepFound = false;
        Iterator pwIterator = processWorkflow.getSteps().iterator();
        while (pwIterator.hasNext() && !currentStepFound) {
            ProcessStep processStep = (ProcessStep)pwIterator.next();
            switch (processWorkflow.getState()) {
                case PAUSE: 
                case RUNNING: {
                    if (processStep.getStepStatusCode() == StatusCode.STARTED) {
                        previousStep = processStep.getStepName();
                        nextStep = pwIterator.hasNext() ? ((ProcessStep)pwIterator.next()).getStepName() : "";
                        workflow.setStepStatus("STARTED");
                        currentStepFound = true;
                        break;
                    }
                    if (processStep.getStepStatusCode() != StatusCode.UNKNOWN) break;
                    previousStep = temporaryPreviousTask;
                    nextStep = processStep.getStepName();
                    currentStepFound = true;
                    break;
                }
                case COMPLETED: {
                    if (processStep.getStepStatusCode() == StatusCode.KO || processStep.getStepStatusCode() == StatusCode.STARTED) {
                        previousStep = processStep.getStepName();
                        workflow.setStepStatus(StatusCode.KO.toString());
                        currentStepFound = true;
                        break;
                    }
                    if (processStep.getStepStatusCode() != StatusCode.UNKNOWN) break;
                    previousStep = temporaryPreviousTask;
                    workflow.setStepStatus(StatusCode.KO.toString());
                    currentStepFound = true;
                    break;
                }
            }
            temporaryPreviousTask = processStep.getStepName();
            workflow.setPreviousStep(previousStep);
            workflow.setNextStep(nextStep);
        }
    }

    @Override
    public ServerConfiguration getConfiguration() {
        return this.config;
    }
}

