/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.multiple.InsertMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.utils.ArrayListScrollSpliterator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.BatchRulesUpdateInfo;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertRequest;
import fr.gouv.vitam.metadata.api.model.UpdateUnit;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbVarNameAdapter;
import fr.gouv.vitam.metadata.core.metrics.CommonMetadataMetrics;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import fr.gouv.vitam.metadata.core.model.RequestById;
import fr.gouv.vitam.metadata.core.rules.MetadataRuleService;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.ElasticsearchParseException;

@Path(value="/v1")
@Tag(name="Metadata")
public class MetadataResource
extends ApplicationStatusResource {
    private static final String CONTEXT_METADATA = "METADATA";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataResource.class);
    private static final String INGEST = "ingest";
    private static final String ACCESS = "ACCESS";
    private static final String CODE_VITAM = "code_vitam";
    private static final MongoDbVarNameAdapter DEFAULT_VARNAME_ADAPTER = new MongoDbVarNameAdapter();
    private final MetaDataImpl metaData;
    private final MetadataRuleService metadataRuleService;
    private final MetaDataConfiguration configuration;

    MetadataResource(MetaDataImpl metaData, MetadataRuleService metadataRuleService, MetaDataConfiguration configuration) {
        this.metaData = metaData;
        this.metadataRuleService = metadataRuleService;
        this.configuration = configuration;
        LOGGER.info("init MetaData Resource server");
    }

    @Path(value="units/bulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response insertUnitBulk(BulkUnitInsertRequest request) {
        try {
            List requests = request.getUnits().stream().map(e -> {
                try {
                    InsertMultiQuery query = new InsertMultiQuery();
                    query.addData(new ObjectNode[]{(ObjectNode)e.getUnit()});
                    query.addRoots((String[])e.getParentUnitIds().toArray(String[]::new));
                    return query.getFinalInsert();
                }
                catch (InvalidParseOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList());
            this.metaData.insertUnits(requests);
        }
        catch (MetaDataExecutionException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage())).build();
        }
        catch (InvalidParseOperationException e2) {
            LOGGER.error((Throwable)e2);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e2.getMessage())).build();
        }
        catch (MetaDataNotFoundException e3) {
            LOGGER.error((Throwable)e3);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e3.getMessage())).build();
        }
        RequestResponseOK responseOK = new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)responseOK).build();
    }

    @Path(value="units/updatebulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitBulk(JsonNode updateQuery) {
        RequestResponseOK resultResponse;
        try {
            UpdateParserMultiple requestParserMultiple = new UpdateParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
            requestParserMultiple.parse(updateQuery);
            Set unitIds = requestParserMultiple.getRequest().getRoots();
            List requestByIds = unitIds.stream().map(unitId -> new RequestById(unitId, (RequestParserMultiple)requestParserMultiple)).collect(Collectors.toList());
            List updatedUnitResult = this.metaData.updateUnits(requestByIds, true, this.configuration.getRefreshElasticIndexPostBulkIndexing());
            resultResponse = new RequestResponseOK(updateQuery).addAllResults(updatedUnitResult);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resultResponse).build();
    }

    @Path(value="units/atomicupdatebulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response atomicUpdateBulk(List<JsonNode> updateQueries) {
        ArrayList<RequestResponse<UpdateUnit>> updateUnitResponses = new ArrayList<RequestResponse<UpdateUnit>>();
        HashMap<Integer, RequestResponse<UpdateUnit>> invalidRequestIndexMap = new HashMap<Integer, RequestResponse<UpdateUnit>>();
        try {
            ArrayList<RequestById> bulkRequests = new ArrayList<RequestById>();
            int queryIndex = -1;
            for (JsonNode updateQuery : updateQueries) {
                ++queryIndex;
                try {
                    bulkRequests.addAll(this.prepareBulkQueries(updateQuery));
                }
                catch (InvalidParseOperationException e) {
                    Response.Status status = Response.Status.BAD_REQUEST;
                    VitamError error = new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage());
                    invalidRequestIndexMap.put(queryIndex, (RequestResponse<UpdateUnit>)error);
                }
            }
            List successCallUpdateUnits = this.metaData.updateUnits(bulkRequests, false, this.configuration.getRefreshElasticIndexPostBulkIndexing());
            this.makeResponsesAsSameOrderAsCalls(updateQueries, invalidRequestIndexMap, updateUnitResponses, successCallUpdateUnits);
        }
        catch (InvalidParseOperationException e) {
            Response.Status status = Response.Status.BAD_REQUEST;
            updateUnitResponses.add((RequestResponse<UpdateUnit>)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage()));
        }
        RequestResponseOK updateRequestResponse = new RequestResponseOK().addAllResults(updateUnitResponses).setHttpCode(Response.Status.OK.getStatusCode());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)updateRequestResponse).build();
    }

    private void makeResponsesAsSameOrderAsCalls(List<JsonNode> updateQueries, Map<Integer, RequestResponse<UpdateUnit>> invalidRequestIndexMap, List<RequestResponse<UpdateUnit>> updateUnitResponses, List<UpdateUnit> successCallUpdateUnits) {
        int okResponseIndex = 0;
        for (int index = 0; index < updateQueries.size(); ++index) {
            if (invalidRequestIndexMap.containsKey(index)) {
                updateUnitResponses.add(invalidRequestIndexMap.get(index));
                continue;
            }
            updateUnitResponses.add((RequestResponse<UpdateUnit>)new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addResult((Object)successCallUpdateUnits.get(okResponseIndex++)));
        }
    }

    private List<RequestById> prepareBulkQueries(JsonNode updateQuery) throws InvalidParseOperationException {
        ArrayList<RequestById> bulkRequests = new ArrayList<RequestById>();
        UpdateParserMultiple updateRequest = new UpdateParserMultiple((VarNameAdapter)DEFAULT_VARNAME_ADAPTER);
        updateRequest.parse(updateQuery);
        UpdateMultiQuery request = updateRequest.getRequest();
        Set unitIds = request.getRoots();
        if (CollectionUtils.size((Object)unitIds) != 1) {
            throw new InvalidParseOperationException("Request with roots different to 1, found %s" + updateQuery.toString());
        }
        for (String documentId : unitIds) {
            bulkRequests.add(new RequestById(documentId, (RequestParserMultiple)updateRequest));
        }
        return bulkRequests;
    }

    @Path(value="units/updaterulesbulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitsRulesBulk(BatchRulesUpdateInfo batchRulesUpdateInfo) {
        RequestResponse result = this.metaData.updateUnitsRules(batchRulesUpdateInfo.getUnitIds(), batchRulesUpdateInfo.getRuleActions(), batchRulesUpdateInfo.getRulesToDurationData());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @Path(value="units/bulk")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnitBulk(List<JsonNode> requests) {
        ArrayList<RequestResponseOK> results = new ArrayList<RequestResponseOK>();
        for (JsonNode request : requests) {
            RequestResponse<?> result = this.selectUnitsByQuery(request);
            if (!result.isOk()) {
                LOGGER.error("Execution of select request was is error: request=" + JsonHandler.unprettyPrint((Object)request));
                return Response.status((int)result.getHttpCode()).entity(result).build();
            }
            results.add((RequestResponseOK)result);
        }
        RequestResponseOK vitamResponse = new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.OK.getStatusCode());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)vitamResponse).build();
    }

    @Path(value="units")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnit(JsonNode request) {
        RequestResponse<?> result = this.selectUnitsByQuery(request);
        int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
        Response.Status status = Response.Status.fromStatusCode((int)st);
        return Response.status((Response.Status)status).entity(result).build();
    }

    private RequestResponse<?> selectUnitsByQuery(JsonNode selectRequest) {
        try {
            MetadataResult metadataResult = this.metaData.selectUnitsByQuery(selectRequest);
            return new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits());
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage());
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage());
        }
        catch (MetaDataExecutionException e) {
            return this.getMetadataExecutionExceptionVitamError((Exception)((Object)e));
        }
        catch (MetaDataDocumentSizeException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.REQUEST_ENTITY_TOO_LARGE;
            return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage());
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage());
        }
    }

    @Path(value="units")
    @PUT
    @Produces(value={"application/json"})
    public Response refreshUnit() {
        try {
            this.metaData.refreshUnit();
            RequestResponseOK response = new RequestResponseOK();
            response.setHits(1L, 0, 1);
            response.setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamThreadAccessException | IllegalArgumentException e) {
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            LOGGER.error(e);
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (Exception e) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @Path(value="objectgroups")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectObjectgroups(JsonNode request) {
        return this.selectObjectgroupsByQuery(request);
    }

    private Response selectObjectgroupsByQuery(JsonNode selectRequest) {
        try {
            MetadataResult metadataResult = this.metaData.selectObjectGroupsByQuery(selectRequest);
            return Response.ok().entity((Object)new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits())).build();
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage())).build();
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            return this.metadataExecutionExceptionTrace((Exception)((Object)e));
        }
        catch (MetaDataDocumentSizeException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.REQUEST_ENTITY_TOO_LARGE;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @Path(value="objectgroups")
    @PUT
    @Produces(value={"application/json"})
    public Response refreshObjectGroup() {
        try {
            this.metaData.refreshObjectGroup();
            RequestResponseOK response = new RequestResponseOK();
            response.setHits(1L, 0, 1);
            response.setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamThreadAccessException | IllegalArgumentException e) {
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            LOGGER.error(e);
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (Exception e) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @Path(value="units/{id_unit}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUnitById(JsonNode selectRequest, @PathParam(value="id_unit") String unitId) {
        return this.selectUnitById(selectRequest, unitId);
    }

    @Path(value="units/{id_unit}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitById(JsonNode updateRequest, @PathParam(value="id_unit") String unitId) {
        try {
            boolean withRefreshIndex = true;
            UpdateUnit result = this.metaData.updateUnitById(updateRequest, unitId, true, withRefreshIndex);
            return Response.ok((Object)new RequestResponseOK().addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException | MetadataValidationException e) {
            return this.metadataExecutionExceptionTrace((Exception)e);
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    private Response selectUnitById(JsonNode selectRequest, String unitId) {
        try {
            MetadataResult metadataResult = this.metaData.selectUnitsById(selectRequest, unitId);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits())).build();
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage())).build();
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            return this.metadataExecutionExceptionTrace((Exception)((Object)e));
        }
        catch (MetaDataDocumentSizeException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.REQUEST_ENTITY_TOO_LARGE;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(e.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
    }

    private Response metadataExecutionExceptionTrace(Exception e) {
        LOGGER.error((Throwable)e);
        Response.Status status = Response.Status.BAD_REQUEST;
        Throwable e2 = e.getCause();
        if (e2 instanceof IllegalArgumentException || e2 instanceof ElasticsearchParseException) {
            status = Response.Status.PRECONDITION_FAILED;
        } else {
            e2 = e;
        }
        return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e2.getMessage())).build();
    }

    private VitamError getMetadataExecutionExceptionVitamError(Exception e) {
        LOGGER.error((Throwable)e);
        Response.Status status = Response.Status.BAD_REQUEST;
        Throwable e2 = e.getCause();
        if (e2 instanceof IllegalArgumentException || e2 instanceof ElasticsearchParseException) {
            status = Response.Status.PRECONDITION_FAILED;
        } else {
            e2 = e;
        }
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e2.getMessage());
    }

    @Path(value="objectgroups")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response insertObjectGroup(JsonNode insertRequest) {
        try {
            this.metaData.insertObjectGroup(insertRequest);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new RequestResponseOK(insertRequest).setHits(1L, 0, 1).setHttpCode(Response.Status.CREATED.getStatusCode())).build();
    }

    @Path(value="objectgroups/bulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response insertObjectGroupBulk(List<JsonNode> insertRequests) {
        try {
            this.metaData.insertObjectGroups(insertRequests);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        insertRequests.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        RequestResponseOK responseOK = new RequestResponseOK();
        responseOK.setHits((long)arrayNode.size(), 0, arrayNode.size()).setHttpCode(Response.Status.CREATED.getStatusCode());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)responseOK).build();
    }

    @Path(value="objectgroups/{id_og}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getObjectGroupById(JsonNode selectRequest, @PathParam(value="id_og") String objectGroupId) {
        try {
            ParametersChecker.checkParameter((String)"Request select required", (Object[])new Object[]{selectRequest});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return this.selectObjectGroupById(selectRequest, objectGroupId);
    }

    @Path(value="objectgroups/{id_og}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateObjectGroupById(JsonNode updateRequest, @PathParam(value="id_og") String objectGroupId) {
        try {
            ParametersChecker.checkParameter((String)"UpdateQuery required", (Object[])new Object[]{updateRequest});
            ParametersChecker.checkParameter((String)"ObjectGroupId required", (String[])new String[]{objectGroupId});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        try {
            boolean withRefreshIndex = true;
            this.metaData.updateObjectGroupId(updateRequest, objectGroupId, true, withRefreshIndex);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new RequestResponseOK().addResult((Object)objectGroupId).setHttpCode(Response.Status.CREATED.getStatusCode())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException | MetadataValidationException e) {
            return this.metadataExecutionExceptionTrace((Exception)e);
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error("Object group not found " + objectGroupId, (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    private Response selectObjectGroupById(JsonNode selectRequest, String objectGroupId) {
        try {
            MetadataResult metadataResult = this.metaData.selectObjectGroupById(selectRequest, objectGroupId);
            return Response.ok().entity((Object)new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits())).build();
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage())).build();
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            return this.metadataExecutionExceptionTrace((Exception)((Object)e));
        }
        catch (MetaDataDocumentSizeException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.REQUEST_ENTITY_TOO_LARGE;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @Path(value="accession-registers/units/{operationId}")
    @Produces(value={"application/json"})
    @GET
    public Response selectAccessionRegisterOnUnitByOperationId(@PathParam(value="operationId") String operationId) {
        try {
            List documents = this.metaData.selectOwnAccessionRegisterOnUnitByOperationId(operationId);
            RequestResponseOK responseOK = new RequestResponseOK();
            responseOK.setHttpCode(Response.Status.OK.getStatusCode());
            responseOK.addAllResults(documents);
            return responseOK.toResponse();
        }
        catch (MetaDataExecutionException e) {
            return this.metadataExecutionExceptionTrace((Exception)((Object)e));
        }
    }

    @POST
    @Path(value="accession-registers/symbolic")
    @Produces(value={"application/json"})
    public Response createAccessionRegisterSymbolic() {
        try {
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            List accessionRegisterSymbolic = this.metaData.createAccessionRegisterSymbolic(tenantId).stream().map(AccessionRegisterSymbolic::new).collect(Collectors.toList());
            return new RequestResponseOK().addAllResults(accessionRegisterSymbolic).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return new VitamError(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).setMessage(e.getMessage()).toResponse();
        }
    }

    @Path(value="accession-registers/objects/{operationId}")
    @Produces(value={"application/json"})
    @GET
    public Response selectAccessionRegisterOnObjectGroupByOperationId(@PathParam(value="operationId") String operationId) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            List documents = this.metaData.selectOwnAccessionRegisterOnObjectGroupByOperationId(tenantId, operationId);
            RequestResponseOK responseOK = new RequestResponseOK();
            responseOK.setHttpCode(Response.Status.OK.getStatusCode());
            responseOK.addAllResults(documents);
            return responseOK.toResponse();
        }
        catch (MetaDataExecutionException e) {
            LOGGER.error((Throwable)e);
            VitamError error = VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_INDEXATION_ERROR, (String)e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
        }
    }

    @Path(value="/reindex")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reindex(IndexParameters indexParameters) {
        try {
            ParametersChecker.checkParameter((String)"Parameters are mandatory", (Object[])new Object[]{indexParameters});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(Response.Status.PRECONDITION_FAILED.name()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        ReindexationResult result = this.metaData.reindex(indexParameters);
        if (result.getIndexKO() == null || result.getIndexKO().isEmpty()) {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        if (result.getIndexOK() != null && !result.getIndexOK().isEmpty()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)result).build();
    }

    @Path(value="/alias")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeIndexes(SwitchIndexParameters switchIndexParameters) {
        try {
            ParametersChecker.checkParameter((String)"parameter is mandatory", (Object[])new Object[]{switchIndexParameters});
            ParametersChecker.checkParameter((String)"alias parameter is mandatory", (String[])new String[]{switchIndexParameters.getAlias()});
            ParametersChecker.checkParameter((String)"indexName parameter is mandatory", (String[])new String[]{switchIndexParameters.getIndexName()});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(Response.Status.PRECONDITION_FAILED.name()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        try {
            SwitchIndexResult switchIndexResult = this.metaData.switchIndex(switchIndexParameters.getAlias(), switchIndexParameters.getIndexName());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)switchIndexResult).build();
        }
        catch (DatabaseException exc) {
            VitamError error = VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_SWITCH_INDEX_ERROR, (String)exc.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
        }
    }

    @Path(value="unitsWithInheritedRules")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnitsWithInheritedRules(JsonNode selectRequest) {
        try {
            MetadataResult metadataResult = this.metadataRuleService.selectUnitsWithInheritedRules(selectRequest);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits())).build();
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(ve.getMessage())).build();
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataExecutionException e) {
            return this.metadataExecutionExceptionTrace((Exception)((Object)e));
        }
        catch (MetaDataDocumentSizeException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.REQUEST_ENTITY_TOO_LARGE;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="objectGroups/bulkDelete")
    public Response deleteObjectGroups(List<String> ids) {
        JsonNode jsonNode;
        try {
            jsonNode = JsonHandler.toJsonNode(ids);
            this.metaData.deleteObjectGroups(ids);
        }
        catch (MetaDataExecutionException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(jsonNode).setHits((long)ids.size(), 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
    }

    @DELETE
    @Path(value="units/bulkDelete")
    public Response deleteUnits(List<String> ids) {
        JsonNode jsonNode;
        try {
            jsonNode = JsonHandler.toJsonNode(ids);
            this.metaData.deleteUnits(ids);
        }
        catch (MetaDataExecutionException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CONTEXT_METADATA).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(jsonNode).setHits((long)ids.size(), 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Path(value="/units/stream")
    public Response streamUnits(JsonNode request) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            this.metaData.checkStreamUnits(tenantId, this.configuration.getUnitsStreamExecutionLimit());
        }
        catch (MetaDataException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        long threshold = this.configuration.getUnitsStreamThreshold();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        Histogram.Timer unitStreamDuration = ((Histogram.Child)CommonMetadataMetrics.UNIT_SCROLL_DURATION_HISTOGRAM.labels(new String[]{requestId})).startTimer();
        File file = null;
        try {
            long documentCount;
            file = FileUtil.createFileInTempDirectoryWithPathCheck((String)requestId, (String)".jsonl");
            try (FileOutputStream out = new FileOutputStream(file);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)out);){
                ArrayListScrollSpliterator scrollRequest;
                SelectParserMultiple parser = new SelectParserMultiple();
                parser.parse(request);
                SelectMultiQuery selectQuery = parser.getRequest();
                if (selectQuery.getThreshold() != null) {
                    threshold = Math.min(threshold, selectQuery.getThreshold());
                }
                if ((documentCount = (scrollRequest = new ArrayListScrollSpliterator(parser.getRequest(), query -> {
                    try {
                        MetadataResult metadataResult = this.metaData.selectUnitsByQuery((JsonNode)query.getFinalSelect());
                        ((Counter.Child)CommonMetadataMetrics.UNIT_SCROLL_COUNTER.labels(new String[]{requestId})).inc((double)metadataResult.getResults().size());
                        return new RequestResponseOK(metadataResult.getQuery()).addResult((Object)metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits());
                    }
                    catch (BadRequestException | InvalidParseOperationException | VitamDBException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                        throw new VitamRuntimeException(e);
                    }
                }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue())).estimateSize()) > threshold) {
                    Response response = Response.status((Response.Status)Response.Status.CONFLICT).build();
                    return response;
                }
                SpliteratorIterator jsonNodeSpliteratorIterator = new SpliteratorIterator((Spliterator)scrollRequest);
                while (jsonNodeSpliteratorIterator.hasNext()) {
                    writer.addEntries((List)jsonNodeSpliteratorIterator.next());
                }
            }
            this.metaData.updateParameterStreamUnits(tenantId);
            FileInputStream is = new FileInputStream(file);
            Response response = Response.ok((Object)new ExactSizeInputStream((InputStream)is, file.length())).header("X-Units-Count", (Object)documentCount).header("X-Content-Length", (Object)file.length()).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            unitStreamDuration.observeDuration();
            FileUtils.deleteQuietly((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Path(value="/objects/stream")
    public Response streamObjects(JsonNode request) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            this.metaData.checkStreamObjects(tenantId, this.configuration.getObjectsStreamExecutionLimit());
        }
        catch (MetaDataException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        Histogram.Timer objectStreamDuration = ((Histogram.Child)CommonMetadataMetrics.OBJECT_SCROLL_DURATION_HISTOGRAM.labels(new String[]{requestId})).startTimer();
        File file = null;
        try {
            long documentCount;
            file = FileUtil.createFileInTempDirectoryWithPathCheck((String)requestId, (String)".jsonl");
            try (FileOutputStream out = new FileOutputStream(file);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)out);){
                SelectParserMultiple parser = new SelectParserMultiple();
                parser.parse(request);
                ArrayListScrollSpliterator scrollRequest = new ArrayListScrollSpliterator(parser.getRequest(), query -> this.selectObjectGroupsByQuery((SelectMultiQuery)query, requestId), VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
                documentCount = scrollRequest.estimateSize();
                if (this.objectsStreamThresholdExceed(documentCount, parser)) {
                    Response response = Response.status((Response.Status)Response.Status.CONFLICT).build();
                    return response;
                }
                SpliteratorIterator jsonNodeSpliteratorIterator = new SpliteratorIterator((Spliterator)scrollRequest);
                while (jsonNodeSpliteratorIterator.hasNext()) {
                    writer.addEntries((List)jsonNodeSpliteratorIterator.next());
                }
            }
            this.metaData.updateParameterStreamObjects(tenantId);
            FileInputStream is = new FileInputStream(file);
            Response response = Response.ok((Object)new ExactSizeInputStream((InputStream)is, file.length())).header("X-Objects-Count", (Object)documentCount).header("X-Content-Length", (Object)file.length()).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            objectStreamDuration.observeDuration();
            FileUtils.deleteQuietly((File)file);
        }
    }

    private RequestResponse<List<JsonNode>> selectObjectGroupsByQuery(SelectMultiQuery query, String requestId) {
        try {
            MetadataResult metadataResult = this.metaData.selectObjectGroupsByQuery((JsonNode)query.getFinalSelect());
            ((Counter.Child)CommonMetadataMetrics.OBJECT_SCROLL_COUNTER.labels(new String[]{requestId})).inc((double)metadataResult.getResults().size());
            return new RequestResponseOK(metadataResult.getQuery()).addResult((Object)metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits());
        }
        catch (BadRequestException | InvalidParseOperationException | VitamDBException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private boolean objectsStreamThresholdExceed(long documentCount, SelectParserMultiple parser) {
        SelectMultiQuery selectQuery = parser.getRequest();
        long threshold = this.configuration.getObjectsStreamThreshold();
        if (selectQuery.getThreshold() != null) {
            threshold = Math.min(threshold, selectQuery.getThreshold());
        }
        return documentCount > threshold;
    }

    @Path(value="/scroll")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response clearESScrollFilter(String scrollId) {
        try {
            this.metaData.clearESScrollFilter(scrollId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
        }
    }
}

