/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.core.migration.UnitsWithTransferRequestsMigrationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/metadata/v1")
@Tag(name="Metadata")
public class MetadataAdminMigrationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataAdminMigrationResource.class);
    private static final String X_THRESHOLD_PARAMETER = "X-Threshold";
    private final UnitsWithTransferRequestsMigrationService migrationService;

    public MetadataAdminMigrationResource(UnitsWithTransferRequestsMigrationService migrationService) {
        this.migrationService = migrationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/migrateUnitsWithTransferRequests")
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response migrateUnitsWithTransferRequests(@HeaderParam(value="X-Tenant-Id") Integer xTenantId, @QueryParam(value="X-Threshold") @DefaultValue(value="100000") Integer threshold) {
        try {
            ParametersChecker.checkParameter((String)"X_TENANT_ID header is required and mustn't be null", (Object[])new Object[]{xTenantId});
            VitamThreadUtils.getVitamSession().setTenantId(xTenantId);
            String operationId = GUIDFactory.newRequestIdGUID((int)xTenantId).toString();
            VitamThreadUtils.getVitamSession().setRequestId(operationId);
            VitamThreadUtils.getVitamSession().setApplicationSessionId("internal-units-with-transfer-requests-migration");
            boolean migrationProceeded = this.migrationService.migrateUnits(threshold.intValue());
            if (migrationProceeded) {
                Response response = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addResult((Object)operationId).toResponse();
                return response;
            }
            Response response = new RequestResponseOK().setHttpCode(Response.Status.ACCEPTED.getStatusCode()).toResponse();
            return response;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            Response response = MetadataAdminMigrationResource.getResponse(Response.Status.BAD_REQUEST, e, "Migration failed for tenant " + xTenantId + ". Illegal parameter");
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            Response response = MetadataAdminMigrationResource.getResponse(Response.Status.INTERNAL_SERVER_ERROR, e, "Migration failed for tenant " + xTenantId + ". Internal server error");
            return response;
        }
        finally {
            VitamThreadUtils.getVitamSession().setApplicationSessionId(null);
        }
    }

    private static Response getResponse(Response.Status status, Exception e, String message) {
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ServiceName.METADATA.getName()).setMessage(message).setDescription(e.getMessage()).toResponse();
    }
}

