/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.security.waf.SanityDynamicFeature;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.MongoDbAccessMetadataFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfigurationValidator;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import fr.gouv.vitam.metadata.core.database.collections.PersistentIdentifierRepositoryImpl;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import fr.gouv.vitam.metadata.core.reconstruction.domain.OffsetManager;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PersistentIdentifierReconstructionManager;
import fr.gouv.vitam.metadata.core.reconstruction.repository.OperationReportRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionOperationRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.impl.OperationReportRepositoryImpl;
import fr.gouv.vitam.metadata.core.reconstruction.repository.impl.ReconstructionOperationRepositoryImpl;
import fr.gouv.vitam.metadata.core.rules.MetadataRuleService;
import fr.gouv.vitam.metadata.rest.MetadataAuditResource;
import fr.gouv.vitam.metadata.rest.MetadataManagementResource;
import fr.gouv.vitam.metadata.rest.MetadataRawResource;
import fr.gouv.vitam.metadata.rest.MetadataReconstructionResource;
import fr.gouv.vitam.metadata.rest.MetadataResource;
import fr.gouv.vitam.metadata.rest.PersistentIdentifierResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private final Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            MetaDataConfiguration metaDataConfiguration = (MetaDataConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, MetaDataConfiguration.class);
            this.commonBusinessApplication = new CommonBusinessApplication();
            MetaDataConfigurationValidator.validateConfiguration((MetaDataConfiguration)metaDataConfiguration);
            MappingLoader mappingLoader = new MappingLoader(metaDataConfiguration.getElasticsearchExternalMetadataMappings());
            ElasticsearchMetadataIndexManager indexManager = new ElasticsearchMetadataIndexManager(metaDataConfiguration, VitamConfiguration.getTenants(), mappingLoader);
            MongoDbAccessMetadataImpl mongoAccessMetadata = MongoDbAccessMetadataFactory.create((MetaDataConfiguration)metaDataConfiguration, (ElasticsearchMetadataIndexManager)indexManager);
            OffsetRepository offsetRepository = new OffsetRepository((MongoDbAccess)mongoAccessMetadata);
            VitamRepositoryFactory vitamRepositoryProvider = VitamRepositoryFactory.get();
            MetaDataImpl metadata = MetaDataImpl.newMetadata((MongoDbAccessMetadataImpl)mongoAccessMetadata, (int)VitamConfiguration.getOntologyCacheMaxEntries(), (int)VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (int)metaDataConfiguration.getArchiveUnitProfileCacheMaxEntries(), (int)metaDataConfiguration.getArchiveUnitProfileCacheTimeoutInSeconds(), (int)metaDataConfiguration.getSchemaValidatorCacheMaxEntries(), (int)metaDataConfiguration.getSchemaValidatorCacheTimeoutInSeconds(), (ElasticsearchMetadataIndexManager)indexManager);
            MetadataRuleService metadataRuleService = new MetadataRuleService(metadata);
            MetadataResource metaDataResource = new MetadataResource(metadata, metadataRuleService, metaDataConfiguration);
            MetadataRawResource metadataRawResource = new MetadataRawResource((VitamRepositoryProvider)vitamRepositoryProvider);
            MetadataManagementResource metadataManagementResource = new MetadataManagementResource((VitamRepositoryProvider)vitamRepositoryProvider, metadata, metaDataConfiguration, indexManager);
            MetadataReconstructionResource metadataReconstructionResource = new MetadataReconstructionResource((VitamRepositoryProvider)vitamRepositoryProvider, offsetRepository, metaDataConfiguration, indexManager);
            MetadataAuditResource metadataAuditResource = new MetadataAuditResource(metaDataConfiguration);
            PersistentIdentifierRepositoryImpl persistentIdentifierRepository = new PersistentIdentifierRepositoryImpl(mongoAccessMetadata);
            OperationReportRepositoryImpl operationReportRepository = new OperationReportRepositoryImpl();
            ReconstructionOperationRepositoryImpl reconstructionOperationRepository = new ReconstructionOperationRepositoryImpl();
            PersistentIdentifierReconstructionManager persistentIdentifierReconstructionManager = new PersistentIdentifierReconstructionManager((OperationReportRepository)operationReportRepository, (ReconstructionOperationRepository)reconstructionOperationRepository, metaDataConfiguration, (PersistentIdentifierRepository)persistentIdentifierRepository);
            OffsetManager offsetManager = new OffsetManager(offsetRepository);
            PersistentIdentifierResource persistentIdentifierResource = new PersistentIdentifierResource(persistentIdentifierReconstructionManager, offsetManager, metaDataConfiguration, (PersistentIdentifierRepository)persistentIdentifierRepository);
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)metaDataResource);
            this.singletons.add(metadataRawResource);
            this.singletons.add(metadataManagementResource);
            this.singletons.add(metadataReconstructionResource);
            this.singletons.add(metadataAuditResource);
            this.singletons.add(persistentIdentifierResource);
            this.singletons.add(new SanityDynamicFeature());
        }
        catch (IOException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

