/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.XsdValidator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;

public class SedaXsdValidatorProvider {
    private static final SedaXsdValidatorProvider INSTANCE = new SedaXsdValidatorProvider();
    private final Map<SupportedSedaVersions, XsdValidator> xsdValidatorMap = Arrays.stream(SupportedSedaVersions.values()).collect(Collectors.toMap(supportedSedaVersions -> supportedSedaVersions, supportedSedaVersions -> {
        try {
            return new XsdValidator(supportedSedaVersions.getVitamValidatorXSD());
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }));

    public static SedaXsdValidatorProvider getInstance() {
        return INSTANCE;
    }

    private SedaXsdValidatorProvider() {
    }

    public XsdValidator getValidator(SupportedSedaVersions supportedSedaVersions) {
        return this.xsdValidatorMap.get(supportedSedaVersions);
    }
}

