/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaIngestParams;
import fr.gouv.vitam.worker.common.utils.SedaUtils;

public class SedaUtilsFactory {
    public static final String SEDA_INGEST_PARAMS_FILE = "Maps/sedaParams.json";
    private static final SedaUtilsFactory sedaUtilsFactory = new SedaUtilsFactory();

    private SedaUtilsFactory() {
    }

    public static SedaUtilsFactory getInstance() {
        return sedaUtilsFactory;
    }

    public SedaUtils createSedaUtils(HandlerIO handlerIO) {
        ParametersChecker.checkParameter((String)"HandlerIO must not be null", (Object[])new Object[]{handlerIO});
        return new SedaUtils(handlerIO);
    }

    public SedaUtils createSedaUtilsWithSedaIngestParams(HandlerIO handlerIO) throws ProcessingException {
        try {
            if (handlerIO.isExistingFileInWorkspace(SEDA_INGEST_PARAMS_FILE)) {
                SedaUtils sedaUtils = this.createSedaUtils(handlerIO);
                JsonNode sedaPrams = handlerIO.getJsonFromWorkspace(SEDA_INGEST_PARAMS_FILE);
                sedaUtils.setSedaIngestParams((SedaIngestParams)JsonHandler.getFromJsonNode((JsonNode)sedaPrams, SedaIngestParams.class));
                return sedaUtils;
            }
            throw new ProcessingException("Seda ingest params have not been saved!");
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            throw new ProcessingException("A problem occurred when reading Seda ingest params from workspace for operation " + handlerIO.getContainerName());
        }
    }

    @Deprecated
    public static SedaUtils create(HandlerIO handlerIO) {
        ParametersChecker.checkParameter((String)"HandlerIO must not be null", (Object[])new Object[]{handlerIO});
        return sedaUtilsFactory.createSedaUtils(handlerIO);
    }
}

