/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.SedaConfiguration;
import fr.gouv.vitam.common.SedaVersion;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.digest.DigestTypeException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamKoRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.InvalidXmlException;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.common.xml.XmlNamespaceUtils;
import fr.gouv.vitam.common.xml.XsdValidator;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.DataObjectInfo;
import fr.gouv.vitam.worker.common.utils.DataObjectValidator;
import fr.gouv.vitam.worker.common.utils.ExtractUriResponse;
import fr.gouv.vitam.worker.common.utils.InvalidDataObjectException;
import fr.gouv.vitam.worker.common.utils.SedaIngestParams;
import fr.gouv.vitam.worker.common.utils.SedaUtilInfo;
import fr.gouv.vitam.worker.common.utils.SedaUtilsException;
import fr.gouv.vitam.worker.common.utils.SedaXsdValidatorProvider;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.SAXException;

public class SedaUtils {
    static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SedaUtils.class);
    private static final String MSG_PARSING_BDO = "Parsing Binary Data Object";
    private static final String CANNOT_READ_SEDA = "Can not read SEDA";
    private static final String MANIFEST_NOT_FOUND = "Manifest.xml Not Found";
    private static final String CONTAINS_OTHER_TYPE = "ContainsOtherType";
    private static final String INCORRECT_VERSION_FORMAT = "IncorrectVersionFormat";
    private static final String INCORRECT_URI = "IncorrectUri";
    private static final String INCORRECT_PHYSICAL_ID = "IncorrectPhysicalId";
    private static final int USAGE_POSITION = 0;
    private static final int VERSION_POSITION = 1;
    public static final String NB_AU_EXISTING = "nbAUExisting";
    public static final String INVALID_DATAOBJECT_VERSION = "INVALID_DATAOBJECT_VERSION";
    public static final String VALID_DATAOBJECT_VERSION = "VALID_DATAOBJECT_VERSION";
    private final HandlerIO handlerIO;
    private static final Pattern namespacePattern = Pattern.compile("^fr:gouv:culture:archivesdefrance:seda:v([0-9]\\.[0-9]+)$");
    private static final String SEDA_PARAMS_ARE_NOT_VALID = "Seda params are not valid!";
    private SedaIngestParams sedaIngestParams;

    protected SedaUtils(HandlerIO handlerIO) {
        this.handlerIO = handlerIO;
    }

    public Map<String, String> getMandatoryValues(WorkerParameters params) throws ProcessingException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        HashMap<String, String> mandatoryValueMap = new HashMap<String, String>();
        XMLEventReader reader = null;
        try (InputStream xmlFile = this.loadIngestManifest();){
            XMLEvent event;
            StringBuilder sedaComment = new StringBuilder();
            reader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
            do {
                if (!(event = reader.nextEvent()).isStartElement()) continue;
                StartElement element = event.asStartElement();
                this.manageMandatoryFields(mandatoryValueMap, reader, sedaComment, element);
            } while (!event.isEndDocument());
            if (sedaComment.length() > 0) {
                mandatoryValueMap.put("Comment", sedaComment.toString());
            }
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error(CANNOT_READ_SEDA, (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            }
        }
        return mandatoryValueMap;
    }

    public void extractXmlNameSpaceAndSaveSedaParams(HandlerIO handlerIO, int sedaIngestParamsRankOutput) throws ProcessingException {
        try (InputStream xmlFile = this.loadIngestManifest();){
            String namespaceURI = XmlNamespaceUtils.parseXmlNamespace((InputStream)xmlFile);
            if (namespaceURI == null) {
                throw new ProcessingException("The namespace URI could not be read from Manifest!");
            }
            this.extractAndSaveSedaIngestParams(handlerIO, sedaIngestParamsRankOutput, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new ProcessingException(CheckSedaValidationStatus.NOT_XML_FILE.name(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("A technical problem occurred when reading Manifest!", (Throwable)e);
        }
    }

    private InputStream loadIngestManifest() throws ProcessingException {
        try {
            return this.handlerIO.getInputStreamFromWorkspace("SIP/manifest.xml");
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(MANIFEST_NOT_FOUND);
            throw new ProcessingException(e);
        }
    }

    private void manageMandatoryFields(Map<String, String> madatoryValueMap, XMLEventReader reader, StringBuilder sedaComment, StartElement element) throws XMLStreamException {
        QName contractName = new QName(this.sedaIngestParams.getNamespaceURI(), "ArchivalAgreement");
        if (element.getName().equals(contractName)) {
            madatoryValueMap.put("ArchivalAgreement", reader.getElementText());
        }
        QName messageObjectName = new QName(this.sedaIngestParams.getNamespaceURI(), "MessageIdentifier");
        if (element.getName().equals(messageObjectName)) {
            madatoryValueMap.put("MessageIdentifier", reader.getElementText());
        }
        QName profilName = new QName(this.sedaIngestParams.getNamespaceURI(), "ArchivalProfile");
        if (element.getName().equals(profilName)) {
            madatoryValueMap.put("ArchivalProfile", reader.getElementText());
        }
        QName submissionAgencyName = new QName(this.sedaIngestParams.getNamespaceURI(), "SubmissionAgencyIdentifier");
        if (element.getName().equals(submissionAgencyName)) {
            madatoryValueMap.put("SubmissionAgencyIdentifier", reader.getElementText());
        }
        QName commentName = new QName(this.sedaIngestParams.getNamespaceURI(), "Comment");
        if (element.getName().equals(commentName)) {
            if (!"".equals(sedaComment.toString())) {
                sedaComment.append("_");
            }
            sedaComment.append(reader.getElementText());
        }
        QName originatingAgencyName = new QName(this.sedaIngestParams.getNamespaceURI(), "OriginatingAgencyIdentifier");
        if (element.getName().equals(originatingAgencyName)) {
            madatoryValueMap.put("OriginatingAgencyIdentifier", reader.getElementText());
        }
        QName acquisitionInformationName = new QName(this.sedaIngestParams.getNamespaceURI(), "AcquisitionInformation");
        if (element.getName().equals(acquisitionInformationName)) {
            madatoryValueMap.put("AcquisitionInformation", reader.getElementText());
        }
        QName legalStatusName = new QName(this.sedaIngestParams.getNamespaceURI(), "LegalStatus");
        if (element.getName().equals(legalStatusName)) {
            madatoryValueMap.put("LegalStatus", reader.getElementText());
        }
    }

    private void extractAndSaveSedaIngestParams(HandlerIO handlerIO, int sedaIngestParamsOutputRank, String xmLNameSpace) throws ProcessingException {
        try {
            Pair<String, String> extractedNameSpaceAndSedaVersion = this.validateNameSpaceAndSedaVersion(xmLNameSpace);
            this.sedaIngestParams = new SedaIngestParams((String)extractedNameSpaceAndSedaVersion.getRight(), (String)extractedNameSpaceAndSedaVersion.getLeft());
            File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(sedaIngestParamsOutputRank).getPath());
            JsonHandler.writeAsFile((Object)this.sedaIngestParams, (File)tempFile);
            handlerIO.addOutputResult(sedaIngestParamsOutputRank, (Object)tempFile, true, false);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException(SEDA_PARAMS_ARE_NOT_VALID);
        }
    }

    private Pair<String, String> validateNameSpaceAndSedaVersion(String namespaceFromManifest) throws ProcessingException {
        Matcher namespaceMatcher = namespacePattern.matcher(namespaceFromManifest);
        if (namespaceMatcher.find()) {
            return Pair.of((Object)namespaceFromManifest, (Object)namespaceMatcher.group(1));
        }
        throw new ProcessingException("Invalid NameSpace pattern in Manifest !");
    }

    public CheckSedaValidationStatus checkSedaValidation(ItemStatus itemStatus) {
        try {
            File manifestFile = this.getManifestFile();
            if (this.checkMultiManifest()) {
                return CheckSedaValidationStatus.MORE_THAN_ONE_MANIFEST;
            }
            if (!this.checkFolderContentNumber()) {
                return CheckSedaValidationStatus.MORE_THAN_ONE_FOLDER_CONTENT;
            }
            Optional<SupportedSedaVersions> sedaSupportedVersionModel = this.getSupportedSedaModelByVersion(this.sedaIngestParams.getVersion());
            if (sedaSupportedVersionModel.isEmpty()) {
                LOGGER.warn(this.sedaIngestParams.getVersion() + " is not supported by Vitam!");
                return CheckSedaValidationStatus.UNSUPPORTED_SEDA_VERSION;
            }
            XsdValidator xsdValidator = SedaXsdValidatorProvider.getInstance().getValidator(sedaSupportedVersionModel.get());
            xsdValidator.validate(manifestFile);
            return CheckSedaValidationStatus.VALID;
        }
        catch (ProcessingException | IOException e) {
            LOGGER.error("Manifest xml file is not valid with the XSD", e);
            return CheckSedaValidationStatus.NO_FILE;
        }
        catch (InvalidXmlException e) {
            LOGGER.error("This is not an xml file", (Throwable)e);
            return CheckSedaValidationStatus.NOT_XML_FILE;
        }
        catch (SAXException e) {
            LOGGER.error("The xml file is not conform with XSD Schema : ", (Throwable)e);
            if (e.getCause() == null) {
                ObjectNode errorNode = JsonHandler.createObjectNode().put("evDetTechData", e.getMessage());
                itemStatus.setEvDetailData(errorNode.toString());
                return CheckSedaValidationStatus.NOT_XSD_VALID;
            }
            return CheckSedaValidationStatus.NOT_XML_FILE;
        }
    }

    private Optional<SupportedSedaVersions> getSupportedSedaModelByVersion(String sedaVersion) {
        return Arrays.stream(SupportedSedaVersions.values()).filter(e -> e.getVersion().equals(sedaVersion)).findFirst();
    }

    private File getManifestFile() throws IOException, ProcessingException {
        try {
            return this.handlerIO.getFileFromWorkspace("SIP/manifest.xml");
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.debug("Manifest not found");
            throw new ProcessingException("Manifest not found", e);
        }
    }

    private boolean checkFolderContentNumber() throws ProcessingException {
        List list = this.handlerIO.getUriList(this.handlerIO.getContainerName(), "SIP");
        return list.stream().filter(uri -> uri.toString().contains(VitamConstants.URL_ENCODED_SEPARATOR)).map(content -> content.toString().split(VitamConstants.URL_ENCODED_SEPARATOR)[0]).allMatch(x -> x.equalsIgnoreCase("content"));
    }

    private boolean checkMultiManifest() throws ProcessingException {
        List listURI = this.handlerIO.getUriList(this.handlerIO.getContainerName(), "SIP");
        return listURI.stream().filter(uri -> !uri.toString().contains(VitamConstants.URL_ENCODED_SEPARATOR)).count() > 1L;
    }

    public ExtractUriResponse getAllDigitalObjectUriFromManifest() throws ProcessingException {
        return this.parsingUriSEDAWithWorkspaceClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtractUriResponse parsingUriSEDAWithWorkspaceClient() throws ProcessingException {
        InputStream xmlFile = null;
        LOGGER.debug(MSG_PARSING_BDO);
        ExtractUriResponse extractUriResponse = new ExtractUriResponse();
        HashSet<URI> uriSet = new HashSet<URI>();
        extractUriResponse.setUriSetManifest(uriSet);
        extractUriResponse.setErrorNumber(0);
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        QName binaryDataObject = new QName(this.sedaIngestParams.getNamespaceURI(), "BinaryDataObject");
        XMLEventReader eventReader = null;
        try {
            XMLEvent event;
            try {
                xmlFile = this.handlerIO.getInputStreamFromWorkspace("SIP/manifest.xml");
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e1) {
                LOGGER.error("Workspace error: Can not get file", e1);
                throw new ProcessingException(e1);
            }
            eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
            do {
                StartElement element;
                if (!(event = eventReader.nextEvent()).isStartElement() || !(element = event.asStartElement()).getName().equals(binaryDataObject)) continue;
                this.getUri(extractUriResponse, eventReader);
            } while (!event.isEndDocument());
            LOGGER.debug("data : " + event);
            LOGGER.debug("End of extracting  Uri from manifest");
            extractUriResponse.setErrorDuplicateUri(!extractUriResponse.getOutcomeMessages().isEmpty());
        }
        catch (UnsupportedEncodingException | XMLStreamException e) {
            try {
                LOGGER.error((Throwable)e);
                throw new ProcessingException((Throwable)e);
                catch (URISyntaxException e2) {
                    LOGGER.error((Throwable)e2);
                    throw new VitamKoRuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                extractUriResponse.setErrorDuplicateUri(!extractUriResponse.getOutcomeMessages().isEmpty());
                try {
                    if (eventReader != null) {
                        eventReader.close();
                    }
                }
                catch (XMLStreamException e3) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e3);
                }
                StreamUtils.closeSilently((InputStream)xmlFile);
                throw throwable;
            }
        }
        try {
            if (eventReader != null) {
                eventReader.close();
            }
        }
        catch (XMLStreamException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
        StreamUtils.closeSilently((InputStream)xmlFile);
        return extractUriResponse;
    }

    private void getUri(ExtractUriResponse extractUriResponse, XMLEventReader evenReader) throws XMLStreamException, URISyntaxException, UnsupportedEncodingException {
        while (evenReader.hasNext()) {
            StartElement startElement;
            XMLEvent event = evenReader.nextEvent();
            if (!event.isStartElement() || !"Uri".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            event = evenReader.nextEvent();
            String uri = event.asCharacters().getData();
            this.checkDuplicatedUri(extractUriResponse, uri);
            extractUriResponse.getUriSetManifest().add(new URI(URLEncoder.encode(uri, StandardCharsets.UTF_8)));
            break;
        }
    }

    private void checkDuplicatedUri(ExtractUriResponse extractUriResponse, String uriString) throws URISyntaxException {
        if (extractUriResponse.getUriSetManifest().contains(new URI(uriString))) {
            extractUriResponse.setErrorNumber(extractUriResponse.getErrorNumber() + 1);
        }
    }

    public Map<String, Map<String, String>> checkSupportedDataObjectVersion(WorkerParameters params) throws ProcessingException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        return this.isSedaVersionValid();
    }

    private Map<String, Map<String, String>> isSedaVersionValid() throws ProcessingException {
        Map<String, Map<String, String>> versionMap;
        InputStream xmlFile = null;
        XMLEventReader reader = null;
        try {
            try {
                xmlFile = this.handlerIO.getInputStreamFromWorkspace("SIP/manifest.xml");
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
                LOGGER.error(MANIFEST_NOT_FOUND);
                throw new ProcessingException(e);
            }
            reader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
            versionMap = this.compareVersionList(reader);
        }
        catch (XMLStreamException e) {
            LOGGER.error(CANNOT_READ_SEDA);
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            }
            StreamUtils.closeSilently((InputStream)xmlFile);
        }
        return versionMap;
    }

    public SedaUtilInfo getDataObjectInfo(XMLEventReader evenReader) throws ProcessingException {
        SedaUtilInfo sedaUtilInfo = new SedaUtilInfo();
        DataObjectInfo dataObjectInfo = new DataObjectInfo();
        block15: while (evenReader.hasNext()) {
            try {
                String tag;
                String id;
                XMLEvent event = evenReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = event.asStartElement();
                if ("BinaryDataObject".equals(startElement.getName().getLocalPart())) {
                    id = startElement.getAttributes().next().getValue();
                    dataObjectInfo.setId(id);
                    dataObjectInfo.setType("BinaryDataObject");
                    evenReader.nextEvent();
                    while (evenReader.hasNext()) {
                        event = evenReader.nextEvent();
                        if (event.isStartElement()) {
                            startElement = event.asStartElement();
                            switch (tag = startElement.getName().getLocalPart()) {
                                case "Uri": {
                                    String uri = evenReader.getElementText();
                                    if (StringUtils.isBlank((CharSequence)uri)) {
                                        LOGGER.debug("Erreur Emply URI");
                                        break;
                                    }
                                    dataObjectInfo.setUri(uri);
                                    break;
                                }
                                case "DataObjectVersion": {
                                    String version = evenReader.getElementText();
                                    dataObjectInfo.setVersion(version);
                                    break;
                                }
                                case "MessageDigest": {
                                    dataObjectInfo.setAlgo(DigestType.fromValue((String)StringUtils.trimToEmpty((String)startElement.getAttributes().next().getValue())));
                                    String messageDigest = StringUtils.trimToEmpty((String)evenReader.getElementText());
                                    dataObjectInfo.setMessageDigest(messageDigest);
                                    break;
                                }
                                case "Size": {
                                    long size = Long.parseLong(evenReader.getElementText());
                                    dataObjectInfo.setSize(size);
                                }
                            }
                        }
                        if (!event.isEndElement() || !"BinaryDataObject".equals(event.asEndElement().getName().getLocalPart())) continue;
                        sedaUtilInfo.setDataObjectMap(dataObjectInfo);
                        dataObjectInfo = new DataObjectInfo();
                        break;
                    }
                }
                if (!"PhysicalDataObject".equals(startElement.getName().getLocalPart())) continue;
                id = startElement.getAttributes().next().getValue();
                dataObjectInfo.setId(id);
                dataObjectInfo.setType("PhysicalDataObject");
                evenReader.nextEvent();
                while (evenReader.hasNext()) {
                    event = evenReader.nextEvent();
                    if (event.isStartElement()) {
                        startElement = event.asStartElement();
                        tag = startElement.getName().getLocalPart();
                        if ("DataObjectVersion".equals(tag)) {
                            dataObjectInfo.setVersion(evenReader.getElementText());
                        } else if ("PhysicalId".equals(tag)) {
                            dataObjectInfo.setPhysicalId(evenReader.getElementText());
                        }
                    }
                    if (!event.isEndElement() || !"PhysicalDataObject".equals(event.asEndElement().getName().getLocalPart())) continue;
                    sedaUtilInfo.setDataObjectMap(dataObjectInfo);
                    dataObjectInfo = new DataObjectInfo();
                    continue block15;
                }
            }
            catch (XMLStreamException e) {
                LOGGER.error("Can not get DataObject info");
                throw new ProcessingException((Throwable)e);
            }
            catch (DigestTypeException d) {
                throw new SedaUtilsException((Exception)((Object)d));
            }
        }
        return sedaUtilInfo;
    }

    public Map<String, List<DataObjectInfo>> manifestVersionList(XMLEventReader evenReader) throws ProcessingException {
        HashMap<String, List<DataObjectInfo>> versionListByType = new HashMap<String, List<DataObjectInfo>>();
        SedaUtilInfo sedaUtilInfo = this.getDataObjectInfo(evenReader);
        Map<String, DataObjectInfo> dataObjectMap = sedaUtilInfo.getDataObjectMap();
        ArrayList<DataObjectInfo> physicalObjectsVersion = new ArrayList<DataObjectInfo>();
        ArrayList<DataObjectInfo> binaryObjectsVersion = new ArrayList<DataObjectInfo>();
        for (String mapKey : dataObjectMap.keySet()) {
            if ("PhysicalDataObject".equals(dataObjectMap.get(mapKey).getType())) {
                physicalObjectsVersion.add(dataObjectMap.get(mapKey));
                continue;
            }
            binaryObjectsVersion.add(dataObjectMap.get(mapKey));
        }
        versionListByType.put("BinaryDataObject", binaryObjectsVersion);
        versionListByType.put("PhysicalDataObject", physicalObjectsVersion);
        return versionListByType;
    }

    public Map<String, Map<String, String>> compareVersionList(XMLEventReader eventReader) throws ProcessingException {
        SedaVersion sedaVersion;
        try {
            sedaVersion = SedaConfiguration.getSupportedVerion();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        Map<String, List<DataObjectInfo>> manifestVersionListByType = this.manifestVersionList(eventReader);
        HashMap<CallSite, String> invalidVersionMap = new HashMap<CallSite, String>();
        HashMap<String, String> validVersionMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> versionMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<DataObjectInfo>> manifestVersionEntry : manifestVersionListByType.entrySet()) {
            List fileVersions = sedaVersion.getVersionForType(manifestVersionEntry.getKey());
            for (DataObjectInfo doi : manifestVersionEntry.getValue()) {
                if (doi.getVersion() == null) continue;
                validVersionMap.put(doi.getId(), "");
                String[] versionParts = doi.getVersion().split("_");
                Object errorCode = manifestVersionEntry.getKey();
                try {
                    DataObjectValidator.validateVersionDataObject(doi.getVersion());
                }
                catch (InvalidDataObjectException e) {
                    errorCode = (String)errorCode + INCORRECT_VERSION_FORMAT;
                    invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode)), doi.getVersion());
                    validVersionMap.remove(doi.getId());
                    continue;
                }
                if (versionParts.length > 2 || !fileVersions.contains(versionParts[0])) {
                    List otherFileVersions = sedaVersion.getVersionForOtherType(manifestVersionEntry.getKey());
                    errorCode = otherFileVersions.contains(versionParts[0]) ? (String)errorCode + CONTAINS_OTHER_TYPE : (String)errorCode + INCORRECT_VERSION_FORMAT;
                    invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode)), doi.getVersion());
                    validVersionMap.remove(doi.getId());
                    continue;
                }
                if (versionParts.length == 2) {
                    try {
                        int currentVersion = Integer.parseInt(versionParts[1]);
                        if (currentVersion < 0) {
                            invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode + "_IncorrectVersionFormat")), doi.getVersion());
                            validVersionMap.remove(doi.getId());
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Wrong version ", (Throwable)e);
                        invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode + "_IncorrectVersionFormat")), doi.getVersion());
                        validVersionMap.remove(doi.getId());
                    }
                }
                if ("BinaryDataObject".equals(doi.getType())) {
                    if (!Strings.isNullOrEmpty((String)doi.getUri())) continue;
                    invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode + "_IncorrectUri")), "Uri");
                    validVersionMap.remove(doi.getId());
                    continue;
                }
                if (!Strings.isNullOrEmpty((String)doi.getPhysicalId())) continue;
                invalidVersionMap.put((CallSite)((Object)(doi.getId() + "_" + (String)errorCode + "_IncorrectPhysicalId")), "PhysicalId");
                validVersionMap.remove(doi.getId());
            }
        }
        versionMap.put(INVALID_DATAOBJECT_VERSION, invalidVersionMap);
        versionMap.put(VALID_DATAOBJECT_VERSION, validVersionMap);
        return versionMap;
    }

    private SedaUtilInfo getSedaUtilInfo() throws ProcessingException {
        XMLEventReader reader = null;
        try {
            SedaUtilInfo sedaUtilInfo;
            block17: {
                InputStream xmlFile = this.handlerIO.getInputStreamFromWorkspace("SIP/manifest.xml");
                try {
                    SedaUtilInfo sedaUtilInfo2;
                    reader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
                    sedaUtilInfo = sedaUtilInfo2 = this.getDataObjectInfo(reader);
                    if (xmlFile == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlFile != null) {
                            try {
                                xmlFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (XMLStreamException e) {
                        LOGGER.error(CANNOT_READ_SEDA);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
                        LOGGER.error(MANIFEST_NOT_FOUND);
                        throw new ProcessingException(e);
                    }
                }
                xmlFile.close();
            }
            return sedaUtilInfo;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.debug("Can not close XML reader SEDA", (Throwable)e);
            }
        }
    }

    public long computeTotalSizeOfObjectsInManifest(WorkerParameters params) throws ProcessingException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        String containerId = params.getContainerName();
        ParametersChecker.checkParameter((String)"Container id is a mandatory parameter", (String[])new String[]{containerId});
        return this.computeBinaryObjectsSizeFromManifest();
    }

    private long computeBinaryObjectsSizeFromManifest() throws ProcessingException {
        long size = 0L;
        SedaUtilInfo sedaUtilInfo = this.getSedaUtilInfo();
        Map<String, DataObjectInfo> dataObjectMap = sedaUtilInfo.getDataObjectMap();
        for (String mapKey : dataObjectMap.keySet()) {
            Long binaryObjectSize = dataObjectMap.get(mapKey).getSize();
            if (binaryObjectSize == null || binaryObjectSize <= 0L) continue;
            size += binaryObjectSize.longValue();
        }
        return size;
    }

    public SedaIngestParams getSedaIngestParams() {
        return this.sedaIngestParams;
    }

    public void setSedaIngestParams(SedaIngestParams sedaIngestParams) {
        this.sedaIngestParams = sedaIngestParams;
    }

    public static enum CheckSedaValidationStatus {
        VALID,
        NOT_XSD_VALID,
        NOT_XML_FILE,
        NO_FILE,
        MORE_THAN_ONE_MANIFEST,
        MORE_THAN_ONE_FOLDER_CONTENT,
        UNSUPPORTED_SEDA_VERSION;

    }
}

