/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import java.util.Arrays;
import java.util.Optional;

public final class SedaIngestParams {
    public String version;
    public String namespaceURI;
    public String sedaValidatorXSD;
    public String vitamValidatorXSD;

    public SedaIngestParams() {
    }

    public SedaIngestParams(String version, String namespaceURI) throws ProcessingException {
        this.version = version;
        this.namespaceURI = namespaceURI;
        Optional<SupportedSedaVersions> sedaSupportedVersionModel = Arrays.stream(SupportedSedaVersions.values()).filter(elmt -> elmt.getVersion().equals(version)).findFirst();
        if (sedaSupportedVersionModel.isEmpty()) {
            throw new ProcessingException(SedaUtils.CheckSedaValidationStatus.UNSUPPORTED_SEDA_VERSION.name());
        }
        this.sedaValidatorXSD = sedaSupportedVersionModel.get().getSedaValidatorXSD();
        this.vitamValidatorXSD = sedaSupportedVersionModel.get().getVitamValidatorXSD();
    }

    public String getVersion() {
        return this.version;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getSedaValidatorXSD() {
        return this.sedaValidatorXSD;
    }

    public String getVitamValidatorXSD() {
        return this.vitamValidatorXSD;
    }
}

