/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCyclesClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import org.apache.commons.io.FilenameUtils;

public class LogbookLifecycleWorkerHelper {
    private static final String LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG = "Logbook LifeCycle resource not found";

    private LogbookLifecycleWorkerHelper() {
    }

    public static final String getObjectID(WorkerParameters params) {
        String extension = FilenameUtils.getExtension((String)params.getObjectName());
        return params.getObjectName().replace("." + extension, "");
    }

    public static void updateLifeCycleStep(LogbookLifeCyclesClientHelper helper, LogbookLifeCycleParameters logbookLifecycleParameters, WorkerParameters params, String lfcEventType, LogbookTypeProcess logbookTypeProcess, StatusCode statusCode, String ... additionalParams) throws ProcessingException {
        try {
            if (additionalParams != null && additionalParams.length >= 1) {
                logbookLifecycleParameters.putParameterValue(LogbookParameterName.objectIdentifier, additionalParams[0]);
            } else {
                logbookLifecycleParameters.putParameterValue(LogbookParameterName.objectIdentifier, LogbookLifecycleWorkerHelper.getObjectID(params));
            }
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, params.getContainerName());
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)0).toString());
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.eventTypeProcess, logbookTypeProcess.name());
            if (lfcEventType == null) {
                logbookLifecycleParameters.setFinalStatus(params.getCurrentStep(), null, statusCode, null, new String[0]);
            } else {
                logbookLifecycleParameters.setFinalStatus(lfcEventType, null, statusCode, null, new String[0]);
            }
            helper.updateDelegate(logbookLifecycleParameters);
        }
        catch (LogbookClientNotFoundException e) {
            SedaUtils.LOGGER.error(LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    public static void updateLifeCycleForBegining(LogbookLifeCyclesClientHelper helper, LogbookLifeCycleParameters logbookLifecycleParameters, WorkerParameters params, LogbookTypeProcess logbookTypeProcess) throws ProcessingException {
        try {
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.objectIdentifier, LogbookLifecycleWorkerHelper.getObjectID(params));
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, params.getContainerName());
            logbookLifecycleParameters.putParameterValue(LogbookParameterName.eventTypeProcess, logbookTypeProcess.name());
            helper.updateDelegate(logbookLifecycleParameters);
        }
        catch (LogbookClientNotFoundException e) {
            SedaUtils.LOGGER.error(LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }
}

