/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import fr.gouv.vitam.worker.common.utils.InvalidDataObjectException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataObjectValidator {
    public static final Pattern DATA_OBJECT_VERSION_PATTERN = Pattern.compile("^[a-zA-Z]+(_[1-9]\\d{0,6})?$");
    public static final String DATA_OBJECT_VERSION_NOT_DEFINED_MESSAGE = "Data object version is not defined";
    public static final String DATA_OBJECT_VERSION_NOT_ALLOWED_MESSAGE = "Data object version pattern '%s' is not allowed";

    public static void validateVersionDataObject(String versionDataObject) throws InvalidDataObjectException {
        DataObjectValidator.checkDataObjectVersionPresence(versionDataObject);
        DataObjectValidator.validateDataObjectVersionFormat(versionDataObject);
    }

    private static void checkDataObjectVersionPresence(String dataObjectVersion) throws InvalidDataObjectException {
        if (StringUtils.isBlank((CharSequence)dataObjectVersion)) {
            throw new InvalidDataObjectException(DATA_OBJECT_VERSION_NOT_DEFINED_MESSAGE);
        }
    }

    private static void validateDataObjectVersionFormat(String dataObjectVersion) throws InvalidDataObjectException {
        Matcher matcher = DATA_OBJECT_VERSION_PATTERN.matcher(dataObjectVersion);
        if (!matcher.matches()) {
            String message = String.format(DATA_OBJECT_VERSION_NOT_ALLOWED_MESSAGE, dataObjectVersion);
            throw new InvalidDataObjectException(message);
        }
    }
}

