/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.common.utils;

import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;

public class ArchiveUnitLifecycleUpdateUtils {
    private static final String UNIT_METADATA_UPDATE = "UPDATE_UNIT_RULES";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitLifecycleUpdateUtils.class);

    public void logLifecycle(WorkerParameters params, String auGuid, StatusCode code, String evDetData, LogbookLifeCyclesClient logbookLifeCycleClient) {
        try {
            LogbookLifeCycleUnitParameters logbookLCParam = this.getLogbookLifeCycleUpdateUnitParameters(GUIDReader.getGUID((String)params.getContainerName()), code, GUIDReader.getGUID((String)auGuid), UNIT_METADATA_UPDATE);
            if (evDetData != null) {
                logbookLCParam.putParameterValue(LogbookParameterName.eventDetailData, evDetData);
            }
            logbookLifeCycleClient.update((LogbookLifeCycleParameters)logbookLCParam);
        }
        catch (InvalidGuidOperationException | LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error("Should be in First Insert step so not alreday commited", e);
        }
    }

    private LogbookLifeCycleUnitParameters getLogbookLifeCycleUpdateUnitParameters(GUID eventIdentifierProcess, StatusCode logbookOutcome, GUID objectIdentifier, String action) {
        LogbookTypeProcess eventTypeProcess = LogbookTypeProcess.UPDATE;
        GUID updateGuid = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter());
        return LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)updateGuid, (String)VitamLogbookMessages.getEventTypeLfc((String)action), (GUID)eventIdentifierProcess, (LogbookTypeProcess)eventTypeProcess, (StatusCode)logbookOutcome, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)action, (StatusCode)logbookOutcome), (String)VitamLogbookMessages.getCodeLfc((String)action, (StatusCode)logbookOutcome), (GUID)objectIdentifier);
    }

    public void commitLifecycle(String processId, String archiveUnitId, LogbookLifeCyclesClient logbookLifeCycleClient) {
        try {
            logbookLifeCycleClient.commitUnit(processId, archiveUnitId);
        }
        catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error("Couldn't commit lifecycles", e);
        }
    }
}

