/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.exception.BatchReportException;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportExportRequest;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ExtractedMetadata;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class BatchReportClientRest
extends DefaultClient
implements BatchReportClient {
    private static final String APPEND = "append";
    private static final String STORE_TO_WORKSPACE = "storeToWorkspace";
    private static final String CLEANUP = "cleanup";
    private static final String EXPORT_PURGE_UNIT_DISTINCT_OBJECTGROUPS = "purge_unit/objectgroup_export/";
    private static final String EXPORT_PURGE_ACCESSION_REGISTER = "purge/accession_register_export/";
    private static final String UNITS_AND_PROGENY_INVALIDATION = "/computedInheritedRulesInvalidation/";
    private static final String STORE_EXTRACTED_METADATA_FOR_AU = "/storeExtractedMetadataForAu/";
    private static final String CREATE_DISTRIBUTION_FILE_FOR_AU = "/createExtractedMetadataDistributionFileForAu/";

    @VisibleForTesting
    BatchReportClientRest(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    @Override
    public void generatePurgeDistinctObjectGroupInUnitReport(String processId, ReportExportRequest reportExportRequest) throws VitamClientInternalException {
        ParametersChecker.checkParameter((String)"processId should be filled", (String[])new String[]{processId});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(EXPORT_PURGE_UNIT_DISTINCT_OBJECTGROUPS + processId).withBody((Object)reportExportRequest).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void appendReportEntries(ReportBody reportBody) throws VitamClientInternalException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(APPEND).withBody((Object)reportBody).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void storeReportToWorkspace(Report reportInfo) throws VitamClientInternalException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(STORE_TO_WORKSPACE).withBody((Object)reportInfo).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void exportUnitsToInvalidate(String processId, ReportExportRequest reportExportRequest) throws VitamClientInternalException {
        ParametersChecker.checkParameter((String)"processId parameter should be filled", (String[])new String[]{processId});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(UNITS_AND_PROGENY_INVALIDATION + processId).withBody((Object)reportExportRequest).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void generatePurgeAccessionRegisterReport(String processId, ReportExportRequest reportExportRequest) throws VitamClientInternalException {
        ParametersChecker.checkParameter((String)"processId should be filled", (String[])new String[]{processId});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(EXPORT_PURGE_ACCESSION_REGISTER + processId).withBody((Object)reportExportRequest).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void cleanupReport(String processId, ReportType reportType) throws VitamClientInternalException {
        ParametersChecker.checkParameter((String)"processId and reportType should be filled", (Object[])new Object[]{processId, reportType});
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("cleanup/" + reportType + "/" + processId).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withAccept(MediaType.APPLICATION_JSON_TYPE);
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void storeExtractedMetadataForAu(List<ExtractedMetadata> extractedMetadata) throws VitamClientInternalException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(STORE_EXTRACTED_METADATA_FOR_AU).withBody(extractedMetadata).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public void createExtractedMetadataDistributionFileForAu(String processId) throws Exception {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(CREATE_DISTRIBUTION_FILE_FOR_AU + processId).withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
        }
    }

    @Override
    public JsonNode readComputedDetailsFromReport(ReportType reportType, String processId) {
        JsonNode jsonNode;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/readComputedDetailsFromReport").withHeader("X-Tenant-Id", (Object)VitamThreadUtils.getVitamSession().getTenantId()).withBody((Object)new ReportBody(processId, reportType, null)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException e) {
                    throw new BatchReportException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    private void check(Response response) throws VitamClientInternalException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
    }
}

