/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.client;

import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class BatchReportClientFactory
extends VitamClientFactory<BatchReportClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BatchReportClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "batch-report-client.conf";
    private static final String RESOURCE_PATH = "/batchreport/v1";
    private static final BatchReportClientFactory BATCH_REPORT_CLIENT_FACTORY = new BatchReportClientFactory();

    private BatchReportClientFactory() {
        super(BatchReportClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    public static final BatchReportClientFactory getInstance() {
        return BATCH_REPORT_CLIENT_FACTORY;
    }

    public static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        BatchReportClientFactory.getInstance().initialisation(configuration, BatchReportClientFactory.getInstance().getResourcePath());
    }

    public BatchReportClient getClient() {
        BatchReportClientRest client;
        switch (this.getVitamClientType()) {
            case PRODUCTION: {
                client = new BatchReportClientRest((VitamClientFactoryInterface<?>)this);
                break;
            }
            case MOCK: {
                throw new IllegalArgumentException("Not implemented");
            }
            default: {
                throw new IllegalArgumentException("Log type unknown");
            }
        }
        return client;
    }
}

