/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.internal.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.IngestCollection;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.NotAcceptableClientException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.ingest.internal.common.exception.IllegalZipFileNameException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientConflictException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientNotFoundException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientServerException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalServerUnavailableClientException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import java.io.InputStream;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

class IngestInternalClientRest
extends DefaultClient
implements IngestInternalClient {
    private static final String PROCESS_WORKFLOW_NOT_FOUND_FOR_OPERATION = "Process Workflow not found for operation :";
    private static final String REQUEST_PRECONDITION_FAILED = "Request precondition failed";
    private static final String REQUEST_CONFLICT = "Request conflict";
    private static final String INVALID_PARSE_OPERATION = "Invalid Parse Operation";
    private static final String NOT_FOUND_EXCEPTION = "Not Found Exception";
    private static final String UNAUTHORIZED = "Unauthorized";
    private static final String SERVICE_UNAVAILABLE_EXCEPTION = "Workspace Server Error";
    private static final String NOT_ACCEPTABLE_EXCEPTION = "File or folder name is not allowed";
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    private static final String LOGBOOK_URL = "/logbooks";
    private static final String INGEST_URL = "/ingests";
    private static final String BLANK_OBJECT_ID = "object identifier should be filled";
    private static final String BLANK_TYPE = "Type should be filled";
    private static final String BLANK_OPERATION_ID = "Operation identifier should be filled";
    private static final String OPERATION_URI = "/operations";
    private static final String WORKFLOWS_URI = "/workflows";

    IngestInternalClientRest(IngestInternalClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public void uploadInitialLogbook(Iterable<LogbookOperationParameters> logbookParametersList) throws VitamException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath(LOGBOOK_URL).withBody(logbookParametersList, "check Upload Parameter").withJson());){
            this.check(response);
        }
    }

    @Override
    public void upload(InputStream inputStream, MediaType archiveMimeType, WorkFlow workflow, String actionAfterInit) throws VitamException {
        ParametersChecker.checkParameter((String)"context Id Request must not be null", (Object[])new Object[]{workflow});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(INGEST_URL).withHeader("X-Context-Id", (Object)workflow.getIdentifier()).withHeader("X_TYPE_PROCESS", (Object)workflow.getTypeProc()).withHeader("X-ACTION", (Object)actionAfterInit).withHeader("X_ACTION_INIT", (Object)ProcessAction.START).withBody((Object)inputStream, "Body cannot be null").withContentType(archiveMimeType).withOctetAccept();
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (NotAcceptableClientException e) {
            throw new IllegalZipFileNameException(NOT_ACCEPTABLE_EXCEPTION, (Throwable)e);
        }
        catch (IngestInternalClientServerException | IngestInternalServerUnavailableClientException e) {
            throw new IngestInternalClientServerException(e);
        }
        catch (VitamClientException e) {
            throw new VitamException((Throwable)e);
        }
    }

    @Override
    public void initWorkflow(WorkFlow workFlow) throws VitamException {
        ParametersChecker.checkParameter((String)"Params cannot be null", (Object[])new Object[]{workFlow});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(INGEST_URL).withHeader("X-Context-Id", (Object)workFlow.getId()).withHeader("X_TYPE_PROCESS", (Object)workFlow.getTypeProc()).withHeader("X-ACTION", (Object)ProcessAction.INIT).withHeader("X_ACTION_INIT", (Object)ProcessAction.INIT).withOctetAccept();
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
            throw new VitamClientException(e);
        }
    }

    @Override
    public Response downloadObjectAsync(String objectId, IngestCollection type) throws InvalidParseOperationException, IngestInternalClientServerException, IngestInternalClientNotFoundException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{objectId});
        ParametersChecker.checkParameter((String)BLANK_TYPE, (Object[])new Object[]{type});
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withPath("/ingests/" + objectId + "/" + type.getCollectionName()).withOctetAccept());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (NotAcceptableClientException | VitamClientException | IngestInternalServerUnavailableClientException e) {
            throw new IngestInternalClientServerException(e);
        }
        catch (IngestInternalClientNotFoundException e) {
            throw new IngestInternalClientNotFoundException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<ItemStatus> updateOperationActionProcess(String actionId, String operationId) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
            Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + operationId).withHeader("X-ACTION", (Object)actionId).withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalClientNotFoundException | IngestInternalClientServerException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public ItemStatus getOperationProcessStatus(String id) throws VitamClientException {
        ItemStatus itemStatus;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            Response response = this.make(VitamRequestBuilder.head().withPath("/operations/" + id).withJsonAccept());
            try {
                this.check(response);
                itemStatus = new ItemStatus().setGlobalState(ProcessState.valueOf((String)response.getHeaderString("X-Global-Execution-State"))).setLogbookTypeProcess(response.getHeaderString("X-Context-Id")).increment(StatusCode.valueOf((String)response.getHeaderString("X-Global-Execution-Status")));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
                catch (VitamClientInternalException | WorkflowNotFoundException | IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return itemStatus;
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessExecutionDetails(String id) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            Response response = this.make(VitamRequestBuilder.get().withPath("/operations/" + id).withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
                catch (VitamClientInternalException | IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> cancelOperationProcessExecution(String id) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            Response response = this.make(VitamRequestBuilder.delete().withPath("/operations/" + id).withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
                catch (VitamClientInternalException | IngestInternalClientConflictException | IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ProcessDetail> listOperationsDetails(ProcessQuery query) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath(OPERATION_URI).withBody((Object)JsonHandler.toJsonNode((Object)query)).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessDetail.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
                catch (VitamClientInternalException | IngestInternalClientConflictException | IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<WorkFlow> getWorkflowDefinitions() throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath(WORKFLOWS_URI).withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, WorkFlow.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException(e);
                }
                catch (VitamClientInternalException | IngestInternalClientConflictException | IngestInternalClientNotFoundException | IngestInternalClientServerException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Optional<WorkFlow> getWorkflowDetails(String workflowIdentifier) throws VitamClientException {
        Optional<WorkFlow> optional;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/workflows/" + workflowIdentifier).withJsonAccept());
            try {
                this.check(response);
                optional = Optional.of((WorkFlow)response.readEntity(WorkFlow.class));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalClientServerException | IngestInternalServerUnavailableClientException e) {
                    throw new VitamClientException("Internal Error Server", e);
                }
                catch (IngestInternalClientNotFoundException e) {
                    return Optional.empty();
                }
            }
            response.close();
        }
        return optional;
    }

    @Override
    public void saveObjectToWorkspace(String id, String objectName, InputStream inputStream) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("workspace/" + id + "/" + objectName).withBody((Object)inputStream).withJson());){
            this.check(response);
        }
        catch (InvalidParseOperationException | NotAcceptableClientException | IngestInternalClientNotFoundException | IngestInternalClientServerException | IngestInternalServerUnavailableClientException e) {
            throw new VitamClientException("Internal Error Server", e);
        }
    }

    private void check(Response response) throws VitamClientException, IngestInternalClientServerException, IngestInternalServerUnavailableClientException, InvalidParseOperationException, IngestInternalClientNotFoundException, NotAcceptableClientException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                throw new IngestInternalClientServerException(INTERNAL_SERVER_ERROR);
            }
            case NOT_ACCEPTABLE: {
                throw new NotAcceptableClientException(NOT_ACCEPTABLE_EXCEPTION);
            }
            case NO_CONTENT: {
                throw new WorkflowNotFoundException(PROCESS_WORKFLOW_NOT_FOUND_FOR_OPERATION);
            }
            case SERVICE_UNAVAILABLE: {
                throw new IngestInternalServerUnavailableClientException(SERVICE_UNAVAILABLE_EXCEPTION);
            }
            case NOT_FOUND: {
                throw new IngestInternalClientNotFoundException(NOT_FOUND_EXCEPTION);
            }
            case CONFLICT: {
                throw new IngestInternalClientConflictException(REQUEST_CONFLICT);
            }
            case BAD_REQUEST: {
                throw new InvalidParseOperationException(INVALID_PARSE_OPERATION);
            }
            case PRECONDITION_FAILED: {
                throw new VitamClientInternalException(REQUEST_PRECONDITION_FAILED);
            }
            case UNAUTHORIZED: {
                throw new VitamClientInternalException(UNAUTHORIZED);
            }
        }
        throw new VitamClientException(status.getReasonPhrase());
    }
}

