/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.internal.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.ClientMockResultHelper;
import fr.gouv.vitam.common.client.IngestCollection;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IngestInternalClientMock
extends AbstractMockClient
implements IngestInternalClient {
    private static final String PARAMS_CANNOT_BE_NULL = "Params cannot be null";
    public static final String ID = "identifier1";
    private static final String FAKE_EXECUTION_STATUS = "Fake";

    @Override
    public void upload(InputStream inputStream, MediaType archiveType, WorkFlow workflowIdentifier, String action) {
        ParametersChecker.checkParameter((String)PARAMS_CANNOT_BE_NULL, (Object[])new Object[]{inputStream, archiveType});
        StreamUtils.closeSilently((InputStream)inputStream);
    }

    @Override
    public void uploadInitialLogbook(Iterable<LogbookOperationParameters> logbookParametersList) {
        ParametersChecker.checkParameter((String)PARAMS_CANNOT_BE_NULL, (Object[])new Object[]{logbookParametersList});
    }

    @Override
    public Response downloadObjectAsync(String objectId, IngestCollection type) {
        return ClientMockResultHelper.getObjectStream();
    }

    @Override
    public ItemStatus getOperationProcessStatus(String id) {
        return new ItemStatus(ID);
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessExecutionDetails(String id) {
        return new RequestResponseOK().addResult((Object)new ItemStatus(ID));
    }

    @Override
    public RequestResponse<ItemStatus> cancelOperationProcessExecution(String id) {
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(Response.Status.OK.getStatusCode());
        ItemStatus itemStatus = new ItemStatus(id, "FakeMessage - The operation has been canceled", StatusCode.OK, status, Collections.emptyMap(), null, null);
        return new RequestResponseOK().addResult((Object)itemStatus).addHeader("X-Global-Execution-State", FAKE_EXECUTION_STATUS).setHttpCode(Response.Status.ACCEPTED.getStatusCode());
    }

    @Override
    public RequestResponse<ItemStatus> updateOperationActionProcess(String actionId, String operationId) {
        return new RequestResponseOK().addHeader("X-Global-Execution-State", FAKE_EXECUTION_STATUS).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public void initWorkflow(WorkFlow contextId) {
    }

    @Override
    public RequestResponse<ProcessDetail> listOperationsDetails(ProcessQuery query) {
        return new RequestResponseOK().addResult((Object)new ProcessDetail()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<WorkFlow> getWorkflowDefinitions() {
        return new RequestResponseOK().addResult((Object)new WorkFlow()).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public Optional<WorkFlow> getWorkflowDetails(String WorkflowIdentifier) {
        return Optional.of(WorkFlow.of((String)"DEFAULT_WORKFLOW", (String)"PROCESS_SIP_UNITARY", (String)"INGEST"));
    }

    @Override
    public void saveObjectToWorkspace(String id, String objectName, InputStream inputStream) throws VitamClientException {
    }
}

