/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientFactory;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2Factory;
import fr.gouv.vitam.client.IhmRecetteClient;
import fr.gouv.vitam.client.IhmRecetteClientFactory;
import fr.gouv.vitam.collect.external.client.CollectExternalClient;
import fr.gouv.vitam.collect.external.client.CollectExternalClientFactory;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functionaltest.configuration.TnrClientConfiguration;
import fr.gouv.vitam.functionaltest.cucumber.service.AccessService;
import fr.gouv.vitam.functionaltest.cucumber.service.LogbookService;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class World {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(World.class);
    public static final String TNR_BASE_DIRECTORY = "tnrBaseDirectory";
    private static final String TNR_CONF = "tnr.conf";
    public static final String DEFAULT_ACCESS_CONTRACT_NAME = "ContratTNR";
    private int tenantId;
    private String contractId;
    private String unitId;
    private String objectGroupId;
    private String applicationSessionId;
    private String projectId;
    private String TransactionId;
    private List<JsonNode> results;
    private LogbookEvent logbookEvent;
    private Path sipFile;
    private Path dipFile;
    private Path transferFile;
    private Path atrFile;
    private String operationId;
    private String eliminationOperationId;
    private final Map<String, String> namedOperationIds = new HashMap<String, String>();
    private String query;
    private static final Map<String, String> operationIdsByTestSet = new HashMap<String, String>();
    private LogbookService logbookService;
    private AccessService accessService;
    private IngestExternalClient ingestClient;
    private AccessExternalClient accessClient;
    private AdminExternalClient adminClient;
    private AccessExternalClientV2 adminClientV2;
    private LogbookOperationsClient logbookOperationsClient;
    private StorageClient storageClient;
    private TnrClientConfiguration tnrClientConfiguration;
    WorkspaceClient workspaceClient;
    private final String baseDirectory = System.getProperty("tnrBaseDirectory");
    private CollectExternalClient collectExternalClient;

    @Before
    public void init() throws IOException {
        this.configuration();
        VitamConfiguration.setSecret((String)this.tnrClientConfiguration.getVitamSecret());
        VitamConfiguration.setTenants(this.tnrClientConfiguration.getTenants());
        VitamConfiguration.setAdminTenant((Integer)this.tnrClientConfiguration.getAdminTenant());
        this.ingestClient = IngestExternalClientFactory.getInstance().getClient();
        this.accessClient = AccessExternalClientFactory.getInstance().getClient();
        this.adminClient = AdminExternalClientFactory.getInstance().getClient();
        this.adminClientV2 = AccessExternalClientV2Factory.getInstance().getClient();
        this.collectExternalClient = CollectExternalClientFactory.getInstance().getClient();
        this.storageClient = StorageClientFactory.getInstance().getClient();
        WorkspaceClientFactory.changeMode((String)this.tnrClientConfiguration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
        this.configureLogbookClient();
        this.logbookOperationsClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.workspaceClient = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM).getClient();
        this.logbookService = new LogbookService();
        this.accessService = new AccessService();
    }

    @Given(value="^les tests effectu\u00e9s sur le tenant (\\d+)$")
    public void the_test_are_done_on_tenant(int tenantId) throws Throwable {
        this.tenantId = tenantId;
    }

    @Given(value="^les tests effectu\u00e9s sur le contrat id (.*)$")
    public void the_test_are_done_on_contract(String contractId) throws Throwable {
        this.contractId = contractId;
    }

    @Given(value="^les tests effectu\u00e9s avec l'identifiant de transaction (.*)$")
    public void the_tests_are_done_with_application_session_id(String applicationSessionId) {
        this.applicationSessionId = applicationSessionId;
    }

    @Given(value="^les jeux de tests r\u00e9initialis\u00e9s$")
    public void the_reinit_of_test_set() {
        operationIdsByTestSet.clear();
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public IngestExternalClient getIngestClient() {
        return this.ingestClient;
    }

    public AccessExternalClient getAccessClient() {
        return this.accessClient;
    }

    public AdminExternalClient getAdminClient() {
        return this.adminClient;
    }

    public WorkspaceClient getWorkspaceClient() {
        return this.workspaceClient;
    }

    public LogbookOperationsClient getLogbookOperationsClient() {
        return this.logbookOperationsClient;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getEliminationOperationId() {
        return this.eliminationOperationId;
    }

    public void setEliminationOperationId(String eliminationOperationId) {
        this.eliminationOperationId = eliminationOperationId;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static String getOperationId(String testSet) {
        return operationIdsByTestSet.get(testSet);
    }

    public static void setOperationId(String testSet, String operationId) {
        operationIdsByTestSet.put(testSet, operationId);
    }

    public String getNamedOperationId(String name) {
        return this.namedOperationIds.get(name);
    }

    public void setNamedOperationId(String name, String namedOperationId) {
        this.namedOperationIds.put(name, namedOperationId);
    }

    public String getUnitId() {
        return this.unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public void setObjectGroupId(String objectGroupId) {
        this.objectGroupId = objectGroupId;
    }

    public String getObjectGroupId() {
        return this.objectGroupId;
    }

    public String getContractId() {
        if (this.contractId == null) {
            return DEFAULT_ACCESS_CONTRACT_NAME;
        }
        return this.contractId;
    }

    @Given(value="^J'utilise le contrat d'access (.*)$")
    public World setContractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    public String getApplicationSessionId() {
        return this.applicationSessionId;
    }

    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    public AccessService getAccessService() {
        return this.accessService;
    }

    @After
    public void finish() {
        this.adminClient.close();
        this.accessClient.close();
        this.ingestClient.close();
        this.storageClient.close();
        this.workspaceClient.close();
        this.logbookOperationsClient.close();
        this.collectExternalClient.close();
    }

    @After
    public void writeOperationId(Scenario scenario) {
        if (!Objects.isNull(this.operationId)) {
            scenario.log(this.operationId);
        }
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private void configuration() {
        try {
            File confFile = PropertiesUtils.findFile((String)TNR_CONF);
            this.tnrClientConfiguration = (TnrClientConfiguration)PropertiesUtils.readYaml((File)confFile, TnrClientConfiguration.class);
            SanityChecker.checkParameter((String[])new String[]{this.baseDirectory});
        }
        catch (InvalidParseOperationException | IOException e) {
            LOGGER.error("Unable to load configuration File: {}tnr.conf", e);
        }
    }

    private void purgeData() {
        try (IhmRecetteClient ihmRecetteClient = IhmRecetteClientFactory.getInstance().getClient();){
            this.tnrClientConfiguration.getTenantsTest().forEach(i -> {
                try {
                    ihmRecetteClient.deleteTnrCollectionsTenant(i.toString());
                }
                catch (VitamException e) {
                    LOGGER.error("Unable purge data " + i + " on tenant: " + i + Arrays.toString(e.getStackTrace()));
                }
            });
        }
    }

    private void configureLogbookClient() throws IOException {
        File confFile = PropertiesUtils.findFile((String)"logbook-client.conf");
        ClientConfigurationImpl conf = (ClientConfigurationImpl)PropertiesUtils.readYaml((File)confFile, ClientConfigurationImpl.class);
        LogbookOperationsClientFactory.changeMode((ClientConfiguration)conf);
    }

    List<JsonNode> getResults() {
        return this.results;
    }

    void setResults(List<JsonNode> results) {
        this.results = results;
    }

    LogbookEvent getLogbookEvent() {
        return this.logbookEvent;
    }

    void setLogbookEvent(LogbookEvent logbookEvent) {
        this.logbookEvent = logbookEvent;
    }

    public AccessExternalClientV2 getAdminClientV2() {
        return this.adminClientV2;
    }

    public CollectExternalClient getCollectExternalClient() {
        return this.collectExternalClient;
    }

    public Path getSipFile() {
        return this.sipFile;
    }

    public void setSipFile(Path path) {
        this.sipFile = path;
    }

    public Path getDipFile() {
        return this.dipFile;
    }

    public void setDipFile(Path dipFile) {
        this.dipFile = dipFile;
    }

    public Path getTransferFile() {
        return this.transferFile;
    }

    public World setTransferFile(Path transferFile) {
        this.transferFile = transferFile;
        return this;
    }

    public Path getAtrFile() {
        return this.atrFile;
    }

    public World setAtrFile(Path atrFile) {
        this.atrFile = atrFile;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTransactionId() {
        return this.TransactionId;
    }

    public void setTransactionId(String transactionId) {
        this.TransactionId = transactionId;
    }
}

