/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.fr.Quand;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Java6Assertions;

public class RevertUpdateStep
extends CommonStep {
    public RevertUpdateStep(World world) {
        super(world);
    }

    @Quand(value="^je lance la restauration des m\u00e9tadonn\u00e9es essentielles des AU$")
    public void unitUpdate() throws VitamException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode queryString = JsonHandler.getFromString((String)query);
        RequestResponse requestResponse = this.world.getAccessClient().revertUpdateUnits(vitamContext, queryString);
        Assertions.assertThat((boolean)requestResponse.isOk()).isTrue();
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"units update  processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }
}

