/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.PreservationVersion;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.Java6Assertions;

public class PreservationStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationStep.class);
    public static final String EMPTY_JSON_FILE = "empty.json";

    public PreservationStep(World world) {
        super(world);
    }

    @When(value="^j'importe le griffon nomm\u00e9 (.*)$")
    public void importGriffin(String fileName) {
        Path file = Paths.get(this.world.getBaseDirectory(), fileName);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
            vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
            RequestResponse response = this.world.getAdminClient().importGriffin(vitamContext, inputStream, fileName);
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            ArrayList<JsonNode> results = new ArrayList<JsonNode>();
            results.add((JsonNode)JsonHandler.createObjectNode().put("Code", String.valueOf(response.getHttpCode())));
            this.world.setResults(results);
        }
        catch (Exception e) {
            Fail.fail((String)("failed to  upload griffin file  " + e));
        }
    }

    @When(value="^j'importe le preservation Scenario nomm\u00e9 (.*)$")
    public void importPreservation(String fileName) {
        Path file = Paths.get(this.world.getBaseDirectory(), fileName);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
            vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
            RequestResponse response = this.world.getAdminClient().importPreservationScenario(vitamContext, inputStream, fileName);
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            ArrayList<JsonNode> results = new ArrayList<JsonNode>();
            results.add((JsonNode)JsonHandler.createObjectNode().put("Code", String.valueOf(response.getHttpCode())));
            this.world.setResults(results);
        }
        catch (Exception e) {
            Fail.fail((String)("failed to  upload griffin file  " + e));
        }
    }

    @When(value="^je cherche le griffon nomm\u00e9 (.*)$")
    public void searchGriffinById(String identifier) throws VitamClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().findGriffinById(vitamContext, identifier);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(200);
        this.world.setResults(((RequestResponseOK)response).getResultsAsJsonNodes());
    }

    @Then(value="^le griffon nomm\u00e9 (.*) n'existe pas$")
    public void searchNotGriffinById(String identifier) throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().findGriffinById(vitamContext, identifier);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(404);
    }

    @Then(value="^le sc\u00e9nario de preservation nomm\u00e9 (.*) n'existe pas$")
    public void searchNotExistantPreservationById(String identifier) throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().findPreservationScenarioById(vitamContext, identifier);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(404);
    }

    @When(value="^je cherche le sc\u00e9nario de preservation nomm\u00e9 (.*)$")
    public void searchPreservationById(String identifier) throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().findPreservationScenarioById(vitamContext, identifier);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(200);
        this.world.setResults(((RequestResponseOK)response).getResultsAsJsonNodes());
    }

    @When(value="^je supprime les griffons et les sc\u00e9narios de pr\u00e9servation sur tous les tenants")
    public void deleteAllPreservationBaseData() throws Exception {
        for (Integer tenant : VitamConfiguration.getTenants()) {
            VitamContext vitamContext = new VitamContext(tenant);
            vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
            Select select = new Select();
            select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.exists((String)"Name")}).add(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.tenant(), (long)tenant.intValue())}));
            ObjectNode queryDsl = select.getFinalSelect();
            RequestResponse scenarioList = this.world.getAdminClient().findPreservationScenario(vitamContext, (JsonNode)queryDsl);
            List resultsAsJsonNodes = ((RequestResponseOK)scenarioList).getResultsAsJsonNodes();
            if (resultsAsJsonNodes.isEmpty()) continue;
            ByteArrayInputStream emptyJson = new ByteArrayInputStream("[]".getBytes());
            this.world.getAdminClient().importPreservationScenario(vitamContext, (InputStream)emptyJson, EMPTY_JSON_FILE);
        }
        VitamContext vitamContext = new VitamContext(VitamConfiguration.getAdminTenant());
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        ByteArrayInputStream emptyJson = new ByteArrayInputStream("[]".getBytes());
        this.world.getAdminClient().importGriffin(vitamContext, (InputStream)emptyJson, EMPTY_JSON_FILE);
    }

    @When(value="^je lance la preservation avec le sc\u00e9nario (.*) et pour l'usage (.*)$")
    public void launchPreservation(String scenarioId, String usage) throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode queryNode = JsonHandler.getFromString((String)query);
        PreservationRequest preservationRequest = new PreservationRequest(queryNode, scenarioId, usage, PreservationVersion.LAST, usage);
        RequestResponse response = this.world.getAccessClient().launchPreservation(vitamContext, preservationRequest);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"preservation processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @When(value="^je lance la preservation du sc\u00e9nario (.*) pour l'usage d'entr\u00e9e (.*) et pour l'usage de sortie (.*)$")
    public void launchPreservation(String scenarioId, String usageEntree, String usageSortie) throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode queryNode = JsonHandler.getFromString((String)query);
        PreservationRequest preservationRequest = new PreservationRequest(queryNode, scenarioId, usageSortie, PreservationVersion.FIRST, usageEntree);
        RequestResponse response = this.world.getAccessClient().launchPreservation(vitamContext, preservationRequest);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"preservation processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @Then(value="^le type du binaire g\u00e9n\u00e9r\u00e9 est un (.*) et de type (.*)$")
    public void verifyIfTypeBinaryHasBeenGenerated(String qualifierParam, String type) throws InvalidParseOperationException {
        ObjectGroupResponse objectGroupResponse = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)this.world.getResults().get(0), ObjectGroupResponse.class);
        String opiPreservation = this.world.getOperationId();
        Boolean versionExist = objectGroupResponse.getQualifiers().stream().filter(qualifier -> qualifierParam.equals(qualifier.getQualifier())).map(QualifiersModel::getVersions).flatMap(Collection::stream).anyMatch(version -> type.equals(version.getFormatIdentification().getMimeType()) && version.getOpi().equals(opiPreservation));
        this.world.setOperationId(objectGroupResponse.getOpi());
        Assertions.assertThat((Boolean)versionExist).isEqualTo(true);
    }

    @Then(value="^Le fichier binaire du type du qualifier (.*) n'a pas \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9$")
    public void verifyBinaryIfNotGenerated(String qualifierParam) throws InvalidParseOperationException {
        ObjectGroupResponse objectGroupResponse = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)this.world.getResults().get(0), ObjectGroupResponse.class);
        String opiPreservation = this.world.getOperationId();
        boolean versionExist = objectGroupResponse.getQualifiers().stream().filter(qualifier -> qualifierParam.equals(qualifier.getQualifier())).map(QualifiersModel::getVersions).flatMap(Collection::stream).anyMatch(version -> version.getOpi().equals(opiPreservation));
        this.world.setOperationId(objectGroupResponse.getOpi());
        Assertions.assertThat((boolean)versionExist).isEqualTo(false);
    }
}

