/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;

public class IngestATRStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestATRStep.class);

    public IngestATRStep(World world) {
        super(world);
    }

    @When(value="je t\u00e9l\u00e9charge son fichier ATR")
    public void download_atr() throws VitamClientException, IOException {
        this.removeTemporaryAtrFile();
        Response response = this.world.getIngestClient().downloadObjectAsync(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), this.world.getOperationId(), IngestCollection.ARCHIVETRANSFERREPLY);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            File tempFile = Files.createTempFile("ATR-" + this.world.getOperationId(), ".xml", new FileAttribute[0]).toFile();
            try (InputStream inputStream = (InputStream)response.readEntity(InputStream.class);){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.world.setAtrFile(tempFile.toPath());
            this.world.getIngestClient().consumeAnyEntityAndClose(response);
        } else {
            LOGGER.error(String.format("could not download ATR for operationId: %s", this.world.getOperationId()));
            Assertions.fail((String)String.format("could not download ATR for operationId: %s", this.world.getOperationId()));
        }
    }

    @Then(value="^l'\u00e9tat final du fichier ATR est (.*)$")
    public void final_status_atr(String replyCode) throws IOException {
        String atr = FileUtils.readFileToString((File)this.world.getAtrFile().toFile(), (Charset)StandardCharsets.UTF_8);
        if (!StringUtils.contains((CharSequence)atr, (CharSequence)("<ReplyCode>" + replyCode + "</ReplyCode>"))) {
            LOGGER.error(String.format("replyCode %s was not found in ATR", replyCode));
            Assertions.fail((String)String.format("replyCode %s was not found in ATR", replyCode));
        }
    }

    @Then(value="^le fichier ATR contient (?:la|les) valeur[s]? (.*)$")
    public void atr_contains_value(String values) throws IOException {
        String atr = FileUtils.readFileToString((File)this.world.getAtrFile().toFile(), (Charset)StandardCharsets.UTF_8);
        for (String value : values.split(",\\s?")) {
            if (StringUtils.contains((CharSequence)atr, (CharSequence)value)) continue;
            LOGGER.error(String.format("%s value was not found in ATR", value));
            Assertions.fail((String)String.format("%s value was not found in ATR", value));
        }
    }

    @Then(value="^le fichier ATR contient la  cha\u00eene de caract\u00e8res$")
    public void atr_contains_complex_value(String value) throws IOException {
        String atr = FileUtils.readFileToString((File)this.world.getAtrFile().toFile(), (Charset)StandardCharsets.UTF_8);
        if (!StringUtils.contains((CharSequence)atr, (CharSequence)value)) {
            LOGGER.error(String.format("%s value was not found in ATR", value));
            Assertions.fail((String)String.format("%s value was not found in ATR", value));
        }
    }

    @Then(value="^le fichier ATR contient (.*) fois la valeur (.*)$")
    public void atr_contains_n_times_the_value(int count, String value) throws IOException {
        String atr = FileUtils.readFileToString((File)this.world.getAtrFile().toFile(), (Charset)StandardCharsets.UTF_8);
        int realCount = StringUtils.countMatches((CharSequence)atr, (CharSequence)value);
        if (realCount != count) {
            LOGGER.error(String.format("expected %d times the value %s but was %d times", count, value, realCount));
            Assertions.fail((String)String.format("expected %d times the value %s but was %d times", count, value, realCount));
        }
    }

    @Then(value="^le fichier ATR contient (.*) balise[s]? de type (.*)$")
    public void atr_contains_n_times_the_tag(int count, String tag) throws IOException {
        String atr = FileUtils.readFileToString((File)this.world.getAtrFile().toFile(), (Charset)StandardCharsets.UTF_8);
        int realCount = StringUtils.countMatches((CharSequence)atr, (CharSequence)("</" + tag + ">")) + StringUtils.countMatches((CharSequence)atr, (CharSequence)("<" + tag + "/>"));
        if (realCount != count) {
            LOGGER.error(String.format("expected %d tags %s but was %d", count, tag, realCount));
            Assertions.fail((String)String.format("expected %d tags %s but was %d", count, tag, realCount));
        }
    }

    @Then(value="^le fichier ATR contient (.*) unit\u00e9[s]? archivistique[s]?$")
    public void atr_contains_units(int nbUnits) throws IOException {
        this.atr_contains_n_times_the_tag(nbUnits, "ArchiveUnit");
    }

    @Then(value="^le fichier ATR contient (.*) objet[s]? binaire[s]?$")
    public void atr_contains_binary_objects(int nbBinaryObjects) throws IOException {
        this.atr_contains_n_times_the_tag(nbBinaryObjects, "BinaryDataObject");
    }

    @Then(value="^le fichier ATR contient (.*) objet[s]? physique[s]?$")
    public void atr_contains_physical_objects(int nbPhysicalObjects) throws IOException {
        this.atr_contains_n_times_the_tag(nbPhysicalObjects, "PhysicalDataObject");
    }

    private void removeTemporaryAtrFile() {
        if (this.world.getAtrFile() != null) {
            FileUtils.deleteQuietly((File)this.world.getAtrFile().toFile());
            this.world.setAtrFile(null);
        }
    }
}

