/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.common.pagination;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ihmdemo.common.api.IhmWebAppHeader;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;

public class OffsetBasedPagination {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OffsetBasedPagination.class);
    private static final String PARAMETERS = "OffsetBasedPagination parameters";
    public static final String HEADER_LIMIT = "X-Limit";
    public static final String HEADER_OFFSET = "X-Offset";
    public static final String HEADER_TOTAL = "X-Total";
    private int offset = 0;
    private int limit = 125;
    private int total = 0;

    public OffsetBasedPagination() {
    }

    public OffsetBasedPagination(HttpServletRequest request) throws VitamException {
        this.parseHttpHeaders(request);
    }

    public OffsetBasedPagination(int offset, int limit) {
        this(offset, limit, 0);
    }

    public OffsetBasedPagination(int offset, int limit, int total) {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{offset, limit, total});
        this.setLimit(limit).setOffset(offset).setTotal(total);
    }

    public int getOffset() {
        return this.offset;
    }

    public OffsetBasedPagination setOffset(int offset) {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{offset});
        this.offset = offset;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public OffsetBasedPagination setLimit(int limit) {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{limit});
        this.limit = limit;
        return this;
    }

    public int getTotal() {
        return this.total;
    }

    public OffsetBasedPagination setTotal(int total) {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{total});
        this.total = total;
        return this;
    }

    private OffsetBasedPagination parseHttpHeaders(HttpServletRequest request) throws VitamException {
        ArrayList limitValues;
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{request});
        ArrayList offsetValues = Collections.list(request.getHeaders(IhmWebAppHeader.OFFSET.getName()));
        if (offsetValues != null && offsetValues.size() == 1) {
            try {
                this.offset = Integer.parseInt((String)offsetValues.get(0));
                if (this.offset < 0 || this.offset > 1000000) {
                    LOGGER.debug("Offset exceeded acceptable range" + (String)offsetValues.get(0));
                    throw new VitamException("Offset exceeded acceptable range " + (String)offsetValues.get(0));
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                LOGGER.debug("Error parsing offset from {}", offsetValues.get(0), (Object)e);
                throw new VitamException("Error parsing Offset from supplied value: " + (String)offsetValues.get(0));
            }
        }
        if ((limitValues = Collections.list(request.getHeaders(IhmWebAppHeader.LIMIT.getName()))) != null && limitValues.size() == 1) {
            try {
                this.limit = Integer.parseInt((String)limitValues.get(0));
                if (this.limit < 1 || this.limit > 1000) {
                    LOGGER.debug("Limit exceeded acceptable range " + (String)limitValues.get(0));
                    throw new VitamException("Limit exceeded acceptable range " + (String)limitValues.get(0));
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                LOGGER.debug("Error parsing limit from {}", limitValues, (Object)e);
                throw new VitamException("Error parsing Limit from supplied value: " + (String)limitValues.get(0));
            }
        }
        return this;
    }
}

