/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.storage.offers.rest.AdminOfferApplication;
import fr.gouv.vitam.storage.offers.rest.BusinessApplication;
import fr.gouv.vitam.storage.offers.rest.OfferCommonApplication;
import fr.gouv.vitam.storage.offers.rest.OfferConfiguration;

public class DefaultOfferMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DefaultOfferMain.class);
    private static final String CONF_FILE_NAME = "default-offer.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.offer.port";
    private VitamStarter vitamStarter;

    public DefaultOfferMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(OfferConfiguration.class, configurationFile, BusinessApplication.class, AdminOfferApplication.class);
        OfferCommonApplication.getInstance().initialize(configurationFile);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            DefaultOfferMain main = new DefaultOfferMain(args[0]);
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

