/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.database;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OfferLogCompactionDatabaseService {
    private static final int COMPACTED_OFFER_LOG_BULK = 10;
    private final MongoCollection<Document> offerLogCompactionCollection;

    public OfferLogCompactionDatabaseService(MongoCollection<Document> offerLogCompactionCollection) {
        this.offerLogCompactionCollection = offerLogCompactionCollection;
    }

    public List<OfferLog> getDescendingOfferLogCompactionBy(String containerName, Long offset, int limit) {
        ArrayList<OfferLog> results = new ArrayList<OfferLog>();
        int nextLimit = limit;
        Long nextOffset = offset;
        while (nextLimit > 0 && this.loadNextOfferLogsDescending(containerName, nextOffset, nextLimit, results)) {
            nextLimit = limit - results.size();
            nextOffset = ((OfferLog)results.get(results.size() - 1)).getSequence() - 1L;
        }
        return results;
    }

    private boolean loadNextOfferLogsDescending(String containerName, Long offset, int limit, List<OfferLog> results) {
        int lastSize = results.size();
        try (MongoCursor offerLogCursor = this.offerLogCompactionCollection.aggregate(Arrays.asList(Aggregates.match((Bson)(offset != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Container", (Object)containerName), Filters.lte((String)"SequenceStart", (Object)offset)}) : Filters.eq((String)"Container", (Object)containerName))), Aggregates.sort((Bson)Sorts.orderBy((Bson[])new Bson[]{Sorts.descending((String[])new String[]{"SequenceStart"})})), Aggregates.limit((int)10), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("Logs", (Object)new Document("$reverseArray", (Object)"$Logs"))})), Aggregates.unwind((String)"$Logs"), Aggregates.match((Bson)(offset != null ? Filters.lte((String)"Logs.Sequence", (Object)offset) : new BsonDocument())), Aggregates.limit((int)limit), Aggregates.replaceWith((Object)"$Logs"))).map(this::transformDocumentToOfferLog).cursor();){
            offerLogCursor.forEachRemaining(results::add);
        }
        return results.size() != lastSize;
    }

    public List<OfferLog> getAscendingOfferLogCompactionBy(String containerName, Long offset, int limit) {
        ArrayList<OfferLog> results = new ArrayList<OfferLog>();
        int nextLimit = limit;
        Long nextOffset = offset;
        while (nextLimit > 0 && this.loadNextOfferLogsAscending(containerName, nextOffset, nextLimit, results)) {
            nextLimit = limit - results.size();
            nextOffset = ((OfferLog)results.get(results.size() - 1)).getSequence() + 1L;
        }
        return results;
    }

    public boolean loadNextOfferLogsAscending(String containerName, Long offset, int limit, List<OfferLog> results) {
        int lastSize = results.size();
        try (MongoCursor offerLogCursor = this.offerLogCompactionCollection.aggregate(Arrays.asList(Aggregates.match((Bson)(offset != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Container", (Object)containerName), Filters.gte((String)"SequenceEnd", (Object)offset)}) : Filters.eq((String)"Container", (Object)containerName))), Aggregates.sort((Bson)Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"SequenceEnd"})})), Aggregates.limit((int)10), Aggregates.unwind((String)"$Logs"), Aggregates.match((Bson)(offset != null ? Filters.gte((String)"Logs.Sequence", (Object)offset) : new BsonDocument())), Aggregates.limit((int)limit), Aggregates.replaceWith((Object)"$Logs"))).map(this::transformDocumentToOfferLog).cursor();){
            offerLogCursor.forEachRemaining(results::add);
        }
        return results.size() != lastSize;
    }

    private OfferLog transformDocumentToOfferLog(Document document) {
        try {
            return (OfferLog)BsonHelper.fromDocumentToObject((Document)document, OfferLog.class);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

