/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.collection.CloseableIterable;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.StorageProvider;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.MultiplexedStreamReader;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResultEntry;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResultEntry;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.engine.common.model.CompactedOfferLog;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.OfferLogAction;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.offers.core.BackgroundObjectDigestValidator;
import fr.gouv.vitam.storage.offers.core.DefaultOfferService;
import fr.gouv.vitam.storage.offers.core.NonUpdatableContentAddressableStorageException;
import fr.gouv.vitam.storage.offers.database.OfferLogAndCompactedOfferLogService;
import fr.gouv.vitam.storage.offers.database.OfferLogCompactionDatabaseService;
import fr.gouv.vitam.storage.offers.database.OfferLogDatabaseService;
import fr.gouv.vitam.storage.offers.database.OfferSequenceDatabaseService;
import fr.gouv.vitam.storage.offers.rest.OfferLogCompactionConfiguration;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDatabaseException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class DefaultOfferServiceImpl
implements DefaultOfferService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DefaultOfferServiceImpl.class);
    private final AlertService alertService = new AlertServiceImpl();
    private final ContentAddressableStorage defaultStorage;
    private final OfferLogCompactionDatabaseService offerLogCompactionDatabaseService;
    private final OfferLogDatabaseService offerDatabaseService;
    private final OfferSequenceDatabaseService offerSequenceDatabaseService;
    private final StorageConfiguration configuration;
    private final OfferLogCompactionConfiguration offerLogCompactionConfig;
    private final OfferLogAndCompactedOfferLogService offerLogAndCompactedOfferLogService;
    private final ExecutorService batchExecutorService;
    private final int batchMetadataComputationTimeoutIsSeconds;
    private final boolean cleanupObjectsOnWriteError;

    public DefaultOfferServiceImpl(ContentAddressableStorage defaultStorage, OfferLogCompactionDatabaseService offerLogCompactionDatabaseService, OfferLogDatabaseService offerDatabaseService, OfferSequenceDatabaseService offerSequenceDatabaseService, StorageConfiguration configuration, OfferLogCompactionConfiguration offerLogCompactionConfig, OfferLogAndCompactedOfferLogService offerLogAndCompactedOfferLogService, int maxBatchThreadPoolSize, int batchMetadataComputationTimeout, boolean cleanupObjectsOnWriteError) {
        this.defaultStorage = defaultStorage;
        this.offerLogCompactionDatabaseService = offerLogCompactionDatabaseService;
        this.offerDatabaseService = offerDatabaseService;
        this.offerSequenceDatabaseService = offerSequenceDatabaseService;
        this.configuration = configuration;
        this.offerLogCompactionConfig = offerLogCompactionConfig;
        this.offerLogAndCompactedOfferLogService = offerLogAndCompactedOfferLogService;
        this.batchMetadataComputationTimeoutIsSeconds = batchMetadataComputationTimeout;
        this.batchExecutorService = ExecutorUtils.createScalableBatchExecutorService((int)maxBatchThreadPoolSize);
        this.cleanupObjectsOnWriteError = cleanupObjectsOnWriteError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public String getObjectDigest(String containerName, String objectId, DigestType digestAlgorithm) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            String string = this.defaultStorage.getObjectDigest(containerName, objectId, digestAlgorithm, true);
            return string;
        }
        finally {
            this.log(times, containerName, "COMPUTE_DIGEST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectContent getObject(String containerName, String objectId) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            ObjectContent objectContent = this.defaultStorage.getObject(containerName, objectId);
            return objectContent;
        }
        finally {
            this.log(times, containerName, "GET_OBJECT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createAccessRequest(String containerName, List<String> objectNames) throws ContentAddressableStorageException {
        if (!StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(this.configuration.getProvider())) {
            throw new ContentAddressableStorageException("Access request is enabled only on tape library offer");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String string = this.defaultStorage.createAccessRequest(containerName, objectNames);
            return string;
        }
        finally {
            this.log(stopwatch, containerName, "CREATE_ACCESS_REQUEST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        if (!StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(this.configuration.getProvider())) {
            throw new ContentAddressableStorageException("Access request is enabled only on tape library offer");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Map map = this.defaultStorage.checkAccessRequestStatuses(accessRequestIds, adminCrossTenantAccessRequestAllowed);
            return map;
        }
        finally {
            this.log(stopwatch, "CHECK_ACCESS_REQUEST", "CHECK_ACCESS_REQUEST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessRequest(String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        if (!StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(this.configuration.getProvider())) {
            throw new ContentAddressableStorageException("Access request is enabled only on tape library offer");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.defaultStorage.removeAccessRequest(accessRequestId, adminCrossTenantAccessRequestAllowed);
        }
        finally {
            this.log(stopwatch, accessRequestId, "REMOVE_ACCESS_REQUEST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkObjectAvailability(String containerName, List<String> objectNames) throws ContentAddressableStorageException {
        if (!StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(this.configuration.getProvider())) {
            throw new ContentAddressableStorageException("Object availability check is enabled only on tape library offer");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            boolean bl = this.defaultStorage.checkObjectAvailability(containerName, objectNames);
            return bl;
        }
        finally {
            this.log(stopwatch, containerName, "CHECK_OBJECT_AVAILABILITY");
        }
    }

    @Override
    public String createObject(String containerName, String objectId, InputStream objectPart, DataCategory type, long size, DigestType digestType) throws ContentAddressableStorageException {
        String digest;
        this.ensureContainerExists(containerName);
        if (!type.canUpdate() && this.defaultStorage.isExistingObject(containerName, objectId)) {
            digest = this.checkNonRewritableObjects(containerName, objectId, objectPart, digestType);
        } else {
            digest = this.writeObject(containerName, objectId, objectPart, size, digestType, type);
            this.defaultStorage.checkObjectDigestAndStoreDigest(containerName, objectId, digest, digestType, size);
        }
        this.logObjectWriteInOfferLog(containerName, objectId);
        return digest;
    }

    void ensureContainerExists(String containerName) throws ContentAddressableStorageServerException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean existsContainer = this.defaultStorage.isExistingContainer(containerName);
        this.log(stopwatch, containerName, "INIT_CHECK_EXISTS_CONTAINER");
        if (!existsContainer) {
            stopwatch = Stopwatch.createStarted();
            this.defaultStorage.createContainer(containerName);
            this.log(stopwatch, containerName, "INIT_CREATE_CONTAINER");
        }
    }

    private String checkNonRewritableObjects(String containerName, String objectId, InputStream objectPart, DigestType digestType) throws ContentAddressableStorageException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Digest digest = new Digest(digestType);
            digest.update(objectPart);
            String streamDigest = digest.digestHex();
            String string = this.checkObjectDigest(containerName, digestType, objectId, streamDigest);
            return string;
        }
        catch (IOException e) {
            throw new ContentAddressableStorageException("Could not read input stream", (Throwable)e);
        }
        finally {
            this.log(stopwatch, containerName, "CHECK_EXISTS_PUT_OBJECT");
        }
    }

    private void logObjectWriteInOfferLog(String containerName, String objectId) throws ContentAddressableStorageServerException, ContentAddressableStorageDatabaseException {
        Stopwatch times = Stopwatch.createStarted();
        long sequence = this.offerSequenceDatabaseService.getNextSequence("Backup_Log_Sequence");
        this.offerDatabaseService.save(containerName, objectId, OfferLogAction.WRITE, sequence);
        this.log(times, containerName, "LOG_CREATE_IN_DB");
    }

    private String writeObject(String containerName, String objectId, InputStream objectPart, long size, DigestType digestType, DataCategory type) throws ContentAddressableStorageException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Digest digest = new Digest(digestType);
            InputStream inputStream = digest.getDigestInputStream(objectPart);
            this.defaultStorage.writeObject(containerName, objectId, inputStream, digestType, size);
            String string = digest.digestHex();
            return string;
        }
        catch (ContentAddressableStorageNotFoundException e) {
            throw e;
        }
        catch (Exception ex) {
            this.trySilentlyDeletePotentiallyIncompleteWormObject(containerName, objectId, type);
            throw ex;
        }
        finally {
            this.log(stopwatch, containerName, "GLOBAL_PUT_OBJECT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageBulkPutResult bulkPutObjects(String containerName, List<String> objectIds, MultiplexedStreamReader multiplexedStreamReader, DataCategory type, DigestType digestType) throws ContentAddressableStorageException, IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.ensureContainerExists(containerName);
            BackgroundObjectDigestValidator backgroundObjectDigestValidator = new BackgroundObjectDigestValidator(this.defaultStorage, containerName, digestType);
            try {
                for (String objectId : objectIds) {
                    String objectDigest;
                    if (backgroundObjectDigestValidator.hasTechnicalExceptionsReported()) break;
                    if (backgroundObjectDigestValidator.hasConflictsReported()) {
                        break;
                    }
                    Optional entryInputStream = multiplexedStreamReader.readNextEntry();
                    if (entryInputStream.isEmpty()) {
                        throw new IllegalStateException("No entry not found for object id " + objectId);
                    }
                    LOGGER.info("Writing object '" + objectId + "' of container " + containerName);
                    ExactSizeInputStream inputStream = (ExactSizeInputStream)entryInputStream.get();
                    long size = inputStream.getSize();
                    if (!type.canUpdate() && this.defaultStorage.isExistingObject(containerName, objectId)) {
                        objectDigest = this.computeObjectDigest(digestType, inputStream);
                        backgroundObjectDigestValidator.addExistingWormObjectToCheck(objectId, objectDigest, size);
                        continue;
                    }
                    objectDigest = this.writeObject(containerName, objectId, (InputStream)inputStream, size, digestType, type);
                    backgroundObjectDigestValidator.addWrittenObjectToCheck(objectId, objectDigest, size);
                }
            }
            finally {
                backgroundObjectDigestValidator.awaitTermination();
                List<StorageBulkPutResultEntry> entries = backgroundObjectDigestValidator.getWrittenObjects();
                if (!entries.isEmpty()) {
                    List<String> storedObjectIds = entries.stream().map(StorageBulkPutResultEntry::getObjectId).collect(Collectors.toList());
                    this.bulkLogObjectWriteInOfferLog(containerName, storedObjectIds);
                }
            }
            if (backgroundObjectDigestValidator.hasConflictsReported()) {
                throw new NonUpdatableContentAddressableStorageException("Bulk object write failed. At least one non-rewritable object override rejected");
            }
            if (backgroundObjectDigestValidator.hasTechnicalExceptionsReported()) {
                throw new ContentAddressableStorageException("Bulk object write failed. At least one object failed");
            }
            if (multiplexedStreamReader.readNextEntry().isPresent()) {
                throw new IllegalStateException("No more entries expected");
            }
            StorageBulkPutResult storageBulkPutResult = new StorageBulkPutResult(backgroundObjectDigestValidator.getWrittenObjects());
            return storageBulkPutResult;
        }
        finally {
            this.log(stopwatch, containerName, "BULK_PUT_OBJECTS");
        }
    }

    private String computeObjectDigest(DigestType digestType, ExactSizeInputStream inputStream) throws IOException {
        Digest entryDigest = new Digest(digestType);
        entryDigest.update((InputStream)inputStream);
        return entryDigest.digestHex();
    }

    private String checkObjectDigest(String containerName, DigestType digestType, String objectId, String entryDigestValue) throws ContentAddressableStorageException {
        String actualObjectDigest = this.defaultStorage.getObjectDigest(containerName, objectId, digestType, true);
        if (entryDigestValue.equals(actualObjectDigest)) {
            LOGGER.warn("Non rewritable object updated with same content. Ignoring duplicate. Object Id '" + objectId + "' in " + containerName);
            return actualObjectDigest;
        }
        this.alertService.createAlert(VitamLogLevel.ERROR, String.format("Object with id %s (%s) already exists and cannot be updated. Existing file digest=%s, input digest=%s", objectId, containerName, actualObjectDigest, entryDigestValue));
        throw new NonUpdatableContentAddressableStorageException("Object with id " + objectId + " already exists and cannot be updated");
    }

    private void bulkLogObjectWriteInOfferLog(String containerName, List<String> objectIds) throws ContentAddressableStorageServerException, ContentAddressableStorageDatabaseException {
        Stopwatch times = Stopwatch.createStarted();
        long sequence = this.offerSequenceDatabaseService.getNextSequence("Backup_Log_Sequence", objectIds.size());
        this.offerDatabaseService.bulkSave(containerName, objectIds, OfferLogAction.WRITE, sequence);
        this.log(times, containerName, "BULK_LOG_CREATE_IN_DB");
    }

    @Override
    public boolean isObjectExist(String containerName, String objectId) throws ContentAddressableStorageException {
        return this.defaultStorage.isExistingObject(containerName, objectId);
    }

    @Override
    public ContainerInformation getCapacity(String containerName) throws ContentAddressableStorageException {
        ContainerInformation containerInformation;
        Stopwatch times = Stopwatch.createStarted();
        try {
            containerInformation = this.defaultStorage.getContainerInformation(containerName);
        }
        catch (ContentAddressableStorageNotFoundException exc) {
            this.defaultStorage.createContainer(containerName);
            containerInformation = this.defaultStorage.getContainerInformation(containerName);
        }
        this.log(times, containerName, "CHECK_CAPACITY");
        return containerInformation;
    }

    private void trySilentlyDeletePotentiallyIncompleteWormObject(String containerName, String objectId, DataCategory type) {
        if (type.canUpdate()) {
            LOGGER.error("Write file failed for " + containerName + "/" + objectId + ". No need to cleanup (object is rewritable)");
            return;
        }
        if (!this.cleanupObjectsOnWriteError) {
            LOGGER.warn("Potentially partially written object: " + containerName + "/" + objectId + ". Automatic cleanup is disabled");
            return;
        }
        try {
            LOGGER.warn("Cleanup partially written object: " + containerName + "/" + objectId + ". Try deleting it...");
            this.defaultStorage.deleteObject(containerName, objectId);
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn("Delete object after upload failure " + containerName + "/" + objectId + ". Object not found", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete object " + containerName + "/" + objectId + ". Potentially partially written object on WORM container", (Throwable)e);
        }
    }

    @Override
    public void deleteObject(String containerName, String objectId, DataCategory type) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        if (!type.canDelete()) {
            throw new ContentAddressableStorageException("Object with id " + objectId + "can not be deleted");
        }
        long sequence = this.offerSequenceDatabaseService.getNextSequence("Backup_Log_Sequence");
        this.offerDatabaseService.save(containerName, objectId, OfferLogAction.DELETE, sequence);
        this.log(times, containerName, "LOG_DELETE_IN_DB");
        times = Stopwatch.createStarted();
        this.defaultStorage.deleteObject(containerName, objectId);
        this.log(times, containerName, "DELETE_FILE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageMetadataResult getMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            StorageMetadataResult storageMetadataResult = new StorageMetadataResult(this.defaultStorage.getObjectMetadata(containerName, objectId, noCache));
            return storageMetadataResult;
        }
        finally {
            this.log(times, containerName, "GET_METADATA");
        }
    }

    @Override
    public StorageBulkMetadataResult getBulkMetadata(String containerName, List<String> objectIds, Boolean noCache) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            ArrayList completableFutures = new ArrayList();
            for (String objectId : objectIds) {
                CompletableFuture<StorageBulkMetadataResultEntry> objectInformationCompletableFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        MetadatasObject objectMetadata = this.defaultStorage.getObjectMetadata(containerName, objectId, noCache.booleanValue());
                        return new StorageBulkMetadataResultEntry(objectMetadata.getObjectName(), objectMetadata.getDigest(), Long.valueOf(objectMetadata.getFileSize()));
                    }
                    catch (ContentAddressableStorageNotFoundException e) {
                        LOGGER.info("Object " + objectId + " not found in container " + containerName, (Throwable)e);
                        return new StorageBulkMetadataResultEntry(objectId, null, null);
                    }
                    catch (ContentAddressableStorageException e) {
                        throw new RuntimeException("Could not get object metadata for " + containerName + "/" + objectId + " (noCache=" + noCache + ")", e);
                    }
                }, this.batchExecutorService);
                completableFutures.add(objectInformationCompletableFuture);
            }
            CompletableFuture batchObjectInformationFuture = this.sequence(completableFutures);
            try {
                String objectId;
                objectId = new StorageBulkMetadataResult(batchObjectInformationFuture.get(this.batchMetadataComputationTimeoutIsSeconds, TimeUnit.SECONDS));
                return objectId;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                for (CompletableFuture completableFuture : completableFutures) {
                    completableFuture.cancel(false);
                }
                throw new ContentAddressableStorageException("Batch object information timed out", (Throwable)e);
            }
        }
        finally {
            this.log(times, containerName, "GET_BULK_METADATA");
        }
    }

    private <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> completableFutures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
        return allDoneFuture.thenApply(v -> completableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    @Override
    public void listObjects(String containerName, ObjectListingListener objectListingListener) throws IOException, ContentAddressableStorageException {
        this.ensureContainerExists(containerName);
        this.defaultStorage.listContainer(containerName, objectListingListener);
    }

    @Override
    public List<OfferLog> getOfferLogs(String containerName, Long offset, int limit, Order order) throws ContentAddressableStorageDatabaseException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            switch (order) {
                case ASC: {
                    List<OfferLog> list = this.searchAscending(containerName, offset, limit);
                    return list;
                }
                case DESC: {
                    List<OfferLog> list = this.searchDescending(containerName, offset, limit);
                    return list;
                }
            }
            try {
                throw new VitamRuntimeException("Order must be ASC or DESC, here " + order);
            }
            catch (Exception e) {
                throw new ContentAddressableStorageDatabaseException(String.format("Database Error while getting OfferLog for container %s", containerName), (Throwable)e);
            }
        }
        finally {
            this.log(times, containerName, "GET_OFFER_LOGS");
        }
    }

    private List<OfferLog> searchDescending(String containerName, Long offset, int limit) {
        List<OfferLog> offerLogs = this.offerDatabaseService.getDescendingOfferLogsBy(containerName, offset, limit);
        int remainingLimit = this.getRemainingLimit(offerLogs, limit);
        Long nextOffset = this.getNextOffsetDescending(offerLogs, offset);
        if (remainingLimit == 0) {
            return offerLogs;
        }
        List<OfferLog> compactedOfferLogs = this.offerLogCompactionDatabaseService.getDescendingOfferLogCompactionBy(containerName, nextOffset, remainingLimit);
        return ListUtils.union(offerLogs, compactedOfferLogs);
    }

    private List<OfferLog> searchAscending(String containerName, Long offset, int limit) {
        List<OfferLog> compactedOfferLogs = this.offerLogCompactionDatabaseService.getAscendingOfferLogCompactionBy(containerName, offset, limit);
        int remainingLimit = this.getRemainingLimit(compactedOfferLogs, limit);
        Long nextOffset = this.getNextOffsetAscending(compactedOfferLogs, offset);
        if (remainingLimit == 0) {
            return compactedOfferLogs;
        }
        List<OfferLog> nextOfferLogs = this.offerDatabaseService.getAscendingOfferLogsBy(containerName, nextOffset, remainingLimit);
        List<OfferLog> nextCompactedOfferLogs = this.offerLogCompactionDatabaseService.getAscendingOfferLogCompactionBy(containerName, nextOffset, remainingLimit);
        List<OfferLog> nextMergedOfferLogs = this.mergeAndResolveDuplicates(nextOfferLogs, nextCompactedOfferLogs, remainingLimit);
        return ListUtils.union(compactedOfferLogs, nextMergedOfferLogs);
    }

    private List<OfferLog> mergeAndResolveDuplicates(List<OfferLog> list1, List<OfferLog> list2, int limit) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        PeekingIterator iterator1 = PeekingIterator.peekingIterator(list1.iterator());
        PeekingIterator iterator2 = PeekingIterator.peekingIterator(list2.iterator());
        ArrayList<OfferLog> results = new ArrayList<OfferLog>();
        while (results.size() < limit) {
            boolean shouldTakeFromList2;
            boolean shouldTakeFromList1 = iterator1.hasNext() && (!iterator2.hasNext() || ((OfferLog)iterator1.peek()).getSequence() <= ((OfferLog)iterator2.peek()).getSequence());
            boolean bl = shouldTakeFromList2 = iterator2.hasNext() && (!iterator1.hasNext() || ((OfferLog)iterator1.peek()).getSequence() >= ((OfferLog)iterator2.peek()).getSequence());
            if (shouldTakeFromList1 && shouldTakeFromList2) {
                results.add((OfferLog)iterator1.next());
                iterator2.next();
                continue;
            }
            if (shouldTakeFromList1) {
                results.add((OfferLog)iterator1.next());
                continue;
            }
            if (!shouldTakeFromList2) break;
            results.add((OfferLog)iterator2.next());
        }
        return results;
    }

    private int getRemainingLimit(List<OfferLog> logs, int limit) {
        return limit - logs.size();
    }

    private Long getNextOffsetDescending(List<OfferLog> logs, Long offset) {
        if (!logs.isEmpty()) {
            return logs.get(logs.size() - 1).getSequence() - 1L;
        }
        return offset;
    }

    private Long getNextOffsetAscending(List<OfferLog> logs, Long offset) {
        if (!logs.isEmpty()) {
            return logs.get(logs.size() - 1).getSequence() + 1L;
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compactOfferLogs() throws Exception {
        Stopwatch timer = Stopwatch.createStarted();
        try (CloseableIterable<OfferLog> expiredOfferLogsByContainer = this.offerDatabaseService.getExpiredOfferLogByContainer(this.offerLogCompactionConfig.getExpirationValue(), this.offerLogCompactionConfig.getExpirationUnit());){
            ArrayList<Object> bulkToSend = new ArrayList<OfferLog>();
            for (OfferLog offerLog : expiredOfferLogsByContainer) {
                if (this.isBulkFull(bulkToSend) || !this.isInSameContainer(offerLog, bulkToSend)) {
                    this.saveOfferLogCompaction(bulkToSend);
                    bulkToSend = new ArrayList();
                }
                bulkToSend.add(offerLog);
            }
            if (!bulkToSend.isEmpty()) {
                this.saveOfferLogCompaction(bulkToSend);
            }
        }
        finally {
            this.log(timer, this.offerLogCompactionConfig.toString(), "COMPACT_OFFER_LOGS");
        }
    }

    private boolean isBulkFull(List<OfferLog> bulkToSend) {
        return bulkToSend.size() >= this.offerLogCompactionConfig.getCompactionSize();
    }

    private boolean isInSameContainer(OfferLog offerLog, List<OfferLog> bulkToSend) {
        if (bulkToSend.isEmpty()) {
            return true;
        }
        return offerLog.getContainer().equals(bulkToSend.get(0).getContainer());
    }

    private void saveOfferLogCompaction(List<OfferLog> bulkToSend) {
        OfferLog first = bulkToSend.get(0);
        OfferLog last = bulkToSend.get(bulkToSend.size() - 1);
        CompactedOfferLog compactedOfferLog = new CompactedOfferLog(first.getSequence(), last.getSequence(), LocalDateUtil.now(), first.getContainer(), bulkToSend);
        this.offerLogAndCompactedOfferLogService.almostTransactionalSaveAndDelete(compactedOfferLog, bulkToSend);
    }

    public void log(Stopwatch timer, String action, String task) {
        PerformanceLogger.getInstance().log(String.format("STP_Offer_%s", this.configuration.getProvider()), action, task, timer.elapsed(TimeUnit.MILLISECONDS));
    }
}

