/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.utils;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;

public class ContainerUtils {
    public static String buildContainerName(DataCategory type, String tenantId) {
        if (type == null || Strings.isNullOrEmpty((String)type.getFolder()) || Strings.isNullOrEmpty((String)tenantId)) {
            return null;
        }
        String environmentName = ContainerUtils.getEnvironmentNamePrefix();
        return environmentName + tenantId + "_" + type.getFolder();
    }

    public static DataCategory parseDataCategoryFromContainerName(String containerName) {
        String environmentName = ContainerUtils.getEnvironmentNamePrefix();
        if (!containerName.startsWith(environmentName)) {
            throw new IllegalArgumentException("Invalid container name '" + containerName + "'. Env name mismatch.");
        }
        int tenantStartPos = environmentName.length();
        int tenantEndPos = containerName.indexOf(95, tenantStartPos + 1);
        int folderStartPos = tenantEndPos + 1;
        String folder = containerName.substring(folderStartPos);
        for (DataCategory value : DataCategory.values()) {
            if (!value.getFolder().equals(folder)) continue;
            return value;
        }
        throw new IllegalArgumentException("Invalid container name " + containerName);
    }

    public static int parseTenantFromContainerName(String containerName) {
        String environmentName = ContainerUtils.getEnvironmentNamePrefix();
        if (!containerName.startsWith(environmentName)) {
            throw new IllegalArgumentException("Invalid container name '" + containerName + "'. Env name mismatch.");
        }
        int tenantStartPos = environmentName.length();
        int tenantEndPos = containerName.indexOf(95, tenantStartPos + 1);
        return Integer.parseInt(containerName.substring(tenantStartPos, tenantEndPos));
    }

    private static String getEnvironmentNamePrefix() {
        return Strings.isNullOrEmpty((String)VitamConfiguration.getEnvironmentName()) ? "" : VitamConfiguration.getEnvironmentName() + "_";
    }
}

