/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.core.impl;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.administration.core.api.LogbookDetailsCheckService;
import fr.gouv.vitam.logbook.common.model.coherence.EventModel;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckError;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookEventName;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookEventType;
import fr.gouv.vitam.logbook.common.model.coherence.OutcomeStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LogbookDetailsCheckServiceImpl
implements LogbookDetailsCheckService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookDetailsCheckServiceImpl.class);
    private final String SAVED_LOGBOOK_MSG = "The saved event %s value is : %s";
    private final String SAVED_LOGBOOK_OP_LFC_NOT_EXISTS_MSG = "The saved LFC event %s value %s, is not present in logbook operation";
    private final String SAVED_LOGBOOK_OP_LFC_NOT_CONFORME_MSG = "The saved LFC event %s value %s, is not conforme in logbook operation";
    private final String SAVED_LOGBOOK_OPERATION_EVENTS_NOT_EXIST_IN_LFC_MSG = "The saved logbook operation event %s value %s, is not present in the lifecycles";
    private final String EXPECTED_LOGBOOK_MSG = "The event %s value must be as : %s";
    private final String EXPECTED_LOGBOOK_OP_LFC_NOT_EXISTS_MSG = "The logbook operation must contains the lifecycle event value %s";
    private final String EXPECTED_LOGBOOK_OP_LFC_NOT_CONFORME_MSG = "The logbook operation must have the same event value %s as in the lifecycle";
    private final String EXPECTED_LOGBOOK_OPERATION_EVENTS_NOT_EXIST_IN_LFC_MSG = "The logbook operation event %s, must be present in the lifecycles";
    private final String DOT = ".";

    @Override
    public List<LogbookCheckError> checkEvent(EventModel event) {
        String regex;
        Pattern pattern;
        Matcher matcher;
        boolean isOutcomeOk;
        ArrayList<LogbookCheckError> logbookCheckErrors = new ArrayList<LogbookCheckError>();
        if (LogbookEventType.TASK.equals((Object)event.getLogbookEventType()) && event.getEvTypeParent() != null) {
            String evTypeFormat = event.getEvTypeParent() + ".";
            if (!event.getEvType().startsWith(evTypeFormat)) {
                logbookCheckErrors.add(new LogbookCheckError(event.getOperationId(), event.getLfcId(), event.getEvType(), String.format("The saved event %s value is : %s", LogbookEventName.EVTYPE.getValue(), event.getEvType()), String.format("The event %s value must be as : %s", LogbookEventName.EVTYPE.getValue(), evTypeFormat + "*")));
            }
        }
        if (!(isOutcomeOk = Stream.of(OutcomeStatus.values()).map(String::valueOf).anyMatch(s -> s.contains(event.getOutcome())))) {
            logbookCheckErrors.add(new LogbookCheckError(event.getOperationId(), event.getLfcId(), event.getEvType(), String.format("The saved event %s value is : %s", event.getEvType() + " " + LogbookEventName.OUTCOME.getValue(), event.getOutcome()), String.format("The event %s value must be as : %s", LogbookEventName.OUTCOME.getValue(), Stream.of(OutcomeStatus.values()).map(String::valueOf).collect(Collectors.joining(", ")))));
        }
        if (!(matcher = (pattern = Pattern.compile(regex = "^" + event.getEvType() + "(\\.(\\w+))*\\." + event.getOutcome() + "$")).matcher(event.getOutDetail())).find()) {
            logbookCheckErrors.add(new LogbookCheckError(event.getOperationId(), event.getLfcId(), event.getEvType(), String.format("The saved event %s value is : %s", LogbookEventName.OUTCOMEDETAILS.getValue(), event.getOutDetail()), String.format("The event %s value must be as : %s", LogbookEventName.OUTCOMEDETAILS.getValue(), regex)));
        }
        return logbookCheckErrors;
    }

    @Override
    public List<LogbookCheckError> checkLFCandOperation(Map<String, EventModel> mapOpEvents, Map<String, EventModel> mapLfcEvents) {
        ArrayList<LogbookCheckError> logbookCheckErrors = new ArrayList<LogbookCheckError>();
        LOGGER.debug("Check coherence between logbook operation and Lifecycles");
        HashSet<String> treatedEvents = new HashSet<String>();
        for (String evType : mapLfcEvents.keySet()) {
            EventModel eventLfc = mapLfcEvents.get(evType);
            EventModel eventOp = mapOpEvents.get(evType);
            if (eventOp == null) {
                logbookCheckErrors.add(new LogbookCheckError(eventLfc.getOperationId(), eventLfc.getLfcId(), eventLfc.getEvType(), String.format("The saved LFC event %s value %s, is not present in logbook operation", LogbookEventName.EVTYPE.getValue(), eventLfc.getEvType()), String.format("The logbook operation must contains the lifecycle event value %s", LogbookEventName.EVTYPE.getValue(), eventLfc.getEvType())));
            } else if (!eventLfc.getOutcome().equals(eventOp.getOutcome())) {
                logbookCheckErrors.add(new LogbookCheckError(eventLfc.getOperationId(), eventLfc.getLfcId(), eventLfc.getEvType(), String.format("The saved LFC event %s value %s, is not conforme in logbook operation", LogbookEventName.OUTCOME.getValue(), eventLfc.getOutcome()), String.format("The logbook operation must have the same event value %s as in the lifecycle", LogbookEventName.OUTCOME.getValue(), eventLfc.getOutcome())));
            }
            treatedEvents.add(evType);
        }
        mapOpEvents.keySet().removeAll(treatedEvents);
        if (!mapOpEvents.isEmpty()) {
            mapOpEvents.values().forEach(event -> logbookCheckErrors.add(new LogbookCheckError(event.getOperationId(), event.getLfcId(), event.getEvType(), String.format("The saved logbook operation event %s value %s, is not present in the lifecycles", LogbookEventName.EVTYPE.getValue(), event.getEvType()), String.format("The logbook operation event %s, must be present in the lifecycles", LogbookEventName.EVTYPE.getValue(), event.getEvType()))));
        }
        return logbookCheckErrors;
    }
}

