/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.core.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.logbook.administration.core.api.LogbookCheckConsistencyService;
import fr.gouv.vitam.logbook.administration.core.api.LogbookDetailsCheckService;
import fr.gouv.vitam.logbook.administration.core.impl.LogbookDetailsCheckServiceImpl;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.model.coherence.EventModel;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckError;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckEvent;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckResult;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookEventName;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookEventType;
import fr.gouv.vitam.logbook.common.model.coherence.OutcomeStatus;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;

public class LogbookCheckConsistencyServiceImpl
implements LogbookCheckConsistencyService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookCheckConsistencyServiceImpl.class);
    private static final String LFC_EVENT_TYPE_PREFIX = "LFC.";
    private static final String STEP_STARTED_SUFFIX = ".STARTED";
    private final String SAVED_LOGBOOK_WORKFLOW_NOT_EXISTS_MSG = "The saved logbook event %s value %s, is not present in the workflow";
    private final String SAVED_LOGBOOK_EVENTS_EMPTY_MSG = "The logbook operation's event list is empty";
    private final String EXPECTED_LOGBOOK_WORKFLOW_NOT_EXISTS_MSG = "The logbook event %s, must be present in the workflow";
    private final String EXPECTED_LOGBOOK_EVENTS_EMPTY_MSG = "The logbook operation's event list must not be empty";
    private static final String CHECK_LOGBOOK_MONDATORY_PARAMETERS_MSG = "the tenant parameter is mondatory to the logbook check consistency.";
    private VitamRepositoryProvider vitamRepository;
    private LogbookDetailsCheckService logbookDetailsCheckService;
    private final Set<LogbookCheckError> logbookKoCheckTotalResults = new HashSet<LogbookCheckError>();
    private final Set<LogbookCheckEvent> logbookCheckedEvents = new HashSet<LogbookCheckEvent>();
    private Map<String, Set<String>> workflowEventTypes;
    private List<String> opEventsNotInWf;
    private List<String> opLfcEventsToSkip;
    private List<String> opWithLfc;

    public LogbookCheckConsistencyServiceImpl(LogbookConfiguration configuration, VitamRepositoryProvider vitamRepository) {
        this(configuration, vitamRepository, new LogbookDetailsCheckServiceImpl());
    }

    @VisibleForTesting
    public LogbookCheckConsistencyServiceImpl(LogbookConfiguration configuration, VitamRepositoryProvider vitamRepository, LogbookDetailsCheckService checkLogbookPropertiesService) {
        this.vitamRepository = vitamRepository;
        this.logbookDetailsCheckService = checkLogbookPropertiesService;
        this.opLfcEventsToSkip = Collections.unmodifiableList(configuration.getOpLfcEventsToSkip());
        this.opWithLfc = Collections.unmodifiableList(configuration.getOpWithLFC());
        this.opEventsNotInWf = Collections.unmodifiableList(configuration.getOpEventsNotInWf());
    }

    @Override
    public LogbookCheckResult logbookCoherenceCheckByTenant(Integer tenant) throws VitamException {
        ParametersChecker.checkParameter((String)CHECK_LOGBOOK_MONDATORY_PARAMETERS_MSG, (Object[])new Object[]{tenant});
        LOGGER.debug(String.format("Logbook coherence check on the %s Vitam tenant", tenant));
        this.initWorkflowEventTypes();
        MongoCursor cursor = this.vitamRepository.getVitamMongoRepository(LogbookCollections.OPERATION.getVitamCollection()).findDocuments(VitamConfiguration.getBatchSize(), tenant).iterator();
        Iterable documentIterable = () -> cursor;
        StreamSupport.stream(documentIterable.spliterator(), false).forEach(operation -> {
            String operationId = operation.getString((Object)LogbookEventName.ID.getValue());
            String operationEvType = operation.getString((Object)LogbookEventName.EVTYPE.getValue());
            Set<String> allowedEvTypes = this.workflowEventTypes.containsKey(operationEvType) ? this.workflowEventTypes.get(operationEvType) : null;
            EventModel eventModelOp = this.getEventModel((Document)operation, operationId, null, LogbookEventType.OPERATION);
            this.logbookKoCheckTotalResults.addAll(this.logbookDetailsCheckService.checkEvent(eventModelOp));
            HashMap<String, EventModel> mapOpEvents = new HashMap<String, EventModel>();
            List operationEvents = (List)operation.get((Object)"events".toString());
            if (operationEvents != null && !operationEvents.isEmpty()) {
                this.checkCoherenceEvents(LogbookEventType.OPERATION, operationId, null, operationEvents, allowedEvTypes, mapOpEvents);
            } else {
                this.logbookKoCheckTotalResults.add(new LogbookCheckError(operationId, "", eventModelOp.getEvType(), "The logbook operation's event list is empty", "The logbook operation's event list must not be empty"));
            }
            if (this.opWithLfc.contains(operationEvType)) {
                HashMap<String, EventModel> mapLfcEvents = new HashMap<String, EventModel>();
                try (LogbookLifeCyclesClient client = LogbookLifeCyclesClientFactory.getInstance().getClient();){
                    this.checkUnitLfcByOperation(client, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED, operationId, allowedEvTypes, mapLfcEvents);
                    this.checkUnitLfcByOperation(client, LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS, operationId, allowedEvTypes, mapLfcEvents);
                    this.checkObjectGroupLfcByOperation(client, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED, operationId, allowedEvTypes, mapLfcEvents);
                    this.checkObjectGroupLfcByOperation(client, LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS, operationId, allowedEvTypes, mapLfcEvents);
                }
                mapOpEvents.remove(operationEvType);
                mapOpEvents.keySet().removeAll(this.opLfcEventsToSkip);
                this.logbookKoCheckTotalResults.addAll(this.logbookDetailsCheckService.checkLFCandOperation(mapOpEvents, mapLfcEvents));
            }
        });
        return new LogbookCheckResult(tenant, this.logbookCheckedEvents, this.logbookKoCheckTotalResults);
    }

    private void initWorkflowEventTypes() {
        if (this.workflowEventTypes == null) {
            this.workflowEventTypes = new HashMap<String, Set<String>>();
            try (ProcessingManagementClient processingClient = ProcessingManagementClientFactory.getInstance().getClient();){
                RequestResponse requestResponse = processingClient.getWorkflowDefinitions();
                if (requestResponse.isOk()) {
                    List workflows = ((RequestResponseOK)requestResponse).getResults();
                    workflows.forEach(workflow -> {
                        HashSet<String> eventTypes = new HashSet<String>();
                        eventTypes.add(workflow.getIdentifier());
                        workflow.getSteps().forEach(step -> {
                            eventTypes.add(step.getStepName());
                            eventTypes.addAll(step.getActions().stream().map(action -> action.getActionDefinition().getActionKey()).collect(Collectors.toSet()));
                        });
                        this.workflowEventTypes.put(workflow.getIdentifier(), eventTypes);
                    });
                }
            }
            catch (VitamClientException e) {
                LOGGER.warn("Unable to load workflows'definitions from ProcessEngineManagement.");
            }
        }
    }

    private void checkUnitLfcByOperation(LogbookLifeCyclesClient client, LifeCycleStatusCode cycleStatusCode, String operationId, Set<String> allowedEvTypes, Map<String, EventModel> mapLfcEvents) {
        Select select = new Select();
        try (CloseableIterator iterator = client.unitLifeCyclesByOperationIterator(operationId, cycleStatusCode, (JsonNode)select.getFinalSelect());){
            CloseableIteratorUtils.map((CloseableIterator)iterator, LogbookLifeCycleUnit::new).forEachRemaining(unitLFC -> {
                this.logbookDetailsCheckService.checkEvent(this.getEventModel((Document)unitLFC, operationId, unitLFC.getId(), LogbookEventType.UNIT_LFC));
                List unitLFCEvents = (List)unitLFC.get((Object)"events");
                if (unitLFCEvents != null && !unitLFCEvents.isEmpty()) {
                    this.checkCoherenceEvents(LogbookEventType.UNIT_LFC, operationId, unitLFC.getId(), unitLFCEvents, allowedEvTypes, mapLfcEvents);
                }
            });
        }
        catch (LogbookClientException | IllegalStateException e) {
            LOGGER.error("ERROR: Exception has been thrown when loading unit's lifeCycles : ", e);
        }
    }

    private void checkObjectGroupLfcByOperation(LogbookLifeCyclesClient client, LifeCycleStatusCode cycleStatusCode, String operationId, Set<String> allowedEvTypes, Map<String, EventModel> mapLfcEvents) {
        Select select = new Select();
        try (CloseableIterator iterator = client.objectGroupLifeCyclesByOperationIterator(operationId, cycleStatusCode, (JsonNode)select.getFinalSelect());){
            CloseableIteratorUtils.map((CloseableIterator)iterator, LogbookLifeCycleObjectGroup::new).forEachRemaining(objectGroupLFC -> {
                this.logbookDetailsCheckService.checkEvent(this.getEventModel((Document)objectGroupLFC, operationId, objectGroupLFC.getId(), LogbookEventType.OBJECTGROUP_LFC));
                List objectGroupLFCEvents = (List)objectGroupLFC.get((Object)"events");
                if (objectGroupLFCEvents != null && !objectGroupLFCEvents.isEmpty()) {
                    this.checkCoherenceEvents(LogbookEventType.OBJECTGROUP_LFC, operationId, objectGroupLFC.getId(), objectGroupLFCEvents, allowedEvTypes, mapLfcEvents);
                }
            });
        }
        catch (LogbookClientException | IllegalStateException e) {
            LOGGER.error("ERROR: Exception has been thrown when loading objectGroup's lifeCycles : ", e);
        }
    }

    private void checkCoherenceEvents(LogbookEventType logbookEventType, String operationId, String lfcId, List<Document> events, Set<String> allowedEvTypes, Map<String, EventModel> mapLogbookEvents) {
        EventModel lastEvent = new EventModel();
        boolean doBreak = false;
        for (Document event : events) {
            if (event.getString((Object)LogbookEventName.EVID_PROC.getValue()).equals(operationId)) {
                doBreak = true;
            } else if (doBreak) break;
            EventModel eventModel = this.getEventModel(event, operationId, lfcId, null);
            this.updateEventLogbookType(eventModel, logbookEventType, event.getString((Object)LogbookEventName.EVPARENT_ID.getValue()), lastEvent);
            lastEvent = eventModel;
            this.logbookCheckedEvents.add(new LogbookCheckEvent(eventModel.getEvType(), eventModel.getOutcome(), eventModel.getOutDetail()));
            if (!(!LogbookEventType.STEP.equals((Object)eventModel.getLogbookEventType()) && !LogbookEventType.ACTION.equals((Object)eventModel.getLogbookEventType()) || allowedEvTypes == null || allowedEvTypes.contains(eventModel.getEvType()) || eventModel.getEvType().endsWith(STEP_STARTED_SUFFIX) || this.opEventsNotInWf.contains(eventModel.getEvType()))) {
                this.logbookKoCheckTotalResults.add(new LogbookCheckError(eventModel.getOperationId(), eventModel.getLfcId(), eventModel.getEvType(), String.format("The saved logbook event %s value %s, is not present in the workflow", LogbookEventName.EVTYPE.getValue(), eventModel.getEvType()), String.format("The logbook event %s, must be present in the workflow", LogbookEventName.EVTYPE.getValue(), eventModel.getEvType())));
            }
            this.logbookKoCheckTotalResults.addAll(this.logbookDetailsCheckService.checkEvent(eventModel));
            if (LogbookEventType.STEP.equals((Object)eventModel.getLogbookEventType()) || eventModel.getEvType().endsWith(STEP_STARTED_SUFFIX)) continue;
            if (!mapLogbookEvents.containsKey(eventModel.getEvType())) {
                mapLogbookEvents.put(eventModel.getEvType(), eventModel);
                continue;
            }
            EventModel value = mapLogbookEvents.get(eventModel.getEvType());
            String eventStatus = eventModel.getOutcome();
            if (!Stream.of(OutcomeStatus.values()).anyMatch(x -> x.name().equals(eventStatus)) || OutcomeStatus.valueOf((String)eventStatus).getWeight() <= OutcomeStatus.valueOf((String)value.getOutcome()).getWeight()) continue;
            mapLogbookEvents.replace(eventModel.getEvType(), eventModel);
        }
    }

    private EventModel getEventModel(Document document, String operationId, String lfcId, LogbookEventType logbookEventType) {
        EventModel eventModel = new EventModel();
        eventModel.setEvId(document.getString((Object)LogbookEventName.EVID.getValue()));
        eventModel.setEvParentId(document.getString((Object)LogbookEventName.EVPARENT_ID.getValue()));
        eventModel.setOutcome(document.getString((Object)LogbookEventName.OUTCOME.getValue()));
        eventModel.setEvType(this.clearLfcPrefix(document.getString((Object)LogbookEventName.EVTYPE.getValue())));
        eventModel.setOutDetail(this.clearLfcPrefix(document.getString((Object)LogbookEventName.OUTCOMEDETAILS.getValue())));
        eventModel.setLogbookEventType(logbookEventType);
        eventModel.setOperationId(operationId);
        eventModel.setLfcId(lfcId);
        return eventModel;
    }

    private String clearLfcPrefix(String property) {
        if (property.startsWith(LFC_EVENT_TYPE_PREFIX)) {
            return property.replace(LFC_EVENT_TYPE_PREFIX, "");
        }
        return property;
    }

    private void updateEventLogbookType(EventModel evModel, LogbookEventType logbookEventType, String evParentId, EventModel lastEvent) {
        switch (logbookEventType) {
            case OPERATION: {
                if (evParentId == null) {
                    evModel.setLogbookEventType(LogbookEventType.STEP);
                    break;
                }
                if (lastEvent == null) break;
                if (lastEvent.getEvParentId() != null && lastEvent.getEvParentId().equals(evParentId)) {
                    evModel.setLogbookEventType(lastEvent.getLogbookEventType());
                    evModel.setEvTypeParent(lastEvent.getEvTypeParent());
                    break;
                }
                switch (lastEvent.getLogbookEventType()) {
                    case STEP: {
                        evModel.setLogbookEventType(LogbookEventType.ACTION);
                        break;
                    }
                    case ACTION: {
                        evModel.setLogbookEventType(LogbookEventType.TASK);
                        evModel.setEvTypeParent(lastEvent.getEvType());
                        break;
                    }
                    case TASK: {
                        evModel.setLogbookEventType(LogbookEventType.ACTION);
                    }
                }
                break;
            }
            case OBJECTGROUP_LFC: 
            case UNIT_LFC: {
                if (evParentId == null) {
                    evModel.setLogbookEventType(LogbookEventType.ACTION);
                    break;
                }
                evModel.setLogbookEventType(LogbookEventType.TASK);
                if (lastEvent == null) break;
                evModel.setEvTypeParent(lastEvent.getEvType());
                break;
            }
            default: {
                evModel.setLogbookEventType(LogbookEventType.DEFAULT);
            }
        }
    }
}

