/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.administration.core.LogbookTraceabilityIterator;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityIterator;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;

public class LogbookOperationTraceabilityHelper
implements LogbookTraceabilityHelper {
    public static final String STP_OP_SECURISATION = "STP_OP_SECURISATION";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationTraceabilityHelper.class);
    private static final String OP_SECURISATION_STORAGE = "OP_SECURISATION_STORAGE";
    private static final String TIMESTAMP = "OP_SECURISATION_TIMESTAMP";
    private static final String EVENT_ID = LogbookMongoDbName.eventIdentifier.getDbname();
    private static final String EVENT_DETAIL_DATA = LogbookMongoDbName.eventDetailData.getDbname();
    private static final String ZIP_NAME = "LogbookOperation";
    private final LogbookOperations logbookOperations;
    private final GUID operationID;
    private final int temporizationDelayInSeconds;
    private final int traceabilityExpirationInSeconds;
    private List<String> expectedLogbookId = null;
    private LogbookOperation lastTraceabilityOperation = null;
    private TraceabilityIterator<LogbookOperation> traceabilityIterator = null;
    private Boolean isLastEventInit = false;
    private Boolean isLastMonthEventInit = false;
    private Boolean isLastYearEventInit = false;
    private String previousStartDate = null;
    private String previousMonthStartDate = null;
    private String previousYearStartDate = null;
    private byte[] previousTimestampToken = null;
    private byte[] previousMonthTimestampToken = null;
    private byte[] previousYearTimestampToken = null;
    private LocalDateTime traceabilityStartDate;
    private LocalDateTime traceabilityEndDate;

    public LogbookOperationTraceabilityHelper(LogbookOperations logbookOperations, GUID operationID, int temporizationDelayInSeconds, int traceabilityExpirationInSeconds) {
        this.logbookOperations = logbookOperations;
        this.operationID = operationID;
        this.temporizationDelayInSeconds = temporizationDelayInSeconds;
        this.traceabilityExpirationInSeconds = traceabilityExpirationInSeconds;
    }

    public void initialize() throws TraceabilityException {
        LocalDateTime startDate;
        this.expectedLogbookId = Lists.newArrayList((Object[])new String[]{this.operationID.getId()});
        try {
            this.lastTraceabilityOperation = this.logbookOperations.findLastTraceabilityOperationOK();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookDatabaseException | LogbookNotFoundException e) {
            throw new TraceabilityException(e);
        }
        if (this.lastTraceabilityOperation == null) {
            startDate = INITIAL_START_DATE;
        } else {
            TraceabilityEvent traceabilityEvent;
            try {
                traceabilityEvent = this.extractEventDetData(this.lastTraceabilityOperation);
            }
            catch (InvalidParseOperationException e) {
                throw new TraceabilityException("Could not parse last traceability operation information", (Throwable)e);
            }
            startDate = LocalDateUtil.parseMongoFormattedDate((String)traceabilityEvent.getEndDate());
            this.expectedLogbookId.add(this.lastTraceabilityOperation.getString((Object)EVENT_ID));
        }
        this.traceabilityStartDate = startDate;
        this.traceabilityEndDate = LocalDateUtil.now().minusSeconds(this.temporizationDelayInSeconds);
    }

    public boolean isTraceabilityOperationRequired() throws TraceabilityException {
        LocalDateTime lastTraceabilityOperationValidityDateTime = this.traceabilityStartDate.plusSeconds(this.traceabilityExpirationInSeconds);
        if (this.traceabilityEndDate.isAfter(lastTraceabilityOperationValidityDateTime)) {
            LOGGER.info("Logbook operation traceability required. Last traceability operation is too old. Max validity date " + LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)lastTraceabilityOperationValidityDateTime));
            return true;
        }
        try {
            if (this.logbookOperations.checkNewEligibleLogbookOperationsSinceLastTraceabilityOperation(this.traceabilityStartDate, this.traceabilityEndDate)) {
                LOGGER.info("Logbook operation traceability required. New logbook operations found since last traceability operation: " + LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityStartDate));
                return true;
            }
        }
        catch (LogbookDatabaseException e) {
            throw new TraceabilityException("Could not parse check traceability operation information", (Throwable)e);
        }
        LOGGER.info("Skipping Logbook operation traceability. No activity since last traceability operation: " + LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityStartDate));
        return false;
    }

    public void saveDataInZip(MerkleTreeAlgo algo, TraceabilityFile file) throws IOException, TraceabilityException {
        MongoCursor mongoCursor;
        try {
            mongoCursor = this.logbookOperations.selectOperationsByLastPersistenceDateInterval(this.traceabilityStartDate, this.traceabilityEndDate);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookDatabaseException | LogbookNotFoundException e) {
            throw new TraceabilityException(e);
        }
        this.traceabilityIterator = new LogbookTraceabilityIterator((MongoCursor<LogbookOperation>)mongoCursor);
        file.initStoreLog();
        try {
            while (this.traceabilityIterator.hasNext()) {
                LogbookOperation logbookOperation = (LogbookOperation)this.traceabilityIterator.next();
                JsonNode logbookOperationJsonNode = JsonHandler.toJsonNode((Object)logbookOperation);
                byte[] logbookOperationJsonBytes = CanonicalJsonFormatter.serializeToByteArray((JsonNode)logbookOperationJsonNode);
                file.storeLog(logbookOperationJsonBytes);
                algo.addLeaf(logbookOperationJsonBytes);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new TraceabilityException("Could not convert document to json", (Throwable)e);
        }
        file.closeStoreLog();
    }

    public String getPreviousStartDate() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousStartDate;
    }

    public byte[] getPreviousTimestampToken() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousTimestampToken;
    }

    public String getPreviousMonthStartDate() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastMonthEventInit.booleanValue()) {
            this.extractMonthPreviousEvent();
        }
        return this.previousMonthStartDate;
    }

    public byte[] getPreviousMonthTimestampToken() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastMonthEventInit.booleanValue()) {
            this.extractMonthPreviousEvent();
        }
        return this.previousMonthTimestampToken;
    }

    public String getPreviousYearStartDate() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastYearEventInit.booleanValue()) {
            this.extractYearPreviousEvent();
        }
        return this.previousYearStartDate;
    }

    public byte[] getPreviousYearTimestampToken() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastYearEventInit.booleanValue()) {
            this.extractYearPreviousEvent();
        }
        return this.previousYearTimestampToken;
    }

    public void startTraceability() throws TraceabilityException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.operationID, (String)STP_OP_SECURISATION, (GUID)this.operationID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)StatusCode.STARTED, null, null, (GUID)this.operationID);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookParameters);
        try {
            this.logbookOperations.create(this.operationID.getId(), new LogbookOperationParameters[]{logbookParameters});
        }
        catch (LogbookAlreadyExistsException | LogbookDatabaseException e) {
            throw new TraceabilityException("unable to create traceability logbook", e);
        }
    }

    public void createLogbookOperationEvent(Integer tenantId, String eventType, StatusCode status, TraceabilityEvent event) throws TraceabilityException {
        GUID eventId = GUIDFactory.newEventGUID((int)tenantId);
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventId, (String)eventType, (GUID)this.operationID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)status, null, null, (GUID)this.operationID);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookOperationParameters);
        if (event != null) {
            String eventData = JsonHandler.unprettyPrint((Object)event);
            logbookOperationParameters.putParameterValue(LogbookParameterName.eventDetailData, eventData);
            ObjectNode masterData = JsonHandler.createObjectNode();
            masterData.put("eventDetailData", eventData);
            logbookOperationParameters.putParameterValue(LogbookParameterName.masterData, JsonHandler.unprettyPrint((Object)masterData));
        }
        try {
            this.logbookOperations.update(this.operationID.getId(), new LogbookOperationParameters[]{logbookOperationParameters});
        }
        catch (LogbookDatabaseException | LogbookNotFoundException e) {
            throw new TraceabilityException("unable to update traceability logbook", e);
        }
    }

    public void saveEmpty(Integer tenantId) throws TraceabilityException {
        this.createLogbookOperationEvent(tenantId, STP_OP_SECURISATION, StatusCode.WARNING, null);
    }

    public void storeAndDeleteZip(Integer tenant, String strategyId, File zipFile, String fileName, TraceabilityEvent event) throws TraceabilityException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(zipFile));
             WorkspaceClient workspaceClient = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM).getClient();){
            String containerName = VitamThreadUtils.getVitamSession().getRequestId();
            workspaceClient.createContainer(containerName);
            workspaceClient.putObject(containerName, fileName, (InputStream)inputStream);
            StorageClientFactory storageClientFactory = StorageClientFactory.getInstance();
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(containerName);
            description.setWorkspaceObjectURI(fileName);
            try (StorageClient storageClient = storageClientFactory.getClient();){
                storageClient.storeFileFromWorkspace(strategyId, DataCategory.LOGBOOK, fileName, description);
                workspaceClient.deleteContainer(containerName, true);
                this.createLogbookOperationEvent(tenant, OP_SECURISATION_STORAGE, StatusCode.OK, event);
            }
            catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException | ContentAddressableStorageNotFoundException e) {
                this.createLogbookOperationEvent(tenant, OP_SECURISATION_STORAGE, StatusCode.FATAL, event);
                LOGGER.error("unable to store zip file", e);
                throw new TraceabilityException(e);
            }
        }
        catch (ContentAddressableStorageServerException | IOException e) {
            LOGGER.error("Unable to store traceability file", e);
            this.createLogbookOperationEvent(tenant, OP_SECURISATION_STORAGE, StatusCode.FATAL, event);
            throw new TraceabilityException(e);
        }
        finally {
            if (!zipFile.delete()) {
                LOGGER.error("Unable to delete zipFile");
            }
        }
    }

    public String getStepName() {
        return STP_OP_SECURISATION;
    }

    public String getTimestampStepName() {
        return TIMESTAMP;
    }

    public String getZipName() {
        return "LogbookOperation_" + this.operationID.getId();
    }

    public TraceabilityType getTraceabilityType() {
        return TraceabilityType.OPERATION;
    }

    public boolean getMaxEntriesReached() {
        return false;
    }

    public TraceabilityStatistics getTraceabilityStatistics() {
        return null;
    }

    public long getDataSize() throws TraceabilityException {
        if (this.traceabilityIterator != null) {
            return this.traceabilityIterator.getNumberOfLines();
        }
        throw new TraceabilityException("Iterator is not yet initialized");
    }

    public String getTraceabilityStartDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityStartDate);
    }

    public String getTraceabilityEndDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityEndDate);
    }

    private void extractPreviousEvent() throws InvalidParseOperationException {
        TraceabilityEvent lastTraceabilityEvent;
        this.previousTimestampToken = this.extractTimestampToken(this.lastTraceabilityOperation);
        if (this.lastTraceabilityOperation != null && (lastTraceabilityEvent = this.extractEventDetData(this.lastTraceabilityOperation)) != null) {
            this.previousStartDate = lastTraceabilityEvent.getStartDate();
        }
        this.isLastEventInit = true;
    }

    private void extractMonthPreviousEvent() throws InvalidParseOperationException, TraceabilityException {
        try {
            TraceabilityEvent oneMonthBeforeTraceabilityEvent;
            this.previousMonthTimestampToken = this.findHashByTraceabilityEventExpect(this.expectedLogbookId, this.traceabilityEndDate.minusMonths(1L));
            LogbookOperation oneMounthBeforeTraceabilityOperation = this.logbookOperations.findFirstTraceabilityOperationOKAfterDate(this.traceabilityEndDate.minusMonths(1L));
            if (oneMounthBeforeTraceabilityOperation != null && (oneMonthBeforeTraceabilityEvent = this.extractEventDetData(oneMounthBeforeTraceabilityOperation)) != null) {
                this.previousMonthStartDate = oneMonthBeforeTraceabilityEvent.getStartDate();
            }
        }
        catch (InvalidCreateOperationException | LogbookDatabaseException | LogbookNotFoundException e) {
            throw new TraceabilityException(e);
        }
        this.isLastMonthEventInit = true;
    }

    private void extractYearPreviousEvent() throws InvalidParseOperationException, TraceabilityException {
        try {
            TraceabilityEvent oneMonthBeforeTraceabilityEvent;
            this.previousYearTimestampToken = this.findHashByTraceabilityEventExpect(this.expectedLogbookId, this.traceabilityEndDate.minusYears(1L));
            LogbookOperation oneMounthBeforeTraceabilityOperation = this.logbookOperations.findFirstTraceabilityOperationOKAfterDate(this.traceabilityEndDate.minusYears(1L));
            if (oneMounthBeforeTraceabilityOperation != null && (oneMonthBeforeTraceabilityEvent = this.extractEventDetData(oneMounthBeforeTraceabilityOperation)) != null) {
                this.previousYearStartDate = oneMonthBeforeTraceabilityEvent.getStartDate();
            }
        }
        catch (InvalidCreateOperationException | LogbookDatabaseException | LogbookNotFoundException e) {
            throw new TraceabilityException(e);
        }
        this.isLastYearEventInit = true;
    }

    private byte[] findHashByTraceabilityEventExpect(List<String> expectIds, LocalDateTime date) throws InvalidCreateOperationException, LogbookNotFoundException, LogbookDatabaseException, InvalidParseOperationException {
        LogbookOperation logbookOperation = this.logbookOperations.findFirstTraceabilityOperationOKAfterDate(date);
        if (logbookOperation == null || expectIds.contains(logbookOperation.getString((Object)EVENT_ID))) {
            return null;
        }
        expectIds.add(logbookOperation.getString((Object)EVENT_ID));
        return this.extractTimestampToken(logbookOperation);
    }

    byte[] extractTimestampToken(LogbookOperation logbookOperation) throws InvalidParseOperationException {
        TraceabilityEvent traceabilityEvent = this.extractEventDetData(logbookOperation);
        if (traceabilityEvent == null) {
            return null;
        }
        return traceabilityEvent.getTimeStampToken();
    }

    private TraceabilityEvent extractEventDetData(LogbookOperation logbookOperation) throws InvalidParseOperationException {
        if (logbookOperation == null) {
            return null;
        }
        String evDetData = (String)logbookOperation.get((Object)EVENT_DETAIL_DATA);
        return (TraceabilityEvent)JsonHandler.getFromString((String)evDetData, TraceabilityEvent.class);
    }
}

