/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.administration.core.LogbookOperationTraceabilityHelper;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TenantLogbookOperationTraceabilityResult;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.common.traceability.TraceabilityService;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class LogbookAdministration {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookAdministration.class);
    private final LogbookOperations logbookOperations;
    private final TimestampGenerator timestampGenerator;
    private final AlertService alertService = new AlertServiceImpl();
    private final File tmpFolder;
    private final int operationTraceabilityTemporizationDelayInSeconds;
    private final int operationTraceabilityMaxRenewalDelayInSeconds;
    private final int operationTraceabilityThreadPoolSize;

    @VisibleForTesting
    LogbookAdministration(LogbookOperations logbookOperations, TimestampGenerator timestampGenerator, File tmpFolder, Integer operationTraceabilityTemporizationDelayInSeconds, Integer operationTraceabilityMaxRenewalDelay, ChronoUnit operationTraceabilityMaxRenewalDelayUnit, int operationTraceabilityThreadPoolSize) {
        this.operationTraceabilityThreadPoolSize = operationTraceabilityThreadPoolSize;
        ParametersChecker.checkParameter((String)"Missing max renewal delay or unit", (Object[])new Object[]{operationTraceabilityMaxRenewalDelay, operationTraceabilityMaxRenewalDelayUnit});
        ParametersChecker.checkValue((String)"Invalid max renewal delay", (long)operationTraceabilityMaxRenewalDelay.intValue(), (long)1L);
        this.logbookOperations = logbookOperations;
        this.timestampGenerator = timestampGenerator;
        this.tmpFolder = tmpFolder;
        this.operationTraceabilityTemporizationDelayInSeconds = LogbookAdministration.validateAndGetTraceabilityTemporizationDelay(operationTraceabilityTemporizationDelayInSeconds);
        this.operationTraceabilityMaxRenewalDelayInSeconds = (int)Duration.of(operationTraceabilityMaxRenewalDelay.intValue(), operationTraceabilityMaxRenewalDelayUnit).toSeconds();
    }

    private static int validateAndGetTraceabilityTemporizationDelay(Integer operationTraceabilityTemporizationDelay) {
        if (operationTraceabilityTemporizationDelay == null) {
            return 0;
        }
        if (operationTraceabilityTemporizationDelay < 0) {
            throw new IllegalArgumentException("Operation traceability temporization delay cannot be negative");
        }
        return operationTraceabilityTemporizationDelay;
    }

    public LogbookAdministration(LogbookOperations logbookOperations, TimestampGenerator timestampGenerator, Integer operationTraceabilityOverlapDelayInSeconds, Integer operationTraceabilityMaxRenewalDelay, ChronoUnit operationTraceabilityMaxRenewalDelayUnit, int operationTraceabilityThreadPoolSize) {
        this(logbookOperations, timestampGenerator, PropertiesUtils.fileFromTmpFolder((String)"secure"), operationTraceabilityOverlapDelayInSeconds, operationTraceabilityMaxRenewalDelay, operationTraceabilityMaxRenewalDelayUnit, operationTraceabilityThreadPoolSize);
    }

    public String generateSecureLogbook(int tenantId) throws TraceabilityException {
        GUID guid = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        VitamThreadUtils.getVitamSession().setRequestId(guid);
        LOGGER.info("Starting traceability operation for tenant " + tenantId);
        LogbookOperationTraceabilityHelper helper = new LogbookOperationTraceabilityHelper(this.logbookOperations, guid, this.operationTraceabilityTemporizationDelayInSeconds, this.operationTraceabilityMaxRenewalDelayInSeconds);
        helper.initialize();
        if (!helper.isTraceabilityOperationRequired()) {
            LOGGER.info("No need for traceability operation. No recent activity to secure...");
            return null;
        }
        TraceabilityService generator = new TraceabilityService(this.timestampGenerator, (LogbookTraceabilityHelper)helper, Integer.valueOf(tenantId), this.tmpFolder);
        generator.secureData(VitamConfiguration.getDefaultStrategy());
        LOGGER.info("Traceability operation succeeded for tenant " + tenantId);
        return guid.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<TenantLogbookOperationTraceabilityResult> generateSecureLogbooks(List<Integer> tenants) throws TraceabilityException {
        int threadPoolSize = Math.min(this.operationTraceabilityThreadPoolSize, tenants.size());
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
        try {
            ArrayList<CompletableFuture<TenantLogbookOperationTraceabilityResult>> completableFutures = new ArrayList<CompletableFuture<TenantLogbookOperationTraceabilityResult>>();
            for (Integer tenantId : tenants) {
                CompletableFuture<TenantLogbookOperationTraceabilityResult> traceabilityCompletableFuture = CompletableFuture.supplyAsync(() -> {
                    Thread.currentThread().setName("OperationTraceability-" + tenantId);
                    VitamThreadUtils.getVitamSession().setTenantId(tenantId);
                    try {
                        String operationId = this.generateSecureLogbook(tenantId);
                        return new TenantLogbookOperationTraceabilityResult().setTenantId(tenantId).setOperationId(operationId);
                    }
                    catch (Exception e) {
                        this.alertService.createAlert(VitamLogLevel.ERROR, "An error occurred during logbook operation traceability for tenant " + tenantId);
                        throw new RuntimeException("An error occurred during logbook operation traceability for tenant " + tenantId, e);
                    }
                }, executorService);
                completableFutures.add(traceabilityCompletableFuture);
            }
            boolean allTenantsSucceeded = true;
            ArrayList<TenantLogbookOperationTraceabilityResult> results = new ArrayList<TenantLogbookOperationTraceabilityResult>();
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    results.add((TenantLogbookOperationTraceabilityResult)completableFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TraceabilityException("Traceability interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOGGER.error("Traceability operation failed", (Throwable)e);
                    allTenantsSucceeded = false;
                }
            }
            if (!allTenantsSucceeded) {
                throw new TraceabilityException("One or more traceability operations failed");
            }
            ArrayList<TenantLogbookOperationTraceabilityResult> arrayList = results;
            return arrayList;
        }
        finally {
            executorService.shutdown();
        }
    }
}

