/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.core.api.WorkerAction;

public abstract class ActionHandler
implements WorkerAction,
VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);

    public void checkMandatoryParameters(WorkerParameters parameters) {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
    }

    public void close() {
    }

    public void updateDetailItemStatus(ItemStatus globalCompositeItemStatus, String value, String globalOutcomeDetailSubCode) {
        try {
            if (value != null) {
                ObjectNode evDetData = (ObjectNode)JsonHandler.getFromString((String)globalCompositeItemStatus.getEvDetailData());
                Object oldValue = "";
                if (evDetData.has("evDetTechData")) {
                    oldValue = evDetData.get("evDetTechData").textValue() + " \n";
                }
                evDetData.put("evDetTechData", (String)oldValue + value);
                globalCompositeItemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)evDetData));
                globalCompositeItemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)JsonHandler.unprettyPrint((Object)evDetData));
            }
            if (null != globalOutcomeDetailSubCode) {
                globalCompositeItemStatus.setGlobalOutcomeDetailSubcode(globalOutcomeDetailSubCode);
            }
        }
        catch (InvalidParseOperationException e1) {
            LOGGER.error("Unexpected exception : evDetData invalid", (Throwable)e1);
            globalCompositeItemStatus.increment(StatusCode.FATAL);
        }
    }
}

