/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.internal.upload.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalException;
import fr.gouv.vitam.ingest.internal.upload.rest.IngestInternalConfiguration;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.exception.ZipFilesNameNotAllowedException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.Queue;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/ingest/v1")
@ApplicationPath(value="webresources")
@Tag(name="Ingest")
public class IngestInternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestInternalResource.class);
    private static final String JSON = ".json";
    private static final String JSONL = ".jsonl";
    private static final String INGEST = "ingest";
    private static final String FOLDER_SIP = "SIP";
    private static final String INGEST_INT_UPLOAD = "STP_UPLOAD_SIP";
    private static final String INGEST_WORKFLOW = "PROCESS_SIP_UNITARY";
    private static final String XML = ".xml";
    private static final String DISTRIBUTIONREPORT_SUFFIX = "_report_error.json";
    private static final String CSV = ".csv";
    public static final String INGEST_INTERNAL_MODULE = "INGEST_INTERNAL_MODULE";
    public static final String UPLOAD_SIP = "UPLOAD_SIP";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public IngestInternalResource(IngestInternalConfiguration configuration) {
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
        WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkspaceType)WorkspaceType.VITAM);
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getProcessingUrl());
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
    }

    @VisibleForTesting
    IngestInternalResource(WorkspaceClientFactory workspaceClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    @POST
    @Path(value="/logbooks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response delegateCreateLogbookOperation(Queue<LogbookOperationParameters> queue) {
        Response response;
        block10: {
            LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();
            try {
                VitamThreadUtils.getVitamSession().checkValidRequestId();
                ParametersChecker.checkParameter((String)"list is a Mandatory parameter", (Object[])new Object[]{queue});
                client.create(VitamThreadUtils.getVitamSession().getRequestId(), queue);
                response = Response.status((Response.Status)Response.Status.CREATED).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientBadRequestException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                catch (LogbookClientAlreadyExistsException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
                }
                catch (LogbookClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
            client.close();
        }
        return response;
    }

    @PUT
    @Path(value="/logbooks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response delegateUpdateLogbookOperation(Queue<LogbookOperationParameters> queue) {
        Response response;
        block10: {
            LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();
            try {
                VitamThreadUtils.getVitamSession().checkValidRequestId();
                ParametersChecker.checkParameter((String)"list is a Mandatory parameter", (Object[])new Object[]{queue});
                client.update(VitamThreadUtils.getVitamSession().getRequestId(), queue);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientBadRequestException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
                }
                catch (LogbookClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
            client.close();
        }
        return response;
    }

    @PUT
    @Path(value="/workspace/{id}/{objectName}")
    public Response updateWorkspaceContainer(@PathParam(value="id") String id, @PathParam(value="objectName") String objectName, InputStream objectStream) {
        Response response;
        block9: {
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                VitamThreadUtils.getVitamSession().checkValidRequestId();
                if (!client.isExistingContainer(id)) {
                    client.createContainer(id);
                }
                client.putObject(id, objectName, objectStream);
                response = Response.ok().build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/ingests")
    @Consumes(value={"application/octet-stream", "application/zip", "application/x-gzip", "application/gzip", "application/x-tar", "application/x-bzip2"})
    public Response uploadSipAsStream(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="X-Context-Id") String contextId, @HeaderParam(value="X_ACTION_INIT") String xActionInit, @HeaderParam(value="X_TYPE_PROCESS") LogbookTypeProcess logbookTypeProcess, InputStream uploadedInputStream) {
        ParametersChecker.checkParameter((String)"context Id Request must not be null", (String[])new String[]{contextId});
        return this.ingestAsync(contentType, uploadedInputStream, contextId, xActionInit, logbookTypeProcess);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/operations/{id}")
    @PUT
    @Produces(value={"application/json"})
    public Response updateWorkFlowStatus(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
            ParametersChecker.checkParameter((String)"Action Id Request must not be null", (Object[])new Object[]{headers.getRequestHeader("X-ACTION")});
            String xAction = (String)headers.getRequestHeader("X-ACTION").get(0);
            GUID containerGUID = GUIDReader.getGUID((String)VitamThreadUtils.getVitamSession().getRequestId());
            RequestResponse updateResponse = processingClient.updateOperationActionProcess(xAction, containerGUID.getId());
            if (!updateResponse.isOk()) {
                Response response2 = updateResponse.toResponse();
                return response2;
            }
            String globalExecutionState = updateResponse.getHeaderString("X-Global-Execution-State");
            if (globalExecutionState == null) {
                throw new IngestInternalException("Global Execution Status not found.");
            }
            String logbookTypeProcessHeader = updateResponse.getHeaderString("X-Context-Id");
            if (logbookTypeProcessHeader == null) {
                throw new IngestInternalException("Logbook Type Process not found.");
            }
            LogbookTypeProcess logbookTypeProcess = LogbookTypeProcess.valueOf((String)logbookTypeProcessHeader);
            ProcessState processState = ProcessState.valueOf((String)globalExecutionState);
            int stepExecutionStatus = updateResponse.getHttpCode();
            if (this.isCompletedProcess(processState)) {
                this.addFinalLogbookOperationEvent(containerGUID, logbookTypeProcess, this.fromStatusToStatusCode(stepExecutionStatus));
            }
            Response response = updateResponse.toResponse();
            return response;
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), INGEST_INTERNAL_MODULE)).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private InputStream getErrorStream(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        try {
            return JsonHandler.writeToInpustream((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(INGEST).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage));
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }

    @Path(value="/operations/{id}")
    @HEAD
    @Produces(value={"application/json"})
    public Response getWorkFlowExecutionStatus(@PathParam(value="id") String id) {
        Response response;
        block13: {
            ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{id});
                ItemStatus itemStatus = processManagementClient.getOperationProcessStatus(id);
                Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.ACCEPTED);
                if (ProcessState.COMPLETED.equals((Object)itemStatus.getGlobalState())) {
                    builder.status(Response.Status.OK);
                } else {
                    builder.status(Response.Status.ACCEPTED);
                }
                response = builder.header("X-Global-Execution-State", (Object)itemStatus.getGlobalState()).header("X-Global-Execution-Status", (Object)itemStatus.getGlobalStatus()).header("X-Context-Id", (Object)itemStatus.getLogbookTypeProcess()).build();
                if (processManagementClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (processManagementClient != null) {
                        try {
                            processManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (WorkflowNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (BadRequestException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (InternalServerException | VitamClientException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            processManagementClient.close();
        }
        return response;
    }

    @Path(value="/operations/{id}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOperationProcessExecutionDetails(@PathParam(value="id") String id) {
        Response response;
        block8: {
            ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();
            try {
                response = processManagementClient.getOperationProcessExecutionDetails(id).toResponse();
                if (processManagementClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (processManagementClient != null) {
                        try {
                            processManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
            }
            processManagementClient.close();
        }
        return response;
    }

    @Path(value="/operations/{id}")
    @DELETE
    @Produces(value={"application/json"})
    public Response cancelOperationProcessExecution(@PathParam(value="id") String id) {
        Response response;
        block8: {
            ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{id});
                RequestResponse response2 = processManagementClient.cancelOperationProcessExecution(id);
                response = response2.toResponse();
                if (processManagementClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (processManagementClient != null) {
                        try {
                            processManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
            }
            processManagementClient.close();
        }
        return response;
    }

    @GET
    @Path(value="/ingests/{objectId}/{type}")
    @Produces(value={"application/octet-stream"})
    public Response downloadObjectAsStream(@PathParam(value="objectId") String objectId, @PathParam(value="type") String type) {
        return this.downloadObjectAsync(objectId, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response downloadObjectAsync(String objectId, String type) {
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();){
            DataCategory documentType = DataCategory.getByCollectionName((String)type);
            switch (documentType) {
                case MANIFEST: 
                case REPORT: {
                    objectId = (String)objectId + XML;
                    break;
                }
                case DISTRIBUTIONREPORTS: {
                    objectId = (String)objectId + DISTRIBUTIONREPORT_SUFFIX;
                    break;
                }
                case BATCH_REPORT: {
                    objectId = (String)objectId + JSONL;
                    documentType = DataCategory.REPORT;
                    break;
                }
                case RULES: {
                    objectId = (String)objectId + JSON;
                    documentType = DataCategory.REPORT;
                    break;
                }
                case REFERENTIAL_RULES_CSV: {
                    objectId = (String)objectId + CSV;
                    documentType = DataCategory.RULES;
                    break;
                }
                case REFERENTIAL_AGENCIES_CSV: {
                    objectId = (String)objectId + CSV;
                    documentType = DataCategory.REPORT;
                    break;
                }
                default: {
                    Response response = Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
                    return response;
                }
            }
            Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), (String)objectId, documentType, AccessLogUtils.getNoLogAccessLog());
            VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            return vitamAsyncInputStreamResponse;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("IllegalArgumentException was thrown : ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (StorageNotFoundException e) {
            LOGGER.error("Storage error was thrown : ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(Response.Status.NOT_FOUND, e.getMessage())).build();
        }
        catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException e) {
            LOGGER.error("Storage error was thrown : ", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    /*
     * Exception decompiling
     */
    private Response ingestAsync(String contentType, InputStream uploadedInputStream, String contextId, String xActionInit, LogbookTypeProcess logbookTypeProcess) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StatusCode fromStatusToStatusCode(int status) {
        StatusCode statusCode = StatusCode.OK;
        if (Response.Status.OK.getStatusCode() != status) {
            statusCode = Response.Status.PARTIAL_CONTENT.getStatusCode() == status ? StatusCode.WARNING : (Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() == status ? StatusCode.FATAL : StatusCode.KO);
        }
        return statusCode;
    }

    private void prepareToStartProcess(InputStream uploadedInputStream, String archiveMimeType, GUID containerGUID) throws LogbookClientBadRequestException, IngestInternalException, ContentAddressableStorageException {
        LOGGER.debug("Starting up the save file sip");
        ItemStatus stpUploadItemStatus = new ItemStatus(UPLOAD_SIP);
        try {
            this.pushSipStreamToWorkspace(containerGUID.getId(), archiveMimeType, uploadedInputStream, stpUploadItemStatus);
            stpUploadItemStatus.increment(StatusCode.OK);
        }
        catch (ZipFilesNameNotAllowedException e) {
            stpUploadItemStatus.increment(StatusCode.KO);
            throw e;
        }
        catch (ContentAddressableStorageException e) {
            stpUploadItemStatus.increment(StatusCode.FATAL);
            throw e;
        }
        finally {
            try {
                this.workspaceClientFactory.getClient().putObject(containerGUID.getId(), "stpUploadResult.json", JsonHandler.writeToInpustream((Object)stpUploadItemStatus));
            }
            catch (InvalidParseOperationException e) {
                throw new IngestInternalException((Throwable)e);
            }
        }
    }

    private void addFinalLogbookOperationEvent(GUID containerGUID, LogbookTypeProcess logbookTypeProcess, StatusCode statusCode) throws LogbookClientNotFoundException, LogbookClientServerException, LogbookClientBadRequestException {
        LogbookOperationParameters parameters = this.logbookInitialisation(containerGUID, containerGUID, logbookTypeProcess);
        parameters.putParameterValue(LogbookParameterName.eventType, INGEST_WORKFLOW);
        this.callLogbookUpdate(parameters, statusCode, INGEST_WORKFLOW, VitamLogbookMessages.getCodeOp((String)INGEST_WORKFLOW, (StatusCode)statusCode));
    }

    private LogbookOperationParameters logbookInitialisation(GUID eventIdentifier, GUID containerGUID, LogbookTypeProcess logbookTypeProcess) {
        return LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((GUID)eventIdentifier), (String)INGEST_INT_UPLOAD, (GUID)containerGUID, (LogbookTypeProcess)logbookTypeProcess, (StatusCode)StatusCode.STARTED, (String)(eventIdentifier != null ? eventIdentifier.toString() : "outcomeDetailMessage"), (GUID)eventIdentifier);
    }

    private void callLogbookUpdate(LogbookOperationParameters parameters, StatusCode logbookOutcome, String outcomeDetail, String outcomeDetailMessage) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        if (parameters == null) {
            return;
        }
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            parameters.setStatus(logbookOutcome);
            parameters.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)outcomeDetail, (StatusCode)logbookOutcome));
            parameters.putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage);
            logbookOperationsClient.update(new LogbookOperationParameters[]{parameters});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSipStreamToWorkspace(String containerName, String archiveMimeType, InputStream uploadedInputStream, ItemStatus stpUploadItemStatus) throws ContentAddressableStorageException {
        block10: {
            LOGGER.debug("Try to push stream to workspace...");
            try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                if (workspaceClient.isExistingContainer(containerName)) {
                    workspaceClient.uncompressObject(containerName, FOLDER_SIP, archiveMimeType, uploadedInputStream);
                    stpUploadItemStatus.increment(StatusCode.OK);
                    break block10;
                }
                stpUploadItemStatus.setMessage(containerName + "doesn't exist");
                stpUploadItemStatus.increment(StatusCode.KO);
                throw new ContentAddressableStorageAlreadyExistException(containerName + "doesn't exist");
            }
            finally {
                StreamUtils.closeSilently((InputStream)uploadedInputStream);
            }
        }
        LOGGER.debug(" -> push stream to workspace finished");
    }

    private void cleanWorkspace(String containerName) throws ContentAddressableStorageServerException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (workspaceClient.isExistingContainer(containerName)) {
                workspaceClient.deleteContainer(containerName, true);
            }
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn((Throwable)e);
        }
    }

    private boolean isCompletedProcess(ProcessState processState) {
        return ProcessState.COMPLETED.equals((Object)processState);
    }

    @GET
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listOperationsDetails(@Context HttpHeaders headers, ProcessQuery query) {
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            Response response = processManagementClient.listOperationsDetails(query).toResponse();
            return response;
        }
    }

    @GET
    @Path(value="/workflows")
    @Produces(value={"application/json"})
    public Response getWorkflowDefinitions(@Context HttpHeaders headers) {
        ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
        try {
            return processingClient.getWorkflowDefinitions().toResponse();
        }
        catch (VitamClientException e) {
            return Response.serverError().entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    @Path(value="workflows/{workfowId}")
    @GET
    @Produces(value={"application/json"})
    public Response getWorkflowDetails(@PathParam(value="workfowId") String workfowId) {
        ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
        try {
            Optional optionalWorkflow = processingClient.getWorkflowDetails(workfowId);
            if (optionalWorkflow.isPresent()) {
                return Response.status((Response.Status)Response.Status.OK).header("X_TYPE_PROCESS", (Object)((WorkFlow)optionalWorkflow.get()).getTypeProc()).entity(optionalWorkflow.get()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("Error while retrieving workflow definitions : ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(ServiceName.INTERNAL_INGEST.getName()).setState(status.name()).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

