/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.internal.upload.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.ingest.internal.upload.rest.BusinessApplication;
import fr.gouv.vitam.ingest.internal.upload.rest.IngestInternalConfiguration;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.IOException;
import java.io.InputStream;

public class IngestInternalMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestInternalMain.class);
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.ingest-internal.port";
    private static final String CONF_FILE_NAME = "ingest-internal.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private VitamStarter vitamStarter;

    public IngestInternalMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(IngestInternalConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            IngestInternalMain main = new IngestInternalMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)args[0]);){
                IngestInternalConfiguration configuration = (IngestInternalConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, IngestInternalConfiguration.class));
                WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkspaceType)WorkspaceType.VITAM);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            serviceRegistry.register((VitamClientFactoryInterface)WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM)).register((VitamClientFactoryInterface)LogbookOperationsClientFactory.getInstance()).register((VitamClientFactoryInterface)StorageClientFactory.getInstance()).register((VitamClientFactoryInterface)ProcessingManagementClientFactory.getInstance());
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }

    public VitamStarter getVitamStarter() {
        return this.vitamStarter;
    }
}

