/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditMetadataFetcher;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditOperationFinder;
import fr.gouv.vitam.scheduler.server.job.auditobject.LastOperationExecution;
import java.util.Objects;
import java.util.Optional;

public class AuditWorkflowLauncher {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditWorkflowLauncher.class);
    private static final String DSL = "dsl";
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final AuditOperationFinder auditOperationFinder;
    private final AuditMetadataFetcher auditMetadataFetcher;

    public AuditWorkflowLauncher(AdminManagementClientFactory adminManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, MetaDataClientFactory metaDataClientFactory) {
        this.auditOperationFinder = new AuditOperationFinder(logbookOperationsClientFactory, processingManagementClientFactory);
        this.auditMetadataFetcher = new AuditMetadataFetcher(metaDataClientFactory);
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public Optional<String> launch(Integer tenantId, String operationId, int operationsDelayInMinutes, String auditAction) {
        LastOperationExecution auditOperation = this.auditOperationFinder.findLastAuditData(auditAction);
        this.ensureLastOperationCompleted(auditOperation);
        String lastAuditDate = auditOperation.getLastUpdateDate();
        String lastUpdateDate = this.auditMetadataFetcher.getLastUpdateDateFromLastUnitToAudit(operationsDelayInMinutes, lastAuditDate);
        if (Objects.isNull(lastUpdateDate)) {
            LOGGER.info("Skip audit for tenant {} : no new data to audit", (Object)tenantId);
            return Optional.empty();
        }
        this.doLaunchAuditWorkflow(lastAuditDate, lastUpdateDate, auditAction);
        return Optional.ofNullable(operationId);
    }

    private void doLaunchAuditWorkflow(String lastAuditDate, String lastUpdateDate, String auditAction) {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            AuditOptions options = this.buildQuery(lastAuditDate, lastUpdateDate, auditAction);
            adminManagementClient.launchAuditWorkflow(options, false);
        }
        catch (InvalidCreateOperationException | AdminManagementClientServerException e) {
            throw new VitamRuntimeException("Could not launch audit workflow due to: ", e);
        }
    }

    private void ensureLastOperationCompleted(LastOperationExecution auditOperation) {
        if (!auditOperation.isHasCompleted()) {
            String message = String.format("Could not run audit since another with id %s is being run or paused on tenantId %s", auditOperation.getLastOperationId(), auditOperation.getTenantId());
            throw new VitamRuntimeException(message);
        }
    }

    private AuditOptions buildQuery(String lastAuditDate, String lastUpdateDate, String auditAction) throws InvalidCreateOperationException {
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        BooleanQuery query = QueryHelper.and();
        if (Objects.nonNull(lastAuditDate)) {
            query.add(new Query[]{QueryHelper.gte((String)VitamFieldsHelper.approximateUpdateDate(), (String)lastAuditDate)});
        }
        query.add(new Query[]{QueryHelper.lte((String)VitamFieldsHelper.approximateUpdateDate(), (String)lastUpdateDate)});
        selectMultiQuery.addQueries(new Query[]{query});
        AuditOptions options = new AuditOptions();
        options.setAuditActions(auditAction);
        options.setQuery((JsonNode)selectMultiQuery.getFinalSelect());
        options.setAuditType(DSL);
        return options;
    }
}

