/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.scheduler.server.BusinessApplication;
import fr.gouv.vitam.scheduler.server.SchedulerAdminApplication;
import fr.gouv.vitam.scheduler.server.SchedulerConfiguration;
import fr.gouv.vitam.scheduler.server.SchedulerListener;
import java.util.List;
import org.quartz.SchedulerException;

public class SchedulerMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchedulerMain.class);
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.scheduler.port";
    private static final String CONF_FILE_NAME = "scheduler.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private final VitamStarter vitamStarter;

    public SchedulerMain(String configurationFile) throws SchedulerException {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        SchedulerListener schedulerListener = SchedulerListener.getInstance();
        this.vitamStarter = new VitamStarter(SchedulerConfiguration.class, configurationFile, BusinessApplication.class, SchedulerAdminApplication.class, List.of(schedulerListener), false);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
        }
        try {
            SchedulerMain schedulerMain = new SchedulerMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            schedulerMain.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

