/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.security.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.DeleteParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.SecurityProfile;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.context.ContextService;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SecurityProfileService
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecurityProfileService.class);
    private static final String SECURITY_PROFILE_IS_MANDATORY_PARAMETER = "The collection of security profiles is mandatory";
    private static final String SECURITY_PROFILE_NOT_FOUND = "Security profile not found";
    private static final String ERR_ID_NOT_ALLOWED_IN_CREATE = "Id must be null when creating security profiles (%s)";
    private static final String ERR_MISSING_SECURITY_PROFILE_IDENTIFIER = "Identifier must not be null when creating security profiles (%s)";
    private static final String ERR_DUPLICATE_IDENTIFIER_IN_CREATE = "One or many security profiles in the imported list have the same identifier : %s";
    private static final String ERR_MISSING_SECURITY_PROFILE_NAME = "Security profile name is mandatory (%s)";
    private static final String ERR_UNEXPECTED_PERMISSION_SET_WITH_FULL_ACCESS = "Permission set cannot be set with full access mode : %s";
    private static final String SECURITY_PROFILE_IMPORT_EVENT = "STP_IMPORT_SECURITY_PROFILE";
    private static final String SECURITY_PROFILE_UPDATE_EVENT = "STP_UPDATE_SECURITY_PROFILE";
    private static final String SECURITY_PROFILE_DELETE_EVENT = "STP_DELETE_SECURITY_PROFILE";
    private static final String SECURITY_PROFILE_BACKUP_EVENT = "STP_BACKUP_SECURITY_PROFILE";
    private static final String IMPORT_SECURITY_PROFILE_UNKNOW_PERMISSION_KEY = "STP_IMPORT_SECURITY_PROFILE.UNKNOWN_PERMISSION";
    private static final String UPDATE_SECURITY_PROFILE_UNKNOW_PERMISSION_KEY = "STP_UPDATE_SECURITY_PROFILE.UNKNOWN_PERMISSION";
    private static final String UNKNOW_PERMISSION_SECURITY_PROFILE_ERROR = "At least, one security pofile's permission is not valid";
    private static final String _ID = "_id";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;
    private ContextService contextService;

    public SecurityProfileService(MongoDbAccessAdminImpl dbConfiguration, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = dbConfiguration;
        this.vitamCounterService = vitamCounterService;
        this.functionalBackupService = functionalBackupService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
    }

    public RequestResponse<SecurityProfileModel> createSecurityProfiles(List<SecurityProfileModel> securityProfileList) throws VitamException {
        ParametersChecker.checkParameter((String)SECURITY_PROFILE_IS_MANDATORY_PARAMETER, (Object[])new Object[]{securityProfileList});
        if (securityProfileList.isEmpty()) {
            return new RequestResponseOK();
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        SecurityProfileLogbookManager manager = new SecurityProfileLogbookManager(this.logbookClient, eip);
        manager.logImportStarted();
        VitamError error = this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), "Global create security profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            this.validateSecurityProfilesToInsert(securityProfileList, (VitamError<SecurityProfileModel>)error);
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getMessage).collect(Collectors.joining(","));
                manager.logValidationError(errorsDetails, SECURITY_PROFILE_IMPORT_EVENT);
                return error;
            }
            boolean slaveMode = this.isSlaveMode();
            for (SecurityProfileModel securityProfile : securityProfileList) {
                securityProfile.setId(GUIDFactory.newContextGUID().getId());
                if (slaveMode) continue;
                String code = this.vitamCounterService.getNextSequenceAsString(ParameterHelper.getTenantParameter(), SequenceType.SECURITY_PROFILE_SEQUENCE);
                securityProfile.setIdentifier(code);
            }
            ArrayNode securityProfilesToPersist = JsonHandler.createArrayNode();
            for (SecurityProfileModel securityProfile : securityProfileList) {
                ObjectNode securityProfileNode = (ObjectNode)JsonHandler.toJsonNode((Object)securityProfile);
                JsonNode jsonNode = securityProfileNode.remove(VitamFieldsHelper.id());
                if (jsonNode != null) {
                    securityProfileNode.set(_ID, jsonNode);
                }
                securityProfilesToPersist.add((JsonNode)securityProfileNode);
            }
            this.mongoAccess.insertDocuments(securityProfilesToPersist, FunctionalAdminCollections.SECURITY_PROFILE).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, SECURITY_PROFILE_BACKUP_EVENT, FunctionalAdminCollections.SECURITY_PROFILE, eip.toString());
            manager.logImportSuccess();
            return new RequestResponseOK().addAllResults(securityProfileList).setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            String err = "Security profile import failed > " + exp.getMessage();
            manager.logFatalError(err, SECURITY_PROFILE_IMPORT_EVENT);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private void validateSecurityProfilesToInsert(List<SecurityProfileModel> securityProfileList, VitamError<SecurityProfileModel> error) {
        boolean slaveMode = this.isSlaveMode();
        HashSet<String> securityProfileIdentifiers = new HashSet<String>();
        for (SecurityProfileModel securityProfile : securityProfileList) {
            if (null != securityProfile.getId()) {
                error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), String.format(ERR_ID_NOT_ALLOWED_IN_CREATE, securityProfile.getName())));
                continue;
            }
            if (slaveMode) {
                if (StringUtils.isEmpty((String)securityProfile.getIdentifier())) {
                    error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), String.format(ERR_MISSING_SECURITY_PROFILE_IDENTIFIER, securityProfile.getName())));
                    continue;
                }
                if (securityProfileIdentifiers.contains(securityProfile.getIdentifier())) {
                    error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), String.format(ERR_DUPLICATE_IDENTIFIER_IN_CREATE, securityProfile.getIdentifier())));
                    continue;
                }
                securityProfileIdentifiers.add(securityProfile.getIdentifier());
            }
            if (StringUtils.isEmpty((String)securityProfile.getName())) {
                error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), String.format(ERR_MISSING_SECURITY_PROFILE_NAME, securityProfile.getName())));
                continue;
            }
            if (securityProfile.getFullAccess().booleanValue() && !CollectionUtils.isEmpty((Collection)securityProfile.getPermissions())) {
                error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), String.format(ERR_UNEXPECTED_PERMISSION_SET_WITH_FULL_ACCESS, securityProfile.getName())));
                continue;
            }
            if (securityProfile.getPermissions() == null || securityProfile.getPermissions().isEmpty()) continue;
            this.checkSecurityProfilePermissions(securityProfile.getPermissions(), error, IMPORT_SECURITY_PROFILE_UNKNOW_PERMISSION_KEY);
        }
    }

    private void checkSecurityProfilePermissions(Set<String> permissions, VitamError<SecurityProfileModel> error, String messageKey) {
        boolean isPermissionsUnvalid = permissions.stream().map(SecurityProfilePermissions::isPermissionValid).anyMatch(isPermissionValid -> isPermissionValid.equals(Boolean.FALSE));
        if (isPermissionsUnvalid) {
            error.addToErrors(this.getVitamErrorWithMessage(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), VitamLogbookMessages.getCodeOp((String)messageKey, (StatusCode)StatusCode.KO)));
        }
    }

    public Optional<SecurityProfileModel> findOneByIdentifier(String identifier) throws ReferentialException, InvalidParseOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        try (DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)parser.getRequest().getFinalSelect(), FunctionalAdminCollections.SECURITY_PROFILE);){
            List list = result.getDocuments(SecurityProfile.class, SecurityProfileModel.class);
            if (list.isEmpty()) {
                Optional<SecurityProfileModel> optional = Optional.empty();
                return optional;
            }
            Optional<SecurityProfileModel> optional = Optional.of((SecurityProfileModel)list.get(0));
            return optional;
        }
    }

    public RequestResponseOK<SecurityProfileModel> findSecurityProfiles(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.SECURITY_PROFILE);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, SecurityProfile.class, SecurityProfileModel.class);
            return requestResponseOK;
        }
    }

    public RequestResponse<SecurityProfileModel> updateSecurityProfile(String identifier, JsonNode queryDsl) throws VitamException {
        VitamError error = this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), "Update security profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        if (queryDsl == null || !queryDsl.isObject()) {
            return error;
        }
        Optional<SecurityProfileModel> securityProfileModelOps = this.findOneByIdentifier(identifier);
        if (securityProfileModelOps.isEmpty()) {
            error.setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            return error.addToErrors(this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), SECURITY_PROFILE_NOT_FOUND + identifier));
        }
        SecurityProfileModel securityProfileModel = securityProfileModelOps.get();
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        SecurityProfileLogbookManager manager = new SecurityProfileLogbookManager(this.logbookClient, eip);
        manager.logUpdateStarted(securityProfileModel.getId());
        try {
            Set<String> permissions = new HashSet<String>();
            ArrayNode permissionsNode = (ArrayNode)queryDsl.findValue("Permissions");
            if (null != permissionsNode && !permissionsNode.isEmpty()) {
                permissions = (Set)JsonHandler.getFromJsonNode((JsonNode)permissionsNode, Set.class, String.class);
            }
            this.checkSecurityProfilePermissions(permissions, (VitamError<SecurityProfileModel>)error, UPDATE_SECURITY_PROFILE_UNKNOW_PERMISSION_KEY);
            if (error.getErrors().size() > 0) {
                error.setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                String errorsDetails = error.getErrors().stream().map(VitamError::getMessage).collect(Collectors.joining(","));
                manager.logValidationError(errorsDetails, SECURITY_PROFILE_UPDATE_EVENT);
                return error;
            }
            JsonNode finalUpdate = this.enforceIdentifierInUpdateQuery(identifier, queryDsl);
            DbRequestResult result = this.mongoAccess.updateData(finalUpdate, FunctionalAdminCollections.SECURITY_PROFILE);
            Map updateDiffs = result.getDiffs();
            result.close();
            this.functionalBackupService.saveCollectionAndSequence(eip, SECURITY_PROFILE_BACKUP_EVENT, FunctionalAdminCollections.SECURITY_PROFILE, identifier);
            manager.logUpdateSuccess(securityProfileModel.getId(), (List)updateDiffs.get(securityProfileModel.getId()));
            return new RequestResponseOK();
        }
        catch (BadRequestException | SchemaValidationException e) {
            LOGGER.error(e);
            String err = "Security profile update failed > " + e.getMessage();
            manager.logValidationError(err, SECURITY_PROFILE_UPDATE_EVENT);
            error.setCode(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
            return error;
        }
        catch (InvalidCreateOperationException | VitamException e) {
            LOGGER.error(e);
            String err = "Security profile update failed > " + e.getMessage();
            manager.logFatalError(err, SECURITY_PROFILE_UPDATE_EVENT);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
    }

    private JsonNode enforceIdentifierInUpdateQuery(String identifier, JsonNode queryDsl) throws InvalidParseOperationException, InvalidCreateOperationException {
        UpdateParserSingle parser = new UpdateParserSingle(FunctionalAdminCollections.SECURITY_PROFILE.getVarNameAdapater());
        parser.parse(queryDsl);
        parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        return parser.getRequest().getFinalUpdate();
    }

    public RequestResponse<SecurityProfileModel> deleteSecurityProfile(String securityProfileId) throws VitamException {
        VitamError error = this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), "Delete security profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        SecurityProfileLogbookManager manager = new SecurityProfileLogbookManager(this.logbookClient, eip);
        manager.logDeleteStarted(securityProfileId);
        try {
            JsonNode finalDelete = this.enforceIdentifierInDeleteQuery(securityProfileId);
            if (!this.exist(finalDelete)) {
                manager.logValidationError("Security profile not found : " + securityProfileId, SECURITY_PROFILE_DELETE_EVENT);
                return this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), "Delete context error : " + securityProfileId).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            }
            boolean isSecurityProfileUsed = this.contextService.securityProfileIsUsedInContexts(securityProfileId);
            if (isSecurityProfileUsed) {
                manager.logValidationError("Security profile is used : " + securityProfileId, SECURITY_PROFILE_DELETE_EVENT);
                return this.getVitamError(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem(), "Delete context error : " + securityProfileId).setHttpCode(Response.Status.FORBIDDEN.getStatusCode());
            }
            DbRequestResult result = this.mongoAccess.deleteDocument(finalDelete, FunctionalAdminCollections.SECURITY_PROFILE);
            RequestResponseOK response = new RequestResponseOK();
            response.addAllResults(result.getDocuments(SecurityProfile.class, SecurityProfileModel.class)).setTotal(result.getTotal()).setHttpCode(Response.Status.NO_CONTENT.getStatusCode());
            result.close();
            this.functionalBackupService.saveCollectionAndSequence(eip, SECURITY_PROFILE_BACKUP_EVENT, FunctionalAdminCollections.SECURITY_PROFILE, eip.toString());
            manager.logDeleteSuccess(securityProfileId);
            return response;
        }
        catch (BadRequestException | SchemaValidationException e) {
            LOGGER.error(e);
            String err = "Security profile delete failed > " + e.getMessage();
            manager.logValidationError(err, SECURITY_PROFILE_DELETE_EVENT);
            error.setCode(VitamCode.SECURITY_PROFILE_VALIDATION_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
            return error;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            String err = "Security profile delete failed > " + e.getMessage();
            manager.logFatalError(err, SECURITY_PROFILE_DELETE_EVENT);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
    }

    private JsonNode enforceIdentifierInDeleteQuery(String identifier) throws InvalidParseOperationException, InvalidCreateOperationException {
        DeleteParserSingle parser = new DeleteParserSingle(FunctionalAdminCollections.SECURITY_PROFILE.getVarNameAdapater());
        parser.parse((JsonNode)new Delete().getFinalDelete());
        parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        return parser.getRequest().getFinalDelete();
    }

    private boolean exist(JsonNode finalSelect) throws InvalidParseOperationException, ReferentialException {
        DbRequestResult result = this.mongoAccess.findDocuments(finalSelect, FunctionalAdminCollections.SECURITY_PROFILE);
        List list = result.getDocuments(SecurityProfile.class, SecurityProfileModel.class);
        return !list.isEmpty();
    }

    public void close() {
        this.logbookClient.close();
    }

    private boolean isSlaveMode() {
        return this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.SECURITY_PROFILE_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
    }

    private VitamError<SecurityProfileModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)"SecurityProfile", (StatusCode)StatusCode.KO, SecurityProfileModel.class);
    }

    private VitamError<SecurityProfileModel> getVitamErrorWithMessage(String vitamCode, String msg) {
        return VitamErrorUtils.getVitamErrorWithMessage((String)vitamCode, (String)UNKNOW_PERMISSION_SECURITY_PROFILE_ERROR, (String)"SecurityProfile", (StatusCode)StatusCode.KO, (String)msg, SecurityProfileModel.class);
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    private static final class SecurityProfileLogbookManager {
        private static final String UPDATED_DIFFS = "updatedDiffs";
        private static final String SECURITY_PROFILE = "SecurityProfile";
        private final GUID eip;
        private final LogbookOperationsClient logbookClient;

        public SecurityProfileLogbookManager(LogbookOperationsClient logbookClient, GUID eip) {
            this.logbookClient = logbookClient;
            this.eip = eip;
        }

        private void logImportStarted() throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)SecurityProfileService.SECURITY_PROFILE_IMPORT_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_IMPORT_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logValidationError(String errorsDetails, String eventType) throws VitamException {
            LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
            GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.KO), (GUID)this.eip);
            this.logbookMessageError(errorsDetails, logbookParameters);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logFatalError(String errorsDetails, String eventCode) throws VitamException {
            LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
            GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventCode, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventCode, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
            this.logbookMessageError(errorsDetails, logbookParameters);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters) {
            if (null != errorsDetails && !errorsDetails.isEmpty()) {
                try {
                    ObjectNode object = JsonHandler.createObjectNode();
                    object.put("errors", errorsDetails);
                    String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                    logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
                }
                catch (InvalidParseOperationException invalidParseOperationException) {
                    // empty catch block
                }
            }
        }

        private void logImportSuccess() throws VitamException {
            GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)SecurityProfileService.SECURITY_PROFILE_IMPORT_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_IMPORT_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logUpdateStarted(String id) throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)SecurityProfileService.SECURITY_PROFILE_UPDATE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_UPDATE_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_SECURITY_PROFILE." + StatusCode.STARTED);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logUpdateSuccess(String id, List<String> listDiffs) throws VitamException {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            String diffs = listDiffs.stream().reduce("", String::concat);
            ObjectNode msg = JsonHandler.createObjectNode();
            msg.put(UPDATED_DIFFS, diffs);
            evDetData.set(SECURITY_PROFILE, (JsonNode)msg);
            GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)SecurityProfileService.SECURITY_PROFILE_UPDATE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_UPDATE_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_SECURITY_PROFILE." + StatusCode.OK);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logDeleteStarted(String id) throws VitamException {
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)SecurityProfileService.SECURITY_PROFILE_DELETE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_DELETE_EVENT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_DELETE_SECURITY_PROFILE." + StatusCode.STARTED);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
        }

        private void logDeleteSuccess(String id) throws VitamException {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
            LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)SecurityProfileService.SECURITY_PROFILE_DELETE_EVENT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)SecurityProfileService.SECURITY_PROFILE_DELETE_EVENT, (StatusCode)StatusCode.OK), (GUID)this.eip);
            if (null != id && !id.isEmpty()) {
                logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
            }
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, "STP_DELETE_SECURITY_PROFILE." + StatusCode.OK);
            this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }
}

