/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.TypeDetail;
import fr.gouv.vitam.common.model.administration.schema.SchemaCategory;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaOrigin;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaStringSizeType;
import fr.gouv.vitam.common.model.administration.schema.SchemaType;
import fr.gouv.vitam.common.model.administration.schema.SchemaTypeDetail;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.schema.SchemaImportValidationException;
import fr.gouv.vitam.functional.administration.common.schema.ErrorReportSchema;
import fr.gouv.vitam.functional.administration.common.schema.Schema;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import fr.gouv.vitam.functional.administration.core.schema.SchemaCommonService;
import fr.gouv.vitam.functional.administration.core.schema.SchemaImportReport;
import fr.gouv.vitam.functional.administration.core.schema.SchemaValidationService;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;

public class SchemaService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchemaService.class);
    private static final String COLLECTION_UNIT = "Unit";
    private static final String COLLECTION_OBJECTGROUP = "ObjectGroup";
    private static final String SCHEMA_JSON_IS_MANDATORY_PARAMETER = "The json input of external schema type is mandatory";
    public static final String SCHEMA_IMPORT_EVENT = "IMPORT_EXTERNAL_SCHEMA";
    private static final String SCHEMA_REPORT = "SCHEMA_REPORT";
    static final String BACKUP_SCHEMA_EVENT = "BACKUP_SCHEMA";
    public static final String DELETE_SCHEMA_EVENT = "DELETE_EXTERNAL_SCHEMA";
    public static final String VITAM_UNIT_INTERNAL_SCHEMA_JSON = "vitam-unit-internal-schema.json";
    public static final String VITAM_OBJECT_GROUP_INTERNAL_SCHEMA_JSON = "vitam-object-group-internal-schema.json";
    private final MongoDbAccessAdminImpl mongoDbAccessReferential;
    private final FunctionalBackupService functionalBackupService;
    private final OntologyService ontologyService;
    private final SchemaValidationService schemaValidationService;

    public SchemaService(MongoDbAccessAdminImpl mongoDbAccessReferential, FunctionalBackupService functionalBackupService, OntologyService ontologyService) {
        this(mongoDbAccessReferential, functionalBackupService, ontologyService, LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    public SchemaService(MongoDbAccessAdminImpl mongoDbAccessReferential, FunctionalBackupService functionalBackupService, OntologyService ontologyService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.ontologyService = ontologyService;
        this.mongoDbAccessReferential = mongoDbAccessReferential;
        this.functionalBackupService = functionalBackupService;
        this.schemaValidationService = new SchemaValidationService((MongoDbAccessReferential)mongoDbAccessReferential, logbookOperationsClientFactory);
    }

    private List<SchemaResponse> findUnitExternalSchema(TenantScope tenantScope) throws InvalidParseOperationException, ReferentialException, InvalidCreateOperationException {
        LOGGER.info("retrieving unit external schema ");
        return this.decorateSchema(this.mapSchemaDbEntityToModel(this.loadCurrentExternalSchema(tenantScope)), COLLECTION_UNIT);
    }

    public List<SchemaResponse> findUnitInternalSchema() throws InvalidParseOperationException, IOException, ReferentialException {
        LOGGER.info("retrieving internal unit schema ");
        return this.loadUnitInternalSchema();
    }

    public List<SchemaResponse> findUnitSchema() throws InvalidParseOperationException, IOException, ReferentialException, InvalidCreateOperationException {
        LOGGER.info("retrieving internal and external unit schema ");
        return Stream.concat(this.loadUnitInternalSchema().stream(), this.findUnitExternalSchema(TenantScope.INCLUDE_ADMIN_TENANT).stream()).collect(Collectors.toList());
    }

    public List<SchemaResponse> findObjectGroupInternalSchema() throws InvalidParseOperationException, IOException, ReferentialException {
        LOGGER.info("retrieving ObjectGroup schema ");
        InputStream isObjectGroupInternalSchema = this.loadObjectGroupInternalSchema();
        List objectGroupSchemaModels = (List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)isObjectGroupInternalSchema, (TypeReference)new TypeReference<List<SchemaResponse>>(){});
        return this.decorateSchema(objectGroupSchemaModels, COLLECTION_OBJECTGROUP);
    }

    public RequestResponse<SchemaModel> importExternalSchemaElements(List<SchemaInputModel> externalSchemaList) throws VitamException {
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID importExternalSchemaOpId = GUIDReader.getGUID((String)operationId);
        SchemaImportReport schemaImportReport = SchemaCommonService.initSchemaImportReport(importExternalSchemaOpId);
        HashMap<String, List<ErrorReportSchema>> importErrors = new HashMap<String, List<ErrorReportSchema>>();
        try {
            ParametersChecker.checkParameter((String)SCHEMA_JSON_IS_MANDATORY_PARAMETER, (Object[])new Object[]{externalSchemaList});
            this.schemaValidationService.startLogBook(importExternalSchemaOpId, SCHEMA_IMPORT_EVENT);
            List<OntologyModel> ontologiesElts = this.loadFullOntologiesElts();
            Map<String, OntologyModel> ontologyEltsMapByIdentifier = ontologiesElts.stream().collect(Collectors.toMap(OntologyModel::getIdentifier, ontologyElt -> ontologyElt));
            ArrayList<SchemaResponse> currentUnitSchemaList = new ArrayList<SchemaResponse>(this.loadUnitInternalSchema());
            currentUnitSchemaList.addAll(this.findUnitExternalSchema(TenantScope.INCLUDE_ADMIN_TENANT));
            this.schemaValidationService.validateExternalSchemaInputs(externalSchemaList, currentUnitSchemaList, ontologyEltsMapByIdentifier, importErrors);
            List<Schema> dbSchemaModelList = SchemaCommonService.mapSchemaFromInputParameters(externalSchemaList, ontologyEltsMapByIdentifier);
            this.persistImportedSchemaList(dbSchemaModelList);
            this.backupSchemaDatabaseToOffers(importExternalSchemaOpId);
            SchemaCommonService.fillSchemaImportReportOK(schemaImportReport, dbSchemaModelList, importExternalSchemaOpId);
            this.backupReport(schemaImportReport, importExternalSchemaOpId);
            this.schemaValidationService.logSuccessLogBook(importExternalSchemaOpId, SCHEMA_IMPORT_EVENT);
            return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (SchemaImportValidationException e) {
            LOGGER.error((Throwable)e);
            this.schemaValidationService.logValidationError(importExternalSchemaOpId, SCHEMA_IMPORT_EVENT, e.getMessage());
            if (importErrors != null) {
                SchemaCommonService.fillSchemaImportReportError(schemaImportReport, importErrors.keySet(), StatusCode.KO, importExternalSchemaOpId);
                this.backupReport(schemaImportReport, importExternalSchemaOpId);
            }
            return SchemaCommonService.getVitamError(VitamCode.SCHEMA_CHECK_ERROR.getItem(), "Error importing schema : " + e.getMessage(), StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            if (importErrors != null) {
                SchemaCommonService.fillSchemaImportReportError(schemaImportReport, importErrors.keySet(), StatusCode.FATAL, importExternalSchemaOpId);
                this.backupReport(schemaImportReport, importExternalSchemaOpId);
            }
            String errorDetails = e.getMessage();
            LOGGER.error("Validation errors on the input file {}", (Object)errorDetails);
            this.schemaValidationService.logError(importExternalSchemaOpId, SCHEMA_IMPORT_EVENT, null, errorDetails);
            return SchemaCommonService.getVitamError(VitamCode.SCHEMA_CHECK_ERROR.getItem(), "Error importing schema : " + errorDetails, StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    private List<SchemaResponse> mapSchemaDbEntityToModel(List<SchemaModel> currentExternalSchemaList) {
        return currentExternalSchemaList.stream().map(schemaElt -> {
            SchemaResponse schemaResponse = new SchemaResponse();
            schemaResponse.setPath(schemaElt.getPath());
            schemaResponse.setShortName(schemaElt.getShortName());
            schemaResponse.setCardinality(schemaElt.getCardinality());
            schemaResponse.setTenant(schemaElt.getTenant());
            schemaResponse.setCollection(schemaElt.getCollection());
            schemaResponse.setDescription(schemaElt.getDescription());
            schemaResponse.setCategory(SchemaCategory.OTHER);
            String pathLeaf = SchemaCommonService.extractLeafFromPath(schemaElt.getPath());
            schemaResponse.setFieldName(pathLeaf);
            schemaResponse.setOrigin(schemaElt.getOrigin());
            if (Boolean.TRUE.equals(schemaElt.getObject())) {
                schemaResponse.setType(SchemaType.OBJECT);
            }
            return schemaResponse;
        }).collect(Collectors.toList());
    }

    private List<SchemaModel> loadCurrentExternalSchema(TenantScope tenantScope) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException {
        HashSet<Integer> filteredTenants = new HashSet<Integer>();
        switch (tenantScope) {
            case INCLUDE_ADMIN_TENANT: {
                filteredTenants.add(VitamThreadUtils.getVitamSession().getTenantId());
                filteredTenants.add(VitamConfiguration.getAdminTenant());
                break;
            }
            case CURRENT_TENANT: {
                filteredTenants.add(VitamThreadUtils.getVitamSession().getTenantId());
                break;
            }
            case ALL_TENANTS: {
                filteredTenants.addAll(VitamConfiguration.getTenants());
            }
        }
        RequestResponseOK<SchemaModel> schemasResponse = this.findExternalSchemaByQueryDsl(SchemaCommonService.buildDslQueryForExtractingSchema(filteredTenants, Collections.emptyList()));
        return schemasResponse.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistImportedSchemaList(List<Schema> externalSchemaList) throws InvalidParseOperationException, ReferentialException, DocumentAlreadyExistsException, SchemaValidationException {
        try (DbRequestResult dbRequestResult = null;){
            if (externalSchemaList.isEmpty()) {
                return;
            }
            ArrayNode schemaListToPersist = JsonHandler.createArrayNode();
            for (Schema schemaModelToPersist : externalSchemaList) {
                ObjectNode schemaModelToPersistNode = (ObjectNode)JsonHandler.toJsonNode((Object)schemaModelToPersist);
                schemaListToPersist.add((JsonNode)schemaModelToPersistNode);
            }
            dbRequestResult = this.mongoDbAccessReferential.insertDocuments(schemaListToPersist, FunctionalAdminCollections.SCHEMA);
        }
    }

    private void backupSchemaDatabaseToOffers(GUID eip) throws VitamException {
        this.functionalBackupService.saveCollectionAndSequence(eip, BACKUP_SCHEMA_EVENT, FunctionalAdminCollections.SCHEMA, eip.toString());
    }

    private List<OntologyModel> loadFullOntologiesElts() throws ReferentialException, InvalidParseOperationException {
        RequestResponseOK<OntologyModel> ontologiesResponse = this.ontologyService.findOntologies((JsonNode)JsonHandler.createObjectNode());
        return ontologiesResponse.getResults();
    }

    private List<SchemaResponse> loadUnitInternalSchema() throws IOException, InvalidParseOperationException, ReferentialException {
        LOGGER.info("loading internal schema from file vitam-unit-internal-schema.json ");
        InputStream unitInternalSchemaInputStream = PropertiesUtils.getResourceAsStream((String)VITAM_UNIT_INTERNAL_SCHEMA_JSON);
        return this.decorateSchema((List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)unitInternalSchemaInputStream, (TypeReference)new TypeReference<List<SchemaResponse>>(){}), COLLECTION_UNIT);
    }

    private List<SchemaResponse> decorateSchema(List<SchemaResponse> schemaResponses, String collection) throws ReferentialException, InvalidParseOperationException {
        Select select = new Select();
        try {
            select.setQuery((Query)QueryHelper.in((String)"Collections", (String[])new String[]{collection}));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException("Unable to create select query", (Throwable)e);
        }
        Map<String, OntologyModel> mapOntologiesByIdentifier = this.ontologyService.findOntologies((JsonNode)select.getFinalSelect()).getResults().stream().collect(Collectors.toMap(OntologyModel::getIdentifier, ontologyModel -> ontologyModel));
        return schemaResponses.stream().peek(schemaResponse -> {
            if (!SchemaType.OBJECT.equals((Object)schemaResponse.getType())) {
                OntologyModel ontologyElt = (OntologyModel)mapOntologiesByIdentifier.get(schemaResponse.getFieldName());
                if (ontologyElt == null) {
                    String message = String.format("No ontology found for path %s", schemaResponse.getPath());
                    LOGGER.error(message);
                    throw new IllegalStateException(message);
                }
                TypeDetail typeDetail = ontologyElt.getTypeDetail();
                if (typeDetail == null) {
                    String message = String.format("Ontology %s has no TypeDetail", ontologyElt.getIdentifier());
                    LOGGER.error(message);
                    throw new IllegalStateException(message);
                }
                schemaResponse.setTypeDetail(SchemaTypeDetail.valueOf((String)typeDetail.getType()));
                Optional.ofNullable(ontologyElt.getStringSize()).ifPresent(stringSize -> schemaResponse.setStringSize(SchemaStringSizeType.valueOf((String)stringSize.getSize())));
                schemaResponse.setDescription(ontologyElt.getDescription());
                if (SchemaOrigin.EXTERNAL.equals((Object)schemaResponse.getOrigin()) && schemaResponse.getType() == null) {
                    schemaResponse.setType(SchemaType.valueOf((String)ontologyElt.getType().getType()));
                }
            }
        }).collect(Collectors.toList());
    }

    private InputStream loadObjectGroupInternalSchema() throws IOException {
        LOGGER.info("loading internal schema from file vitam-object-group-internal-schema.json ");
        return PropertiesUtils.getResourceAsStream((String)VITAM_OBJECT_GROUP_INTERNAL_SCHEMA_JSON);
    }

    private void backupReport(SchemaImportReport schemaImportReport, GUID eip) throws VitamException {
        try (InputStream reportInputStream = JsonHandler.writeToInpustream((Object)schemaImportReport);){
            String fileName = eip + ".json";
            this.functionalBackupService.saveFile(reportInputStream, eip, SCHEMA_REPORT, DataCategory.REPORT, fileName);
        }
        catch (VitamException | IOException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private RequestResponseOK<SchemaModel> findExternalSchemaByQueryDsl(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoDbAccessReferential.findDocumentsWithoutRestrictionOnCurrentTenant(queryDsl, FunctionalAdminCollections.SCHEMA);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, Schema.class, SchemaModel.class);
            return requestResponseOK;
        }
    }

    public void checkAndDeleteExternalSchemaElementsByPaths(List<String> pathsToDelete, boolean includeAllTenant) throws InvalidCreateOperationException, IOException, VitamException {
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID deleteExternalSchemaOpId = GUIDReader.getGUID((String)operationId);
        try {
            this.schemaValidationService.startLogBook(deleteExternalSchemaOpId, DELETE_SCHEMA_EVENT);
            List<String> internalPaths = this.getInternalPaths(pathsToDelete);
            if (!internalPaths.isEmpty()) {
                throw new BadRequestException("Some paths cannot be deleted because they are internal: " + internalPaths);
            }
            List<String> nonExistingPaths = this.getNonExistingPaths(pathsToDelete);
            if (!nonExistingPaths.isEmpty()) {
                throw new BadRequestException("Some paths cannot be deleted because they do not exist: " + nonExistingPaths);
            }
            List<SchemaModel> unitExternalSchemas = this.loadCurrentExternalSchema(includeAllTenant ? TenantScope.ALL_TENANTS : TenantScope.CURRENT_TENANT);
            List existingPaths = unitExternalSchemas.stream().map(SchemaModel::getPath).collect(Collectors.toList());
            List nonDeletablePaths = pathsToDelete.stream().filter(pathToDelete -> existingPaths.stream().anyMatch(existingPath -> existingPath.startsWith((String)pathToDelete) && !pathsToDelete.contains(existingPath))).collect(Collectors.toList());
            if (!nonDeletablePaths.isEmpty()) {
                throw new BadRequestException("Some paths cannot be deleted because they are referenced by other schemas:");
            }
            LOGGER.debug("All selected paths are deletable.");
            this.deleteExternalSchemaElementsByPaths(pathsToDelete);
            this.schemaValidationService.logSuccessLogBook(deleteExternalSchemaOpId, DELETE_SCHEMA_EVENT);
        }
        catch (Exception e) {
            String errorDetails = e.getMessage();
            LOGGER.error("Unable to perform delete: {}", (Object)errorDetails);
            this.schemaValidationService.logError(deleteExternalSchemaOpId, DELETE_SCHEMA_EVENT, null, errorDetails);
            throw e;
        }
    }

    private List<String> getInternalPaths(List<String> pathsToDelete) throws ReferentialException, IOException, InvalidParseOperationException {
        List<SchemaResponse> unitInternalSchema = this.loadUnitInternalSchema();
        List internalPaths = unitInternalSchema.stream().map(SchemaResponse::getPath).collect(Collectors.toList());
        List<String> internalPathsToDelete = pathsToDelete.stream().filter(internalPaths::contains).collect(Collectors.toList());
        return internalPathsToDelete;
    }

    private List<String> getNonExistingPaths(List<String> pathsToDelete) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException {
        List<SchemaModel> unitExternalSchemas = this.loadCurrentExternalSchema(TenantScope.CURRENT_TENANT);
        List existingPaths = unitExternalSchemas.stream().map(SchemaModel::getPath).collect(Collectors.toList());
        List<String> nonExistingPaths = pathsToDelete.stream().filter(pathToDelete -> !existingPaths.contains(pathToDelete)).collect(Collectors.toList());
        return nonExistingPaths;
    }

    private void deleteExternalSchemaElementsByPaths(List<String> schemaPathsToDelete) throws BadRequestException, ReferentialException {
        Delete delete = new Delete();
        try {
            if (CollectionUtils.isNotEmpty(schemaPathsToDelete)) {
                delete.setQuery((Query)QueryHelper.in((String)"Path", (String[])((String[])schemaPathsToDelete.toArray(String[]::new))));
                this.mongoDbAccessReferential.deleteDocument((JsonNode)delete.getFinalDelete(), FunctionalAdminCollections.SCHEMA);
            }
        }
        catch (InvalidCreateOperationException | SchemaValidationException e) {
            throw new BadRequestException(e);
        }
    }

    public static enum TenantScope {
        INCLUDE_ADMIN_TENANT,
        CURRENT_TENANT,
        ALL_TENANTS;

    }
}

