/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.common.ReferentialFileUtils;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.Set;

public class LogbookRuleImportManager {
    private static final String STP_IMPORT_RULES = "STP_IMPORT_RULES";
    private static final String CHECK_RULES = "CHECK_RULES";
    private static final String COMMIT_RULES = "COMMIT_RULES";
    private static final String USED_DELETED_RULE_IDS = "usedDeletedRuleIds";
    private static final String USED_UPDATED_RULE_IDS = "usedUpdatedRuleIds";
    private static final String USED_RULE_IDS_WITH_DURATION_MODE_UPDATE = "usedRuleIdsWithDurationModeUpdate";
    private static final String NB_DELETED = "nbDeleted";
    private static final String NB_UPDATED = "nbUpdated";
    private static final String NB_INSERTED = "nbInserted";
    private static final String DELETED_RULE_IDS = "deletedRuleIds";
    private static final String UPDATE_RULES_ARCHIVE_UNITS = Contexts.UPDATE_RULES_ARCHIVE_UNITS.name();
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookRuleImportManager.class);
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public LogbookRuleImportManager(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void initStpImportRulesLogbookOperation(GUID eip) throws LogbookClientException {
        LogbookOperationParameters logbookParametersStart = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_IMPORT_RULES, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_IMPORT_RULES, (StatusCode)StatusCode.STARTED), (GUID)eip);
        this.createLogBookEntry(logbookParametersStart);
    }

    public void updateCommitFileRulesLogbookOperationOkOrKo(StatusCode statusCode, GUID evIdentifierProcess, int nbDeleted, int nbUpdated, int nbInserted) throws LogbookClientException {
        ObjectNode evDetData = JsonHandler.createObjectNode();
        evDetData.put(NB_DELETED, nbDeleted);
        evDetData.put(NB_UPDATED, nbUpdated);
        evDetData.put(NB_INSERTED, nbInserted);
        GUID eventId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventId, (String)COMMIT_RULES, (GUID)evIdentifierProcess, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)statusCode, (String)VitamLogbookMessages.getCodeOp((String)COMMIT_RULES, (StatusCode)statusCode), (GUID)evIdentifierProcess);
        logbookOperationParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)evDetData));
        logbookOperationParameters.putParameterValue(LogbookParameterName.outcomeDetail, "COMMIT_RULES." + statusCode);
        this.updateLogBookEntry(logbookOperationParameters);
    }

    public void updateCheckFileRulesLogbookOperation(StatusCode statusCode, Set<String> usedUpdatedRuleIds, Set<String> notUsedDeletedRuleIds, Set<String> nonDeletableUsedRuleIds, Set<String> usedRuleIdsWithDurationModeUpdate, GUID evIdentifierProcess) throws LogbookClientException {
        ObjectNode evDetData = JsonHandler.createObjectNode();
        if (!notUsedDeletedRuleIds.isEmpty()) {
            evDetData.set(DELETED_RULE_IDS, (JsonNode)this.serializeRuleIds(notUsedDeletedRuleIds));
        }
        if (!usedUpdatedRuleIds.isEmpty()) {
            evDetData.set(USED_UPDATED_RULE_IDS, (JsonNode)this.serializeRuleIds(usedUpdatedRuleIds));
        }
        if (!nonDeletableUsedRuleIds.isEmpty()) {
            evDetData.set(USED_DELETED_RULE_IDS, (JsonNode)this.serializeRuleIds(nonDeletableUsedRuleIds));
        }
        if (!usedRuleIdsWithDurationModeUpdate.isEmpty()) {
            evDetData.set(USED_RULE_IDS_WITH_DURATION_MODE_UPDATE, (JsonNode)this.serializeRuleIds(usedRuleIdsWithDurationModeUpdate));
        }
        GUID eventId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventId, (String)CHECK_RULES, (GUID)evIdentifierProcess, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)statusCode, (String)VitamLogbookMessages.getCodeOp((String)CHECK_RULES, (StatusCode)statusCode), (GUID)evIdentifierProcess);
        logbookOperationParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)evDetData));
        logbookOperationParameters.putParameterValue(LogbookParameterName.outcomeDetail, "CHECK_RULES." + statusCode);
        this.updateLogBookEntry(logbookOperationParameters);
    }

    private ArrayNode serializeRuleIds(Set<String> ruleIds) {
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        for (String fileRulesId : ruleIds) {
            arrayNode.add(fileRulesId);
        }
        return arrayNode;
    }

    public void updateCheckFileRulesLogbookOperationWhenCheckBeforeImportIsKo(String subEvenType, GUID evIdentifierProcess) throws LogbookClientException {
        GUID eventId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventId, (String)CHECK_RULES, (GUID)evIdentifierProcess, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)CHECK_RULES, (String)subEvenType, (StatusCode)StatusCode.KO), (GUID)evIdentifierProcess);
        logbookOperationParameters.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)CHECK_RULES, (String)subEvenType, (StatusCode)StatusCode.KO));
        this.updateLogBookEntry(logbookOperationParameters);
    }

    public void updateStpImportRulesLogbookOperation(GUID eip, StatusCode status, String filename) throws InvalidParseOperationException, LogbookClientException {
        GUID eip1 = GUIDFactory.newEventGUID((GUID)eip);
        LogbookOperationParameters logbookParametersEnd = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip1, (String)STP_IMPORT_RULES, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)status, (String)VitamLogbookMessages.getCodeOp((String)STP_IMPORT_RULES, (StatusCode)status), (GUID)eip);
        ReferentialFileUtils.addFilenameInLogbookOperation((String)filename, (LogbookOperationParameters)logbookParametersEnd);
        this.updateLogBookEntry(logbookParametersEnd);
    }

    public void initializeUnitRuleUpdateWorkflowLogbook(GUID updateOperationGUID, GUID reqId) throws LogbookClientException {
        LogbookOperationParameters logbookUpdateParametersStart = LogbookParameterHelper.newLogbookOperationParameters((GUID)updateOperationGUID, (String)UPDATE_RULES_ARCHIVE_UNITS, (GUID)updateOperationGUID, (LogbookTypeProcess)LogbookTypeProcess.UPDATE, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)UPDATE_RULES_ARCHIVE_UNITS, (StatusCode)StatusCode.STARTED), (GUID)reqId);
        this.createLogBookEntry(logbookUpdateParametersStart);
    }

    public void updateUnitRuleUpdateWorkflowLogbook(GUID updateOperationGUID, GUID reqId) throws LogbookClientException {
        LogbookOperationParameters logbookUpdateParametersEnd = LogbookParameterHelper.newLogbookOperationParameters((GUID)updateOperationGUID, (String)UPDATE_RULES_ARCHIVE_UNITS, (GUID)updateOperationGUID, (LogbookTypeProcess)LogbookTypeProcess.UPDATE, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)UPDATE_RULES_ARCHIVE_UNITS, (StatusCode)StatusCode.KO), (GUID)reqId);
        this.updateLogBookEntry(logbookUpdateParametersEnd);
    }

    private void createLogBookEntry(LogbookOperationParameters logbookParametersStart) throws LogbookClientException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            client.create(new LogbookOperationParameters[]{logbookParametersStart});
        }
    }

    private void updateLogBookEntry(LogbookOperationParameters logbookParametersEnd) throws LogbookClientException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            client.update(new LogbookOperationParameters[]{logbookParametersEnd});
        }
    }

    public boolean isImportOperationInProgress() throws FileRulesException {
        try {
            Select select = new Select();
            select.setLimitFilter(0L, 1L);
            select.addOrderByDescFilter(new String[]{LogbookMongoDbName.eventDateTime.getDbname()});
            select.setQuery((Query)QueryHelper.eq((String)String.format("%s.%s", "events", LogbookMongoDbName.eventType.getDbname()), (String)STP_IMPORT_RULES));
            JsonNode logbookResult = this.logbookOperationsClientFactory.getClient().selectOperation((JsonNode)select.getFinalSelect());
            RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookResult);
            if (requestResponseOK.getHits().getSize() != 0L) {
                JsonNode result = (JsonNode)requestResponseOK.getResults().get(0);
                if (result.get("events") != null && result.get("events").size() > 0) {
                    JsonNode lastEvent = result.get("events").get(result.get("events").size() - 1);
                    return !STP_IMPORT_RULES.equals(lastEvent.get(LogbookMongoDbName.eventType.getDbname()).asText());
                }
                return false;
            }
            return false;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            throw new FileRulesException(e);
        }
    }
}

