/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.reconstruction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.api.impl.VitamElasticsearchRepository;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterBackupModel;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterSummary;
import fr.gouv.vitam.functional.administration.common.CollectionBackupModel;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.ReconstructionResponseItem;
import fr.gouv.vitam.functional.administration.common.VitamSequence;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.backup.RestoreBackupService;
import fr.gouv.vitam.functional.administration.core.reconstruction.FunctionalAdministrationReconstructionMetricsCache;
import fr.gouv.vitam.functional.administration.core.reconstruction.ReconstructionService;
import fr.gouv.vitam.functional.administration.core.reconstruction.RestoreBackupServiceImpl;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import io.prometheus.client.Histogram;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.shiro.util.CollectionUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReconstructionServiceImpl
implements ReconstructionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionServiceImpl.class);
    private static final int ADMIN_TENANT = VitamConfiguration.getAdminTenant();
    private final RestoreBackupService recoverBackupService;
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private static final String RECONSTRUCTION_ITEM_MANDATORY_MSG = "the item defining reconstruction is mandatory.";
    private static final String RECONSTRUCTION_COLLECTION_MANDATORY_MSG = "the collection to reconstruct is mandatory.";
    private static final String RECONSTRUCTION_TENANT_MANDATORY_MSG = "the tenant to reconstruct is mandatory.";
    private static final String RECONSTRUCTION_LIMIT_POSITIVE_MSG = "the limit to reconstruct is should at least 0.";
    private static final String TOTAL_OBJECT_GROUPS_INGESTED = "TotalObjectGroups_ingested";
    private static final String TOTAL_OBJECT_GROUPS_DELETED = "TotalObjectGroups_deleted";
    private static final String TOTAL_OBJECT_GROUPS_REMAINED = "TotalObjectGroups_remained";
    private static final String TOTAL_UNITS_INGESTED = "TotalUnits_ingested";
    private static final String TOTAL_UNITS_DELETED = "TotalUnits_deleted";
    private static final String TOTAL_UNITS_REMAINED = "TotalUnits_remained";
    private static final String TOTAL_OBJECT_INGEST = "TotalObjects_ingested";
    private static final String TOTAL_OBJECT_DELETED = "TotalObjects_deleted";
    private static final String TOTAL_OBJECT_REMAINED = "TotalObjects_remained";
    private static final String OBJECT_SIZE_INGESTED = "ObjectSize_ingested";
    private static final String OBJECT_SIZE_DELETED = "ObjectSize_deleted";
    private static final String OBJECT_SIZE_REMAINED = "ObjectSize_remained";
    private final OffsetRepository offsetRepository;
    private final ElasticsearchFunctionalAdminIndexManager indexManager;
    private final FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache;

    public ReconstructionServiceImpl(VitamRepositoryProvider vitamRepositoryProvider, OffsetRepository offsetRepository, ElasticsearchFunctionalAdminIndexManager indexManager, FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache) {
        this(vitamRepositoryProvider, new RestoreBackupServiceImpl(), offsetRepository, indexManager, reconstructionMetricsCache);
    }

    @VisibleForTesting
    public ReconstructionServiceImpl(VitamRepositoryProvider vitamRepositoryProvider, RestoreBackupService recoverBackupService, OffsetRepository offsetRepository, ElasticsearchFunctionalAdminIndexManager indexManager, FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.recoverBackupService = recoverBackupService;
        this.offsetRepository = offsetRepository;
        this.indexManager = indexManager;
        this.reconstructionMetricsCache = reconstructionMetricsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconstruct(FunctionalAdminCollections collection, Integer ... tenants) throws DatabaseException {
        ParametersChecker.checkParameter((String)"All parameters [%s, %s] are required.", (Object[])new Object[]{collection, tenants});
        LOGGER.debug(String.format("Start reconstruction of the %s collection on the Vitam tenant %s.", collection.getName(), Arrays.toString((Object[])tenants)));
        Integer originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
        VitamMongoRepository mongoRepository = this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection());
        VitamElasticsearchRepository elasticsearchRepository = this.vitamRepositoryProvider.getVitamESRepository(collection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(collection));
        VitamMongoRepository sequenceRepository = this.vitamRepositoryProvider.getVitamMongoRepository(FunctionalAdminCollections.VITAM_SEQUENCE.getVitamCollection());
        switch (collection) {
            case RULES: 
            case INGEST_CONTRACT: 
            case ACCESS_CONTRACT: 
            case MANAGEMENT_CONTRACT: 
            case PROFILE: 
            case ARCHIVE_UNIT_PROFILE: 
            case AGENCIES: 
            case GRIFFIN: 
            case PRESERVATION_SCENARIO: 
            case SCHEMA: {
                break;
            }
            case CONTEXT: 
            case FORMATS: 
            case SECURITY_PROFILE: 
            case ONTOLOGY: {
                tenants = new Integer[]{ADMIN_TENANT};
                break;
            }
            default: {
                throw new IllegalArgumentException("Collection '" + collection + "' not supported in this service!");
            }
        }
        try {
            for (Integer tenant : tenants) {
                this.reconstructByTenant(collection, mongoRepository, elasticsearchRepository, sequenceRepository, tenant, tenants);
            }
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructByTenant(FunctionalAdminCollections collection, VitamMongoRepository mongoRepository, VitamElasticsearchRepository elasticsearchRepository, VitamMongoRepository sequenceRepository, Integer tenant, Integer[] tenants) throws DatabaseException {
        Histogram.Timer timer = ((Histogram.Child)VitamCommonMetrics.RECONSTRUCTION_DURATION.labels(new String[]{String.valueOf(tenant), collection.name()})).startTimer();
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();){
            VitamThreadUtils.getVitamSession().setTenantId(tenant);
            String referentOfferForStrategy = storageClient.getReferentOffer(VitamConfiguration.getDefaultStrategy());
            Optional<CollectionBackupModel> collectionBackup = this.recoverBackupService.readLatestSavedFile(VitamConfiguration.getDefaultStrategy(), referentOfferForStrategy, collection);
            if (collectionBackup.isPresent()) {
                LOGGER.debug(String.format("Last backup copy version : %s", collectionBackup));
                if (collection.isMultitenant()) {
                    mongoRepository.purge(tenant);
                    elasticsearchRepository.purge(tenant);
                } else {
                    mongoRepository.purge();
                    elasticsearchRepository.purge();
                }
                this.restoreSequence(sequenceRepository, collectionBackup.get().getSequence());
                this.restoreSequence(sequenceRepository, collectionBackup.get().getBackupSequence());
                if (!CollectionUtils.isEmpty((Collection)collectionBackup.get().getDocuments())) {
                    mongoRepository.save(collectionBackup.get().getDocuments());
                    elasticsearchRepository.save(collectionBackup.get().getDocuments());
                }
                LOGGER.debug(String.format("[Reconstruction]: the collection {%s} has been reconstructed on the tenants {%s} at %s", collectionBackup, Arrays.toString((Object[])tenants), LocalDateUtil.now()));
            }
        }
        catch (StorageNotFoundClientException | StorageServerClientException e) {
            LOGGER.error("ERROR: Exception has been thrown when trying to get Referent offer :", e);
        }
        finally {
            timer.observeDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReconstructionResponseItem reconstructAccessionRegister(ReconstructionRequestItem reconstructionItem) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_ITEM_MANDATORY_MSG, (Object[])new Object[]{reconstructionItem});
        ParametersChecker.checkParameter((String)RECONSTRUCTION_COLLECTION_MANDATORY_MSG, (String[])new String[]{reconstructionItem.getCollection()});
        ParametersChecker.checkParameter((String)RECONSTRUCTION_TENANT_MANDATORY_MSG, (Object[])new Object[]{reconstructionItem.getTenant()});
        if (reconstructionItem.getLimit() < 0) {
            throw new IllegalArgumentException(RECONSTRUCTION_LIMIT_POSITIVE_MSG);
        }
        LOGGER.info(String.format("[Reconstruction]: Reconstruction of {%s} Collection on {%s} Vitam tenant", reconstructionItem.getCollection(), reconstructionItem.getTenant()));
        FunctionalAdminCollections collection = this.getCollection(reconstructionItem);
        Histogram.Timer timer = ((Histogram.Child)VitamCommonMetrics.RECONSTRUCTION_DURATION.labels(new String[]{String.valueOf(reconstructionItem.getTenant()), collection.name()})).startTimer();
        try {
            ReconstructionResponseItem reconstructionResponseItem = this.reconstructAccessionRegister(collection, reconstructionItem.getTenant(), reconstructionItem.getLimit());
            return reconstructionResponseItem;
        }
        finally {
            timer.observeDuration();
        }
    }

    private FunctionalAdminCollections getCollection(ReconstructionRequestItem reconstructionItem) {
        if (FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getName().equalsIgnoreCase(reconstructionItem.getCollection())) {
            return FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL;
        }
        if (FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC.getName().equalsIgnoreCase(reconstructionItem.getCollection())) {
            return FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC;
        }
        throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", reconstructionItem.getCollection()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ReconstructionResponseItem reconstructAccessionRegister(FunctionalAdminCollections collection, int tenant, int limit) {
        Integer originalTenant;
        ReconstructionResponseItem response;
        block20: {
            long offset;
            block17: {
                offset = this.offsetRepository.findOffsetBy(tenant, VitamConfiguration.getDefaultStrategy(), collection.getName());
                ParametersChecker.checkParameter((String)"Parameter collection is required.", (Object[])new Object[]{collection});
                LOGGER.info(String.format("[Reconstruction]: Start reconstruction of the {%s} collection on the Vitam tenant {%s} for %s elements starting from {%s}.", collection.name(), tenant, limit, offset + 1L));
                response = new ReconstructionResponseItem().setCollection(collection.name()).setTenant(Integer.valueOf(tenant));
                originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
                long newOffset = offset;
                try {
                    DataCategory type;
                    VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
                    switch (collection) {
                        case ACCESSION_REGISTER_DETAIL: {
                            type = DataCategory.ACCESSION_REGISTER_DETAIL;
                            break;
                        }
                        case ACCESSION_REGISTER_SYMBOLIC: {
                            type = DataCategory.ACCESSION_REGISTER_SYMBOLIC;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", collection));
                        }
                    }
                    LocalDateTime reconstructionStartDateTime = LocalDateUtil.now();
                    LocalDateTime lastReconstructedDocumentDate = null;
                    int nbEntriesReconstructed = 0;
                    Iterator<List<OfferLog>> offerLogIterator = this.recoverBackupService.getListing(VitamConfiguration.getDefaultStrategy(), type, offset + 1L, limit, Order.ASC);
                    HashSet<String> originatingAgencies = new HashSet<String>();
                    while (offerLogIterator.hasNext()) {
                        List<OfferLog> listingBulk = offerLogIterator.next();
                        ArrayList<AccessionRegisterBackupModel> dataFromOffer = new ArrayList<AccessionRegisterBackupModel>();
                        for (OfferLog offerLog : listingBulk) {
                            AccessionRegisterBackupModel model = this.recoverBackupService.loadData(VitamConfiguration.getDefaultStrategy(), collection, offerLog.getFileName(), offerLog.getSequence());
                            if (model.getAccessionRegister() != null && model.getOffset() != null) {
                                originatingAgencies.add(model.getAccessionRegister().getString((Object)"OriginatingAgency"));
                                dataFromOffer.add(model);
                                continue;
                            }
                            throw new StorageException(String.format("[Reconstruction]: Data is not present in file {%s} for the collection {%s} on the tenant {%s}", offerLog.getFileName(), collection, tenant));
                        }
                        if (dataFromOffer.isEmpty()) continue;
                        this.reconstructCollectionAccessionRegister(collection, dataFromOffer, VitamConfiguration.getOptimisticLockRetryNumber());
                        AccessionRegisterBackupModel last = (AccessionRegisterBackupModel)Iterables.getLast(dataFromOffer);
                        newOffset = last.getOffset();
                        nbEntriesReconstructed += listingBulk.size();
                        lastReconstructedDocumentDate = listingBulk.get(listingBulk.size() - 1).getTime();
                        LOGGER.info(String.format("[Reconstruction]: the collection {%s} has been reconstructed on the tenant {%s} from {offset:%s} at %s", collection.name(), tenant, offset, LocalDateUtil.now()));
                    }
                    if (collection.equals((Object)FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL)) {
                        this.computeAccessionRegisterSummary(originatingAgencies, tenant);
                    }
                    if (nbEntriesReconstructed != limit) {
                        lastReconstructedDocumentDate = LocalDateUtil.max((LocalDateTime)reconstructionStartDateTime, lastReconstructedDocumentDate);
                    }
                    this.reconstructionMetricsCache.registerLastDocumentReconstructionDate(collection, tenant, lastReconstructedDocumentDate);
                    response.setStatus(StatusCode.OK);
                    if (newOffset == offset) break block17;
                }
                catch (DatabaseException de) {
                    block22: {
                        block18: {
                            LOGGER.error(String.format("[Reconstruction]: Exception has been thrown when reconstructing Vitam collection {%s} on the tenant {%s} from {offset:%s}", collection, tenant, offset), (Throwable)de);
                            newOffset = offset;
                            response.setStatus(StatusCode.KO);
                            if (newOffset == offset) break block18;
                            this.offsetRepository.createOrUpdateOffset(tenant, VitamConfiguration.getDefaultStrategy(), collection.getName(), newOffset);
                            break block22;
                        }
                        LOGGER.info(String.format("[Reconstruction]: Nothing to reconstruct for Vitam collection {%s} on the tenant {%s} from {offset:%s}", collection, tenant, offset));
                    }
                    VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
                }
                catch (StorageNotFoundClientException | StorageServerClientException | StorageException se) {
                    block23: {
                        block19: {
                            LOGGER.error(se.getMessage());
                            newOffset = offset;
                            response.setStatus(StatusCode.KO);
                            if (newOffset == offset) break block19;
                            {
                                catch (Throwable throwable) {
                                    if (newOffset != offset) {
                                        this.offsetRepository.createOrUpdateOffset(tenant, VitamConfiguration.getDefaultStrategy(), collection.getName(), newOffset);
                                    } else {
                                        LOGGER.info(String.format("[Reconstruction]: Nothing to reconstruct for Vitam collection {%s} on the tenant {%s} from {offset:%s}", collection, tenant, offset));
                                    }
                                    VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
                                    throw throwable;
                                }
                            }
                            this.offsetRepository.createOrUpdateOffset(tenant, VitamConfiguration.getDefaultStrategy(), collection.getName(), newOffset);
                            break block23;
                        }
                        LOGGER.info(String.format("[Reconstruction]: Nothing to reconstruct for Vitam collection {%s} on the tenant {%s} from {offset:%s}", collection, tenant, offset));
                    }
                    VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
                }
                this.offsetRepository.createOrUpdateOffset(tenant, VitamConfiguration.getDefaultStrategy(), collection.getName(), newOffset);
                break block20;
            }
            LOGGER.info(String.format("[Reconstruction]: Nothing to reconstruct for Vitam collection {%s} on the tenant {%s} from {offset:%s}", collection, tenant, offset));
        }
        VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        return response;
    }

    private void reconstructCollectionAccessionRegister(FunctionalAdminCollections collection, List<AccessionRegisterBackupModel> dataFromOffer, Integer nbRetry) throws DatabaseException {
        if (nbRetry < 0) {
            throw new DatabaseException("Optimistic lock number of retry reached");
        }
        LOGGER.info("[Reconstruction]: Back up of Accession Register bulk");
        List<WriteModel<Document>> metadataList = dataFromOffer.stream().map(AccessionRegisterBackupModel::getAccessionRegister).map(this::createReplaceOneModel).collect(Collectors.toList());
        try {
            this.bulkMongo(collection, metadataList);
        }
        catch (DatabaseException e) {
            if (e.getCause() instanceof MongoBulkWriteException) {
                LOGGER.warn("[Reconstruction]: [Optimistic_Lock]: optimistic lock occurs while reconstruct Accession Register");
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(VitamConfiguration.getOptimisticLockSleepTime()));
                }
                catch (InterruptedException e1) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e1);
                    throw new DatabaseException((Throwable)e1);
                }
                Integer n = nbRetry;
                Integer n2 = nbRetry = Integer.valueOf(nbRetry - 1);
                this.reconstructCollectionAccessionRegister(collection, dataFromOffer, nbRetry);
                return;
            }
            throw e;
        }
        List<Document> documents = dataFromOffer.stream().map(AccessionRegisterBackupModel::getAccessionRegister).collect(Collectors.toList());
        this.bulkElasticsearch(collection, documents);
    }

    private void restoreSequence(VitamMongoRepository sequenceRepository, VitamSequence sequenceCollection) throws DatabaseException {
        sequenceRepository.removeByNameAndTenant(sequenceCollection.getName(), sequenceCollection.getTenantId());
        sequenceRepository.save((Document)sequenceCollection);
    }

    @Override
    public void reconstruct(FunctionalAdminCollections collection) throws DatabaseException {
        ParametersChecker.checkParameter((String)"The collection parameter is required.", (Object[])new Object[]{collection});
        LOGGER.debug(String.format("Start reconstruction of the %s collection on all of the Vitam tenants.", collection.getName()));
        List tenants = VitamConfiguration.getTenants();
        if (null != tenants && !tenants.isEmpty()) {
            LOGGER.debug(String.format("Reconstruction of %s Vitam tenants", tenants.size()));
            this.reconstruct(collection, tenants.toArray(new Integer[0]));
        }
    }

    private WriteModel<Document> createReplaceOneModel(Document document) {
        Bson filter = Filters.eq((String)"_id", (Object)document.get((Object)"_id"));
        return new ReplaceOneModel(filter, (Object)document, new ReplaceOptions().upsert(true));
    }

    private void bulkMongo(FunctionalAdminCollections faCollection, List<WriteModel<Document>> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamMongoRepository(faCollection.getVitamCollection()).update(collection);
    }

    private void bulkElasticsearch(FunctionalAdminCollections faCollection, List<Document> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamESRepository(faCollection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(faCollection)).save(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAccessionRegisterSummary(Set<String> originatingAgencies, Integer tenant) {
        block17: {
            ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{originatingAgencies, tenant});
            if (originatingAgencies.isEmpty()) {
                return;
            }
            int originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
            try {
                VitamThreadUtils.getVitamSession().setTenantId(tenant);
                List<Document> documents = this.agregateAccessionRegisterSummary(originatingAgencies, tenant);
                HashSet<Document> accessionRegisterSummary = new HashSet<Document>();
                for (Document registerSummaryDoc : documents) {
                    registerSummaryDoc.append("_tenant", (Object)tenant).append("_v", (Object)0).append("CreationDate", (Object)LocalDateUtil.nowFormatted());
                    BasicDBObject searchQuery = new BasicDBObject();
                    searchQuery.put((Object)"OriginatingAgency", (Object)registerSummaryDoc.getString((Object)"OriginatingAgency"));
                    searchQuery.put((Object)"_tenant", (Object)tenant);
                    try (MongoCursor registerSummaryIt = FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.getCollection().find((Bson)searchQuery).iterator();){
                        if (registerSummaryIt.hasNext()) {
                            registerSummaryDoc.append("_id", ((AccessionRegisterSummary)registerSummaryIt.next()).get((Object)"_id"));
                        } else {
                            registerSummaryDoc.append("_id", (Object)GUIDFactory.newAccessionRegisterSummaryGUID((int)ParameterHelper.getTenantParameter()).getId());
                        }
                    }
                    accessionRegisterSummary.add(registerSummaryDoc);
                }
                List<WriteModel<Document>> collectionWM = accessionRegisterSummary.stream().map(this::createReplaceOneModel).collect(Collectors.toList());
                try {
                    this.bulkMongo(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY, collectionWM);
                    this.bulkElasticsearch(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY, Lists.newArrayList(accessionRegisterSummary));
                }
                catch (DatabaseException e) {
                    if (e.getCause() instanceof MongoBulkWriteException) {
                        LOGGER.warn("[Reconstruction]: [Optimistic_Lock]: optimistic lock occurs while reconstruct Accession Register");
                        break block17;
                    }
                    LOGGER.error((Throwable)e);
                }
            }
            finally {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(originalTenant));
            }
        }
    }

    @Override
    public List<Document> agregateAccessionRegisterSummary(Set<String> originatingAgencies, Integer tenant) {
        MongoCollection accessionRegisterDetailCollection = FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getCollection();
        AggregateIterable aggregate = accessionRegisterDetailCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.in((String)"OriginatingAgency", originatingAgencies), Filters.eq((String)"_tenant", (Object)tenant)})), Aggregates.group((Object)"$OriginatingAgency", (BsonField[])new BsonField[]{Accumulators.sum((String)TOTAL_OBJECT_GROUPS_INGESTED, (Object)"$TotalObjectGroups.ingested"), Accumulators.sum((String)TOTAL_OBJECT_GROUPS_DELETED, (Object)"$TotalObjectGroups.deleted"), Accumulators.sum((String)TOTAL_OBJECT_GROUPS_REMAINED, (Object)"$TotalObjectGroups.remained"), Accumulators.sum((String)TOTAL_UNITS_INGESTED, (Object)"$TotalUnits.ingested"), Accumulators.sum((String)TOTAL_UNITS_DELETED, (Object)"$TotalUnits.deleted"), Accumulators.sum((String)TOTAL_UNITS_REMAINED, (Object)"$TotalUnits.remained"), Accumulators.sum((String)TOTAL_OBJECT_INGEST, (Object)"$TotalObjects.ingested"), Accumulators.sum((String)TOTAL_OBJECT_DELETED, (Object)"$TotalObjects.deleted"), Accumulators.sum((String)TOTAL_OBJECT_REMAINED, (Object)"$TotalObjects.remained"), Accumulators.sum((String)OBJECT_SIZE_INGESTED, (Object)"$ObjectSize.ingested"), Accumulators.sum((String)OBJECT_SIZE_DELETED, (Object)"$ObjectSize.deleted"), Accumulators.sum((String)OBJECT_SIZE_REMAINED, (Object)"$ObjectSize.remained")}), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("OriginatingAgency", (Object)"$_id"), new Document("TotalObjectGroups", (Object)new Document().append("ingested", (Object)"$TotalObjectGroups_ingested").append("deleted", (Object)"$TotalObjectGroups_deleted").append("remained", (Object)"$TotalObjectGroups_remained")), new Document("TotalUnits", (Object)new Document().append("ingested", (Object)"$TotalUnits_ingested").append("deleted", (Object)"$TotalUnits_deleted").append("remained", (Object)"$TotalUnits_remained")), new Document("TotalObjects", (Object)new Document().append("ingested", (Object)"$TotalObjects_ingested").append("deleted", (Object)"$TotalObjects_deleted").append("remained", (Object)"$TotalObjects_remained")), new Document("ObjectSize", (Object)new Document().append("ingested", (Object)"$ObjectSize_ingested").append("deleted", (Object)"$ObjectSize_deleted").append("remained", (Object)"$ObjectSize_remained"))}))), Document.class);
        return Lists.newArrayList((Iterator)aggregate.iterator());
    }
}

