/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.profile;

import fr.gouv.vitam.common.model.administration.ProfileModel;
import java.util.List;
import java.util.Optional;

@FunctionalInterface
public interface ProfileValidator {
    public Optional<RejectionCause> validate(ProfileModel var1);

    public static class RejectionCause {
        private static final String ERR_ID_NOT_ALLOWED_IN_CREATE = "Id must be null when creating profile (%s)";
        private static final String ERR_DUPLICATE_PROFILE = "The profile %s already exists in database";
        private static final String ERR_MANDATORY_FIELD = "The field %s is mandatory.";
        private String reason;

        public RejectionCause(String error) {
            this.setReason(error);
        }

        public static RejectionCause rejectIdNotAllowedInCreate(String profileIdentifier) {
            return new RejectionCause(String.format(ERR_ID_NOT_ALLOWED_IN_CREATE, profileIdentifier));
        }

        public static RejectionCause rejectDuplicatedInDatabase(String identifier) {
            return new RejectionCause(String.format(ERR_DUPLICATE_PROFILE, identifier));
        }

        public static RejectionCause rejectMandatoryMissing(String fieldName) {
            return new RejectionCause(String.format(ERR_MANDATORY_FIELD, fieldName));
        }

        public static RejectionCause rejectSeveralMandatoryMissing(List<String> fieldsName) {
            Object allMissingFields = "";
            for (String field : fieldsName) {
                allMissingFields = (String)allMissingFields + String.format(ERR_MANDATORY_FIELD, field);
            }
            return new RejectionCause((String)allMissingFields);
        }

        public String getReason() {
            return this.reason;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }
    }
}

