/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ProfileFormat;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.model.administration.ProfileStatus;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.Profile;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.profile.ProfileManager;
import fr.gouv.vitam.functional.administration.core.profile.ProfileService;
import fr.gouv.vitam.functional.administration.core.profile.ProfileValidator;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;

public class ProfileServiceImpl
implements ProfileService {
    public static final String OP_PROFILE_STORAGE = "OP_PROFILE_STORAGE";
    public static final String PROFILE_FORMAT_SHOULD_BE_XSD_OR_RNG = "Profile Format should be XSD or RNG : ";
    public static final String PROFILE_IDENTIFIER_ALREADY_EXISTS_IN_DATABASE = "Profile identifier already exists in database ";
    public static final String PROFILE_IDENTIFIER_MUST_BE_STRING = "Profile identifier shoud be a string ";
    public static final String PROFILE_BACKUP_EVENT = "BACKUP_PROFILE";
    public static final String PATH_UNUPDATABLE = "The path field is not updatable";
    public static final String PATH_SHOULD_NOT_BE_FILLED = "The profile path should not be filled manually";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProfileServiceImpl.class);
    private static final String PROFILE_IS_MANDATORY_PARAMETER = "profiles parameter is mandatory";
    private static final String PROFILES_IMPORT_EVENT = "STP_IMPORT_PROFILE_JSON";
    private static final String PROFILES_UPDATE_EVENT = "STP_UPDATE_PROFILE_JSON";
    private static final String PROFILES_FILE_IMPORT_EVENT = "STP_IMPORT_PROFILE_FILE";
    private static final String PROFILE_NOT_FOUND = "Update a not found profile";
    private static final String PROFILE_NOT_FOUND_WITH_IDENTIFIER = "No profile metadata found with identifier : ";
    private static final String MANDATORY_PROFILE_METADATA = ", to import the file, the metadata profile must be created first";
    private static final String UPDATED_DIFFS = "updatedDiffs";
    private static final String THE_PROFILE_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT = "The profile status must be ACTIVE or INACTIVE but not ";
    private static final String TENANT = "_tenant";
    private static final String ID = "_id";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;

    public ProfileServiceImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.logbookClient = LogbookOperationsClientFactory.getInstance().getClient();
        this.functionalBackupService = functionalBackupService;
    }

    @Override
    public RequestResponse<ProfileModel> createProfiles(List<ProfileModel> profileModelList) throws VitamException {
        ParametersChecker.checkParameter((String)PROFILE_IS_MANDATORY_PARAMETER, (Object[])new Object[]{profileModelList});
        if (profileModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.PROFILE_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        ProfileManager manager = new ProfileManager(this.logbookClient, eip);
        manager.logStarted(PROFILES_IMPORT_EVENT, null);
        HashSet<String> profileIdentifiers = new HashSet<String>();
        HashSet<String> profileNames = new HashSet<String>();
        VitamError error = this.getVitamError(VitamCode.PROFILE_FILE_IMPORT_ERROR.getItem(), "Global create profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            for (ProfileModel pm : profileModelList) {
                if (null != pm.getId()) {
                    error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), ProfileValidator.RejectionCause.rejectIdNotAllowedInCreate(pm.getName()).getReason()));
                    continue;
                }
                if (ParametersChecker.isNotEmpty((String[])new String[]{pm.getIdentifier()})) {
                    if (profileIdentifiers.contains(pm.getIdentifier())) {
                        error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "Duplicate profiles").setMessage("Profile identifier " + pm.getIdentifier() + " already exists in the json"));
                        continue;
                    }
                    profileIdentifiers.add(pm.getIdentifier());
                }
                profileNames.add(pm.getName());
                if (manager.validateProfile(pm, error)) {
                    pm.setId(GUIDFactory.newProfileGUID((int)ParameterHelper.getTenantParameter()).getId());
                }
                if (pm.getTenant() == null) {
                    pm.setTenant(ParameterHelper.getTenantParameter());
                }
                if (slaveMode) {
                    Optional<ProfileValidator.RejectionCause> result = manager.checkEmptyIdentifierSlaveModeValidator().validate(pm);
                    result.ifPresent(t -> error.addToErrors(new VitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem()).setDescription(((ProfileValidator.RejectionCause)result.get()).getReason()).setMessage("STP_IMPORT_PROFILE_JSON.IDENTIFIER_DUPLICATION.KO")));
                }
                if (pm.getPath() == null) continue;
                error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), PATH_UNUPDATABLE).setMessage(PATH_SHOULD_NOT_BE_FILLED));
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                manager.logValidationError(PROFILES_IMPORT_EVENT, null, errorsDetails, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            ArrayNode profilesToPersist = JsonHandler.createArrayNode();
            for (ProfileModel pm : profileModelList) {
                JsonNode hashTenant;
                this.setIdentifier(slaveMode, pm);
                ObjectNode profileNode = (ObjectNode)JsonHandler.toJsonNode((Object)pm);
                JsonNode jsonNode = profileNode.remove(VitamFieldsHelper.id());
                if (jsonNode != null) {
                    profileNode.set(ID, jsonNode);
                }
                if ((hashTenant = profileNode.remove(VitamFieldsHelper.tenant())) != null) {
                    profileNode.set(TENANT, hashTenant);
                }
                profilesToPersist.add((JsonNode)profileNode);
            }
            this.mongoAccess.insertDocuments(profilesToPersist, FunctionalAdminCollections.PROFILE).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, PROFILE_BACKUP_EVENT, FunctionalAdminCollections.PROFILE, eip.toString());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            String err = "Import profiles error : " + exp.getMessage();
            manager.logFatalError(PROFILES_IMPORT_EVENT, null, err);
            return this.getVitamError(VitamCode.PROFILE_FILE_IMPORT_ERROR.getItem(), err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        manager.logSuccess(PROFILES_IMPORT_EVENT, null, null);
        return new RequestResponseOK().addAllResults(profileModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    private void setIdentifier(boolean slaveMode, ProfileModel pm) throws ReferentialException {
        if (!slaveMode) {
            String code = this.vitamCounterService.getNextSequenceAsString(ParameterHelper.getTenantParameter(), SequenceType.PROFILE_SEQUENCE);
            pm.setIdentifier(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestResponse<ProfileModel> importProfileFile(String profileIdentifier, InputStream profileFile) throws VitamException {
        ProfileModel profileMetadata = this.findByIdentifier(profileIdentifier);
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        ProfileManager manager = new ProfileManager(this.logbookClient, eip);
        VitamError vitamError = this.getVitamError(VitamCode.PROFILE_FILE_IMPORT_ERROR.getItem(), "Global import profile error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        if (null == profileMetadata) {
            LOGGER.error(PROFILE_NOT_FOUND_WITH_IDENTIFIER + profileIdentifier + MANDATORY_PROFILE_METADATA);
            manager.logValidationError(PROFILES_FILE_IMPORT_EVENT, profileIdentifier, PROFILE_NOT_FOUND_WITH_IDENTIFIER + profileIdentifier + MANDATORY_PROFILE_METADATA, "STP_IMPORT_PROFILE_JSON.KO");
            return vitamError.addToErrors(this.getVitamError(VitamCode.PROFILE_FILE_IMPORT_ERROR.getItem(), PROFILE_NOT_FOUND_WITH_IDENTIFIER + profileIdentifier + MANDATORY_PROFILE_METADATA));
        }
        manager.logStarted(PROFILES_FILE_IMPORT_EVENT, null);
        File file = null;
        try {
            file = File.createTempFile(GUIDFactory.newGUID().getId(), "profile");
            Files.copy(profileFile, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean isValid = manager.validateProfileFile(profileMetadata, file, vitamError);
            if (!isValid) {
                String errorsDetails = vitamError.getErrors().stream().map(VitamError::getMessage).collect(Collectors.joining(","));
                manager.logValidationError(PROFILES_FILE_IMPORT_EVENT, profileMetadata.getId(), "Profile file validate error : " + errorsDetails, "STP_IMPORT_PROFILE_JSON.KO");
                VitamError vitamError2 = vitamError;
                return vitamError2;
            }
            String extension = "xsd";
            if (profileMetadata.getFormat().equals((Object)ProfileFormat.RNG)) {
                extension = "rng";
            }
            Integer tenantId = ParameterHelper.getTenantParameter();
            String fileName = String.format("%d_profile_%s_%s.%s", tenantId, profileMetadata.getId(), LocalDateUtil.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")), extension);
            String oldPath = profileMetadata.getPath();
            FileInputStream profileIS = new FileInputStream(file);
            this.functionalBackupService.saveFile(profileIS, eip, OP_PROFILE_STORAGE, DataCategory.PROFILE, fileName);
            UpdateParserSingle updateParserActive = new UpdateParserSingle((VarNameAdapter)new SingleVarNameAdapter());
            Update update = new Update();
            update.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)profileMetadata.getIdentifier()));
            update.addActions(new Action[]{UpdateActionHelper.set((String)"Path", (String)fileName), UpdateActionHelper.set((String)"LastUpdate", (String)LocalDateUtil.nowFormatted())});
            updateParserActive.parse((JsonNode)update.getFinalUpdate());
            ObjectNode queryDsl = updateParserActive.getRequest().getFinalUpdate();
            this.mongoAccess.updateData((JsonNode)queryDsl, FunctionalAdminCollections.PROFILE).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, PROFILE_BACKUP_EVENT, FunctionalAdminCollections.PROFILE, eip.toString());
            String wellFormedJson = null;
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                ObjectNode msg = JsonHandler.createObjectNode();
                msg.put("updateField", "Path");
                msg.put("oldPath", oldPath);
                msg.put("newPath", fileName);
                object.set("profileUpdate", (JsonNode)msg);
                wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
            manager.logSuccess(PROFILES_FILE_IMPORT_EVENT, null, wellFormedJson);
        }
        catch (Exception e) {
            String err = "Import profile error : " + e.getMessage();
            LOGGER.error(err, (Throwable)e);
            manager.logFatalError(PROFILES_FILE_IMPORT_EVENT, null, err);
            VitamError vitamError3 = this.getVitamError(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem(), err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return vitamError3;
        }
        finally {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            }
            if (null != profileFile) {
                try {
                    profileFile.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error while closing the profile file stream!");
                }
            }
        }
        return new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    @Override
    public Response downloadProfileFile(String profileIdentifier) throws ProfileNotFoundException, InvalidParseOperationException, ReferentialException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block11: {
            ProfileModel profileMetadata = this.findByIdentifier(profileIdentifier);
            if (null == profileMetadata) {
                LOGGER.error("No profile metadata found with id : " + profileIdentifier + MANDATORY_PROFILE_METADATA);
                throw new ProfileNotFoundException("No profile metadata found with id : " + profileIdentifier + MANDATORY_PROFILE_METADATA);
            }
            if (Strings.isNullOrEmpty((String)profileMetadata.getPath()) || profileMetadata.getPath().isEmpty()) {
                LOGGER.error("The profile metadata found with an id : " + profileIdentifier + ", does not have an xsd or an rng file yet");
                throw new ProfileNotFoundException("The profile metadata found with id : " + profileIdentifier + ", does not have a xsd or rng file yet");
            }
            StorageClient storageClient = StorageClientFactory.getInstance().getClient();
            try {
                Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), profileMetadata.getPath(), DataCategory.PROFILE, AccessLogUtils.getNoLogAccessLog());
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("Content-Type", "application/octet-stream");
                headers.put("Content-Disposition", "filename=" + profileMetadata.getPath());
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (storageClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException e) {
                    throw new ReferentialException(e);
                }
                catch (StorageNotFoundException e) {
                    throw new ProfileNotFoundException((Throwable)e);
                }
            }
            storageClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    @Override
    public RequestResponse<ProfileModel> updateProfile(String identifier, JsonNode jsonDsl) throws VitamException {
        ProfileModel profileModel = this.findByIdentifier(identifier);
        return this.updateProfile(profileModel, jsonDsl);
    }

    @Override
    public RequestResponse<ProfileModel> updateProfile(ProfileModel profileModel, JsonNode jsonDsl) throws VitamException {
        if (profileModel == null) {
            return this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), PROFILE_NOT_FOUND).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.PROFILE_NOT_FOUND.KO");
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ProfileManager manager = new ProfileManager(this.logbookClient, eip);
        RequestResponseOK response = new RequestResponseOK();
        manager.logStarted(PROFILES_UPDATE_EVENT, profileModel.getId());
        if (jsonDsl == null || !jsonDsl.isObject()) {
            manager.logValidationError(PROFILES_UPDATE_EVENT, profileModel.getId(), "Update query dsl must be an object and not null", "STP_UPDATE_PROFILE_JSON.KO");
            return this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "Update query dsl must be an object and not null : " + profileModel.getIdentifier()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.KO");
        }
        VitamError error = this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "Update profile error : " + profileModel.getIdentifier()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        JsonNode actionNode = jsonDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            Iterator it = fieldName.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = fieldName.findValue(field);
                this.validateUpdateAction(profileModel, (VitamError<ProfileModel>)error, field, value, manager);
            }
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
        }
        if (error.getErrors() != null && CollectionUtils.isNotEmpty((Collection)error.getErrors())) {
            String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
            manager.logValidationError(PROFILES_UPDATE_EVENT, profileModel.getId(), errorsDetails, ((VitamError)error.getErrors().get(0)).getMessage());
            return error;
        }
        String wellFormedJson = null;
        try {
            Map updateDiffs;
            try (DbRequestResult result = this.mongoAccess.updateData(jsonDsl, FunctionalAdminCollections.PROFILE);){
                updateDiffs = result.getDiffs();
                response.addAllResults(result.getDocuments(Profile.class, ProfileModel.class)).setTotal(result.getTotal()).setQuery(jsonDsl).setHttpCode(Response.Status.OK.getStatusCode());
            }
            List diff = (List)updateDiffs.get(profileModel.getId());
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put(UPDATED_DIFFS, Joiner.on((String)" ").join((Iterable)diff));
                wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
            }
            catch (InvalidParseOperationException object) {
                // empty catch block
            }
            this.functionalBackupService.saveCollectionAndSequence(eip, PROFILE_BACKUP_EVENT, FunctionalAdminCollections.PROFILE, profileModel.getId());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            String err = "Update profile error : " + e.getMessage();
            manager.logFatalError(PROFILES_UPDATE_EVENT, profileModel.getId(), err);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
        manager.logSuccess(PROFILES_UPDATE_EVENT, profileModel.getId(), wellFormedJson);
        return response;
    }

    private void validateUpdateAction(ProfileModel profileModel, VitamError<ProfileModel> error, String field, JsonNode value, ProfileManager manager) {
        if ("Status".equals(field) && !ProfileStatus.ACTIVE.name().equals(value.asText()) && !ProfileStatus.INACTIVE.name().equals(value.asText())) {
            error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), THE_PROFILE_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.NOT_IN_ENUM.KO"));
        }
        if ("Format".equals(field) && !ProfileFormat.XSD.name().equals(value.asText()) && !ProfileFormat.RNG.name().equals(value.asText())) {
            error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), PROFILE_FORMAT_SHOULD_BE_XSD_OR_RNG + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.KO"));
        }
        if ("Identifier".equals(field)) {
            Optional<ProfileValidator.RejectionCause> validateIdentifier;
            if (!value.isTextual()) {
                error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "Profile identifier shoud be a string  : " + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.KO"));
            } else if (!profileModel.getIdentifier().equals(value.asText()) && (validateIdentifier = manager.createCheckDuplicateInDatabaseValidator().validate(new ProfileModel().setIdentifier(value.asText()))).isPresent()) {
                error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "Profile identifier already exists in database  : " + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage("STP_UPDATE_PROFILE_JSON.IDENTIFIER_DUPLICATION.KO"));
            }
        }
        if ("Path".equals(field)) {
            error.addToErrors(this.getVitamError(VitamCode.PROFILE_VALIDATION_ERROR.getItem(), "The path field is not updatable : " + value.asText()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setMessage(PATH_SHOULD_NOT_BE_FILLED));
        }
    }

    @Override
    public ProfileModel findByIdentifier(String identifier) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{identifier});
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
        parser.parse((JsonNode)new Select().getFinalSelect());
        try {
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
        }
        catch (InvalidCreateOperationException e) {
            throw new ReferentialException((Throwable)e);
        }
        try (DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)parser.getRequest().getFinalSelect(), FunctionalAdminCollections.PROFILE);){
            List list = result.getDocuments(Profile.class, ProfileModel.class);
            if (list.isEmpty()) {
                ProfileModel profileModel = null;
                return profileModel;
            }
            ProfileModel profileModel = (ProfileModel)list.get(0);
            return profileModel;
        }
    }

    @Override
    public RequestResponseOK<ProfileModel> findProfiles(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.PROFILE);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, Profile.class, ProfileModel.class);
            return requestResponseOK;
        }
    }

    private VitamError<ProfileModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)"Profile", (StatusCode)StatusCode.KO, ProfileModel.class);
    }

    public void close() {
        if (null != this.logbookClient) {
            this.logbookClient.close();
        }
    }
}

