/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.ontologies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.FindIterable;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamErrorMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.model.administration.StringSize;
import fr.gouv.vitam.common.model.administration.TypeDetail;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.ArchiveUnitProfile;
import fr.gouv.vitam.functional.administration.common.ErrorReportOntologies;
import fr.gouv.vitam.functional.administration.common.Ontology;
import fr.gouv.vitam.functional.administration.common.OntologyErrorCode;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.exception.OntologyInternalExternalConflictException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyManager;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.bson.Document;

public class OntologyServiceImpl
implements OntologyService {
    static final String BACKUP_ONTOLOGY_EVENT = "STP_BACKUP_ONTOLOGY";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OntologyServiceImpl.class);
    private static final Integer ADMIN_TENANT = VitamConfiguration.getAdminTenant();
    private static final String IDENTIFIER = "IDENTIFIER";
    private static final String CTR_SCHEMA = "CTR_SCHEMA";
    private static final String ONTOLOGY_IMPORT_EVENT = "IMPORT_ONTOLOGY";
    private static final String CHECK_ONTOLOGY_IMPORT_EVENT = "CHECK_ONTOLOGY_IMPORT";
    private static final String ONTOLOGIES_IS_MANDATORY_PARAMETER = "ontologies parameter is mandatory";
    private static final String ONTOLOGIES_REPORT = "ONTOLOGY_REPORT";
    private static final String DELETED_ONTOLOGIES = "deletedOntologies";
    private static final String UPDATED_ONTOLOGIES = "updatedOntologies";
    private static final String CREATED_ONTOLOGIES = "createdOntologies";
    private static final Pattern INVALID_IDENTIFIER_PATTERN = Pattern.compile("^[_#\\s]|\\s");
    private static final String UND_TENANT = "_tenant";
    private static final String UND_ID = "_id";
    private static final Map<OntologyType, List<OntologyType>> typeMap = OntologyServiceImpl.getOntologyTypeMap();
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final FunctionalBackupService functionalBackupService;

    public OntologyServiceImpl(MongoDbAccessAdminImpl mongoAccess, FunctionalBackupService functionalBackupService) {
        this(mongoAccess, functionalBackupService, LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    public OntologyServiceImpl(MongoDbAccessAdminImpl mongoAccess, FunctionalBackupService functionalBackupService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.mongoAccess = mongoAccess;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.functionalBackupService = functionalBackupService;
    }

    private static Map<OntologyType, List<OntologyType>> getOntologyTypeMap() {
        EnumMap<OntologyType, List<OntologyType>> ontologyTypeMap = new EnumMap<OntologyType, List<OntologyType>>(OntologyType.class);
        ontologyTypeMap.put(OntologyType.TEXT, Collections.singletonList(OntologyType.KEYWORD));
        ontologyTypeMap.put(OntologyType.KEYWORD, Collections.singletonList(OntologyType.TEXT));
        ontologyTypeMap.put(OntologyType.DATE, Arrays.asList(OntologyType.KEYWORD, OntologyType.TEXT));
        ontologyTypeMap.put(OntologyType.LONG, Collections.emptyList());
        ontologyTypeMap.put(OntologyType.DOUBLE, Collections.emptyList());
        ontologyTypeMap.put(OntologyType.BOOLEAN, Collections.emptyList());
        ontologyTypeMap.put(OntologyType.GEO_POINT, Arrays.asList(OntologyType.KEYWORD, OntologyType.TEXT));
        ontologyTypeMap.put(OntologyType.ENUM, Arrays.asList(OntologyType.KEYWORD, OntologyType.TEXT));
        return ontologyTypeMap;
    }

    @Override
    public RequestResponse<OntologyModel> importOntologies(boolean forceUpdate, List<OntologyModel> ontologyModelList) throws VitamException, IOException {
        return this.importOntologies(forceUpdate, ontologyModelList, false);
    }

    @Override
    public RequestResponse<OntologyModel> importInternalOntologies(List<OntologyModel> ontologyInternalModelList) throws VitamException, IOException {
        if (this.isExternalOntologies(ontologyInternalModelList)) {
            String error = "Import ontologies error : The imported ontologies contains EXTERNAL fields.";
            LOGGER.error("Import ontologies error : The imported ontologies contains EXTERNAL fields.");
            return this.getVitamError(VitamCode.ONTOLOGY_IMPORT_ERROR.getItem(), "Import ontologies error : The imported ontologies contains EXTERNAL fields.", StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        return this.importOntologies(true, ontologyInternalModelList, true);
    }

    private RequestResponse<OntologyModel> importOntologies(boolean forceUpdate, List<OntologyModel> ontologyModelList, boolean externalOntologyUpdate) throws VitamException, IOException {
        ParametersChecker.checkParameter((String)ONTOLOGIES_IS_MANDATORY_PARAMETER, (Object[])new Object[]{ontologyModelList});
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        HashMap<String, List<ErrorReportOntologies>> errors = new HashMap<String, List<ErrorReportOntologies>>();
        OntologyManager manager = new OntologyManager(this.logbookOperationsClientFactory, eip, errors);
        manager.logStarted(ONTOLOGY_IMPORT_EVENT, null);
        try {
            VitamError checkResults = this.ontologyCommonChecks(ontologyModelList, externalOntologyUpdate, eip, errors, manager, false);
            if (checkResults != null) {
                return checkResults;
            }
            this.computeMissingAttributes(ontologyModelList);
            List<OntologyModel> actualOntologies = this.selectOntologies();
            List actualInternals = actualOntologies.stream().filter(om -> om.getOrigin().equals((Object)OntologyOrigin.INTERNAL)).collect(Collectors.toList());
            Map<String, OntologyModel> actualOntologiesMap = actualOntologies.stream().collect(Collectors.toMap(OntologyModel::getIdentifier, item -> item));
            ArrayList<OntologyModel> toDelete = new ArrayList<OntologyModel>();
            ArrayList<OntologyModel> toCreate = new ArrayList<OntologyModel>();
            ArrayList<OntologyModel> toUpdate = new ArrayList<OntologyModel>();
            HashSet<String> importedOntologyIdentifiers = new HashSet<String>();
            for (OntologyModel ontm : ontologyModelList) {
                if (actualOntologiesMap.containsKey(ontm.getIdentifier())) {
                    toUpdate.add(ontm);
                } else {
                    toCreate.add(ontm);
                }
                importedOntologyIdentifiers.add(ontm.getIdentifier());
            }
            if (externalOntologyUpdate) {
                for (OntologyModel actualTenantOntology : actualInternals) {
                    if (importedOntologyIdentifiers.contains(actualTenantOntology.getIdentifier())) continue;
                    toDelete.add(actualTenantOntology);
                }
            } else {
                for (OntologyModel actualTenantOntology : actualOntologies) {
                    if (importedOntologyIdentifiers.contains(actualTenantOntology.getIdentifier())) continue;
                    toDelete.add(actualTenantOntology);
                }
            }
            if (!forceUpdate) {
                this.checkTypeChangeCompatibility(toUpdate, actualOntologiesMap, manager, errors);
                this.checkUsedByArchiveUnitProfileValidator(toDelete, manager, errors);
                this.checkInternalFieldDelete(toDelete, manager, errors);
            }
            this.rejectOntologiesToDeleteUsedInSchema(toDelete, manager, errors);
            VitamError coherenceErrors = this.abortOnErrors(eip, errors, manager);
            if (coherenceErrors != null) {
                return coherenceErrors;
            }
            this.commitToDatabase(actualOntologiesMap, toDelete, toCreate, toUpdate);
            this.backupDatabaseToOffers(eip);
            InputStream errorStream = this.generateReportOK(toCreate, toDelete, toUpdate, eip);
            this.backupReport(errorStream, eip);
        }
        catch (SchemaValidationException e) {
            LOGGER.error((Throwable)e);
            String err = "Import ontologies schema error > " + e.getMessage();
            HashMap<String, List<ErrorReportOntologies>> exception = new HashMap<String, List<ErrorReportOntologies>>();
            ErrorReportOntologies errorReport = new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_EXCEPTION, "", err, null);
            exception.put(err, Collections.singletonList(errorReport));
            InputStream errorStream = this.generateErrorReport(exception, StatusCode.KO, eip);
            manager.logValidationError(CTR_SCHEMA, null, err);
            this.backupReport(errorStream, eip);
            manager.logFatalError(ONTOLOGY_IMPORT_EVENT, null, null);
            return this.getVitamError(VitamCode.ONTOLOGY_VALIDATION_ERROR.getItem(), err, StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (OntologyInternalExternalConflictException e) {
            LOGGER.error((Throwable)e);
            String error = "Import/upgrade ontologies error : ";
            String err = error + e.getMessage();
            HashMap<String, List<ErrorReportOntologies>> exception = new HashMap<String, List<ErrorReportOntologies>>();
            ErrorReportOntologies errorReport = new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_INTERNAL_EXTERNAL_CONFLICT_EXCEPTION, "the merge between internal and external ontologies didn't succeed, correct the conflict", err, null);
            exception.put(error, Collections.singletonList(errorReport));
            InputStream errorStream = this.generateErrorReport(exception, StatusCode.KO, eip);
            this.backupReport(errorStream, eip);
            manager.logFatalError(ONTOLOGY_IMPORT_EVENT, null, err);
            return this.getVitamError(VitamCode.ONTOLOGY_IMPORT_ERROR.getItem(), err, StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            String err = "Import ontologies error : " + e.getMessage();
            HashMap<String, List<ErrorReportOntologies>> exception = new HashMap<String, List<ErrorReportOntologies>>();
            ErrorReportOntologies errorReport = new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_EXCEPTION, "", err, null);
            exception.put(err, Collections.singletonList(errorReport));
            InputStream errorStream = this.generateErrorReport(exception, StatusCode.KO, eip);
            this.backupReport(errorStream, eip);
            manager.logFatalError(ONTOLOGY_IMPORT_EVENT, null, err);
            return this.getVitamError(VitamCode.ONTOLOGY_IMPORT_ERROR.getItem(), err, StatusCode.KO).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        manager.logSuccess(ONTOLOGY_IMPORT_EVENT, null, null);
        return new RequestResponseOK().addAllResults(ontologyModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
    }

    private void computeMissingAttributes(List<OntologyModel> ontologyModelList) {
        ontologyModelList.forEach(ontology -> {
            if (ontology.getTypeDetail() == null) {
                ontology.setTypeDetail(TypeDetail.fromOntologyType((OntologyType)ontology.getType()));
            }
            if (TypeDetail.STRING.equals((Object)ontology.getTypeDetail()) && ontology.getStringSize() == null) {
                ontology.setStringSize(StringSize.MEDIUM);
            }
        });
    }

    @Override
    public RequestResponse<OntologyModel> checkUpgradeOntologies(List<OntologyModel> ontologyInternalModelList) throws VitamException {
        if (this.isExternalOntologies(ontologyInternalModelList)) {
            LOGGER.error("Import ontologies error : The imported ontologies contains EXTERNAL fields.");
            return new RequestResponseOK().setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        return this.check(ontologyInternalModelList);
    }

    private RequestResponse<OntologyModel> check(List<OntologyModel> ontologyInternalModelList) throws VitamException {
        ParametersChecker.checkParameter((String)ONTOLOGIES_IS_MANDATORY_PARAMETER, (Object[])new Object[]{ontologyInternalModelList});
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        HashMap<String, List<ErrorReportOntologies>> errors = new HashMap<String, List<ErrorReportOntologies>>();
        OntologyManager manager = new OntologyManager(this.logbookOperationsClientFactory, eip, errors);
        manager.logStarted(CHECK_ONTOLOGY_IMPORT_EVENT, null);
        try {
            VitamError checkResults = this.ontologyCommonChecks(ontologyInternalModelList, true, eip, errors, manager, true);
            if (checkResults != null) {
                return checkResults;
            }
        }
        catch (SchemaValidationException e) {
            LOGGER.error((Throwable)e);
            manager.logValidationError(CTR_SCHEMA, null, e.getMessage());
            return this.getVitamError(VitamCode.ONTOLOGY_CHECK_ERROR.getItem(), "Import ontology errors : " + e.getMessage(), StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (OntologyInternalExternalConflictException e) {
            LOGGER.error((Throwable)e);
            manager.logValidationError(CHECK_ONTOLOGY_IMPORT_EVENT, null, e.getMessage());
            return this.getVitamError(VitamCode.ONTOLOGY_CHECK_ERROR.getItem(), "Import ontology errors : " + e.getMessage(), StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            manager.logFatalError(CHECK_ONTOLOGY_IMPORT_EVENT, null, "Import ontologies error : " + e.getMessage());
            return this.getVitamError(VitamCode.ONTOLOGY_CHECK_ERROR.getItem(), "Import ontology errors : " + e.getMessage(), StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        manager.logSuccess(CHECK_ONTOLOGY_IMPORT_EVENT, null, null);
        return new RequestResponseOK().addAllResults(ontologyInternalModelList).setHttpCode(Response.Status.OK.getStatusCode());
    }

    private VitamError ontologyCommonChecks(List<OntologyModel> ontologyModelList, boolean externalOntologyUpdate, GUID eip, Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager, boolean check) throws VitamException, IOException {
        VitamError requestValidationErrors;
        VitamError tenantValidationErrors;
        this.checkAdminTenant(manager, errors);
        VitamError vitamError = tenantValidationErrors = check ? this.exitCheckOnErrors(errors, manager) : this.abortOnErrors(eip, errors, manager);
        if (tenantValidationErrors != null) {
            return tenantValidationErrors;
        }
        this.validateRequest(ontologyModelList, errors, manager);
        VitamError vitamError2 = requestValidationErrors = check ? this.exitCheckOnErrors(errors, manager) : this.abortOnErrors(eip, errors, manager);
        if (requestValidationErrors != null) {
            return requestValidationErrors;
        }
        List<OntologyModel> actualOntologies = this.selectOntologies();
        if (externalOntologyUpdate) {
            List<OntologyModel> actualExternalOntologies = actualOntologies.stream().filter(om -> om.getOrigin().equals((Object)OntologyOrigin.EXTERNAL)).collect(Collectors.toList());
            this.checkInternalWithExistingExternalConflict(ontologyModelList, actualExternalOntologies);
        }
        return null;
    }

    private boolean isExternalOntologies(List<OntologyModel> ontologyInternalModelList) {
        return ontologyInternalModelList.stream().anyMatch(oM -> oM.getOrigin().equals((Object)OntologyOrigin.EXTERNAL));
    }

    private void checkInternalWithExistingExternalConflict(List<OntologyModel> ontologyModelList, List<OntologyModel> actualExternalOntologies) throws OntologyInternalExternalConflictException {
        Map<String, OntologyModel> currentImportedOntologiesMap = ontologyModelList.stream().collect(Collectors.toMap(oM -> oM.getIdentifier().toLowerCase(), item -> item));
        ArrayList<OntologyModel> conflictModels = new ArrayList<OntologyModel>();
        ArrayList<OntologyModel> existingModels = new ArrayList<OntologyModel>();
        for (OntologyModel ontm : actualExternalOntologies) {
            if (ParametersChecker.isNotEmpty((String[])new String[]{ontm.getIdentifier()}) && currentImportedOntologiesMap.containsKey(ontm.getIdentifier().trim().toLowerCase())) {
                conflictModels.add(currentImportedOntologiesMap.get(ontm.getIdentifier().toLowerCase()));
                existingModels.add(ontm);
            }
            if (conflictModels.isEmpty()) continue;
            String message = String.format("There is conflict between Ontologies being imported and those already exists in database : expected =  %s  but found = %s ", conflictModels.stream().map(Objects::toString).collect(Collectors.joining(", ")), existingModels.stream().map(Objects::toString).collect(Collectors.joining(", ")));
            throw new OntologyInternalExternalConflictException(message);
        }
    }

    private VitamError exitCheckOnErrors(Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager) throws VitamException {
        VitamError vitamError = null;
        if (!errors.isEmpty()) {
            String errorsDetails = errors.entrySet().stream().map(c -> (String)c.getKey() + " : " + ((ErrorReportOntologies)((List)c.getValue()).get(0)).getMessage()).collect(Collectors.joining(","));
            manager.logValidationError(ONTOLOGY_IMPORT_EVENT, null, errorsDetails);
            vitamError = this.getVitamError(VitamCode.ONTOLOGY_CHECK_ERROR.getItem(), "Check ontology errors : " + errorsDetails, StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        return vitamError;
    }

    private VitamError abortOnErrors(GUID eip, Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager) throws VitamException, IOException {
        VitamError vitamError = null;
        if (!errors.isEmpty()) {
            String errorsDetails = errors.entrySet().stream().map(c -> (String)c.getKey() + ": " + ((ErrorReportOntologies)((List)c.getValue()).get(0)).getMessage()).collect(Collectors.joining("; "));
            InputStream errorStream = this.generateErrorReport(errors, StatusCode.OK, eip);
            this.backupReport(errorStream, eip);
            manager.logValidationError(ONTOLOGY_IMPORT_EVENT, null, errorsDetails);
            vitamError = this.getVitamError(VitamCode.ONTOLOGY_IMPORT_ERROR.getItem(), errorsDetails, StatusCode.KO).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        return vitamError;
    }

    private void checkAdminTenant(OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        if (ADMIN_TENANT.equals(ParameterHelper.getTenantParameter())) {
            return;
        }
        manager.addError(UND_ID, new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_NOT_AUTHORIZED_FOR_TENANT, "Identifier", "Ontology import not authorized for tenant", null), errors);
    }

    private void validateRequest(List<OntologyModel> ontologyModelList, Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager) {
        this.checkForbiddenFields(ontologyModelList, manager, errors);
        this.checkMandatoryFields(ontologyModelList, manager, errors);
        this.checkInvalidFieldFormat(ontologyModelList, manager, errors);
        this.checkDuplicates(ontologyModelList, errors, manager);
        this.checkFieldsCoherence(ontologyModelList, errors, manager);
    }

    private void checkForbiddenFields(List<OntologyModel> ontologyModelList, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        for (OntologyModel ontology : ontologyModelList) {
            if (null == ontology.getId()) continue;
            manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_ID_NOT_ALLOWED_IN_CREATE, "id", "Forbidden field id", ontology), errors);
        }
    }

    private void checkMandatoryFields(List<OntologyModel> ontologyModelList, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        for (OntologyModel ontology : ontologyModelList) {
            if (ontology.getIdentifier() == null || ontology.getIdentifier().isEmpty()) {
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_MISSING_INFORMATION, "Identifier", "The field Identifier is mandatory", ontology), errors);
            }
            if (ontology.getType() == null) {
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_MISSING_INFORMATION, "Type", "The field Type is mandatory", ontology), errors);
            }
            if (ontology.getOrigin() == null) {
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_MISSING_INFORMATION, "Origin", "The field Origin is mandatory", ontology), errors);
            }
            if (!OntologyOrigin.INTERNAL.equals((Object)ontology.getOrigin())) continue;
            if (ontology.getTypeDetail() == null) {
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_MISSING_INFORMATION, "TypeDetail", "The field TypeDetail is mandatory for internal ontology", ontology), errors);
            }
            if (!TypeDetail.STRING.equals((Object)ontology.getTypeDetail()) || ontology.getStringSize() != null) continue;
            manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_MISSING_INFORMATION, "StringSize", "The field StringSize is mandatory for internal ontology with STRING TypeDetail", ontology), errors);
        }
    }

    private void checkInvalidFieldFormat(List<OntologyModel> ontologyModelList, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        String now = LocalDateUtil.nowFormatted();
        ontologyModelList.forEach(ontology -> {
            Matcher matcher;
            if (ontology.getOrigin() == OntologyOrigin.EXTERNAL && ParametersChecker.isNotEmpty((String[])new String[]{ontology.getIdentifier()}) && (matcher = INVALID_IDENTIFIER_PATTERN.matcher(ontology.getIdentifier())).find()) {
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_INVALID_PARAMETER, "Identifier", "Invalid field Identifier", ontology), errors);
            }
            try {
                String date = StringUtils.isBlank((CharSequence)ontology.getCreationdate()) ? now : LocalDateUtil.getFormattedDateTimeForMongo((String)ontology.getCreationdate());
                ontology.setCreationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)date));
            }
            catch (Exception e) {
                LOGGER.error("Error ontology parse dates", (Throwable)e);
                manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_INVALID_PARAMETER, "CreationDate", "Invalid field CreationDate", ontology), errors);
            }
            ontology.setLastupdate(now);
        });
    }

    private void checkDuplicates(List<OntologyModel> ontologyModelList, Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager) {
        HashSet<String> ontologyIdentifiers = new HashSet<String>();
        for (OntologyModel ontm : ontologyModelList) {
            if (!ParametersChecker.isNotEmpty((String[])new String[]{ontm.getIdentifier()})) continue;
            if (ontologyIdentifiers.contains(ontm.getIdentifier().trim().toLowerCase())) {
                manager.addError(ontm.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_IDENTIFIER_ALREADY_IN_ONTOLOGY, "Identifier", "Ontology identifier " + ontm.getIdentifier() + " already exists in the json file", ontm), errors);
                continue;
            }
            ontologyIdentifiers.add(ontm.getIdentifier().trim().toLowerCase());
            if (ontm.getSedaField() == null) continue;
            ontologyIdentifiers.add(ontm.getSedaField().trim().toLowerCase());
        }
    }

    private void checkFieldsCoherence(List<OntologyModel> ontologyModelList, Map<String, List<ErrorReportOntologies>> errors, OntologyManager manager) {
        ontologyModelList.stream().filter(ontology -> ontology.getTypeDetail() != null && !ontology.getTypeDetail().isCompatibleWithType(ontology.getType())).forEach(ontology -> manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_INCOMPATIBLE_TYPES, "TypeDetail", "The type detail " + ontology.getTypeDetail() + " is not compatible with the type " + ontology.getType(), ontology), errors));
        ontologyModelList.stream().filter(ontology -> ontology.getStringSize() != null && !TypeDetail.STRING.equals((Object)ontology.getTypeDetail())).forEach(ontology -> manager.addError(ontology.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_STRING_SIZE_FORBIDDEN, "StringSize", "The string size attribute is not authorized for type detail " + ontology.getTypeDetail() + " (only for " + TypeDetail.STRING + " type detail)", ontology), errors));
    }

    private void checkTypeChangeCompatibility(List<OntologyModel> toUpdate, Map<String, OntologyModel> currentOntologiesMap, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        for (OntologyModel ontm : toUpdate) {
            List<OntologyType> compatibleTypes;
            OntologyModel modelInDb = currentOntologiesMap.get(ontm.getIdentifier());
            OntologyType typeInDb = modelInDb.getType();
            OntologyType newType = ontm.getType();
            if (newType.name().equalsIgnoreCase(typeInDb.toString()) || (compatibleTypes = typeMap.get(typeInDb)).contains(newType)) continue;
            manager.addError(ontm.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_UPDATE_INVALID_TYPE, "Type", "Change of type from " + typeInDb + " to " + newType + " is not possible", ontm), errors);
        }
    }

    private void checkInternalFieldDelete(List<OntologyModel> toDelete, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        for (OntologyModel ontm : toDelete) {
            if (!OntologyOrigin.INTERNAL.equals((Object)ontm.getOrigin())) continue;
            manager.addError(ontm.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_DELETE_NOT_AUTHORIZED, "Identifier", "header \"Force-Update\" must be true", ontm), errors);
        }
    }

    private void checkUsedByArchiveUnitProfileValidator(List<OntologyModel> toDelete, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        List<ArchiveUnitProfile> archiveUnitProfiles = this.selectArchiveUnitProfiles();
        ArrayListValuedHashMap archiveUnitProfileByFieldName = new ArrayListValuedHashMap();
        for (ArchiveUnitProfile archiveUnitProfileModel : archiveUnitProfiles) {
            for (String field : archiveUnitProfileModel.getList((Object)"Fields", String.class, Collections.emptyList())) {
                archiveUnitProfileByFieldName.put((Object)field, (Object)archiveUnitProfileModel);
            }
        }
        for (OntologyModel ontologyToDelete : toDelete) {
            if (!ParametersChecker.isNotEmpty((String[])new String[]{ontologyToDelete.getIdentifier()})) continue;
            for (ArchiveUnitProfile archiveUnitProfile : archiveUnitProfileByFieldName.get((Object)ontologyToDelete.getIdentifier())) {
                manager.addError(ontologyToDelete.getIdentifier(), new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_DELETE_USED_ONTOLOGY, "Identifier", "Field Identifier used by ArchiveUnitProfile " + archiveUnitProfile.getIdentifier() + " of tenant " + archiveUnitProfile.getTenantId(), ontologyToDelete), errors);
            }
        }
    }

    private void rejectOntologiesToDeleteUsedInSchema(List<OntologyModel> ontologiesToDelete, OntologyManager manager, Map<String, List<ErrorReportOntologies>> errors) {
        List schemaModels = IterableUtils.toList((Iterable)FunctionalAdminCollections.SCHEMA.getCollection().find());
        schemaModels.forEach(schema -> {
            String[] pathFragments = schema.getPath().split("[.]");
            String lastFragment = pathFragments.length == 0 ? schema.getPath() : pathFragments[pathFragments.length - 1];
            ontologiesToDelete.forEach(ontologyModel -> {
                boolean isOntologyUsedInSchema = lastFragment.equals(ontologyModel.getIdentifier());
                if (isOntologyUsedInSchema) {
                    String message = String.format("Ontology identifier '%s' is still used in schema path '%s'", ontologyModel.getIdentifier(), schema.getPath());
                    ErrorReportOntologies errorReportOntologies = new ErrorReportOntologies(OntologyErrorCode.STP_IMPORT_ONTOLOGIES_DELETE_USED_ONTOLOGY, "Identifier", message, ontologyModel);
                    manager.addError(ontologyModel.getIdentifier(), errorReportOntologies, errors);
                }
            });
        });
    }

    private void commitToDatabase(Map<String, OntologyModel> currentOntologiesMap, List<OntologyModel> toDelete, List<OntologyModel> toCreate, List<OntologyModel> toUpdate) throws ReferentialException, SchemaValidationException, InvalidParseOperationException, InvalidCreateOperationException, BadRequestException, DocumentAlreadyExistsException {
        this.deleteOntologies(toDelete);
        this.createOntologies(toCreate);
        this.updateOntologies(currentOntologiesMap, toUpdate);
    }

    private void backupDatabaseToOffers(GUID eip) throws VitamException {
        this.functionalBackupService.saveCollectionAndSequence(eip, BACKUP_ONTOLOGY_EVENT, FunctionalAdminCollections.ONTOLOGY, eip.toString());
    }

    private List<ArchiveUnitProfile> selectArchiveUnitProfiles() {
        FindIterable find = FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE.getCollection().find();
        return IterableUtils.toList((Iterable)find);
    }

    private List<OntologyModel> selectOntologies() throws ReferentialException, InvalidParseOperationException {
        Select select = new Select();
        DbRequestResult result = this.mongoAccess.findDocuments((JsonNode)select.getFinalSelect(), FunctionalAdminCollections.ONTOLOGY);
        return result.getDocuments(Ontology.class, OntologyModel.class);
    }

    @Override
    public RequestResponseOK<OntologyModel> findOntologiesForCache(JsonNode queryDsl) throws InvalidParseOperationException {
        RequestResponseOK response = new RequestResponseOK(queryDsl);
        FindIterable documents = FunctionalAdminCollections.ONTOLOGY.getCollection().find();
        for (Ontology document : documents) {
            response.addResult((Object)((OntologyModel)BsonHelper.fromDocumentToObject((Document)document, OntologyModel.class)));
        }
        return response;
    }

    private void createOntologies(List<OntologyModel> toCreate) throws ReferentialException, SchemaValidationException, InvalidParseOperationException, DocumentAlreadyExistsException {
        if (toCreate.isEmpty()) {
            return;
        }
        Integer tenant = ParameterHelper.getTenantParameter();
        ArrayNode ontologiesToCreate = JsonHandler.createArrayNode();
        for (OntologyModel ontm : toCreate) {
            ontm.setId(GUIDFactory.newOntologyGUID((int)tenant).getId());
            ontm.setTenant(tenant);
            JsonNode ontologyNode = this.buildOntologyNode(ontm);
            ontologiesToCreate.add(ontologyNode);
        }
        this.mongoAccess.insertDocuments(ontologiesToCreate, FunctionalAdminCollections.ONTOLOGY).close();
    }

    private JsonNode buildOntologyNode(OntologyModel ontm) throws InvalidParseOperationException {
        JsonNode hashTenant;
        ObjectNode ontologyNode = (ObjectNode)JsonHandler.toJsonNode((Object)ontm);
        JsonNode jsonNode = ontologyNode.remove(VitamFieldsHelper.id());
        if (jsonNode != null) {
            ontologyNode.set(UND_ID, jsonNode);
        }
        if ((hashTenant = ontologyNode.remove(VitamFieldsHelper.tenant())) != null) {
            ontologyNode.set(UND_TENANT, hashTenant);
        }
        return ontologyNode;
    }

    @Override
    public RequestResponseOK<OntologyModel> findOntologies(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.ONTOLOGY);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, Ontology.class, OntologyModel.class);
            return requestResponseOK;
        }
    }

    private VitamError getVitamError(String vitamCode, String error, StatusCode statusCode) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)"Ontology", (StatusCode)statusCode);
    }

    private void updateOntologies(Map<String, OntologyModel> currentOntologiesMap, List<OntologyModel> toUpdate) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException, SchemaValidationException, BadRequestException {
        if (toUpdate.isEmpty()) {
            return;
        }
        for (OntologyModel ontology : toUpdate) {
            OntologyModel currentOntology = currentOntologiesMap.get(ontology.getIdentifier());
            ontology.setTenant(ParameterHelper.getTenantParameter());
            ontology.setId(currentOntology.getId());
            ontology.setDescription(Optional.ofNullable(ontology.getDescription()).orElse(""));
            ontology.setApiField(Optional.ofNullable(ontology.getApiField()).orElse(""));
            ontology.setSedaField(Optional.ofNullable(ontology.getSedaField()).orElse(""));
            ontology.setShortName(Optional.ofNullable(ontology.getShortName()).orElse(""));
            boolean ontologyHasChanged = !EqualsBuilder.reflectionEquals((Object)ontology, (Object)currentOntology, (String[])new String[]{"version", "creationdate", "lastupdate"});
            if (!ontologyHasChanged) continue;
            this.updateOntology(ontology);
        }
    }

    private void updateOntology(OntologyModel ontologyModel) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException, SchemaValidationException, BadRequestException {
        UpdateParserSingle updateParser = new UpdateParserSingle(new VarNameAdapter());
        Update updateOntologies = new Update();
        updateOntologies.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)ontologyModel.getIdentifier()));
        updateOntologies.addActions(new Action[]{new SetAction("Description", ontologyModel.getDescription()), new SetAction("LastUpdate", LocalDateUtil.nowFormatted()), new SetAction("ApiField", ontologyModel.getApiField()), new SetAction("SedaField", ontologyModel.getSedaField()), new SetAction("Type", ontologyModel.getType().toString()), new SetAction("ShortName", ontologyModel.getShortName()), new SetAction("Collections", (List)Optional.ofNullable(ontologyModel.getCollections()).orElse(new ArrayList())), new SetAction("TypeDetail", ontologyModel.getTypeDetail().toString()), ontologyModel.getStringSize() == null ? new UnsetAction(new String[]{"StringSize"}) : new SetAction("StringSize", ontologyModel.getStringSize().toString())});
        updateParser.parse((JsonNode)updateOntologies.getFinalUpdate());
        ObjectNode queryDslForUpdate = updateParser.getRequest().getFinalUpdate();
        this.mongoAccess.updateData((JsonNode)queryDslForUpdate, FunctionalAdminCollections.ONTOLOGY);
    }

    private void deleteOntologies(List<OntologyModel> ontologyModels) {
        if (ontologyModels.isEmpty()) {
            return;
        }
        try {
            List ontologyIdentifiers = ontologyModels.stream().map(OntologyModel::getIdentifier).collect(Collectors.toList());
            for (List ids : ListUtils.partition(ontologyIdentifiers, (int)VitamConfiguration.getBatchSize())) {
                Delete delete = new Delete();
                delete.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])ids.toArray(new String[0])));
                this.mongoAccess.deleteCollectionForTesting(FunctionalAdminCollections.ONTOLOGY, delete);
            }
        }
        catch (InvalidCreateOperationException | DatabaseException e) {
            throw new RuntimeException("Could not delete ontologies", e);
        }
    }

    private InputStream generateErrorReport(Map<String, List<ErrorReportOntologies>> errors, StatusCode status, GUID eipMaster) {
        ObjectNode reportFinal = JsonHandler.createObjectNode();
        ObjectNode guidmasterNode = JsonHandler.createObjectNode();
        ObjectNode lineNode = JsonHandler.createObjectNode();
        guidmasterNode.put("evType", ONTOLOGY_IMPORT_EVENT);
        guidmasterNode.put("evDateTime", LocalDateUtil.nowFormatted());
        if (eipMaster != null) {
            guidmasterNode.put("evId", eipMaster.toString());
        }
        guidmasterNode.put("outMessg", VitamErrorMessages.getFromKey((String)("IMPORT_ONTOLOGY." + status)));
        for (String identifier : errors.keySet()) {
            List<ErrorReportOntologies> errorsReports = errors.get(identifier);
            ArrayNode messagesArrayNode = JsonHandler.createArrayNode();
            for (ErrorReportOntologies error : errorsReports) {
                ObjectNode errorNode = JsonHandler.createObjectNode();
                if (error.getOntologyModel() != null) {
                    errorNode.put(IDENTIFIER, error.getOntologyModel().getIdentifier());
                }
                errorNode.put("Code", error.getCode() + ".KO");
                errorNode.put("Message", error.getMessage());
                errorNode.put("Information additionnelle", error.getFieldName());
                messagesArrayNode.add((JsonNode)errorNode);
            }
            lineNode.set(identifier, (JsonNode)messagesArrayNode);
        }
        reportFinal.set("Operation", (JsonNode)guidmasterNode);
        if (!errors.isEmpty()) {
            reportFinal.set("error", (JsonNode)lineNode);
        }
        String json = JsonHandler.unprettyPrint((Object)reportFinal);
        return new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
    }

    private InputStream generateReportOK(List<OntologyModel> createdOntologies, List<OntologyModel> deletedOntologies, List<OntologyModel> updatedOntologies, GUID eip) {
        ObjectNode reportFinal = JsonHandler.createObjectNode();
        ObjectNode guidmasterNode = JsonHandler.createObjectNode();
        ArrayNode deletedArrayNode = JsonHandler.createArrayNode();
        ArrayNode createdArrayNode = JsonHandler.createArrayNode();
        ArrayNode updatedArrayNode = JsonHandler.createArrayNode();
        guidmasterNode.put("evType", ONTOLOGY_IMPORT_EVENT);
        guidmasterNode.put("evDateTime", LocalDateUtil.nowFormatted());
        guidmasterNode.put("evId", eip.toString());
        guidmasterNode.put("outMessg", ONTOLOGY_IMPORT_EVENT);
        for (OntologyModel ontologyModel : createdOntologies) {
            createdArrayNode.add(ontologyModel.getIdentifier());
        }
        for (OntologyModel ontologyModel : updatedOntologies) {
            updatedArrayNode.add(ontologyModel.getIdentifier());
        }
        for (OntologyModel ontologyModel : deletedOntologies) {
            deletedArrayNode.add(ontologyModel.getIdentifier());
        }
        reportFinal.set("Operation", (JsonNode)guidmasterNode);
        reportFinal.set(DELETED_ONTOLOGIES, (JsonNode)deletedArrayNode);
        reportFinal.set(UPDATED_ONTOLOGIES, (JsonNode)updatedArrayNode);
        reportFinal.set(CREATED_ONTOLOGIES, (JsonNode)createdArrayNode);
        String json = JsonHandler.unprettyPrint((Object)reportFinal);
        return new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
    }

    private void backupReport(InputStream stream, GUID eip) throws VitamException, IOException {
        this.functionalBackupService.saveFile(stream, eip, ONTOLOGIES_REPORT, DataCategory.REPORT, eip + ".json");
        stream.close();
    }
}

