/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.ontologies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.ErrorReportOntologies;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OntologyManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OntologyManager.class);
    private final Map<String, List<ErrorReportOntologies>> errors;
    private final GUID eip;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public OntologyManager(LogbookOperationsClientFactory logbookOperationsClientFactory, GUID eip, Map<String, List<ErrorReportOntologies>> errors) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.eip = eip;
        this.errors = errors;
    }

    public void addError(String identifier, ErrorReportOntologies error, Map<String, List<ErrorReportOntologies>> errors) {
        List<ErrorReportOntologies> lineErrors = this.errors.get(identifier);
        if (lineErrors == null) {
            lineErrors = new ArrayList<ErrorReportOntologies>();
        }
        lineErrors.add(error);
        errors.put(identifier, lineErrors);
    }

    public void logValidationError(String eventType, String objectId, String errorsDetails) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.KO), (GUID)this.eip);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    private void logbookMessageError(String objectId, String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("ontologyCheck", errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
    }

    public void logFatalError(String eventType, String objectId, String errorsDetails) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
        this.logbookMessageError(objectId, errorsDetails, logbookParameters);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    public void logStarted(String eventType, String objectId) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        this.logbookMessageError(objectId, null, logbookParameters);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.create(new LogbookOperationParameters[]{logbookParameters});
        }
    }

    public void logSuccess(String eventType, String objectId, String message) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)this.eip);
        if (null != objectId && !objectId.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, objectId);
        }
        if (null != message && !message.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, message);
        }
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookParameters});
        }
    }
}

