/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicy;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierUsage;
import fr.gouv.vitam.common.model.administration.StorageDetailModel;
import fr.gouv.vitam.common.model.administration.VersionRetentionPolicyModel;
import fr.gouv.vitam.common.model.administration.VersionUsageModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.ManagementContract;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.contract.ContractHelper;
import fr.gouv.vitam.functional.administration.core.contract.ContractLogbookService;
import fr.gouv.vitam.functional.administration.core.contract.ContractService;
import fr.gouv.vitam.functional.administration.core.contract.GenericContractValidator;
import fr.gouv.vitam.functional.administration.core.contract.ManagementContractValidator;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyReferentOfferException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.EnumUtils;

public class ManagementContractImpl
implements ContractService<ManagementContractModel> {
    public static final String CONTRACT_BACKUP_EVENT = "STP_BACKUP_MANAGEMENT_CONTRACT";
    public static final String INVALID_INTERMEDIARY_VERSION_TYPE = "%s is an invalid intermediary version type.";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ManagementContractImpl.class);
    private static final String MANAGEMENT_CONTRACT_NOT_FOUND = "Management contract not found";
    private static final String CONTRACT_IS_MANDATORY_PARAMETER = "The collection of management contracts is mandatory";
    private static final String THE_MANAGEMENT_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT = "The management contract status must be ACTIVE or INACTIVE but not ";
    private static final String DATE_MUST_BE_VALID = "must be a valid date";
    private static final String CONTRACTS_IMPORT_EVENT = "STP_IMPORT_MANAGEMENT_CONTRACT";
    private static final String CONTRACT_UPDATE_EVENT = "STP_UPDATE_MANAGEMENT_CONTRACT";
    private static final String EMPTY_REQUIRED_FIELD = "STP_IMPORT_MANAGEMENT_CONTRACT.EMPTY_REQUIRED_FIELD.KO";
    private static final String DUPLICATE_IN_DATABASE = "STP_IMPORT_MANAGEMENT_CONTRACT.IDENTIFIER_DUPLICATION.KO";
    private static final String STRATEGY_VALIDATION_ERROR = "STP_IMPORT_MANAGEMENT_CONTRACT.STRATEGY_VALIDATION_ERROR.KO";
    private static final String CONTRACT_BAD_REQUEST = "STP_IMPORT_MANAGEMENT_CONTRACT.BAD_REQUEST.KO";
    private static final String VERSION_RETENTION_POLICY_VALIDATION_ERROR = "STP_IMPORT_MANAGEMENT_CONTRACT.VERSION_RETENTION_POLICY_ERROR.KO";
    private static final String PERSISTENCE_IDENTIFIER_POLICY_VALIDATION_ERROR = "STP_IMPORT_MANAGEMENT_CONTRACT.PERSISTENCE_IDENTIFIER_POLICY_ERROR.KO";
    private static final String UPDATE_CONTRACT_NOT_FOUND = "STP_UPDATE_MANAGEMENT_CONTRACT.CONTRACT_NOT_FOUND.KO";
    private static final String UPDATE_CONTRACT_BAD_REQUEST = "STP_UPDATE_MANAGEMENT_CONTRACT.BAD_REQUEST.KO";
    private static final String UPDATE_VALUE_NOT_IN_ENUM = "STP_UPDATE_MANAGEMENT_CONTRACT.NOT_IN_ENUM.KO";
    private static final String UPDATE_STRATEGY_VALIDATION_ERROR = "STP_UPDATE_MANAGEMENT_CONTRACT.STRATEGY_VALIDATION_ERROR.KO";
    private static final String UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR = "STP_UPDATE_MANAGEMENT_CONTRACT.VERSION_RETENTION_POLICY_ERROR.KO";
    private static final String UND_TENANT = "_tenant";
    private static final String UND_ID = "_id";
    private static final String CONTRACT_KEY = "ManagementContract";
    private static final String CONTRACT_CHECK_KEY = "managementContractCheck";
    private final MongoDbAccessReferential mongoAccess;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;
    private final StorageClient storageClient;
    private final LogbookOperationsClient logbookClient;

    public ManagementContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService) {
        this(mongoAccess, vitamCounterService, StorageClientFactory.getInstance().getClient(), LogbookOperationsClientFactory.getInstance().getClient(), new FunctionalBackupService(vitamCounterService));
    }

    public ManagementContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, StorageClient storageClient, LogbookOperationsClient logbookOperationsClient, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.functionalBackupService = functionalBackupService;
        this.storageClient = storageClient;
        this.logbookClient = logbookOperationsClient;
    }

    private static VitamError<ManagementContractModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)CONTRACT_KEY, (StatusCode)StatusCode.KO, ManagementContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> createContracts(List<ManagementContractModel> contractModelList) throws VitamException {
        ParametersChecker.checkParameter((String)CONTRACT_IS_MANDATORY_PARAMETER, (Object[])new Object[]{contractModelList});
        if (contractModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.MANAGEMENT_CONTRACT_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        ManagementContractValidationService validationService = new ManagementContractValidationService(this.storageClient, this.mongoAccess);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        logbookService.logStarted();
        VitamError error = ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Management contract import error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            for (ManagementContractModel managementContractModel : contractModelList) {
                if (null != managementContractModel.getId()) {
                    error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectIdNotAllowedInCreate(managementContractModel.getName()).getReason()));
                    continue;
                }
                if (managementContractModel.getVersionRetentionPolicy() == null) {
                    managementContractModel.setVersionRetentionPolicy(new VersionRetentionPolicyModel());
                    managementContractModel.getVersionRetentionPolicy().setInitialVersion(true);
                    managementContractModel.getVersionRetentionPolicy().setIntermediaryVersion(VersionUsageModel.IntermediaryVersionEnum.LAST);
                }
                if (validationService.validateContract(managementContractModel, managementContractModel.getName(), (VitamError<ManagementContractModel>)error)) {
                    managementContractModel.setId(GUIDFactory.newContractGUID((int)ParameterHelper.getTenantParameter()).getId());
                }
                if (managementContractModel.getTenant() == null) {
                    managementContractModel.setTenant(ParameterHelper.getTenantParameter());
                }
                if (!slaveMode) continue;
                Optional<GenericContractValidator.GenericRejectionCause> result = validationService.checkEmptyIdentifierSlaveModeValidator().validate(managementContractModel, managementContractModel.getIdentifier());
                result.ifPresent(t -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ((GenericContractValidator.GenericRejectionCause)result.get()).getReason()).setMessage(EMPTY_REQUIRED_FIELD)));
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).distinct().collect(Collectors.joining(","));
                logbookService.logValidationError(errorsDetails, CONTRACTS_IMPORT_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            ArrayNode contractsToPersist = JsonHandler.createArrayNode();
            for (ManagementContractModel mcm : contractModelList) {
                JsonNode hashTenant;
                ContractHelper.setIdentifier(slaveMode, (AbstractContractModel)mcm, this.vitamCounterService, SequenceType.MANAGEMENT_CONTRACT_SEQUENCE);
                ObjectNode managementContractNode = (ObjectNode)JsonHandler.toJsonNode((Object)mcm);
                JsonNode hashId = managementContractNode.remove(VitamFieldsHelper.id());
                if (hashId != null) {
                    managementContractNode.set(UND_ID, hashId);
                }
                if ((hashTenant = managementContractNode.remove(VitamFieldsHelper.tenant())) != null) {
                    managementContractNode.set(UND_TENANT, hashTenant);
                }
                contractsToPersist.add((JsonNode)managementContractNode);
            }
            this.mongoAccess.insertDocuments(contractsToPersist, FunctionalAdminCollections.MANAGEMENT_CONTRACT).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.MANAGEMENT_CONTRACT, eip.toString());
            logbookService.logSuccess();
            return new RequestResponseOK().addAllResults(contractModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (BadRequestException | SchemaValidationException exp) {
            LOGGER.error(exp);
            String string = "Import management contracts error > " + exp.getMessage();
            logbookService.logValidationError(string, CONTRACTS_IMPORT_EVENT, CONTRACT_BAD_REQUEST);
            return ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(string).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            String string = "Import management contracts error > " + exp.getMessage();
            logbookService.logFatalError(string, CONTRACTS_IMPORT_EVENT);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(string).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public RequestResponse<ManagementContractModel> updateContract(String identifier, JsonNode queryDsl) throws VitamException {
        String err;
        VitamError error = ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Management contract update error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        if (queryDsl == null || !queryDsl.isObject()) {
            return error;
        }
        ManagementContractModel managementContractModel = this.findByIdentifier(identifier);
        if (managementContractModel == null) {
            error.setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            return error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), MANAGEMENT_CONTRACT_NOT_FOUND + identifier).setMessage(UPDATE_CONTRACT_NOT_FOUND));
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        RequestResponseOK response = new RequestResponseOK();
        ManagementContractValidationService validationService = new ManagementContractValidationService(this.storageClient, this.mongoAccess);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        logbookService.logUpdateStarted(managementContractModel.getId());
        boolean isVersionRetentionPolicyUpdated = false;
        JsonNode actionNode = queryDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            Iterator it = fieldName.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = fieldName.findValue(field);
                if (field.contains("VersionRetentionPolicy")) {
                    isVersionRetentionPolicyUpdated = true;
                }
                this.validateUpdateAction(validationService, managementContractModel.getName(), (VitamError<ManagementContractModel>)error, field, value, managementContractModel);
            }
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
        }
        if (managementContractModel.getVersionRetentionPolicy() == null && !isVersionRetentionPolicyUpdated) {
            VersionRetentionPolicyModel versionRetentionPolicyModel = new VersionRetentionPolicyModel();
            versionRetentionPolicyModel.setInitialVersion(true);
            versionRetentionPolicyModel.setIntermediaryVersion(VersionUsageModel.IntermediaryVersionEnum.LAST);
            ObjectNode versionRetentionPolicyNode = JsonHandler.createObjectNode();
            versionRetentionPolicyNode.set("VersionRetentionPolicy", JsonHandler.toJsonNode((Object)versionRetentionPolicyModel));
            ObjectNode setFields = JsonHandler.createObjectNode();
            setFields.set(BuilderToken.UPDATEACTION.SET.exactToken(), (JsonNode)versionRetentionPolicyNode);
            ((ArrayNode)actionNode).add((JsonNode)setFields);
        }
        try {
            if (error.getErrors() != null && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                logbookService.logValidationError(errorsDetails, CONTRACT_UPDATE_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            DbRequestResult result = this.mongoAccess.updateData(queryDsl, FunctionalAdminCollections.MANAGEMENT_CONTRACT);
            Map updateDiffs = result.getDiffs();
            response.addAllResults(result.getDocuments(ManagementContract.class, ManagementContractModel.class)).setTotal(result.getTotal()).setQuery(queryDsl).setHttpCode(Response.Status.OK.getStatusCode());
            result.close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.MANAGEMENT_CONTRACT, managementContractModel.getId());
            logbookService.logUpdateSuccess(managementContractModel.getId(), identifier, (List)updateDiffs.get(managementContractModel.getId()));
            return response;
        }
        catch (BadRequestException | SchemaValidationException exp) {
            LOGGER.error(exp);
            err = "Update management contract error > " + exp.getMessage();
            logbookService.logValidationError(err, CONTRACT_UPDATE_EVENT, UPDATE_CONTRACT_BAD_REQUEST);
            return ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            err = "Update management contract error > " + e.getMessage();
            logbookService.logFatalError(err, CONTRACT_UPDATE_EVENT);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
    }

    @Override
    public ManagementContractModel findByIdentifier(String identifier) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{identifier});
        try (DbRequestResult result = ContractHelper.findByIdentifier(identifier, FunctionalAdminCollections.MANAGEMENT_CONTRACT, this.mongoAccess);){
            List list = result.getDocuments(ManagementContract.class, ManagementContractModel.class);
            if (list.isEmpty()) {
                ManagementContractModel managementContractModel = null;
                return managementContractModel;
            }
            ManagementContractModel managementContractModel = (ManagementContractModel)list.get(0);
            return managementContractModel;
        }
    }

    @Override
    public RequestResponseOK<ManagementContractModel> findContracts(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkJsonAll((JsonNode)queryDsl);
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.MANAGEMENT_CONTRACT);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, ManagementContract.class, ManagementContractModel.class);
            return requestResponseOK;
        }
    }

    public void close() {
        this.logbookClient.close();
        this.storageClient.close();
    }

    private void validateUpdateAction(ManagementContractValidationService validationService, String contractName, VitamError<ManagementContractModel> error, String field, JsonNode value, ManagementContractModel managementContractModel) {
        switch (field) {
            case "Status": {
                if (ActivationStatus.ACTIVE.name().equals(value.asText()) || ActivationStatus.INACTIVE.name().equals(value.asText())) break;
                error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), THE_MANAGEMENT_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "LastUpdate": 
            case "CreationDate": 
            case "ActivationDate": 
            case "DeactivationDate": {
                try {
                    LocalDateUtil.getFormattedDateTimeForMongo((String)value.asText());
                    break;
                }
                catch (DateTimeParseException e) {
                    error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), String.format("%s %s", field, DATE_MUST_BE_VALID)).setMessage(UPDATE_CONTRACT_BAD_REQUEST));
                }
            }
        }
        this.validateStorage(validationService, contractName, error, field, value);
        this.validateVersionRetentionPolicy(validationService, contractName, error, field, value, managementContractModel);
    }

    private void validateStorage(ManagementContractValidationService validationService, String contractName, VitamError<ManagementContractModel> error, String field, JsonNode value) {
        Optional<GenericContractValidator.GenericRejectionCause> rejection;
        ManagementContractModel toValidate;
        if ("Storage".equals(field)) {
            Iterator it = value.fieldNames();
            while (it.hasNext()) {
                String subField = (String)it.next();
                JsonNode subValue = value.findValue(subField);
                this.validateUpdateAction(validationService, contractName, error, subField, subValue, null);
            }
        }
        if ("Storage.ObjectGroupStrategy".equals(field) || "ObjectGroupStrategy".equals(field)) {
            toValidate = new ManagementContractModel();
            toValidate.setStorage(new StorageDetailModel().setObjectGroupStrategy(value.asText()));
            rejection = validationService.checkStorageStrategies().validate(toValidate, contractName);
            rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_STRATEGY_VALIDATION_ERROR)));
        }
        if ("Storage.UnitStrategy".equals(field) || "UnitStrategy".equals(field)) {
            toValidate = new ManagementContractModel();
            toValidate.setStorage(new StorageDetailModel().setUnitStrategy(value.asText()));
            rejection = validationService.checkStorageStrategies().validate(toValidate, contractName);
            rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_STRATEGY_VALIDATION_ERROR)));
        }
        if ("Storage.ObjectStrategy".equals(field) || "ObjectStrategy".equals(field)) {
            toValidate = new ManagementContractModel();
            toValidate.setStorage(new StorageDetailModel().setObjectStrategy(value.asText()));
            rejection = validationService.checkStorageStrategies().validate(toValidate, contractName);
            rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_STRATEGY_VALIDATION_ERROR)));
        }
    }

    private void validateVersionRetentionPolicy(ManagementContractValidationService validationService, String contractName, VitamError<ManagementContractModel> error, String field, JsonNode value, ManagementContractModel managementContractModel) {
        Optional<GenericContractValidator.GenericRejectionCause> rejection;
        if ("VersionRetentionPolicy".equals(field)) {
            Iterator it = value.fieldNames();
            while (it.hasNext()) {
                String subField = (String)it.next();
                JsonNode subValue = value.findValue(subField);
                this.validateUpdateAction(validationService, contractName, error, subField, subValue, managementContractModel);
            }
        }
        ManagementContractModel managementContractModeltoValidate = new ManagementContractModel().setVersionRetentionPolicy(new VersionRetentionPolicyModel());
        if (managementContractModel != null) {
            if (managementContractModel.getVersionRetentionPolicy() == null) {
                managementContractModeltoValidate.setVersionRetentionPolicy(new VersionRetentionPolicyModel());
                managementContractModeltoValidate.getVersionRetentionPolicy().setInitialVersion(true);
                managementContractModeltoValidate.getVersionRetentionPolicy().setIntermediaryVersion(VersionUsageModel.IntermediaryVersionEnum.LAST);
            } else {
                managementContractModeltoValidate.getVersionRetentionPolicy().setInitialVersion(managementContractModel.getVersionRetentionPolicy().getInitialVersion());
                managementContractModeltoValidate.getVersionRetentionPolicy().setIntermediaryVersion(managementContractModel.getVersionRetentionPolicy().getIntermediaryVersion());
            }
        }
        if (List.of("InitialVersion", "VersionRetentionPolicy.InitialVersion").contains(field)) {
            managementContractModeltoValidate.getVersionRetentionPolicy().setInitialVersion(value.asBoolean());
            rejection = validationService.checkVersionRetentionPolicy().validate(managementContractModeltoValidate, contractName);
            rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR)));
        }
        if (List.of("IntermediaryVersion", "VersionRetentionPolicy.IntermediaryVersion").contains(field)) {
            if (EnumUtils.isValidEnum(VersionUsageModel.IntermediaryVersionEnum.class, (String)value.textValue())) {
                managementContractModeltoValidate.getVersionRetentionPolicy().setIntermediaryVersion(VersionUsageModel.IntermediaryVersionEnum.valueOf((String)value.textValue()));
                rejection = validationService.checkVersionRetentionPolicy().validate(managementContractModeltoValidate, contractName);
                rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR)));
            } else {
                error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), String.format(INVALID_INTERMEDIARY_VERSION_TYPE, value.textValue())).setMessage(UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR));
            }
        }
        if (List.of("Usages", "VersionRetentionPolicy.Usages").contains(field)) {
            try {
                Set usages = (Set)JsonHandler.getFromJsonNode((JsonNode)value, (TypeReference)new TypeReference<Set<VersionUsageModel>>(){});
                managementContractModeltoValidate.getVersionRetentionPolicy().setUsages(usages);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error(e.getMessage());
                error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), e.getMessage()).setMessage(UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR));
            }
            rejection = validationService.checkVersionRetentionPolicy().validate(managementContractModeltoValidate, contractName);
            rejection.ifPresent(genericRejectionCause -> error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_VERSION_RETENTION_POLICY_VALIDATION_ERROR)));
        }
    }

    protected static final class ManagementContractValidationService {
        private static final String USAGE_NAME = "UsageName";
        private final Map<ManagementContractValidator, String> validators;
        private final StorageClient storageClient;
        private final MongoDbAccessReferential mongoAccess;

        public ManagementContractValidationService(StorageClient storageClient, MongoDbAccessReferential mongoAccess) {
            this.storageClient = storageClient;
            this.mongoAccess = mongoAccess;
            this.validators = new HashMap<ManagementContractValidator, String>(){
                {
                    this.put(this.createMandatoryParamsValidator(), ManagementContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.createWrongFieldFormatValidator(), ManagementContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.createCheckDuplicateInDatabaseValidator(), ManagementContractImpl.DUPLICATE_IN_DATABASE);
                    this.put(this.checkStorageStrategies(), ManagementContractImpl.STRATEGY_VALIDATION_ERROR);
                    this.put(this.checkVersionRetentionPolicy(), ManagementContractImpl.VERSION_RETENTION_POLICY_VALIDATION_ERROR);
                    this.put(this.checkPersistenceIdentifierPolicy(), ManagementContractImpl.PERSISTENCE_IDENTIFIER_POLICY_VALIDATION_ERROR);
                }
            };
        }

        private boolean validateContract(ManagementContractModel contract, String jsonFormat, VitamError<ManagementContractModel> error) {
            for (ManagementContractValidator validator : this.validators.keySet()) {
                Optional<GenericContractValidator.GenericRejectionCause> result = validator.validate(contract, jsonFormat);
                if (!result.isPresent()) continue;
                error.addToErrors(ManagementContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), result.get().getReason()).setMessage(this.validators.get(validator)));
                return false;
            }
            return true;
        }

        private ManagementContractValidator createMandatoryParamsValidator() {
            return (contract, jsonFormat) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                if (contract.getName() == null || contract.getName().trim().isEmpty()) {
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Name");
                }
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private ManagementContractValidator createWrongFieldFormatValidator() {
            return (contract, inputList) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                String now = LocalDateUtil.nowFormatted();
                if (contract.getStatus() == null) {
                    contract.setStatus(ActivationStatus.INACTIVE);
                }
                try {
                    if (contract.getCreationdate() == null || contract.getCreationdate().trim().isEmpty()) {
                        contract.setCreationdate(now);
                    } else {
                        contract.setCreationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getCreationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error management contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("CreationDate");
                }
                try {
                    if (contract.getActivationdate() == null || contract.getActivationdate().trim().isEmpty()) {
                        contract.setActivationdate(now);
                    } else {
                        contract.setActivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getActivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error management contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("ActivationDate");
                }
                try {
                    if (contract.getDeactivationdate() == null || contract.getDeactivationdate().trim().isEmpty()) {
                        contract.setDeactivationdate(null);
                    } else {
                        contract.setDeactivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getDeactivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error management contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("DeactivationDate");
                }
                contract.setLastupdate(now);
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private ManagementContractValidator createCheckDuplicateInDatabaseValidator() {
            return (contract, contractName) -> {
                if (!ParametersChecker.isNotEmpty((String[])new String[]{contract.getIdentifier()})) return Optional.empty();
                try (DbRequestResult result = ContractHelper.findByIdentifier(contract.getIdentifier(), FunctionalAdminCollections.MANAGEMENT_CONTRACT, this.mongoAccess);){
                    boolean exist = result.getCount() > 0L;
                    if (!exist) return Optional.empty();
                    Optional<GenericContractValidator.GenericRejectionCause> optional = Optional.of(GenericContractValidator.GenericRejectionCause.rejectDuplicatedInDatabase(contract.getIdentifier()));
                    return optional;
                }
                catch (InvalidParseOperationException | ReferentialException e) {
                    throw new VitamRuntimeException(e);
                }
            };
        }

        private ManagementContractValidator checkEmptyIdentifierSlaveModeValidator() {
            return (contract, contractIdentifier) -> {
                if (contractIdentifier == null || contractIdentifier.isEmpty()) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Identifier"));
                }
                return Optional.empty();
            };
        }

        private ManagementContractValidator checkStorageStrategies() {
            return (contract, contractName) -> {
                try {
                    StorageDetailModel storage = contract.getStorage();
                    if (storage == null || storage.getObjectGroupStrategy() == null && storage.getUnitStrategy() == null && storage.getObjectStrategy() == null) {
                        return Optional.empty();
                    }
                    RequestResponse strategiesResponse = this.storageClient.getStorageStrategies();
                    if (!strategiesResponse.isOk()) {
                        LOGGER.error(strategiesResponse.toString());
                        throw new StorageException("Exception while retrieving storage strategies");
                    }
                    List strategies = ((RequestResponseOK)strategiesResponse).getResults();
                    try {
                        if (storage.getObjectGroupStrategy() != null) {
                            StorageStrategyUtils.checkStrategy((String)storage.getObjectGroupStrategy(), (List)strategies, (String)"Storage.ObjectGroupStrategy", (boolean)true);
                        }
                        if (storage.getUnitStrategy() != null) {
                            StorageStrategyUtils.checkStrategy((String)storage.getUnitStrategy(), (List)strategies, (String)"Storage.UnitStrategy", (boolean)true);
                        }
                        if (storage.getObjectStrategy() != null) {
                            StorageStrategyUtils.checkStrategy((String)storage.getObjectStrategy(), (List)strategies, (String)"Storage.ObjectStrategy", (boolean)false);
                        }
                    }
                    catch (StorageStrategyNotFoundException storageStrategyNotFoundException) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectStorageStrategyMissing(storageStrategyNotFoundException.getStrategyId(), storageStrategyNotFoundException.getVariableName()));
                    }
                    catch (StorageStrategyReferentOfferException storageStrategyReferentOfferException) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectStorageStrategyDoesNotContainsOneReferent(storageStrategyReferentOfferException.getStrategyId(), storageStrategyReferentOfferException.getVariableName()));
                    }
                    return Optional.empty();
                }
                catch (Exception e) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExceptionOccurred(contract.getName(), "Error checking storage", e));
                }
            };
        }

        private ManagementContractValidator checkVersionRetentionPolicy() {
            return (contract, contractName) -> {
                try {
                    VersionRetentionPolicyModel versionRetentionPolicy = contract.getVersionRetentionPolicy();
                    if (versionRetentionPolicy == null || !versionRetentionPolicy.getInitialVersion() && versionRetentionPolicy.getIntermediaryVersion() == null) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("InitialVersion", "VersionRetentionPolicy", contractName));
                    }
                    if (!versionRetentionPolicy.getInitialVersion()) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("InitialVersion", "Default", contractName));
                    }
                    if (versionRetentionPolicy.getIntermediaryVersion() == null || !List.of(VersionUsageModel.IntermediaryVersionEnum.LAST, VersionUsageModel.IntermediaryVersionEnum.ALL).contains(versionRetentionPolicy.getIntermediaryVersion())) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("IntermediaryVersion", "Default", contractName));
                    }
                    Set versionsUsages = versionRetentionPolicy.getUsages();
                    if (versionsUsages != null && !versionsUsages.isEmpty()) {
                        for (VersionUsageModel versionUsage : versionsUsages) {
                            if (Arrays.stream(DataObjectVersionType.values()).noneMatch(elmt -> elmt.getName().equals(versionUsage.getUsageName()))) {
                                return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyUsage(versionUsage.getUsageName(), contractName));
                            }
                            if (versionUsage.getUsageName().equals(DataObjectVersionType.BINARY_MASTER.getName())) {
                                if (!versionUsage.getInitialVersion()) {
                                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("InitialVersion", DataObjectVersionType.BINARY_MASTER.getName(), contractName));
                                }
                                if (versionUsage.getIntermediaryVersion() != null && List.of(VersionUsageModel.IntermediaryVersionEnum.LAST, VersionUsageModel.IntermediaryVersionEnum.ALL).contains(versionUsage.getIntermediaryVersion())) continue;
                                return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("IntermediaryVersion", DataObjectVersionType.BINARY_MASTER.getName(), contractName));
                            }
                            if (versionUsage.getIntermediaryVersion() != null && EnumUtils.isValidEnum(VersionUsageModel.IntermediaryVersionEnum.class, (String)versionUsage.getIntermediaryVersion().toString())) continue;
                            return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyParamOfUsage("IntermediaryVersion", versionUsage.getUsageName(), contractName));
                        }
                    }
                    return Optional.empty();
                }
                catch (Exception e) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExceptionOccurred(contract.getName(), "Error checking version retention policy", e));
                }
            };
        }

        private ManagementContractValidator checkPersistenceIdentifierPolicy() {
            return (contract, contractName) -> {
                try {
                    HashSet<String> uniqueUsageNames = new HashSet<String>();
                    List persistentIdentifierPolicyList = contract.getPersistentIdentifierPolicyList();
                    if (persistentIdentifierPolicyList == null) {
                        return Optional.empty();
                    }
                    for (PersistentIdentifierPolicy persistentIdentifierPolicy : persistentIdentifierPolicyList) {
                        List persistentIdentifierUsages = persistentIdentifierPolicy.getPersistentIdentifierUsages();
                        if (persistentIdentifierUsages == null || persistentIdentifierUsages.isEmpty()) continue;
                        for (PersistentIdentifierUsage persistentIdentifierUsage : persistentIdentifierUsages) {
                            String usageName = persistentIdentifierUsage.getUsageName().getName();
                            if (Arrays.stream(DataObjectVersionType.values()).noneMatch(elmt -> elmt.getName().equals(usageName))) {
                                return Optional.of(GenericContractValidator.GenericRejectionCause.rejectInvalidVersionRetentionPolicyUsage(usageName, contractName));
                            }
                            if (uniqueUsageNames.add(usageName)) continue;
                            return Optional.of(GenericContractValidator.GenericRejectionCause.rejectDuplicateVersionRetentionPolicyUsage(usageName, contractName));
                        }
                    }
                    return Optional.empty();
                }
                catch (Exception e) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExceptionOccurred(contract.getName(), "Error checking version retention policy", e));
                }
            };
        }
    }
}

